// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl

public class DescribeGameSessionDetailsRequest private constructor(builder: Builder) {
    /**
     * A unique identifier for the alias associated with the fleet to retrieve all game sessions for. You can use either the alias ID or ARN value.
     */
    public val aliasId: kotlin.String? = builder.aliasId
    /**
     * A unique identifier for the fleet to retrieve all game sessions active on the fleet. You can use either the fleet ID or ARN value.
     */
    public val fleetId: kotlin.String? = builder.fleetId
    /**
     * A unique identifier for the game session to retrieve.
     */
    public val gameSessionId: kotlin.String? = builder.gameSessionId
    /**
     * The maximum number of results to return. Use this parameter with `NextToken` to get results as a set of sequential pages.
     */
    public val limit: kotlin.Int? = builder.limit
    /**
     * A fleet location to get game session details for. You can specify a fleet's home Region or a remote location. Use the Amazon Web Services Region code format, such as `us-west-2`.
     */
    public val location: kotlin.String? = builder.location
    /**
     * A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * Game session status to filter results on. Possible game session statuses include `ACTIVE`, `TERMINATED`, `ACTIVATING` and `TERMINATING` (the last two are transitory).
     */
    public val statusFilter: kotlin.String? = builder.statusFilter

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.DescribeGameSessionDetailsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeGameSessionDetailsRequest(")
        append("aliasId=$aliasId,")
        append("fleetId=$fleetId,")
        append("gameSessionId=$gameSessionId,")
        append("limit=$limit,")
        append("location=$location,")
        append("nextToken=$nextToken,")
        append("statusFilter=$statusFilter")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aliasId?.hashCode() ?: 0
        result = 31 * result + (fleetId?.hashCode() ?: 0)
        result = 31 * result + (gameSessionId?.hashCode() ?: 0)
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (statusFilter?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeGameSessionDetailsRequest

        if (aliasId != other.aliasId) return false
        if (fleetId != other.fleetId) return false
        if (gameSessionId != other.gameSessionId) return false
        if (limit != other.limit) return false
        if (location != other.location) return false
        if (nextToken != other.nextToken) return false
        if (statusFilter != other.statusFilter) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.DescribeGameSessionDetailsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique identifier for the alias associated with the fleet to retrieve all game sessions for. You can use either the alias ID or ARN value.
         */
        public var aliasId: kotlin.String? = null
        /**
         * A unique identifier for the fleet to retrieve all game sessions active on the fleet. You can use either the fleet ID or ARN value.
         */
        public var fleetId: kotlin.String? = null
        /**
         * A unique identifier for the game session to retrieve.
         */
        public var gameSessionId: kotlin.String? = null
        /**
         * The maximum number of results to return. Use this parameter with `NextToken` to get results as a set of sequential pages.
         */
        public var limit: kotlin.Int? = null
        /**
         * A fleet location to get game session details for. You can specify a fleet's home Region or a remote location. Use the Amazon Web Services Region code format, such as `us-west-2`.
         */
        public var location: kotlin.String? = null
        /**
         * A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.
         */
        public var nextToken: kotlin.String? = null
        /**
         * Game session status to filter results on. Possible game session statuses include `ACTIVE`, `TERMINATED`, `ACTIVATING` and `TERMINATING` (the last two are transitory).
         */
        public var statusFilter: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.DescribeGameSessionDetailsRequest) : this() {
            this.aliasId = x.aliasId
            this.fleetId = x.fleetId
            this.gameSessionId = x.gameSessionId
            this.limit = x.limit
            this.location = x.location
            this.nextToken = x.nextToken
            this.statusFilter = x.statusFilter
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.DescribeGameSessionDetailsRequest = DescribeGameSessionDetailsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
