// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl

public class DescribeFleetPortSettingsResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name ([ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is assigned to a Amazon GameLift Servers fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is `arn:aws:gamelift:<region>::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912`.
     */
    public val fleetArn: kotlin.String? = builder.fleetArn
    /**
     * A unique identifier for the fleet that was requested.
     */
    public val fleetId: kotlin.String? = builder.fleetId
    /**
     * The port settings for the requested fleet ID.
     */
    public val inboundPermissions: List<IpPermission>? = builder.inboundPermissions
    /**
     * The requested fleet location, expressed as an Amazon Web Services Region code, such as `us-west-2`.
     */
    public val location: kotlin.String? = builder.location
    /**
     * The current status of updates to the fleet's port settings in the requested fleet location. A status of `PENDING_UPDATE` indicates that an update was requested for the fleet but has not yet been completed for the location.
     */
    public val updateStatus: aws.sdk.kotlin.services.gamelift.model.LocationUpdateStatus? = builder.updateStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.DescribeFleetPortSettingsResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeFleetPortSettingsResponse(")
        append("fleetArn=$fleetArn,")
        append("fleetId=$fleetId,")
        append("inboundPermissions=$inboundPermissions,")
        append("location=$location,")
        append("updateStatus=$updateStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fleetArn?.hashCode() ?: 0
        result = 31 * result + (fleetId?.hashCode() ?: 0)
        result = 31 * result + (inboundPermissions?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (updateStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeFleetPortSettingsResponse

        if (fleetArn != other.fleetArn) return false
        if (fleetId != other.fleetId) return false
        if (inboundPermissions != other.inboundPermissions) return false
        if (location != other.location) return false
        if (updateStatus != other.updateStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.DescribeFleetPortSettingsResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name ([ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is assigned to a Amazon GameLift Servers fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is `arn:aws:gamelift:<region>::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912`.
         */
        public var fleetArn: kotlin.String? = null
        /**
         * A unique identifier for the fleet that was requested.
         */
        public var fleetId: kotlin.String? = null
        /**
         * The port settings for the requested fleet ID.
         */
        public var inboundPermissions: List<IpPermission>? = null
        /**
         * The requested fleet location, expressed as an Amazon Web Services Region code, such as `us-west-2`.
         */
        public var location: kotlin.String? = null
        /**
         * The current status of updates to the fleet's port settings in the requested fleet location. A status of `PENDING_UPDATE` indicates that an update was requested for the fleet but has not yet been completed for the location.
         */
        public var updateStatus: aws.sdk.kotlin.services.gamelift.model.LocationUpdateStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.DescribeFleetPortSettingsResponse) : this() {
            this.fleetArn = x.fleetArn
            this.fleetId = x.fleetId
            this.inboundPermissions = x.inboundPermissions
            this.location = x.location
            this.updateStatus = x.updateStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.DescribeFleetPortSettingsResponse = DescribeFleetPortSettingsResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
