// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Set of rules for processing a deployment for a container fleet update.
 */
public class DeploymentConfiguration private constructor(builder: Builder) {
    /**
     * Determines what actions to take if a deployment fails. If the fleet is multi-location, this strategy applies across all fleet locations. With a rollback strategy, updated fleet instances are rolled back to the last successful deployment. Alternatively, you can maintain a few impaired containers for the purpose of debugging, while all other tasks return to the last successful deployment.
     */
    public val impairmentStrategy: aws.sdk.kotlin.services.gamelift.model.DeploymentImpairmentStrategy? = builder.impairmentStrategy
    /**
     * Sets a minimum level of healthy tasks to maintain during deployment activity.
     */
    public val minimumHealthyPercentage: kotlin.Int? = builder.minimumHealthyPercentage
    /**
     * Determines how fleet deployment activity affects active game sessions on the fleet. With protection, a deployment honors game session protection, and delays actions that would interrupt a protected active game session until the game session ends. Without protection, deployment activity can shut down all running tasks, including active game sessions, regardless of game session protection.
     */
    public val protectionStrategy: aws.sdk.kotlin.services.gamelift.model.DeploymentProtectionStrategy? = builder.protectionStrategy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.DeploymentConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeploymentConfiguration(")
        append("impairmentStrategy=$impairmentStrategy,")
        append("minimumHealthyPercentage=$minimumHealthyPercentage,")
        append("protectionStrategy=$protectionStrategy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = impairmentStrategy?.hashCode() ?: 0
        result = 31 * result + (minimumHealthyPercentage ?: 0)
        result = 31 * result + (protectionStrategy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeploymentConfiguration

        if (impairmentStrategy != other.impairmentStrategy) return false
        if (minimumHealthyPercentage != other.minimumHealthyPercentage) return false
        if (protectionStrategy != other.protectionStrategy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.DeploymentConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Determines what actions to take if a deployment fails. If the fleet is multi-location, this strategy applies across all fleet locations. With a rollback strategy, updated fleet instances are rolled back to the last successful deployment. Alternatively, you can maintain a few impaired containers for the purpose of debugging, while all other tasks return to the last successful deployment.
         */
        public var impairmentStrategy: aws.sdk.kotlin.services.gamelift.model.DeploymentImpairmentStrategy? = null
        /**
         * Sets a minimum level of healthy tasks to maintain during deployment activity.
         */
        public var minimumHealthyPercentage: kotlin.Int? = null
        /**
         * Determines how fleet deployment activity affects active game sessions on the fleet. With protection, a deployment honors game session protection, and delays actions that would interrupt a protected active game session until the game session ends. Without protection, deployment activity can shut down all running tasks, including active game sessions, regardless of game session protection.
         */
        public var protectionStrategy: aws.sdk.kotlin.services.gamelift.model.DeploymentProtectionStrategy? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.DeploymentConfiguration) : this() {
            this.impairmentStrategy = x.impairmentStrategy
            this.minimumHealthyPercentage = x.minimumHealthyPercentage
            this.protectionStrategy = x.protectionStrategy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.DeploymentConfiguration = DeploymentConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
