// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreatePlayerSessionsRequest private constructor(builder: Builder) {
    /**
     * A unique identifier for the game session to add players to.
     */
    public val gameSessionId: kotlin.String? = builder.gameSessionId
    /**
     * Map of string pairs, each specifying a player ID and a set of developer-defined information related to the player. Amazon GameLift Servers does not use this data, so it can be formatted as needed for use in the game. Any player data strings for player IDs that are not included in the `PlayerIds` parameter are ignored.
     */
    public val playerDataMap: Map<String, String>? = builder.playerDataMap
    /**
     * List of unique identifiers for the players to be added.
     */
    public val playerIds: List<String>? = builder.playerIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.CreatePlayerSessionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreatePlayerSessionsRequest(")
        append("gameSessionId=$gameSessionId,")
        append("playerDataMap=$playerDataMap,")
        append("playerIds=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = gameSessionId?.hashCode() ?: 0
        result = 31 * result + (playerDataMap?.hashCode() ?: 0)
        result = 31 * result + (playerIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreatePlayerSessionsRequest

        if (gameSessionId != other.gameSessionId) return false
        if (playerDataMap != other.playerDataMap) return false
        if (playerIds != other.playerIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.CreatePlayerSessionsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique identifier for the game session to add players to.
         */
        public var gameSessionId: kotlin.String? = null
        /**
         * Map of string pairs, each specifying a player ID and a set of developer-defined information related to the player. Amazon GameLift Servers does not use this data, so it can be formatted as needed for use in the game. Any player data strings for player IDs that are not included in the `PlayerIds` parameter are ignored.
         */
        public var playerDataMap: Map<String, String>? = null
        /**
         * List of unique identifiers for the players to be added.
         */
        public var playerIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.CreatePlayerSessionsRequest) : this() {
            this.gameSessionId = x.gameSessionId
            this.playerDataMap = x.playerDataMap
            this.playerIds = x.playerIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.CreatePlayerSessionsRequest = CreatePlayerSessionsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
