// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateGameSessionRequest private constructor(builder: Builder) {
    /**
     * A unique identifier for the alias associated with the fleet to create a game session in. You can use either the alias ID or ARN value. Each request must reference either a fleet ID or alias ID, but not both.
     */
    public val aliasId: kotlin.String? = builder.aliasId
    /**
     * A unique identifier for a player or entity creating the game session.
     *
     * If you add a resource creation limit policy to a fleet, the `CreateGameSession` operation requires a `CreatorId`. Amazon GameLift Servers limits the number of game session creation requests with the same `CreatorId` in a specified time period.
     *
     * If you your fleet doesn't have a resource creation limit policy and you provide a `CreatorId` in your `CreateGameSession` requests, Amazon GameLift Servers limits requests to one request per `CreatorId` per second.
     *
     * To not limit `CreateGameSession` requests with the same `CreatorId`, don't provide a `CreatorId` in your `CreateGameSession` request.
     */
    public val creatorId: kotlin.String? = builder.creatorId
    /**
     * A unique identifier for the fleet to create a game session in. You can use either the fleet ID or ARN value. Each request must reference either a fleet ID or alias ID, but not both.
     */
    public val fleetId: kotlin.String? = builder.fleetId
    /**
     * A set of key-value pairs that can store custom data in a game session. For example: `{"Key": "difficulty", "Value": "novice"}`. For an example, see [Create a game session with custom properties](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#game-properties-create).
     */
    public val gameProperties: List<GameProperty>? = builder.gameProperties
    /**
     * A set of custom game session properties, formatted as a single string value. This data is passed to a game server process with a request to start a new game session. For more information, see [Start a game session](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession).
     */
    public val gameSessionData: kotlin.String? = builder.gameSessionData
    /**
     * *This parameter is deprecated. Use `IdempotencyToken` instead.*
     *
     * Custom string that uniquely identifies a request for a new game session. Maximum token length is 48 characters. If provided, this string is included in the new game session's ID.
     */
    public val gameSessionId: kotlin.String? = builder.gameSessionId
    /**
     * Custom string that uniquely identifies the new game session request. This is useful for ensuring that game session requests with the same idempotency token are processed only once. Subsequent requests with the same string return the original `GameSession` object, with an updated status. Maximum token length is 48 characters. If provided, this string is included in the new game session's ID. A game session ARN has the following format: `arn:aws:gamelift:<location>::gamesession/<fleet ID>/<custom ID string or idempotency token>`. Idempotency tokens remain in use for 30 days after a game session has ended; game session objects are retained for this time period and then deleted.
     */
    public val idempotencyToken: kotlin.String? = builder.idempotencyToken
    /**
     * A fleet's remote location to place the new game session in. If this parameter is not set, the new game session is placed in the fleet's home Region. Specify a remote location with an Amazon Web Services Region code such as `us-west-2`. When using an Anywhere fleet, this parameter is required and must be set to the Anywhere fleet's custom location.
     */
    public val location: kotlin.String? = builder.location
    /**
     * The maximum number of players that can be connected simultaneously to the game session.
     */
    public val maximumPlayerSessionCount: kotlin.Int? = builder.maximumPlayerSessionCount
    /**
     * A descriptive label that is associated with a game session. Session names do not need to be unique.
     */
    public val name: kotlin.String? = builder.name

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.CreateGameSessionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateGameSessionRequest(")
        append("aliasId=$aliasId,")
        append("creatorId=$creatorId,")
        append("fleetId=$fleetId,")
        append("gameProperties=$gameProperties,")
        append("gameSessionData=$gameSessionData,")
        append("gameSessionId=$gameSessionId,")
        append("idempotencyToken=$idempotencyToken,")
        append("location=$location,")
        append("maximumPlayerSessionCount=$maximumPlayerSessionCount,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aliasId?.hashCode() ?: 0
        result = 31 * result + (creatorId?.hashCode() ?: 0)
        result = 31 * result + (fleetId?.hashCode() ?: 0)
        result = 31 * result + (gameProperties?.hashCode() ?: 0)
        result = 31 * result + (gameSessionData?.hashCode() ?: 0)
        result = 31 * result + (gameSessionId?.hashCode() ?: 0)
        result = 31 * result + (idempotencyToken?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (maximumPlayerSessionCount ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateGameSessionRequest

        if (aliasId != other.aliasId) return false
        if (creatorId != other.creatorId) return false
        if (fleetId != other.fleetId) return false
        if (gameProperties != other.gameProperties) return false
        if (gameSessionData != other.gameSessionData) return false
        if (gameSessionId != other.gameSessionId) return false
        if (idempotencyToken != other.idempotencyToken) return false
        if (location != other.location) return false
        if (maximumPlayerSessionCount != other.maximumPlayerSessionCount) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.CreateGameSessionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique identifier for the alias associated with the fleet to create a game session in. You can use either the alias ID or ARN value. Each request must reference either a fleet ID or alias ID, but not both.
         */
        public var aliasId: kotlin.String? = null
        /**
         * A unique identifier for a player or entity creating the game session.
         *
         * If you add a resource creation limit policy to a fleet, the `CreateGameSession` operation requires a `CreatorId`. Amazon GameLift Servers limits the number of game session creation requests with the same `CreatorId` in a specified time period.
         *
         * If you your fleet doesn't have a resource creation limit policy and you provide a `CreatorId` in your `CreateGameSession` requests, Amazon GameLift Servers limits requests to one request per `CreatorId` per second.
         *
         * To not limit `CreateGameSession` requests with the same `CreatorId`, don't provide a `CreatorId` in your `CreateGameSession` request.
         */
        public var creatorId: kotlin.String? = null
        /**
         * A unique identifier for the fleet to create a game session in. You can use either the fleet ID or ARN value. Each request must reference either a fleet ID or alias ID, but not both.
         */
        public var fleetId: kotlin.String? = null
        /**
         * A set of key-value pairs that can store custom data in a game session. For example: `{"Key": "difficulty", "Value": "novice"}`. For an example, see [Create a game session with custom properties](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#game-properties-create).
         */
        public var gameProperties: List<GameProperty>? = null
        /**
         * A set of custom game session properties, formatted as a single string value. This data is passed to a game server process with a request to start a new game session. For more information, see [Start a game session](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession).
         */
        public var gameSessionData: kotlin.String? = null
        /**
         * *This parameter is deprecated. Use `IdempotencyToken` instead.*
         *
         * Custom string that uniquely identifies a request for a new game session. Maximum token length is 48 characters. If provided, this string is included in the new game session's ID.
         */
        public var gameSessionId: kotlin.String? = null
        /**
         * Custom string that uniquely identifies the new game session request. This is useful for ensuring that game session requests with the same idempotency token are processed only once. Subsequent requests with the same string return the original `GameSession` object, with an updated status. Maximum token length is 48 characters. If provided, this string is included in the new game session's ID. A game session ARN has the following format: `arn:aws:gamelift:<location>::gamesession/<fleet ID>/<custom ID string or idempotency token>`. Idempotency tokens remain in use for 30 days after a game session has ended; game session objects are retained for this time period and then deleted.
         */
        public var idempotencyToken: kotlin.String? = null
        /**
         * A fleet's remote location to place the new game session in. If this parameter is not set, the new game session is placed in the fleet's home Region. Specify a remote location with an Amazon Web Services Region code such as `us-west-2`. When using an Anywhere fleet, this parameter is required and must be set to the Anywhere fleet's custom location.
         */
        public var location: kotlin.String? = null
        /**
         * The maximum number of players that can be connected simultaneously to the game session.
         */
        public var maximumPlayerSessionCount: kotlin.Int? = null
        /**
         * A descriptive label that is associated with a game session. Session names do not need to be unique.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.CreateGameSessionRequest) : this() {
            this.aliasId = x.aliasId
            this.creatorId = x.creatorId
            this.fleetId = x.fleetId
            this.gameProperties = x.gameProperties
            this.gameSessionData = x.gameSessionData
            this.gameSessionId = x.gameSessionId
            this.idempotencyToken = x.idempotencyToken
            this.location = x.location
            this.maximumPlayerSessionCount = x.maximumPlayerSessionCount
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.CreateGameSessionRequest = CreateGameSessionRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
