// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateContainerGroupDefinitionRequest private constructor(builder: Builder) {
    /**
     * The type of container group being defined. Container group type determines how Amazon GameLift Servers deploys the container group on each fleet instance.
     *
     * Default value: `GAME_SERVER`
     */
    public val containerGroupType: aws.sdk.kotlin.services.gamelift.model.ContainerGroupType? = builder.containerGroupType
    /**
     * The definition for the game server container in this group. Define a game server container only when the container group type is `GAME_SERVER`. Game server containers specify a container image with your game server build. You can pass in your container definitions as a JSON file.
     */
    public val gameServerContainerDefinition: aws.sdk.kotlin.services.gamelift.model.GameServerContainerDefinitionInput? = builder.gameServerContainerDefinition
    /**
     * A descriptive identifier for the container group definition. The name value must be unique in an Amazon Web Services Region.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The platform that all containers in the group use. Containers in a group must run on the same operating system.
     *
     * Default value: `AMAZON_LINUX_2023`
     *
     * Amazon Linux 2 (AL2) will reach end of support on 6/30/2025. See more details in the [Amazon Linux 2 FAQs](http://aws.amazon.com/amazon-linux-2/faqs/). For game servers that are hosted on AL2 and use server SDK version 4.x for Amazon GameLift Servers, first update the game server build to server SDK 5.x, and then deploy to AL2023 instances. See [ Migrate to server SDK version 5.](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk5-migration.html)
     */
    public val operatingSystem: aws.sdk.kotlin.services.gamelift.model.ContainerOperatingSystem? = builder.operatingSystem
    /**
     * One or more definition for support containers in this group. You can define a support container in any type of container group. You can pass in your container definitions as a JSON file.
     */
    public val supportContainerDefinitions: List<SupportContainerDefinitionInput>? = builder.supportContainerDefinitions
    /**
     * A list of labels to assign to the container group definition resource. Tags are developer-defined key-value pairs. Tagging Amazon Web Services resources are useful for resource management, access management and cost allocation. For more information, see [ Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference*.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The maximum amount of memory (in MiB) to allocate to the container group. All containers in the group share this memory. If you specify memory limits for an individual container, the total value must be greater than any individual container's memory limit.
     *
     * Default value: 1024
     */
    public val totalMemoryLimitMebibytes: kotlin.Int? = builder.totalMemoryLimitMebibytes
    /**
     * The maximum amount of vCPU units to allocate to the container group (1 vCPU is equal to 1024 CPU units). All containers in the group share this memory. If you specify vCPU limits for individual containers, the total value must be equal to or greater than the sum of the CPU limits for all containers in the group.
     *
     * Default value: 1
     */
    public val totalVcpuLimit: kotlin.Double? = builder.totalVcpuLimit
    /**
     * A description for the initial version of this container group definition.
     */
    public val versionDescription: kotlin.String? = builder.versionDescription

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.CreateContainerGroupDefinitionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateContainerGroupDefinitionRequest(")
        append("containerGroupType=$containerGroupType,")
        append("gameServerContainerDefinition=$gameServerContainerDefinition,")
        append("name=$name,")
        append("operatingSystem=$operatingSystem,")
        append("supportContainerDefinitions=$supportContainerDefinitions,")
        append("tags=$tags,")
        append("totalMemoryLimitMebibytes=$totalMemoryLimitMebibytes,")
        append("totalVcpuLimit=$totalVcpuLimit,")
        append("versionDescription=$versionDescription")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = containerGroupType?.hashCode() ?: 0
        result = 31 * result + (gameServerContainerDefinition?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (operatingSystem?.hashCode() ?: 0)
        result = 31 * result + (supportContainerDefinitions?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (totalMemoryLimitMebibytes ?: 0)
        result = 31 * result + (totalVcpuLimit?.hashCode() ?: 0)
        result = 31 * result + (versionDescription?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateContainerGroupDefinitionRequest

        if (containerGroupType != other.containerGroupType) return false
        if (gameServerContainerDefinition != other.gameServerContainerDefinition) return false
        if (name != other.name) return false
        if (operatingSystem != other.operatingSystem) return false
        if (supportContainerDefinitions != other.supportContainerDefinitions) return false
        if (tags != other.tags) return false
        if (totalMemoryLimitMebibytes != other.totalMemoryLimitMebibytes) return false
        if (!(totalVcpuLimit?.equals(other.totalVcpuLimit) ?: (other.totalVcpuLimit == null))) return false
        if (versionDescription != other.versionDescription) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.CreateContainerGroupDefinitionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The type of container group being defined. Container group type determines how Amazon GameLift Servers deploys the container group on each fleet instance.
         *
         * Default value: `GAME_SERVER`
         */
        public var containerGroupType: aws.sdk.kotlin.services.gamelift.model.ContainerGroupType? = null
        /**
         * The definition for the game server container in this group. Define a game server container only when the container group type is `GAME_SERVER`. Game server containers specify a container image with your game server build. You can pass in your container definitions as a JSON file.
         */
        public var gameServerContainerDefinition: aws.sdk.kotlin.services.gamelift.model.GameServerContainerDefinitionInput? = null
        /**
         * A descriptive identifier for the container group definition. The name value must be unique in an Amazon Web Services Region.
         */
        public var name: kotlin.String? = null
        /**
         * The platform that all containers in the group use. Containers in a group must run on the same operating system.
         *
         * Default value: `AMAZON_LINUX_2023`
         *
         * Amazon Linux 2 (AL2) will reach end of support on 6/30/2025. See more details in the [Amazon Linux 2 FAQs](http://aws.amazon.com/amazon-linux-2/faqs/). For game servers that are hosted on AL2 and use server SDK version 4.x for Amazon GameLift Servers, first update the game server build to server SDK 5.x, and then deploy to AL2023 instances. See [ Migrate to server SDK version 5.](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk5-migration.html)
         */
        public var operatingSystem: aws.sdk.kotlin.services.gamelift.model.ContainerOperatingSystem? = null
        /**
         * One or more definition for support containers in this group. You can define a support container in any type of container group. You can pass in your container definitions as a JSON file.
         */
        public var supportContainerDefinitions: List<SupportContainerDefinitionInput>? = null
        /**
         * A list of labels to assign to the container group definition resource. Tags are developer-defined key-value pairs. Tagging Amazon Web Services resources are useful for resource management, access management and cost allocation. For more information, see [ Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference*.
         */
        public var tags: List<Tag>? = null
        /**
         * The maximum amount of memory (in MiB) to allocate to the container group. All containers in the group share this memory. If you specify memory limits for an individual container, the total value must be greater than any individual container's memory limit.
         *
         * Default value: 1024
         */
        public var totalMemoryLimitMebibytes: kotlin.Int? = null
        /**
         * The maximum amount of vCPU units to allocate to the container group (1 vCPU is equal to 1024 CPU units). All containers in the group share this memory. If you specify vCPU limits for individual containers, the total value must be equal to or greater than the sum of the CPU limits for all containers in the group.
         *
         * Default value: 1
         */
        public var totalVcpuLimit: kotlin.Double? = null
        /**
         * A description for the initial version of this container group definition.
         */
        public var versionDescription: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.CreateContainerGroupDefinitionRequest) : this() {
            this.containerGroupType = x.containerGroupType
            this.gameServerContainerDefinition = x.gameServerContainerDefinition
            this.name = x.name
            this.operatingSystem = x.operatingSystem
            this.supportContainerDefinitions = x.supportContainerDefinitions
            this.tags = x.tags
            this.totalMemoryLimitMebibytes = x.totalMemoryLimitMebibytes
            this.totalVcpuLimit = x.totalVcpuLimit
            this.versionDescription = x.versionDescription
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.CreateContainerGroupDefinitionRequest = CreateContainerGroupDefinitionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.GameServerContainerDefinitionInput] inside the given [block]
         */
        public fun gameServerContainerDefinition(block: aws.sdk.kotlin.services.gamelift.model.GameServerContainerDefinitionInput.Builder.() -> kotlin.Unit) {
            this.gameServerContainerDefinition = aws.sdk.kotlin.services.gamelift.model.GameServerContainerDefinitionInput.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
