// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateContainerFleetRequest private constructor(builder: Builder) {
    /**
     * Indicates whether to use On-Demand or Spot instances for this fleet. Learn more about when to use [ On-Demand versus Spot Instances](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot). This fleet property can't be changed after the fleet is created.
     *
     * By default, this property is set to `ON_DEMAND`.
     *
     * You can't update this fleet property later.
     */
    public val billingType: aws.sdk.kotlin.services.gamelift.model.ContainerFleetBillingType? = builder.billingType
    /**
     * A meaningful description of the container fleet.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The unique identifier for an Identity and Access Management (IAM) role with permissions to run your containers on resources that are managed by Amazon GameLift Servers. Use an IAM service role with the `GameLiftContainerFleetPolicy` managed policy attached. For more information, see [Set up an IAM service role](https://docs.aws.amazon.com/gamelift/latest/developerguide/setting-up-role.html). You can't change this fleet property after the fleet is created.
     *
     * IAM role ARN values use the following pattern: `arn:aws:iam::[Amazon Web Services account]:role/[role name]`.
     */
    public val fleetRoleArn: kotlin.String? = builder.fleetRoleArn
    /**
     * A container group definition resource that describes how to deploy containers with your game server build and support software onto each fleet instance. You can specify the container group definition's name to use the latest version. Alternatively, provide an ARN value with a specific version number.
     *
     * Create a container group definition by calling [CreateContainerGroupDefinition](https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateContainerGroupDefinition.html). This operation creates a [ContainerGroupDefinition](https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html) resource.
     */
    public val gameServerContainerGroupDefinitionName: kotlin.String? = builder.gameServerContainerGroupDefinitionName
    /**
     * The number of times to replicate the game server container group on each fleet instance.
     *
     * By default, Amazon GameLift Servers calculates the maximum number of game server container groups that can fit on each instance. This calculation is based on the CPU and memory resources of the fleet's instance type). To use the calculated maximum, don't set this parameter. If you set this number manually, Amazon GameLift Servers uses your value as long as it's less than the calculated maximum.
     */
    public val gameServerContainerGroupsPerInstance: kotlin.Int? = builder.gameServerContainerGroupsPerInstance
    /**
     * A policy that limits the number of game sessions that each individual player can create on instances in this fleet. The limit applies for a specified span of time.
     */
    public val gameSessionCreationLimitPolicy: aws.sdk.kotlin.services.gamelift.model.GameSessionCreationLimitPolicy? = builder.gameSessionCreationLimitPolicy
    /**
     * The set of port numbers to open on each fleet instance. A fleet's connection ports map to container ports that are configured in the fleet's container group definitions.
     *
     * By default, Amazon GameLift Servers calculates an optimal port range based on your fleet configuration. To use the calculated range, don't set this parameter. The values are:
     * + Port range: 4192 to a number calculated based on your fleet configuration. Amazon GameLift Servers uses the following formula: `4192 + [# of game server container groups per fleet instance] * [# of container ports in the game server container group definition] + [# of container ports in the game server container group definition]`
     *
     * You can also choose to manually set this parameter. When manually setting this parameter, you must use port numbers that match the fleet's inbound permissions port range.
     *
     * If you set values manually, Amazon GameLift Servers no longer calculates a port range for you, even if you later remove the manual settings.
     */
    public val instanceConnectionPortRange: aws.sdk.kotlin.services.gamelift.model.ConnectionPortRange? = builder.instanceConnectionPortRange
    /**
     * The IP address ranges and port settings that allow inbound traffic to access game server processes and other processes on this fleet. As a best practice, when remotely accessing a fleet instance, we recommend opening ports only when you need them and closing them when you're finished.
     *
     * By default, Amazon GameLift Servers calculates an optimal port range based on your fleet configuration. To use the calculated range, don't set this parameter. The values are:
     * + Protocol: UDP
     * + Port range: 4192 to a number calculated based on your fleet configuration. Amazon GameLift Servers uses the following formula: `4192 + [# of game server container groups per fleet instance] * [# of container ports in the game server container group definition] + [# of container ports in the game server container group definition]`
     *
     * You can also choose to manually set this parameter. When manually setting this parameter, you must use port numbers that match the fleet's connection port range.
     *
     * If you set values manually, Amazon GameLift Servers no longer calculates a port range for you, even if you later remove the manual settings.
     */
    public val instanceInboundPermissions: List<IpPermission>? = builder.instanceInboundPermissions
    /**
     * The Amazon EC2 instance type to use for all instances in the fleet. For multi-location fleets, the instance type must be available in the home region and all remote locations. Instance type determines the computing resources and processing power that's available to host your game servers. This includes including CPU, memory, storage, and networking capacity.
     *
     * By default, Amazon GameLift Servers selects an instance type that fits the needs of your container groups and is available in all selected fleet locations. You can also choose to manually set this parameter. See [Amazon Elastic Compute Cloud Instance Types](http://aws.amazon.com/ec2/instance-types/) for detailed descriptions of Amazon EC2 instance types.
     *
     * You can't update this fleet property later.
     */
    public val instanceType: kotlin.String? = builder.instanceType
    /**
     * A set of locations to deploy container fleet instances to. You can add any Amazon Web Services Region or Local Zone that's supported by Amazon GameLift Servers. Provide a list of one or more Amazon Web Services Region codes, such as `us-west-2`, or Local Zone names. Also include the fleet's home Region, which is the Amazon Web Services Region where the fleet is created. For a list of supported Regions and Local Zones, see [ Amazon GameLift Servers service locations](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html) for managed hosting.
     */
    public val locations: List<LocationConfiguration>? = builder.locations
    /**
     * A method for collecting container logs for the fleet. Amazon GameLift Servers saves all standard output for each container in logs, including game session logs. You can select from the following methods:
     * + `CLOUDWATCH` -- Send logs to an Amazon CloudWatch log group that you define. Each container emits a log stream, which is organized in the log group.
     * + `S3` -- Store logs in an Amazon S3 bucket that you define.
     * + `NONE` -- Don't collect container logs.
     *
     * By default, this property is set to `CLOUDWATCH`.
     *
     * Amazon GameLift Servers requires permissions to send logs other Amazon Web Services services in your account. These permissions are included in the IAM fleet role for this container fleet (see `FleetRoleArn)`.
     */
    public val logConfiguration: aws.sdk.kotlin.services.gamelift.model.LogConfiguration? = builder.logConfiguration
    /**
     * The name of an Amazon Web Services CloudWatch metric group to add this fleet to. You can use a metric group to aggregate metrics for multiple fleets. You can specify an existing metric group name or use a new name to create a new metric group. Each fleet can have only one metric group, but you can change this value at any time.
     */
    public val metricGroups: List<String>? = builder.metricGroups
    /**
     * Determines whether Amazon GameLift Servers can shut down game sessions on the fleet that are actively running and hosting players. Amazon GameLift Servers might prompt an instance shutdown when scaling down fleet capacity or when retiring unhealthy instances. You can also set game session protection for individual game sessions using [UpdateGameSession](gamelift/latest/apireference/API_UpdateGameSession.html).
     * + **NoProtection** -- Game sessions can be shut down during active gameplay.
     * + **FullProtection** -- Game sessions in `ACTIVE` status can't be shut down.
     *
     * By default, this property is set to `NoProtection`.
     */
    public val newGameSessionProtectionPolicy: aws.sdk.kotlin.services.gamelift.model.ProtectionPolicy? = builder.newGameSessionProtectionPolicy
    /**
     * The name of a container group definition resource that describes a set of axillary software. A fleet instance has one process for executables in this container group. A per-instance container group is optional. You can update the fleet to add or remove a per-instance container group at any time. You can specify the container group definition's name to use the latest version. Alternatively, provide an ARN value with a specific version number.
     *
     * Create a container group definition by calling [https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateContainerGroupDefinition.html](https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateContainerGroupDefinition.html). This operation creates a [https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html](https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html) resource.
     */
    public val perInstanceContainerGroupDefinitionName: kotlin.String? = builder.perInstanceContainerGroupDefinitionName
    /**
     * A list of labels to assign to the new fleet resource. Tags are developer-defined key-value pairs. Tagging Amazon Web Services resources are useful for resource management, access management and cost allocation. For more information, see [ Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference*.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.CreateContainerFleetRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateContainerFleetRequest(")
        append("billingType=$billingType,")
        append("description=$description,")
        append("fleetRoleArn=$fleetRoleArn,")
        append("gameServerContainerGroupDefinitionName=$gameServerContainerGroupDefinitionName,")
        append("gameServerContainerGroupsPerInstance=$gameServerContainerGroupsPerInstance,")
        append("gameSessionCreationLimitPolicy=$gameSessionCreationLimitPolicy,")
        append("instanceConnectionPortRange=$instanceConnectionPortRange,")
        append("instanceInboundPermissions=$instanceInboundPermissions,")
        append("instanceType=$instanceType,")
        append("locations=$locations,")
        append("logConfiguration=$logConfiguration,")
        append("metricGroups=$metricGroups,")
        append("newGameSessionProtectionPolicy=$newGameSessionProtectionPolicy,")
        append("perInstanceContainerGroupDefinitionName=$perInstanceContainerGroupDefinitionName,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = billingType?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (fleetRoleArn?.hashCode() ?: 0)
        result = 31 * result + (gameServerContainerGroupDefinitionName?.hashCode() ?: 0)
        result = 31 * result + (gameServerContainerGroupsPerInstance ?: 0)
        result = 31 * result + (gameSessionCreationLimitPolicy?.hashCode() ?: 0)
        result = 31 * result + (instanceConnectionPortRange?.hashCode() ?: 0)
        result = 31 * result + (instanceInboundPermissions?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (locations?.hashCode() ?: 0)
        result = 31 * result + (logConfiguration?.hashCode() ?: 0)
        result = 31 * result + (metricGroups?.hashCode() ?: 0)
        result = 31 * result + (newGameSessionProtectionPolicy?.hashCode() ?: 0)
        result = 31 * result + (perInstanceContainerGroupDefinitionName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateContainerFleetRequest

        if (billingType != other.billingType) return false
        if (description != other.description) return false
        if (fleetRoleArn != other.fleetRoleArn) return false
        if (gameServerContainerGroupDefinitionName != other.gameServerContainerGroupDefinitionName) return false
        if (gameServerContainerGroupsPerInstance != other.gameServerContainerGroupsPerInstance) return false
        if (gameSessionCreationLimitPolicy != other.gameSessionCreationLimitPolicy) return false
        if (instanceConnectionPortRange != other.instanceConnectionPortRange) return false
        if (instanceInboundPermissions != other.instanceInboundPermissions) return false
        if (instanceType != other.instanceType) return false
        if (locations != other.locations) return false
        if (logConfiguration != other.logConfiguration) return false
        if (metricGroups != other.metricGroups) return false
        if (newGameSessionProtectionPolicy != other.newGameSessionProtectionPolicy) return false
        if (perInstanceContainerGroupDefinitionName != other.perInstanceContainerGroupDefinitionName) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.CreateContainerFleetRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates whether to use On-Demand or Spot instances for this fleet. Learn more about when to use [ On-Demand versus Spot Instances](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot). This fleet property can't be changed after the fleet is created.
         *
         * By default, this property is set to `ON_DEMAND`.
         *
         * You can't update this fleet property later.
         */
        public var billingType: aws.sdk.kotlin.services.gamelift.model.ContainerFleetBillingType? = null
        /**
         * A meaningful description of the container fleet.
         */
        public var description: kotlin.String? = null
        /**
         * The unique identifier for an Identity and Access Management (IAM) role with permissions to run your containers on resources that are managed by Amazon GameLift Servers. Use an IAM service role with the `GameLiftContainerFleetPolicy` managed policy attached. For more information, see [Set up an IAM service role](https://docs.aws.amazon.com/gamelift/latest/developerguide/setting-up-role.html). You can't change this fleet property after the fleet is created.
         *
         * IAM role ARN values use the following pattern: `arn:aws:iam::[Amazon Web Services account]:role/[role name]`.
         */
        public var fleetRoleArn: kotlin.String? = null
        /**
         * A container group definition resource that describes how to deploy containers with your game server build and support software onto each fleet instance. You can specify the container group definition's name to use the latest version. Alternatively, provide an ARN value with a specific version number.
         *
         * Create a container group definition by calling [CreateContainerGroupDefinition](https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateContainerGroupDefinition.html). This operation creates a [ContainerGroupDefinition](https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html) resource.
         */
        public var gameServerContainerGroupDefinitionName: kotlin.String? = null
        /**
         * The number of times to replicate the game server container group on each fleet instance.
         *
         * By default, Amazon GameLift Servers calculates the maximum number of game server container groups that can fit on each instance. This calculation is based on the CPU and memory resources of the fleet's instance type). To use the calculated maximum, don't set this parameter. If you set this number manually, Amazon GameLift Servers uses your value as long as it's less than the calculated maximum.
         */
        public var gameServerContainerGroupsPerInstance: kotlin.Int? = null
        /**
         * A policy that limits the number of game sessions that each individual player can create on instances in this fleet. The limit applies for a specified span of time.
         */
        public var gameSessionCreationLimitPolicy: aws.sdk.kotlin.services.gamelift.model.GameSessionCreationLimitPolicy? = null
        /**
         * The set of port numbers to open on each fleet instance. A fleet's connection ports map to container ports that are configured in the fleet's container group definitions.
         *
         * By default, Amazon GameLift Servers calculates an optimal port range based on your fleet configuration. To use the calculated range, don't set this parameter. The values are:
         * + Port range: 4192 to a number calculated based on your fleet configuration. Amazon GameLift Servers uses the following formula: `4192 + [# of game server container groups per fleet instance] * [# of container ports in the game server container group definition] + [# of container ports in the game server container group definition]`
         *
         * You can also choose to manually set this parameter. When manually setting this parameter, you must use port numbers that match the fleet's inbound permissions port range.
         *
         * If you set values manually, Amazon GameLift Servers no longer calculates a port range for you, even if you later remove the manual settings.
         */
        public var instanceConnectionPortRange: aws.sdk.kotlin.services.gamelift.model.ConnectionPortRange? = null
        /**
         * The IP address ranges and port settings that allow inbound traffic to access game server processes and other processes on this fleet. As a best practice, when remotely accessing a fleet instance, we recommend opening ports only when you need them and closing them when you're finished.
         *
         * By default, Amazon GameLift Servers calculates an optimal port range based on your fleet configuration. To use the calculated range, don't set this parameter. The values are:
         * + Protocol: UDP
         * + Port range: 4192 to a number calculated based on your fleet configuration. Amazon GameLift Servers uses the following formula: `4192 + [# of game server container groups per fleet instance] * [# of container ports in the game server container group definition] + [# of container ports in the game server container group definition]`
         *
         * You can also choose to manually set this parameter. When manually setting this parameter, you must use port numbers that match the fleet's connection port range.
         *
         * If you set values manually, Amazon GameLift Servers no longer calculates a port range for you, even if you later remove the manual settings.
         */
        public var instanceInboundPermissions: List<IpPermission>? = null
        /**
         * The Amazon EC2 instance type to use for all instances in the fleet. For multi-location fleets, the instance type must be available in the home region and all remote locations. Instance type determines the computing resources and processing power that's available to host your game servers. This includes including CPU, memory, storage, and networking capacity.
         *
         * By default, Amazon GameLift Servers selects an instance type that fits the needs of your container groups and is available in all selected fleet locations. You can also choose to manually set this parameter. See [Amazon Elastic Compute Cloud Instance Types](http://aws.amazon.com/ec2/instance-types/) for detailed descriptions of Amazon EC2 instance types.
         *
         * You can't update this fleet property later.
         */
        public var instanceType: kotlin.String? = null
        /**
         * A set of locations to deploy container fleet instances to. You can add any Amazon Web Services Region or Local Zone that's supported by Amazon GameLift Servers. Provide a list of one or more Amazon Web Services Region codes, such as `us-west-2`, or Local Zone names. Also include the fleet's home Region, which is the Amazon Web Services Region where the fleet is created. For a list of supported Regions and Local Zones, see [ Amazon GameLift Servers service locations](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html) for managed hosting.
         */
        public var locations: List<LocationConfiguration>? = null
        /**
         * A method for collecting container logs for the fleet. Amazon GameLift Servers saves all standard output for each container in logs, including game session logs. You can select from the following methods:
         * + `CLOUDWATCH` -- Send logs to an Amazon CloudWatch log group that you define. Each container emits a log stream, which is organized in the log group.
         * + `S3` -- Store logs in an Amazon S3 bucket that you define.
         * + `NONE` -- Don't collect container logs.
         *
         * By default, this property is set to `CLOUDWATCH`.
         *
         * Amazon GameLift Servers requires permissions to send logs other Amazon Web Services services in your account. These permissions are included in the IAM fleet role for this container fleet (see `FleetRoleArn)`.
         */
        public var logConfiguration: aws.sdk.kotlin.services.gamelift.model.LogConfiguration? = null
        /**
         * The name of an Amazon Web Services CloudWatch metric group to add this fleet to. You can use a metric group to aggregate metrics for multiple fleets. You can specify an existing metric group name or use a new name to create a new metric group. Each fleet can have only one metric group, but you can change this value at any time.
         */
        public var metricGroups: List<String>? = null
        /**
         * Determines whether Amazon GameLift Servers can shut down game sessions on the fleet that are actively running and hosting players. Amazon GameLift Servers might prompt an instance shutdown when scaling down fleet capacity or when retiring unhealthy instances. You can also set game session protection for individual game sessions using [UpdateGameSession](gamelift/latest/apireference/API_UpdateGameSession.html).
         * + **NoProtection** -- Game sessions can be shut down during active gameplay.
         * + **FullProtection** -- Game sessions in `ACTIVE` status can't be shut down.
         *
         * By default, this property is set to `NoProtection`.
         */
        public var newGameSessionProtectionPolicy: aws.sdk.kotlin.services.gamelift.model.ProtectionPolicy? = null
        /**
         * The name of a container group definition resource that describes a set of axillary software. A fleet instance has one process for executables in this container group. A per-instance container group is optional. You can update the fleet to add or remove a per-instance container group at any time. You can specify the container group definition's name to use the latest version. Alternatively, provide an ARN value with a specific version number.
         *
         * Create a container group definition by calling [https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateContainerGroupDefinition.html](https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateContainerGroupDefinition.html). This operation creates a [https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html](https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html) resource.
         */
        public var perInstanceContainerGroupDefinitionName: kotlin.String? = null
        /**
         * A list of labels to assign to the new fleet resource. Tags are developer-defined key-value pairs. Tagging Amazon Web Services resources are useful for resource management, access management and cost allocation. For more information, see [ Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference*.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.CreateContainerFleetRequest) : this() {
            this.billingType = x.billingType
            this.description = x.description
            this.fleetRoleArn = x.fleetRoleArn
            this.gameServerContainerGroupDefinitionName = x.gameServerContainerGroupDefinitionName
            this.gameServerContainerGroupsPerInstance = x.gameServerContainerGroupsPerInstance
            this.gameSessionCreationLimitPolicy = x.gameSessionCreationLimitPolicy
            this.instanceConnectionPortRange = x.instanceConnectionPortRange
            this.instanceInboundPermissions = x.instanceInboundPermissions
            this.instanceType = x.instanceType
            this.locations = x.locations
            this.logConfiguration = x.logConfiguration
            this.metricGroups = x.metricGroups
            this.newGameSessionProtectionPolicy = x.newGameSessionProtectionPolicy
            this.perInstanceContainerGroupDefinitionName = x.perInstanceContainerGroupDefinitionName
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.CreateContainerFleetRequest = CreateContainerFleetRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.GameSessionCreationLimitPolicy] inside the given [block]
         */
        public fun gameSessionCreationLimitPolicy(block: aws.sdk.kotlin.services.gamelift.model.GameSessionCreationLimitPolicy.Builder.() -> kotlin.Unit) {
            this.gameSessionCreationLimitPolicy = aws.sdk.kotlin.services.gamelift.model.GameSessionCreationLimitPolicy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.ConnectionPortRange] inside the given [block]
         */
        public fun instanceConnectionPortRange(block: aws.sdk.kotlin.services.gamelift.model.ConnectionPortRange.Builder.() -> kotlin.Unit) {
            this.instanceConnectionPortRange = aws.sdk.kotlin.services.gamelift.model.ConnectionPortRange.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.LogConfiguration] inside the given [block]
         */
        public fun logConfiguration(block: aws.sdk.kotlin.services.gamelift.model.LogConfiguration.Builder.() -> kotlin.Unit) {
            this.logConfiguration = aws.sdk.kotlin.services.gamelift.model.LogConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
