// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateBuildRequest private constructor(builder: Builder) {
    /**
     * A descriptive label that is associated with a build. Build names do not need to be unique. You can change this value later.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The operating system that your game server binaries run on. This value determines the type of fleet resources that you use for this build. If your game build contains multiple executables, they all must run on the same operating system. You must specify a valid operating system in this request. There is no default value. You can't change a build's operating system later.
     *
     * Amazon Linux 2 (AL2) will reach end of support on 6/30/2025. See more details in the [Amazon Linux 2 FAQs](http://aws.amazon.com/amazon-linux-2/faqs/). For game servers that are hosted on AL2 and use server SDK version 4.x for Amazon GameLift Servers, first update the game server build to server SDK 5.x, and then deploy to AL2023 instances. See [ Migrate to server SDK version 5.](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk5-migration.html)
     */
    public val operatingSystem: aws.sdk.kotlin.services.gamelift.model.OperatingSystem? = builder.operatingSystem
    /**
     * A server SDK version you used when integrating your game server build with Amazon GameLift Servers. For more information see [Integrate games with custom game servers](https://docs.aws.amazon.com/gamelift/latest/developerguide/integration-custom-intro.html). By default Amazon GameLift Servers sets this value to `4.0.2`.
     */
    public val serverSdkVersion: kotlin.String? = builder.serverSdkVersion
    /**
     * Information indicating where your game build files are stored. Use this parameter only when creating a build with files stored in an Amazon S3 bucket that you own. The storage location must specify an Amazon S3 bucket name and key. The location must also specify a role ARN that you set up to allow Amazon GameLift Servers to access your Amazon S3 bucket. The S3 bucket and your new build must be in the same Region.
     *
     * If a `StorageLocation` is specified, the size of your file can be found in your Amazon S3 bucket. Amazon GameLift Servers will report a `SizeOnDisk` of 0.
     */
    public val storageLocation: aws.sdk.kotlin.services.gamelift.model.S3Location? = builder.storageLocation
    /**
     * A list of labels to assign to the new build resource. Tags are developer defined key-value pairs. Tagging Amazon Web Services resources are useful for resource management, access management and cost allocation. For more information, see [ Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference*. Once the resource is created, you can use [TagResource](https://docs.aws.amazon.com/gamelift/latest/apireference/API_TagResource.html), [UntagResource](https://docs.aws.amazon.com/gamelift/latest/apireference/API_UntagResource.html), and [ListTagsForResource](https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListTagsForResource.html) to add, remove, and view tags. The maximum tag limit may be lower than stated. See the Amazon Web Services General Reference for actual tagging limits.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Version information that is associated with a build or script. Version strings do not need to be unique. You can change this value later.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.CreateBuildRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateBuildRequest(")
        append("name=$name,")
        append("operatingSystem=$operatingSystem,")
        append("serverSdkVersion=$serverSdkVersion,")
        append("storageLocation=$storageLocation,")
        append("tags=$tags,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (operatingSystem?.hashCode() ?: 0)
        result = 31 * result + (serverSdkVersion?.hashCode() ?: 0)
        result = 31 * result + (storageLocation?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateBuildRequest

        if (name != other.name) return false
        if (operatingSystem != other.operatingSystem) return false
        if (serverSdkVersion != other.serverSdkVersion) return false
        if (storageLocation != other.storageLocation) return false
        if (tags != other.tags) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.CreateBuildRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A descriptive label that is associated with a build. Build names do not need to be unique. You can change this value later.
         */
        public var name: kotlin.String? = null
        /**
         * The operating system that your game server binaries run on. This value determines the type of fleet resources that you use for this build. If your game build contains multiple executables, they all must run on the same operating system. You must specify a valid operating system in this request. There is no default value. You can't change a build's operating system later.
         *
         * Amazon Linux 2 (AL2) will reach end of support on 6/30/2025. See more details in the [Amazon Linux 2 FAQs](http://aws.amazon.com/amazon-linux-2/faqs/). For game servers that are hosted on AL2 and use server SDK version 4.x for Amazon GameLift Servers, first update the game server build to server SDK 5.x, and then deploy to AL2023 instances. See [ Migrate to server SDK version 5.](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk5-migration.html)
         */
        public var operatingSystem: aws.sdk.kotlin.services.gamelift.model.OperatingSystem? = null
        /**
         * A server SDK version you used when integrating your game server build with Amazon GameLift Servers. For more information see [Integrate games with custom game servers](https://docs.aws.amazon.com/gamelift/latest/developerguide/integration-custom-intro.html). By default Amazon GameLift Servers sets this value to `4.0.2`.
         */
        public var serverSdkVersion: kotlin.String? = null
        /**
         * Information indicating where your game build files are stored. Use this parameter only when creating a build with files stored in an Amazon S3 bucket that you own. The storage location must specify an Amazon S3 bucket name and key. The location must also specify a role ARN that you set up to allow Amazon GameLift Servers to access your Amazon S3 bucket. The S3 bucket and your new build must be in the same Region.
         *
         * If a `StorageLocation` is specified, the size of your file can be found in your Amazon S3 bucket. Amazon GameLift Servers will report a `SizeOnDisk` of 0.
         */
        public var storageLocation: aws.sdk.kotlin.services.gamelift.model.S3Location? = null
        /**
         * A list of labels to assign to the new build resource. Tags are developer defined key-value pairs. Tagging Amazon Web Services resources are useful for resource management, access management and cost allocation. For more information, see [ Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference*. Once the resource is created, you can use [TagResource](https://docs.aws.amazon.com/gamelift/latest/apireference/API_TagResource.html), [UntagResource](https://docs.aws.amazon.com/gamelift/latest/apireference/API_UntagResource.html), and [ListTagsForResource](https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListTagsForResource.html) to add, remove, and view tags. The maximum tag limit may be lower than stated. See the Amazon Web Services General Reference for actual tagging limits.
         */
        public var tags: List<Tag>? = null
        /**
         * Version information that is associated with a build or script. Version strings do not need to be unique. You can change this value later.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.CreateBuildRequest) : this() {
            this.name = x.name
            this.operatingSystem = x.operatingSystem
            this.serverSdkVersion = x.serverSdkVersion
            this.storageLocation = x.storageLocation
            this.tags = x.tags
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.CreateBuildRequest = CreateBuildRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.S3Location] inside the given [block]
         */
        public fun storageLocation(block: aws.sdk.kotlin.services.gamelift.model.S3Location.Builder.() -> kotlin.Unit) {
            this.storageLocation = aws.sdk.kotlin.services.gamelift.model.S3Location.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
