// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A set of port ranges that can be opened on the container. A process that's running in the container can bind to a port number, making it accessible to inbound traffic when it's mapped to a container fleet's connection port.
 *
 * Each container port range specifies a network protocol. When the configuration supports more than one protocol, we recommend that you use a different range for each protocol. If your ranges have overlapping port numbers, Amazon GameLift Servers maps a duplicated container port number to different connection ports. For example, if you include 1935 in port ranges for both TCP and UDP, it might result in the following mappings:
 * + container port 1935 (tcp) => connection port 2001
 * + container port 1935 (udp) => connection port 2002
 *
 * **Part of:**[GameServerContainerDefinition](https://docs.aws.amazon.com/gamelift/latest/apireference/API_GameServerContainerDefinition.html), [GameServerContainerDefinitionInput](https://docs.aws.amazon.com/gamelift/latest/apireference/API_GameServerContainerDefinitionInput.html), [SupportContainerDefinition](https://docs.aws.amazon.com/gamelift/latest/apireference/API_SupportContainerDefinition.html), [SupportContainerDefinitionInput](https://docs.aws.amazon.com/gamelift/latest/apireference/API_SupportContainerDefinitionInput.html)
 */
public class ContainerPortConfiguration private constructor(builder: Builder) {
    /**
     * A set of one or more container port number ranges. The ranges can't overlap if the ranges' network protocols are the same. Overlapping ranges with different protocols is allowed but not recommended.
     */
    public val containerPortRanges: List<ContainerPortRange>? = builder.containerPortRanges

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.ContainerPortConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContainerPortConfiguration(")
        append("containerPortRanges=$containerPortRanges")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = containerPortRanges?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContainerPortConfiguration

        if (containerPortRanges != other.containerPortRanges) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.ContainerPortConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A set of one or more container port number ranges. The ranges can't overlap if the ranges' network protocols are the same. Overlapping ranges with different protocols is allowed but not recommended.
         */
        public var containerPortRanges: List<ContainerPortRange>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.ContainerPortConfiguration) : this() {
            this.containerPortRanges = x.containerPortRanges
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.ContainerPortConfiguration = ContainerPortConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
