// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A mount point that binds a container to a file or directory on the host system.
 *
 * **Part of:**[GameServerContainerDefinition](https://docs.aws.amazon.com/gamelift/latest/apireference/API_GameServerContainerDefinition.html), [https://docs.aws.amazon.com/gamelift/latest/apireference/API_GameServerContainerDefinitionInput.html](https://docs.aws.amazon.com/gamelift/latest/apireference/API_GameServerContainerDefinitionInput.html), [SupportContainerDefinition](https://docs.aws.amazon.com/gamelift/latest/apireference/API_SupportContainerDefinition.html), [https://docs.aws.amazon.com/gamelift/latest/apireference/API_SupportContainerDefinitionInput.html](https://docs.aws.amazon.com/gamelift/latest/apireference/API_SupportContainerDefinitionInput.html)
 */
public class ContainerMountPoint private constructor(builder: Builder) {
    /**
     * The type of access for the container.
     */
    public val accessLevel: aws.sdk.kotlin.services.gamelift.model.ContainerMountPointAccessLevel? = builder.accessLevel
    /**
     * The mount path on the container. If this property isn't set, the instance path is used.
     */
    public val containerPath: kotlin.String? = builder.containerPath
    /**
     * The path to the source file or directory.
     */
    public val instancePath: kotlin.String? = builder.instancePath

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.ContainerMountPoint = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContainerMountPoint(")
        append("accessLevel=$accessLevel,")
        append("containerPath=$containerPath,")
        append("instancePath=$instancePath")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessLevel?.hashCode() ?: 0
        result = 31 * result + (containerPath?.hashCode() ?: 0)
        result = 31 * result + (instancePath?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContainerMountPoint

        if (accessLevel != other.accessLevel) return false
        if (containerPath != other.containerPath) return false
        if (instancePath != other.instancePath) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.ContainerMountPoint = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The type of access for the container.
         */
        public var accessLevel: aws.sdk.kotlin.services.gamelift.model.ContainerMountPointAccessLevel? = null
        /**
         * The mount path on the container. If this property isn't set, the instance path is used.
         */
        public var containerPath: kotlin.String? = null
        /**
         * The path to the source file or directory.
         */
        public var instancePath: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.ContainerMountPoint) : this() {
            this.accessLevel = x.accessLevel
            this.containerPath = x.containerPath
            this.instancePath = x.instancePath
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.ContainerMountPoint = ContainerMountPoint(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
