// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A unique identifier for a container in a compute on a managed container fleet instance. This information makes it possible to remotely connect to a specific container on a fleet instance.
 *
 * **Related to:**[ContainerAttribute](https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerAttribute.html)
 *
 * **Use with: **[GetComputeAccess](https://docs.aws.amazon.com/gamelift/latest/apireference/API_GetComputeAccess.html)
 */
public class ContainerIdentifier private constructor(builder: Builder) {
    /**
     * The identifier for a container that's running in a compute.
     */
    public val containerName: kotlin.String? = builder.containerName
    /**
     * The runtime ID for the container that's running in a compute. This value is unique within the compute. It is returned as a `ContainerAttribute` value in a `Compute` object.
     */
    public val containerRuntimeId: kotlin.String? = builder.containerRuntimeId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.ContainerIdentifier = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContainerIdentifier(")
        append("containerName=$containerName,")
        append("containerRuntimeId=$containerRuntimeId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = containerName?.hashCode() ?: 0
        result = 31 * result + (containerRuntimeId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContainerIdentifier

        if (containerName != other.containerName) return false
        if (containerRuntimeId != other.containerRuntimeId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.ContainerIdentifier = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier for a container that's running in a compute.
         */
        public var containerName: kotlin.String? = null
        /**
         * The runtime ID for the container that's running in a compute. This value is unique within the compute. It is returned as a `ContainerAttribute` value in a `Compute` object.
         */
        public var containerRuntimeId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.ContainerIdentifier) : this() {
            this.containerName = x.containerName
            this.containerRuntimeId = x.containerRuntimeId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.ContainerIdentifier = ContainerIdentifier(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
