// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Instructions on when and how to check the health of a support container in a container fleet. These properties override any Docker health checks that are set in the container image. For more information on container health checks, see [HealthCheck command](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_HealthCheck.html#ECS-Type-HealthCheck-command) in the *Amazon Elastic Container Service API*. Game server containers don't have a health check parameter; Amazon GameLift Servers automatically handles health checks for these containers.
 *
 * The following example instructs the container to initiate a health check command every 60 seconds and wait 10 seconds for it to succeed. If it fails, retry the command 3 times before flagging the container as unhealthy. It also tells the container to wait 100 seconds after launch before counting failed health checks.
 *
 * `{"Command": [ "CMD-SHELL", "ps cax | grep "processmanager" || exit 1" ], "Interval": 60, "Timeout": 10, "Retries": 3, "StartPeriod": 100 }`
 *
 * **Part of:**[SupportContainerDefinition](https://docs.aws.amazon.com/gamelift/latest/apireference/API_SupportContainerDefinition.html), [SupportContainerDefinitionInput](https://docs.aws.amazon.com/gamelift/latest/apireference/API_SupportContainerDefinitionInput.html)
 */
public class ContainerHealthCheck private constructor(builder: Builder) {
    /**
     * A string array that specifies the command that the container runs to determine if it's healthy.
     */
    public val command: List<String>? = builder.command
    /**
     * The time period (in seconds) between each health check.
     */
    public val interval: kotlin.Int? = builder.interval
    /**
     * The number of times to retry a failed health check before flagging the container unhealthy. The first run of the command does not count as a retry.
     */
    public val retries: kotlin.Int? = builder.retries
    /**
     * The optional grace period (in seconds) to give a container time to bootstrap before the first failed health check counts toward the number of retries.
     */
    public val startPeriod: kotlin.Int? = builder.startPeriod
    /**
     * The time period (in seconds) to wait for a health check to succeed before counting a failed health check.
     */
    public val timeout: kotlin.Int? = builder.timeout

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.ContainerHealthCheck = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContainerHealthCheck(")
        append("command=$command,")
        append("interval=$interval,")
        append("retries=$retries,")
        append("startPeriod=$startPeriod,")
        append("timeout=$timeout")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = command?.hashCode() ?: 0
        result = 31 * result + (interval ?: 0)
        result = 31 * result + (retries ?: 0)
        result = 31 * result + (startPeriod ?: 0)
        result = 31 * result + (timeout ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContainerHealthCheck

        if (command != other.command) return false
        if (interval != other.interval) return false
        if (retries != other.retries) return false
        if (startPeriod != other.startPeriod) return false
        if (timeout != other.timeout) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.ContainerHealthCheck = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A string array that specifies the command that the container runs to determine if it's healthy.
         */
        public var command: List<String>? = null
        /**
         * The time period (in seconds) between each health check.
         */
        public var interval: kotlin.Int? = null
        /**
         * The number of times to retry a failed health check before flagging the container unhealthy. The first run of the command does not count as a retry.
         */
        public var retries: kotlin.Int? = null
        /**
         * The optional grace period (in seconds) to give a container time to bootstrap before the first failed health check counts toward the number of retries.
         */
        public var startPeriod: kotlin.Int? = null
        /**
         * The time period (in seconds) to wait for a health check to succeed before counting a failed health check.
         */
        public var timeout: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.ContainerHealthCheck) : this() {
            this.command = x.command
            this.interval = x.interval
            this.retries = x.retries
            this.startPeriod = x.startPeriod
            this.timeout = x.timeout
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.ContainerHealthCheck = ContainerHealthCheck(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
