// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The properties that describe a container group resource. You can update all properties of a container group definition properties. Updates to a container group definition are saved as new versions.
 *
 * **Used with:**[CreateContainerGroupDefinition](https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateContainerGroupDefinition.html)
 *
 * **Returned by:**[DescribeContainerGroupDefinition](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeContainerGroupDefinition.html), [ListContainerGroupDefinitions](https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListContainerGroupDefinitions.html), [UpdateContainerGroupDefinition](https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateContainerGroupDefinition.html)
 */
public class ContainerGroupDefinition private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name ([ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is assigned to an Amazon GameLift Servers `ContainerGroupDefinition` resource. It uniquely identifies the resource across all Amazon Web Services Regions. Format is `arn:aws:gamelift:[region]::containergroupdefinition/[container group definition name]:[version]`.
     */
    public val containerGroupDefinitionArn: kotlin.String? = builder.containerGroupDefinitionArn
    /**
     * The type of container group. Container group type determines how Amazon GameLift Servers deploys the container group on each fleet instance.
     */
    public val containerGroupType: aws.sdk.kotlin.services.gamelift.model.ContainerGroupType? = builder.containerGroupType
    /**
     * A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example `"1469498468.057"`).
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The definition for the game server container in this group. This property is used only when the container group type is `GAME_SERVER`. This container definition specifies a container image with the game server build.
     */
    public val gameServerContainerDefinition: aws.sdk.kotlin.services.gamelift.model.GameServerContainerDefinition? = builder.gameServerContainerDefinition
    /**
     * A descriptive identifier for the container group definition. The name value is unique in an Amazon Web Services Region.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The platform that all containers in the container group definition run on.
     *
     * Amazon Linux 2 (AL2) will reach end of support on 6/30/2025. See more details in the [Amazon Linux 2 FAQs](http://aws.amazon.com/amazon-linux-2/faqs/). For game servers that are hosted on AL2 and use server SDK version 4.x for Amazon GameLift Servers, first update the game server build to server SDK 5.x, and then deploy to AL2023 instances. See [ Migrate to server SDK version 5.](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk5-migration.html)
     */
    public val operatingSystem: aws.sdk.kotlin.services.gamelift.model.ContainerOperatingSystem? = builder.operatingSystem
    /**
     * Current status of the container group definition resource. Values include:
     * + `COPYING` -- Amazon GameLift Servers is in the process of making copies of all container images that are defined in the group. While in this state, the resource can't be used to create a container fleet.
     * + `READY` -- Amazon GameLift Servers has copied the registry images for all containers that are defined in the group. You can use a container group definition in this status to create a container fleet.
     * + `FAILED` -- Amazon GameLift Servers failed to create a valid container group definition resource. For more details on the cause of the failure, see `StatusReason`. A container group definition resource in failed status will be deleted within a few minutes.
     */
    public val status: aws.sdk.kotlin.services.gamelift.model.ContainerGroupDefinitionStatus? = builder.status
    /**
     * Additional information about a container group definition that's in `FAILED` status. Possible reasons include:
     * + An internal issue prevented Amazon GameLift Servers from creating the container group definition resource. Delete the failed resource and call [CreateContainerGroupDefinition](https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateContainerGroupDefinition.html)again.
     * + An access-denied message means that you don't have permissions to access the container image on ECR. See [ IAM permission examples](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-iam-policy-examples.html.html) for help setting up required IAM permissions for Amazon GameLift Servers.
     * + The `ImageUri` value for at least one of the containers in the container group definition was invalid or not found in the current Amazon Web Services account.
     * + At least one of the container images referenced in the container group definition exceeds the allowed size. For size limits, see [ Amazon GameLift Servers endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/gamelift.html).
     * + At least one of the container images referenced in the container group definition uses a different operating system than the one defined for the container group.
     */
    public val statusReason: kotlin.String? = builder.statusReason
    /**
     * The set of definitions for support containers in this group. A container group definition might have zero support container definitions. Support container can be used in any type of container group.
     */
    public val supportContainerDefinitions: List<SupportContainerDefinition>? = builder.supportContainerDefinitions
    /**
     * The amount of memory (in MiB) on a fleet instance to allocate for the container group. All containers in the group share these resources.
     *
     * You can set a limit for each container definition in the group. If individual containers have limits, this total value must be greater than any individual container's memory limit.
     */
    public val totalMemoryLimitMebibytes: kotlin.Int? = builder.totalMemoryLimitMebibytes
    /**
     * The amount of vCPU units on a fleet instance to allocate for the container group (1 vCPU is equal to 1024 CPU units). All containers in the group share these resources. You can set a limit for each container definition in the group. If individual containers have limits, this total value must be equal to or greater than the sum of the limits for each container in the group.
     */
    public val totalVcpuLimit: kotlin.Double? = builder.totalVcpuLimit
    /**
     * An optional description that was provided for a container group definition update. Each version can have a unique description.
     */
    public val versionDescription: kotlin.String? = builder.versionDescription
    /**
     * Indicates the version of a particular container group definition. This number is incremented automatically when you update a container group definition. You can view, update, or delete individual versions or the entire container group definition.
     */
    public val versionNumber: kotlin.Int? = builder.versionNumber

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.ContainerGroupDefinition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContainerGroupDefinition(")
        append("containerGroupDefinitionArn=$containerGroupDefinitionArn,")
        append("containerGroupType=$containerGroupType,")
        append("creationTime=$creationTime,")
        append("gameServerContainerDefinition=$gameServerContainerDefinition,")
        append("name=$name,")
        append("operatingSystem=$operatingSystem,")
        append("status=$status,")
        append("statusReason=$statusReason,")
        append("supportContainerDefinitions=$supportContainerDefinitions,")
        append("totalMemoryLimitMebibytes=$totalMemoryLimitMebibytes,")
        append("totalVcpuLimit=$totalVcpuLimit,")
        append("versionDescription=$versionDescription,")
        append("versionNumber=$versionNumber")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = containerGroupDefinitionArn?.hashCode() ?: 0
        result = 31 * result + (containerGroupType?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (gameServerContainerDefinition?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (operatingSystem?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (supportContainerDefinitions?.hashCode() ?: 0)
        result = 31 * result + (totalMemoryLimitMebibytes ?: 0)
        result = 31 * result + (totalVcpuLimit?.hashCode() ?: 0)
        result = 31 * result + (versionDescription?.hashCode() ?: 0)
        result = 31 * result + (versionNumber ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContainerGroupDefinition

        if (containerGroupDefinitionArn != other.containerGroupDefinitionArn) return false
        if (containerGroupType != other.containerGroupType) return false
        if (creationTime != other.creationTime) return false
        if (gameServerContainerDefinition != other.gameServerContainerDefinition) return false
        if (name != other.name) return false
        if (operatingSystem != other.operatingSystem) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false
        if (supportContainerDefinitions != other.supportContainerDefinitions) return false
        if (totalMemoryLimitMebibytes != other.totalMemoryLimitMebibytes) return false
        if (!(totalVcpuLimit?.equals(other.totalVcpuLimit) ?: (other.totalVcpuLimit == null))) return false
        if (versionDescription != other.versionDescription) return false
        if (versionNumber != other.versionNumber) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.ContainerGroupDefinition = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name ([ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is assigned to an Amazon GameLift Servers `ContainerGroupDefinition` resource. It uniquely identifies the resource across all Amazon Web Services Regions. Format is `arn:aws:gamelift:[region]::containergroupdefinition/[container group definition name]:[version]`.
         */
        public var containerGroupDefinitionArn: kotlin.String? = null
        /**
         * The type of container group. Container group type determines how Amazon GameLift Servers deploys the container group on each fleet instance.
         */
        public var containerGroupType: aws.sdk.kotlin.services.gamelift.model.ContainerGroupType? = null
        /**
         * A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example `"1469498468.057"`).
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The definition for the game server container in this group. This property is used only when the container group type is `GAME_SERVER`. This container definition specifies a container image with the game server build.
         */
        public var gameServerContainerDefinition: aws.sdk.kotlin.services.gamelift.model.GameServerContainerDefinition? = null
        /**
         * A descriptive identifier for the container group definition. The name value is unique in an Amazon Web Services Region.
         */
        public var name: kotlin.String? = null
        /**
         * The platform that all containers in the container group definition run on.
         *
         * Amazon Linux 2 (AL2) will reach end of support on 6/30/2025. See more details in the [Amazon Linux 2 FAQs](http://aws.amazon.com/amazon-linux-2/faqs/). For game servers that are hosted on AL2 and use server SDK version 4.x for Amazon GameLift Servers, first update the game server build to server SDK 5.x, and then deploy to AL2023 instances. See [ Migrate to server SDK version 5.](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk5-migration.html)
         */
        public var operatingSystem: aws.sdk.kotlin.services.gamelift.model.ContainerOperatingSystem? = null
        /**
         * Current status of the container group definition resource. Values include:
         * + `COPYING` -- Amazon GameLift Servers is in the process of making copies of all container images that are defined in the group. While in this state, the resource can't be used to create a container fleet.
         * + `READY` -- Amazon GameLift Servers has copied the registry images for all containers that are defined in the group. You can use a container group definition in this status to create a container fleet.
         * + `FAILED` -- Amazon GameLift Servers failed to create a valid container group definition resource. For more details on the cause of the failure, see `StatusReason`. A container group definition resource in failed status will be deleted within a few minutes.
         */
        public var status: aws.sdk.kotlin.services.gamelift.model.ContainerGroupDefinitionStatus? = null
        /**
         * Additional information about a container group definition that's in `FAILED` status. Possible reasons include:
         * + An internal issue prevented Amazon GameLift Servers from creating the container group definition resource. Delete the failed resource and call [CreateContainerGroupDefinition](https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateContainerGroupDefinition.html)again.
         * + An access-denied message means that you don't have permissions to access the container image on ECR. See [ IAM permission examples](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-iam-policy-examples.html.html) for help setting up required IAM permissions for Amazon GameLift Servers.
         * + The `ImageUri` value for at least one of the containers in the container group definition was invalid or not found in the current Amazon Web Services account.
         * + At least one of the container images referenced in the container group definition exceeds the allowed size. For size limits, see [ Amazon GameLift Servers endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/gamelift.html).
         * + At least one of the container images referenced in the container group definition uses a different operating system than the one defined for the container group.
         */
        public var statusReason: kotlin.String? = null
        /**
         * The set of definitions for support containers in this group. A container group definition might have zero support container definitions. Support container can be used in any type of container group.
         */
        public var supportContainerDefinitions: List<SupportContainerDefinition>? = null
        /**
         * The amount of memory (in MiB) on a fleet instance to allocate for the container group. All containers in the group share these resources.
         *
         * You can set a limit for each container definition in the group. If individual containers have limits, this total value must be greater than any individual container's memory limit.
         */
        public var totalMemoryLimitMebibytes: kotlin.Int? = null
        /**
         * The amount of vCPU units on a fleet instance to allocate for the container group (1 vCPU is equal to 1024 CPU units). All containers in the group share these resources. You can set a limit for each container definition in the group. If individual containers have limits, this total value must be equal to or greater than the sum of the limits for each container in the group.
         */
        public var totalVcpuLimit: kotlin.Double? = null
        /**
         * An optional description that was provided for a container group definition update. Each version can have a unique description.
         */
        public var versionDescription: kotlin.String? = null
        /**
         * Indicates the version of a particular container group definition. This number is incremented automatically when you update a container group definition. You can view, update, or delete individual versions or the entire container group definition.
         */
        public var versionNumber: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.ContainerGroupDefinition) : this() {
            this.containerGroupDefinitionArn = x.containerGroupDefinitionArn
            this.containerGroupType = x.containerGroupType
            this.creationTime = x.creationTime
            this.gameServerContainerDefinition = x.gameServerContainerDefinition
            this.name = x.name
            this.operatingSystem = x.operatingSystem
            this.status = x.status
            this.statusReason = x.statusReason
            this.supportContainerDefinitions = x.supportContainerDefinitions
            this.totalMemoryLimitMebibytes = x.totalMemoryLimitMebibytes
            this.totalVcpuLimit = x.totalVcpuLimit
            this.versionDescription = x.versionDescription
            this.versionNumber = x.versionNumber
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.ContainerGroupDefinition = ContainerGroupDefinition(this)

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.GameServerContainerDefinition] inside the given [block]
         */
        public fun gameServerContainerDefinition(block: aws.sdk.kotlin.services.gamelift.model.GameServerContainerDefinition.Builder.() -> kotlin.Unit) {
            this.gameServerContainerDefinition = aws.sdk.kotlin.services.gamelift.model.GameServerContainerDefinition.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
