// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Details about a location in a multi-location container fleet.
 */
public class ContainerFleetLocationAttributes private constructor(builder: Builder) {
    /**
     * A location identifier.
     */
    public val location: kotlin.String? = builder.location
    /**
     * The status of fleet activity in the location.
     * + `PENDING` -- A new container fleet has been requested.
     * + `CREATING` -- A new container fleet resource is being created.
     * + `CREATED` -- A new container fleet resource has been created. No fleet instances have been deployed.
     * + `ACTIVATING` -- New container fleet instances are being deployed.
     * + `ACTIVE` -- The container fleet has been deployed and is ready to host game sessions.
     * + `UPDATING` -- Updates to the container fleet is being updated. A deployment is in progress.
     */
    public val status: aws.sdk.kotlin.services.gamelift.model.ContainerFleetLocationStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.ContainerFleetLocationAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContainerFleetLocationAttributes(")
        append("location=$location,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = location?.hashCode() ?: 0
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContainerFleetLocationAttributes

        if (location != other.location) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.ContainerFleetLocationAttributes = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A location identifier.
         */
        public var location: kotlin.String? = null
        /**
         * The status of fleet activity in the location.
         * + `PENDING` -- A new container fleet has been requested.
         * + `CREATING` -- A new container fleet resource is being created.
         * + `CREATED` -- A new container fleet resource has been created. No fleet instances have been deployed.
         * + `ACTIVATING` -- New container fleet instances are being deployed.
         * + `ACTIVE` -- The container fleet has been deployed and is ready to host game sessions.
         * + `UPDATING` -- Updates to the container fleet is being updated. A deployment is in progress.
         */
        public var status: aws.sdk.kotlin.services.gamelift.model.ContainerFleetLocationStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.ContainerFleetLocationAttributes) : this() {
            this.location = x.location
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.ContainerFleetLocationAttributes = ContainerFleetLocationAttributes(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
