// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an Amazon GameLift Servers managed container fleet.
 */
public class ContainerFleet private constructor(builder: Builder) {
    /**
     * Indicates whether the fleet uses On-Demand or Spot instances for this fleet. Learn more about when to use [ On-Demand versus Spot Instances](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot). You can't update this fleet property.
     *
     * By default, this property is set to `ON_DEMAND`.
     */
    public val billingType: aws.sdk.kotlin.services.gamelift.model.ContainerFleetBillingType? = builder.billingType
    /**
     * A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example `"1469498468.057"`).
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * Information about the most recent deployment for the container fleet.
     */
    public val deploymentDetails: aws.sdk.kotlin.services.gamelift.model.DeploymentDetails? = builder.deploymentDetails
    /**
     * A meaningful description of the container fleet.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The Amazon Resource Name ([ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is assigned to a Amazon GameLift Servers fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is `arn:aws:gamelift:<region>::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912`. In a GameLift fleet ARN, the resource ID matches the `FleetId` value.
     */
    public val fleetArn: kotlin.String? = builder.fleetArn
    /**
     * A unique identifier for the container fleet to retrieve.
     */
    public val fleetId: kotlin.String? = builder.fleetId
    /**
     * The unique identifier for an Identity and Access Management (IAM) role with permissions to run your containers on resources that are managed by Amazon GameLift Servers. See [Set up an IAM service role](https://docs.aws.amazon.com/gamelift/latest/developerguide/setting-up-role.html). This fleet property can't be changed.
     */
    public val fleetRoleArn: kotlin.String? = builder.fleetRoleArn
    /**
     * The Amazon Resource Name ([ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is assigned to the fleet's game server container group. The ARN value also identifies the specific container group definition version in use.
     */
    public val gameServerContainerGroupDefinitionArn: kotlin.String? = builder.gameServerContainerGroupDefinitionArn
    /**
     * The name of the fleet's game server container group definition, which describes how to deploy containers with your game server build and support software onto each fleet instance.
     */
    public val gameServerContainerGroupDefinitionName: kotlin.String? = builder.gameServerContainerGroupDefinitionName
    /**
     * The number of times to replicate the game server container group on each fleet instance.
     */
    public val gameServerContainerGroupsPerInstance: kotlin.Int? = builder.gameServerContainerGroupsPerInstance
    /**
     * A policy that limits the number of game sessions that each individual player can create on instances in this fleet. The limit applies for a specified span of time.
     */
    public val gameSessionCreationLimitPolicy: aws.sdk.kotlin.services.gamelift.model.GameSessionCreationLimitPolicy? = builder.gameSessionCreationLimitPolicy
    /**
     * The set of port numbers to open on each instance in a container fleet. Connection ports are used by inbound traffic to connect with processes that are running in containers on the fleet.
     */
    public val instanceConnectionPortRange: aws.sdk.kotlin.services.gamelift.model.ConnectionPortRange? = builder.instanceConnectionPortRange
    /**
     * The IP address ranges and port settings that allow inbound traffic to access game server processes and other processes on this fleet.
     */
    public val instanceInboundPermissions: List<IpPermission>? = builder.instanceInboundPermissions
    /**
     * The Amazon EC2 instance type to use for all instances in the fleet. Instance type determines the computing resources and processing power that's available to host your game servers. This includes including CPU, memory, storage, and networking capacity. You can't update this fleet property.
     */
    public val instanceType: kotlin.String? = builder.instanceType
    /**
     * Information about the container fleet's remote locations where fleet instances are deployed.
     */
    public val locationAttributes: List<ContainerFleetLocationAttributes>? = builder.locationAttributes
    /**
     * The method that is used to collect container logs for the fleet. Amazon GameLift Servers saves all standard output for each container in logs, including game session logs.
     * + `CLOUDWATCH` -- Send logs to an Amazon CloudWatch log group that you define. Each container emits a log stream, which is organized in the log group.
     * + `S3` -- Store logs in an Amazon S3 bucket that you define.
     * + `NONE` -- Don't collect container logs.
     */
    public val logConfiguration: aws.sdk.kotlin.services.gamelift.model.LogConfiguration? = builder.logConfiguration
    /**
     * The calculated maximum number of game server container group that can be deployed on each fleet instance. The calculation depends on the resource needs of the container group and the CPU and memory resources of the fleet's instance type.
     */
    public val maximumGameServerContainerGroupsPerInstance: kotlin.Int? = builder.maximumGameServerContainerGroupsPerInstance
    /**
     * The name of an Amazon Web Services CloudWatch metric group to add this fleet to. Metric groups aggregate metrics for multiple fleets.
     */
    public val metricGroups: List<String>? = builder.metricGroups
    /**
     * Determines whether Amazon GameLift Servers can shut down game sessions on the fleet that are actively running and hosting players. Amazon GameLift Servers might prompt an instance shutdown when scaling down fleet capacity or when retiring unhealthy instances. You can also set game session protection for individual game sessions using [UpdateGameSession](gamelift/latest/apireference/API_UpdateGameSession.html).
     * + **NoProtection** -- Game sessions can be shut down during active gameplay.
     * + **FullProtection** -- Game sessions in `ACTIVE` status can't be shut down.
     */
    public val newGameSessionProtectionPolicy: aws.sdk.kotlin.services.gamelift.model.ProtectionPolicy? = builder.newGameSessionProtectionPolicy
    /**
     * The Amazon Resource Name ([ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is assigned to the fleet's per-instance container group. The ARN value also identifies the specific container group definition version in use.
     */
    public val perInstanceContainerGroupDefinitionArn: kotlin.String? = builder.perInstanceContainerGroupDefinitionArn
    /**
     * The name of the fleet's per-instance container group definition.
     */
    public val perInstanceContainerGroupDefinitionName: kotlin.String? = builder.perInstanceContainerGroupDefinitionName
    /**
     * The current status of the container fleet.
     * + `PENDING` -- A new container fleet has been requested.
     * + `CREATING` -- A new container fleet resource is being created.
     * + `CREATED` -- A new container fleet resource has been created. No fleet instances have been deployed.
     * + `ACTIVATING` -- New container fleet instances are being deployed.
     * + `ACTIVE` -- The container fleet has been deployed and is ready to host game sessions.
     * + `UPDATING` -- Updates to the container fleet is being updated. A deployment is in progress.
     */
    public val status: aws.sdk.kotlin.services.gamelift.model.ContainerFleetStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.ContainerFleet = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContainerFleet(")
        append("billingType=$billingType,")
        append("creationTime=$creationTime,")
        append("deploymentDetails=$deploymentDetails,")
        append("description=$description,")
        append("fleetArn=$fleetArn,")
        append("fleetId=$fleetId,")
        append("fleetRoleArn=$fleetRoleArn,")
        append("gameServerContainerGroupDefinitionArn=$gameServerContainerGroupDefinitionArn,")
        append("gameServerContainerGroupDefinitionName=$gameServerContainerGroupDefinitionName,")
        append("gameServerContainerGroupsPerInstance=$gameServerContainerGroupsPerInstance,")
        append("gameSessionCreationLimitPolicy=$gameSessionCreationLimitPolicy,")
        append("instanceConnectionPortRange=$instanceConnectionPortRange,")
        append("instanceInboundPermissions=$instanceInboundPermissions,")
        append("instanceType=$instanceType,")
        append("locationAttributes=$locationAttributes,")
        append("logConfiguration=$logConfiguration,")
        append("maximumGameServerContainerGroupsPerInstance=$maximumGameServerContainerGroupsPerInstance,")
        append("metricGroups=$metricGroups,")
        append("newGameSessionProtectionPolicy=$newGameSessionProtectionPolicy,")
        append("perInstanceContainerGroupDefinitionArn=$perInstanceContainerGroupDefinitionArn,")
        append("perInstanceContainerGroupDefinitionName=$perInstanceContainerGroupDefinitionName,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = billingType?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (deploymentDetails?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (fleetArn?.hashCode() ?: 0)
        result = 31 * result + (fleetId?.hashCode() ?: 0)
        result = 31 * result + (fleetRoleArn?.hashCode() ?: 0)
        result = 31 * result + (gameServerContainerGroupDefinitionArn?.hashCode() ?: 0)
        result = 31 * result + (gameServerContainerGroupDefinitionName?.hashCode() ?: 0)
        result = 31 * result + (gameServerContainerGroupsPerInstance ?: 0)
        result = 31 * result + (gameSessionCreationLimitPolicy?.hashCode() ?: 0)
        result = 31 * result + (instanceConnectionPortRange?.hashCode() ?: 0)
        result = 31 * result + (instanceInboundPermissions?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (locationAttributes?.hashCode() ?: 0)
        result = 31 * result + (logConfiguration?.hashCode() ?: 0)
        result = 31 * result + (maximumGameServerContainerGroupsPerInstance ?: 0)
        result = 31 * result + (metricGroups?.hashCode() ?: 0)
        result = 31 * result + (newGameSessionProtectionPolicy?.hashCode() ?: 0)
        result = 31 * result + (perInstanceContainerGroupDefinitionArn?.hashCode() ?: 0)
        result = 31 * result + (perInstanceContainerGroupDefinitionName?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContainerFleet

        if (billingType != other.billingType) return false
        if (creationTime != other.creationTime) return false
        if (deploymentDetails != other.deploymentDetails) return false
        if (description != other.description) return false
        if (fleetArn != other.fleetArn) return false
        if (fleetId != other.fleetId) return false
        if (fleetRoleArn != other.fleetRoleArn) return false
        if (gameServerContainerGroupDefinitionArn != other.gameServerContainerGroupDefinitionArn) return false
        if (gameServerContainerGroupDefinitionName != other.gameServerContainerGroupDefinitionName) return false
        if (gameServerContainerGroupsPerInstance != other.gameServerContainerGroupsPerInstance) return false
        if (gameSessionCreationLimitPolicy != other.gameSessionCreationLimitPolicy) return false
        if (instanceConnectionPortRange != other.instanceConnectionPortRange) return false
        if (instanceInboundPermissions != other.instanceInboundPermissions) return false
        if (instanceType != other.instanceType) return false
        if (locationAttributes != other.locationAttributes) return false
        if (logConfiguration != other.logConfiguration) return false
        if (maximumGameServerContainerGroupsPerInstance != other.maximumGameServerContainerGroupsPerInstance) return false
        if (metricGroups != other.metricGroups) return false
        if (newGameSessionProtectionPolicy != other.newGameSessionProtectionPolicy) return false
        if (perInstanceContainerGroupDefinitionArn != other.perInstanceContainerGroupDefinitionArn) return false
        if (perInstanceContainerGroupDefinitionName != other.perInstanceContainerGroupDefinitionName) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.ContainerFleet = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates whether the fleet uses On-Demand or Spot instances for this fleet. Learn more about when to use [ On-Demand versus Spot Instances](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot). You can't update this fleet property.
         *
         * By default, this property is set to `ON_DEMAND`.
         */
        public var billingType: aws.sdk.kotlin.services.gamelift.model.ContainerFleetBillingType? = null
        /**
         * A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example `"1469498468.057"`).
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Information about the most recent deployment for the container fleet.
         */
        public var deploymentDetails: aws.sdk.kotlin.services.gamelift.model.DeploymentDetails? = null
        /**
         * A meaningful description of the container fleet.
         */
        public var description: kotlin.String? = null
        /**
         * The Amazon Resource Name ([ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is assigned to a Amazon GameLift Servers fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is `arn:aws:gamelift:<region>::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912`. In a GameLift fleet ARN, the resource ID matches the `FleetId` value.
         */
        public var fleetArn: kotlin.String? = null
        /**
         * A unique identifier for the container fleet to retrieve.
         */
        public var fleetId: kotlin.String? = null
        /**
         * The unique identifier for an Identity and Access Management (IAM) role with permissions to run your containers on resources that are managed by Amazon GameLift Servers. See [Set up an IAM service role](https://docs.aws.amazon.com/gamelift/latest/developerguide/setting-up-role.html). This fleet property can't be changed.
         */
        public var fleetRoleArn: kotlin.String? = null
        /**
         * The Amazon Resource Name ([ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is assigned to the fleet's game server container group. The ARN value also identifies the specific container group definition version in use.
         */
        public var gameServerContainerGroupDefinitionArn: kotlin.String? = null
        /**
         * The name of the fleet's game server container group definition, which describes how to deploy containers with your game server build and support software onto each fleet instance.
         */
        public var gameServerContainerGroupDefinitionName: kotlin.String? = null
        /**
         * The number of times to replicate the game server container group on each fleet instance.
         */
        public var gameServerContainerGroupsPerInstance: kotlin.Int? = null
        /**
         * A policy that limits the number of game sessions that each individual player can create on instances in this fleet. The limit applies for a specified span of time.
         */
        public var gameSessionCreationLimitPolicy: aws.sdk.kotlin.services.gamelift.model.GameSessionCreationLimitPolicy? = null
        /**
         * The set of port numbers to open on each instance in a container fleet. Connection ports are used by inbound traffic to connect with processes that are running in containers on the fleet.
         */
        public var instanceConnectionPortRange: aws.sdk.kotlin.services.gamelift.model.ConnectionPortRange? = null
        /**
         * The IP address ranges and port settings that allow inbound traffic to access game server processes and other processes on this fleet.
         */
        public var instanceInboundPermissions: List<IpPermission>? = null
        /**
         * The Amazon EC2 instance type to use for all instances in the fleet. Instance type determines the computing resources and processing power that's available to host your game servers. This includes including CPU, memory, storage, and networking capacity. You can't update this fleet property.
         */
        public var instanceType: kotlin.String? = null
        /**
         * Information about the container fleet's remote locations where fleet instances are deployed.
         */
        public var locationAttributes: List<ContainerFleetLocationAttributes>? = null
        /**
         * The method that is used to collect container logs for the fleet. Amazon GameLift Servers saves all standard output for each container in logs, including game session logs.
         * + `CLOUDWATCH` -- Send logs to an Amazon CloudWatch log group that you define. Each container emits a log stream, which is organized in the log group.
         * + `S3` -- Store logs in an Amazon S3 bucket that you define.
         * + `NONE` -- Don't collect container logs.
         */
        public var logConfiguration: aws.sdk.kotlin.services.gamelift.model.LogConfiguration? = null
        /**
         * The calculated maximum number of game server container group that can be deployed on each fleet instance. The calculation depends on the resource needs of the container group and the CPU and memory resources of the fleet's instance type.
         */
        public var maximumGameServerContainerGroupsPerInstance: kotlin.Int? = null
        /**
         * The name of an Amazon Web Services CloudWatch metric group to add this fleet to. Metric groups aggregate metrics for multiple fleets.
         */
        public var metricGroups: List<String>? = null
        /**
         * Determines whether Amazon GameLift Servers can shut down game sessions on the fleet that are actively running and hosting players. Amazon GameLift Servers might prompt an instance shutdown when scaling down fleet capacity or when retiring unhealthy instances. You can also set game session protection for individual game sessions using [UpdateGameSession](gamelift/latest/apireference/API_UpdateGameSession.html).
         * + **NoProtection** -- Game sessions can be shut down during active gameplay.
         * + **FullProtection** -- Game sessions in `ACTIVE` status can't be shut down.
         */
        public var newGameSessionProtectionPolicy: aws.sdk.kotlin.services.gamelift.model.ProtectionPolicy? = null
        /**
         * The Amazon Resource Name ([ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is assigned to the fleet's per-instance container group. The ARN value also identifies the specific container group definition version in use.
         */
        public var perInstanceContainerGroupDefinitionArn: kotlin.String? = null
        /**
         * The name of the fleet's per-instance container group definition.
         */
        public var perInstanceContainerGroupDefinitionName: kotlin.String? = null
        /**
         * The current status of the container fleet.
         * + `PENDING` -- A new container fleet has been requested.
         * + `CREATING` -- A new container fleet resource is being created.
         * + `CREATED` -- A new container fleet resource has been created. No fleet instances have been deployed.
         * + `ACTIVATING` -- New container fleet instances are being deployed.
         * + `ACTIVE` -- The container fleet has been deployed and is ready to host game sessions.
         * + `UPDATING` -- Updates to the container fleet is being updated. A deployment is in progress.
         */
        public var status: aws.sdk.kotlin.services.gamelift.model.ContainerFleetStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.ContainerFleet) : this() {
            this.billingType = x.billingType
            this.creationTime = x.creationTime
            this.deploymentDetails = x.deploymentDetails
            this.description = x.description
            this.fleetArn = x.fleetArn
            this.fleetId = x.fleetId
            this.fleetRoleArn = x.fleetRoleArn
            this.gameServerContainerGroupDefinitionArn = x.gameServerContainerGroupDefinitionArn
            this.gameServerContainerGroupDefinitionName = x.gameServerContainerGroupDefinitionName
            this.gameServerContainerGroupsPerInstance = x.gameServerContainerGroupsPerInstance
            this.gameSessionCreationLimitPolicy = x.gameSessionCreationLimitPolicy
            this.instanceConnectionPortRange = x.instanceConnectionPortRange
            this.instanceInboundPermissions = x.instanceInboundPermissions
            this.instanceType = x.instanceType
            this.locationAttributes = x.locationAttributes
            this.logConfiguration = x.logConfiguration
            this.maximumGameServerContainerGroupsPerInstance = x.maximumGameServerContainerGroupsPerInstance
            this.metricGroups = x.metricGroups
            this.newGameSessionProtectionPolicy = x.newGameSessionProtectionPolicy
            this.perInstanceContainerGroupDefinitionArn = x.perInstanceContainerGroupDefinitionArn
            this.perInstanceContainerGroupDefinitionName = x.perInstanceContainerGroupDefinitionName
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.ContainerFleet = ContainerFleet(this)

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.DeploymentDetails] inside the given [block]
         */
        public fun deploymentDetails(block: aws.sdk.kotlin.services.gamelift.model.DeploymentDetails.Builder.() -> kotlin.Unit) {
            this.deploymentDetails = aws.sdk.kotlin.services.gamelift.model.DeploymentDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.GameSessionCreationLimitPolicy] inside the given [block]
         */
        public fun gameSessionCreationLimitPolicy(block: aws.sdk.kotlin.services.gamelift.model.GameSessionCreationLimitPolicy.Builder.() -> kotlin.Unit) {
            this.gameSessionCreationLimitPolicy = aws.sdk.kotlin.services.gamelift.model.GameSessionCreationLimitPolicy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.ConnectionPortRange] inside the given [block]
         */
        public fun instanceConnectionPortRange(block: aws.sdk.kotlin.services.gamelift.model.ConnectionPortRange.Builder.() -> kotlin.Unit) {
            this.instanceConnectionPortRange = aws.sdk.kotlin.services.gamelift.model.ConnectionPortRange.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.LogConfiguration] inside the given [block]
         */
        public fun logConfiguration(block: aws.sdk.kotlin.services.gamelift.model.LogConfiguration.Builder.() -> kotlin.Unit) {
            this.logConfiguration = aws.sdk.kotlin.services.gamelift.model.LogConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
