// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A container's dependency on another container in the same container group. The dependency impacts how the dependent container is able to start or shut down based the status of the other container.
 *
 * For example, *ContainerA* is configured with the following dependency: a `START` dependency on *ContainerB*. This means that *ContainerA* can't start until *ContainerB* has started. It also means that *ContainerA* must shut down before *ContainerB*.
 *
 * **Part of:**[GameServerContainerDefinition](https://docs.aws.amazon.com/gamelift/latest/apireference/API_GameServerContainerDefinition.html), [GameServerContainerDefinitionInput](https://docs.aws.amazon.com/gamelift/latest/apireference/API_GameServerContainerDefinitionInput.html), [SupportContainerDefinition](https://docs.aws.amazon.com/gamelift/latest/apireference/API_SupportContainerDefinition.html), [SupportContainerDefinitionInput](https://docs.aws.amazon.com/gamelift/latest/apireference/API_SupportContainerDefinitionInput.html)
 */
public class ContainerDependency private constructor(builder: Builder) {
    /**
     * The condition that the dependency container must reach before the dependent container can start. Valid conditions include:
     * + START - The dependency container must have started.
     * + COMPLETE - The dependency container has run to completion (exits). Use this condition with nonessential containers, such as those that run a script and then exit. The dependency container can't be an essential container.
     * + SUCCESS - The dependency container has run to completion and exited with a zero status. The dependency container can't be an essential container.
     * + HEALTHY - The dependency container has passed its Docker health check. Use this condition with dependency containers that have health checks configured. This condition is confirmed at container group startup only.
     */
    public val condition: aws.sdk.kotlin.services.gamelift.model.ContainerDependencyCondition? = builder.condition
    /**
     * A descriptive label for the container definition that this container depends on.
     */
    public val containerName: kotlin.String? = builder.containerName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.ContainerDependency = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContainerDependency(")
        append("condition=$condition,")
        append("containerName=$containerName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = condition?.hashCode() ?: 0
        result = 31 * result + (containerName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContainerDependency

        if (condition != other.condition) return false
        if (containerName != other.containerName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.ContainerDependency = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The condition that the dependency container must reach before the dependent container can start. Valid conditions include:
         * + START - The dependency container must have started.
         * + COMPLETE - The dependency container has run to completion (exits). Use this condition with nonessential containers, such as those that run a script and then exit. The dependency container can't be an essential container.
         * + SUCCESS - The dependency container has run to completion and exited with a zero status. The dependency container can't be an essential container.
         * + HEALTHY - The dependency container has passed its Docker health check. Use this condition with dependency containers that have health checks configured. This condition is confirmed at container group startup only.
         */
        public var condition: aws.sdk.kotlin.services.gamelift.model.ContainerDependencyCondition? = null
        /**
         * A descriptive label for the container definition that this container depends on.
         */
        public var containerName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.ContainerDependency) : this() {
            this.condition = x.condition
            this.containerName = x.containerName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.ContainerDependency = ContainerDependency(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
