// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * An Amazon GameLift Servers compute resource for hosting your game servers. Computes in an Amazon GameLift Servers fleet differs depending on the fleet's compute type property as follows:
 * + For managed EC2 fleets, a compute is an EC2 instance.
 * + For Anywhere fleets, a compute is a computing resource that you provide and is registered to the fleet.
 */
public class Compute private constructor(builder: Builder) {
    /**
     * The ARN that is assigned to a compute resource and uniquely identifies it. ARNs are unique across locations. Instances in managed EC2 fleets are not assigned a Compute ARN.
     */
    public val computeArn: kotlin.String? = builder.computeArn
    /**
     * A descriptive label for the compute resource. For instances in a managed EC2 fleet, the compute name is the same value as the `InstanceId` ID.
     */
    public val computeName: kotlin.String? = builder.computeName
    /**
     * Current status of the compute. A compute must have an `ACTIVE` status to host game sessions.
     */
    public val computeStatus: aws.sdk.kotlin.services.gamelift.model.ComputeStatus? = builder.computeStatus
    /**
     * A set of attributes for each container in the compute.
     */
    public val containerAttributes: List<ContainerAttribute>? = builder.containerAttributes
    /**
     * A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example `"1469498468.057"`).
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The DNS name of a compute resource. Amazon GameLift Servers requires a DNS name or IP address for a compute.
     */
    public val dnsName: kotlin.String? = builder.dnsName
    /**
     * The Amazon Resource Name (ARN) of the fleet that the compute belongs to.
     */
    public val fleetArn: kotlin.String? = builder.fleetArn
    /**
     * A unique identifier for the fleet that the compute belongs to.
     */
    public val fleetId: kotlin.String? = builder.fleetId
    /**
     * The endpoint of the Amazon GameLift Servers Agent.
     */
    public val gameLiftAgentEndpoint: kotlin.String? = builder.gameLiftAgentEndpoint
    /**
     * The Amazon GameLift Servers SDK endpoint connection for a registered compute resource in an Anywhere fleet. The game servers on the compute use this endpoint to connect to the Amazon GameLift Servers service.
     */
    public val gameLiftServiceSdkEndpoint: kotlin.String? = builder.gameLiftServiceSdkEndpoint
    /**
     * The game server container group definition for the compute.
     */
    public val gameServerContainerGroupDefinitionArn: kotlin.String? = builder.gameServerContainerGroupDefinitionArn
    /**
     * The `InstanceID` of the EC2 instance that is hosting the compute.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * The IP address of a compute resource. Amazon GameLift Servers requires a DNS name or IP address for a compute.
     */
    public val ipAddress: kotlin.String? = builder.ipAddress
    /**
     * The name of the custom location you added to the fleet that this compute resource resides in.
     */
    public val location: kotlin.String? = builder.location
    /**
     * The type of operating system on the compute resource.
     *
     * Amazon Linux 2 (AL2) will reach end of support on 6/30/2025. See more details in the [Amazon Linux 2 FAQs](http://aws.amazon.com/aws.amazon.com/amazon-linux-2/faqs/). For game servers that are hosted on AL2 and use server SDK version 4.x for Amazon GameLift Servers, first update the game server build to server SDK 5.x, and then deploy to AL2023 instances. See [ Migrate to server SDK version 5.](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk5-migration.html)
     */
    public val operatingSystem: aws.sdk.kotlin.services.gamelift.model.OperatingSystem? = builder.operatingSystem
    /**
     * The Amazon EC2 instance type that the fleet uses. For registered computes in an Amazon GameLift Servers Anywhere fleet, this property is empty.
     */
    public val type: aws.sdk.kotlin.services.gamelift.model.Ec2InstanceType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.Compute = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Compute(")
        append("computeArn=$computeArn,")
        append("computeName=$computeName,")
        append("computeStatus=$computeStatus,")
        append("containerAttributes=$containerAttributes,")
        append("creationTime=$creationTime,")
        append("dnsName=$dnsName,")
        append("fleetArn=$fleetArn,")
        append("fleetId=$fleetId,")
        append("gameLiftAgentEndpoint=$gameLiftAgentEndpoint,")
        append("gameLiftServiceSdkEndpoint=$gameLiftServiceSdkEndpoint,")
        append("gameServerContainerGroupDefinitionArn=$gameServerContainerGroupDefinitionArn,")
        append("instanceId=$instanceId,")
        append("ipAddress=*** Sensitive Data Redacted ***,")
        append("location=$location,")
        append("operatingSystem=$operatingSystem,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = computeArn?.hashCode() ?: 0
        result = 31 * result + (computeName?.hashCode() ?: 0)
        result = 31 * result + (computeStatus?.hashCode() ?: 0)
        result = 31 * result + (containerAttributes?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (dnsName?.hashCode() ?: 0)
        result = 31 * result + (fleetArn?.hashCode() ?: 0)
        result = 31 * result + (fleetId?.hashCode() ?: 0)
        result = 31 * result + (gameLiftAgentEndpoint?.hashCode() ?: 0)
        result = 31 * result + (gameLiftServiceSdkEndpoint?.hashCode() ?: 0)
        result = 31 * result + (gameServerContainerGroupDefinitionArn?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (ipAddress?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (operatingSystem?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Compute

        if (computeArn != other.computeArn) return false
        if (computeName != other.computeName) return false
        if (computeStatus != other.computeStatus) return false
        if (containerAttributes != other.containerAttributes) return false
        if (creationTime != other.creationTime) return false
        if (dnsName != other.dnsName) return false
        if (fleetArn != other.fleetArn) return false
        if (fleetId != other.fleetId) return false
        if (gameLiftAgentEndpoint != other.gameLiftAgentEndpoint) return false
        if (gameLiftServiceSdkEndpoint != other.gameLiftServiceSdkEndpoint) return false
        if (gameServerContainerGroupDefinitionArn != other.gameServerContainerGroupDefinitionArn) return false
        if (instanceId != other.instanceId) return false
        if (ipAddress != other.ipAddress) return false
        if (location != other.location) return false
        if (operatingSystem != other.operatingSystem) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.Compute = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN that is assigned to a compute resource and uniquely identifies it. ARNs are unique across locations. Instances in managed EC2 fleets are not assigned a Compute ARN.
         */
        public var computeArn: kotlin.String? = null
        /**
         * A descriptive label for the compute resource. For instances in a managed EC2 fleet, the compute name is the same value as the `InstanceId` ID.
         */
        public var computeName: kotlin.String? = null
        /**
         * Current status of the compute. A compute must have an `ACTIVE` status to host game sessions.
         */
        public var computeStatus: aws.sdk.kotlin.services.gamelift.model.ComputeStatus? = null
        /**
         * A set of attributes for each container in the compute.
         */
        public var containerAttributes: List<ContainerAttribute>? = null
        /**
         * A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example `"1469498468.057"`).
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The DNS name of a compute resource. Amazon GameLift Servers requires a DNS name or IP address for a compute.
         */
        public var dnsName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the fleet that the compute belongs to.
         */
        public var fleetArn: kotlin.String? = null
        /**
         * A unique identifier for the fleet that the compute belongs to.
         */
        public var fleetId: kotlin.String? = null
        /**
         * The endpoint of the Amazon GameLift Servers Agent.
         */
        public var gameLiftAgentEndpoint: kotlin.String? = null
        /**
         * The Amazon GameLift Servers SDK endpoint connection for a registered compute resource in an Anywhere fleet. The game servers on the compute use this endpoint to connect to the Amazon GameLift Servers service.
         */
        public var gameLiftServiceSdkEndpoint: kotlin.String? = null
        /**
         * The game server container group definition for the compute.
         */
        public var gameServerContainerGroupDefinitionArn: kotlin.String? = null
        /**
         * The `InstanceID` of the EC2 instance that is hosting the compute.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The IP address of a compute resource. Amazon GameLift Servers requires a DNS name or IP address for a compute.
         */
        public var ipAddress: kotlin.String? = null
        /**
         * The name of the custom location you added to the fleet that this compute resource resides in.
         */
        public var location: kotlin.String? = null
        /**
         * The type of operating system on the compute resource.
         *
         * Amazon Linux 2 (AL2) will reach end of support on 6/30/2025. See more details in the [Amazon Linux 2 FAQs](http://aws.amazon.com/aws.amazon.com/amazon-linux-2/faqs/). For game servers that are hosted on AL2 and use server SDK version 4.x for Amazon GameLift Servers, first update the game server build to server SDK 5.x, and then deploy to AL2023 instances. See [ Migrate to server SDK version 5.](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk5-migration.html)
         */
        public var operatingSystem: aws.sdk.kotlin.services.gamelift.model.OperatingSystem? = null
        /**
         * The Amazon EC2 instance type that the fleet uses. For registered computes in an Amazon GameLift Servers Anywhere fleet, this property is empty.
         */
        public var type: aws.sdk.kotlin.services.gamelift.model.Ec2InstanceType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.Compute) : this() {
            this.computeArn = x.computeArn
            this.computeName = x.computeName
            this.computeStatus = x.computeStatus
            this.containerAttributes = x.containerAttributes
            this.creationTime = x.creationTime
            this.dnsName = x.dnsName
            this.fleetArn = x.fleetArn
            this.fleetId = x.fleetId
            this.gameLiftAgentEndpoint = x.gameLiftAgentEndpoint
            this.gameLiftServiceSdkEndpoint = x.gameLiftServiceSdkEndpoint
            this.gameServerContainerGroupDefinitionArn = x.gameServerContainerGroupDefinitionArn
            this.instanceId = x.instanceId
            this.ipAddress = x.ipAddress
            this.location = x.location
            this.operatingSystem = x.operatingSystem
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.Compute = Compute(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
