// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ClaimGameServerRequest private constructor(builder: Builder) {
    /**
     * Object that restricts how a claimed game server is chosen.
     */
    public val filterOption: aws.sdk.kotlin.services.gamelift.model.ClaimFilterOption? = builder.filterOption
    /**
     * A set of custom game server properties, formatted as a single string value. This data is passed to a game client or service when it requests information on game servers.
     */
    public val gameServerData: kotlin.String? = builder.gameServerData
    /**
     * A unique identifier for the game server group where the game server is running. If you are not specifying a game server to claim, this value identifies where you want Amazon GameLift Servers FleetIQ to look for an available game server to claim.
     */
    public val gameServerGroupName: kotlin.String? = builder.gameServerGroupName
    /**
     * A custom string that uniquely identifies the game server to claim. If this parameter is left empty, Amazon GameLift Servers FleetIQ searches for an available game server in the specified game server group.
     */
    public val gameServerId: kotlin.String? = builder.gameServerId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.ClaimGameServerRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ClaimGameServerRequest(")
        append("filterOption=$filterOption,")
        append("gameServerData=$gameServerData,")
        append("gameServerGroupName=$gameServerGroupName,")
        append("gameServerId=$gameServerId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = filterOption?.hashCode() ?: 0
        result = 31 * result + (gameServerData?.hashCode() ?: 0)
        result = 31 * result + (gameServerGroupName?.hashCode() ?: 0)
        result = 31 * result + (gameServerId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ClaimGameServerRequest

        if (filterOption != other.filterOption) return false
        if (gameServerData != other.gameServerData) return false
        if (gameServerGroupName != other.gameServerGroupName) return false
        if (gameServerId != other.gameServerId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.ClaimGameServerRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Object that restricts how a claimed game server is chosen.
         */
        public var filterOption: aws.sdk.kotlin.services.gamelift.model.ClaimFilterOption? = null
        /**
         * A set of custom game server properties, formatted as a single string value. This data is passed to a game client or service when it requests information on game servers.
         */
        public var gameServerData: kotlin.String? = null
        /**
         * A unique identifier for the game server group where the game server is running. If you are not specifying a game server to claim, this value identifies where you want Amazon GameLift Servers FleetIQ to look for an available game server to claim.
         */
        public var gameServerGroupName: kotlin.String? = null
        /**
         * A custom string that uniquely identifies the game server to claim. If this parameter is left empty, Amazon GameLift Servers FleetIQ searches for an available game server in the specified game server group.
         */
        public var gameServerId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.ClaimGameServerRequest) : this() {
            this.filterOption = x.filterOption
            this.gameServerData = x.gameServerData
            this.gameServerGroupName = x.gameServerGroupName
            this.gameServerId = x.gameServerId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.ClaimGameServerRequest = ClaimGameServerRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.ClaimFilterOption] inside the given [block]
         */
        public fun filterOption(block: aws.sdk.kotlin.services.gamelift.model.ClaimFilterOption.Builder.() -> kotlin.Unit) {
            this.filterOption = aws.sdk.kotlin.services.gamelift.model.ClaimFilterOption.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
