// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Determines whether a TLS/SSL certificate is generated for a fleet. This feature must be enabled when creating the fleet. All instances in a fleet share the same certificate. The certificate can be retrieved by calling the [Amazon GameLift Servers Server SDK](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk.html) operation `GetInstanceCertificate`.
 */
public class CertificateConfiguration private constructor(builder: Builder) {
    /**
     * Indicates whether a TLS/SSL certificate is generated for a fleet.
     *
     * Valid values include:
     * + **GENERATED** - Generate a TLS/SSL certificate for this fleet.
     * + **DISABLED** - (default) Do not generate a TLS/SSL certificate for this fleet.
     */
    public val certificateType: aws.sdk.kotlin.services.gamelift.model.CertificateType? = builder.certificateType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.CertificateConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CertificateConfiguration(")
        append("certificateType=$certificateType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateType?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CertificateConfiguration

        if (certificateType != other.certificateType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.CertificateConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates whether a TLS/SSL certificate is generated for a fleet.
         *
         * Valid values include:
         * + **GENERATED** - Generate a TLS/SSL certificate for this fleet.
         * + **DISABLED** - (default) Do not generate a TLS/SSL certificate for this fleet.
         */
        public var certificateType: aws.sdk.kotlin.services.gamelift.model.CertificateType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.CertificateConfiguration) : this() {
            this.certificateType = x.certificateType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.CertificateConfiguration = CertificateConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
