// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Properties describing a custom game build.
 *
 * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public class Build private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name ([ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is assigned to a Amazon GameLift Servers build resource and uniquely identifies it. ARNs are unique across all Regions. Format is `arn:aws:gamelift:<region>::build/build-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912`. In a GameLift build ARN, the resource ID matches the *BuildId* value.
     */
    public val buildArn: kotlin.String? = builder.buildArn
    /**
     * A unique identifier for the build.
     */
    public val buildId: kotlin.String? = builder.buildId
    /**
     * A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example `"1469498468.057"`).
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * A descriptive label that is associated with a build. Build names do not need to be unique. It can be set using [CreateBuild](https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateBuild.html) or [UpdateBuild](https://docs.aws.amazon.com/gamelift/latest/apireference/UpdateBuild).
     */
    public val name: kotlin.String? = builder.name
    /**
     * Operating system that the game server binaries are built to run on. This value determines the type of fleet resources that you can use for this build.
     *
     * Amazon Linux 2 (AL2) will reach end of support on 6/30/2025. See more details in the [Amazon Linux 2 FAQs](http://aws.amazon.com/amazon-linux-2/faqs/). For game servers that are hosted on AL2 and use server SDK version 4.x for Amazon GameLift Servers, first update the game server build to server SDK 5.x, and then deploy to AL2023 instances. See [ Migrate to server SDK version 5.](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk5-migration.html)
     */
    public val operatingSystem: aws.sdk.kotlin.services.gamelift.model.OperatingSystem? = builder.operatingSystem
    /**
     * The Amazon GameLift Servers Server SDK version used to develop your game server.
     */
    public val serverSdkVersion: kotlin.String? = builder.serverSdkVersion
    /**
     * File size of the uploaded game build, expressed in bytes. When the build status is `INITIALIZED` or when using a custom Amazon S3 storage location, this value is 0.
     */
    public val sizeOnDisk: kotlin.Long? = builder.sizeOnDisk
    /**
     * Current status of the build.
     *
     * Possible build statuses include the following:
     * + **INITIALIZED** -- A new build has been defined, but no files have been uploaded. You cannot create fleets for builds that are in this status. When a build is successfully created, the build status is set to this value.
     * + **READY** -- The game build has been successfully uploaded. You can now create new fleets for this build.
     * + **FAILED** -- The game build upload failed. You cannot create new fleets for this build.
     */
    public val status: aws.sdk.kotlin.services.gamelift.model.BuildStatus? = builder.status
    /**
     * Version information that is associated with a build or script. Version strings do not need to be unique.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.Build = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Build(")
        append("buildArn=$buildArn,")
        append("buildId=$buildId,")
        append("creationTime=$creationTime,")
        append("name=$name,")
        append("operatingSystem=$operatingSystem,")
        append("serverSdkVersion=$serverSdkVersion,")
        append("sizeOnDisk=$sizeOnDisk,")
        append("status=$status,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = buildArn?.hashCode() ?: 0
        result = 31 * result + (buildId?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (operatingSystem?.hashCode() ?: 0)
        result = 31 * result + (serverSdkVersion?.hashCode() ?: 0)
        result = 31 * result + (sizeOnDisk?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Build

        if (buildArn != other.buildArn) return false
        if (buildId != other.buildId) return false
        if (creationTime != other.creationTime) return false
        if (name != other.name) return false
        if (operatingSystem != other.operatingSystem) return false
        if (serverSdkVersion != other.serverSdkVersion) return false
        if (sizeOnDisk != other.sizeOnDisk) return false
        if (status != other.status) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.Build = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name ([ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is assigned to a Amazon GameLift Servers build resource and uniquely identifies it. ARNs are unique across all Regions. Format is `arn:aws:gamelift:<region>::build/build-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912`. In a GameLift build ARN, the resource ID matches the *BuildId* value.
         */
        public var buildArn: kotlin.String? = null
        /**
         * A unique identifier for the build.
         */
        public var buildId: kotlin.String? = null
        /**
         * A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example `"1469498468.057"`).
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A descriptive label that is associated with a build. Build names do not need to be unique. It can be set using [CreateBuild](https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateBuild.html) or [UpdateBuild](https://docs.aws.amazon.com/gamelift/latest/apireference/UpdateBuild).
         */
        public var name: kotlin.String? = null
        /**
         * Operating system that the game server binaries are built to run on. This value determines the type of fleet resources that you can use for this build.
         *
         * Amazon Linux 2 (AL2) will reach end of support on 6/30/2025. See more details in the [Amazon Linux 2 FAQs](http://aws.amazon.com/amazon-linux-2/faqs/). For game servers that are hosted on AL2 and use server SDK version 4.x for Amazon GameLift Servers, first update the game server build to server SDK 5.x, and then deploy to AL2023 instances. See [ Migrate to server SDK version 5.](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk5-migration.html)
         */
        public var operatingSystem: aws.sdk.kotlin.services.gamelift.model.OperatingSystem? = null
        /**
         * The Amazon GameLift Servers Server SDK version used to develop your game server.
         */
        public var serverSdkVersion: kotlin.String? = null
        /**
         * File size of the uploaded game build, expressed in bytes. When the build status is `INITIALIZED` or when using a custom Amazon S3 storage location, this value is 0.
         */
        public var sizeOnDisk: kotlin.Long? = null
        /**
         * Current status of the build.
         *
         * Possible build statuses include the following:
         * + **INITIALIZED** -- A new build has been defined, but no files have been uploaded. You cannot create fleets for builds that are in this status. When a build is successfully created, the build status is set to this value.
         * + **READY** -- The game build has been successfully uploaded. You can now create new fleets for this build.
         * + **FAILED** -- The game build upload failed. You cannot create new fleets for this build.
         */
        public var status: aws.sdk.kotlin.services.gamelift.model.BuildStatus? = null
        /**
         * Version information that is associated with a build or script. Version strings do not need to be unique.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.Build) : this() {
            this.buildArn = x.buildArn
            this.buildId = x.buildId
            this.creationTime = x.creationTime
            this.name = x.name
            this.operatingSystem = x.operatingSystem
            this.serverSdkVersion = x.serverSdkVersion
            this.sizeOnDisk = x.sizeOnDisk
            this.status = x.status
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.Build = Build(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
