// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Amazon Web Services account security credentials that allow interactions with Amazon GameLift Servers resources. The credentials are temporary and valid for a limited time span. You can request fresh credentials at any time.
 *
 *  Amazon Web Services security credentials consist of three parts: an access key ID, a secret access key, and a session token. You must use all three parts together to authenticate your access requests.
 *
 * You need Amazon Web Services credentials for the following tasks:
 * + To upload a game server build directly to Amazon GameLift Servers S3 storage using `CreateBuild`. To get access for this task, call [https://docs.aws.amazon.com/gamelift/latest/apireference/API_RequestUploadCredentials.html](https://docs.aws.amazon.com/gamelift/latest/apireference/API_RequestUploadCredentials.html).
 * + To remotely connect to an active Amazon GameLift Servers fleet instances. To get remote access, call [https://docs.aws.amazon.com/gamelift/latest/apireference/API_GetComputeAccess.html](https://docs.aws.amazon.com/gamelift/latest/apireference/API_GetComputeAccess.html).
 */
public class AwsCredentials private constructor(builder: Builder) {
    /**
     * The access key ID that identifies the temporary security credentials.
     */
    public val accessKeyId: kotlin.String? = builder.accessKeyId
    /**
     * The secret access key that can be used to sign requests.
     */
    public val secretAccessKey: kotlin.String? = builder.secretAccessKey
    /**
     * The token that users must pass to the service API to use the temporary credentials.
     */
    public val sessionToken: kotlin.String? = builder.sessionToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.AwsCredentials = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsCredentials(")
        append("*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessKeyId?.hashCode() ?: 0
        result = 31 * result + (secretAccessKey?.hashCode() ?: 0)
        result = 31 * result + (sessionToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsCredentials

        if (accessKeyId != other.accessKeyId) return false
        if (secretAccessKey != other.secretAccessKey) return false
        if (sessionToken != other.sessionToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.AwsCredentials = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The access key ID that identifies the temporary security credentials.
         */
        public var accessKeyId: kotlin.String? = null
        /**
         * The secret access key that can be used to sign requests.
         */
        public var secretAccessKey: kotlin.String? = null
        /**
         * The token that users must pass to the service API to use the temporary credentials.
         */
        public var sessionToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.AwsCredentials) : this() {
            this.accessKeyId = x.accessKeyId
            this.secretAccessKey = x.secretAccessKey
            this.sessionToken = x.sessionToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.AwsCredentials = AwsCredentials(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
