// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Properties that describe an alias resource.
 *
 * **Related actions**
 *
 * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public class Alias private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name ([ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is assigned to a Amazon GameLift Servers alias resource and uniquely identifies it. ARNs are unique across all Regions. Format is `arn:aws:gamelift:<region>::alias/alias-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912`. In a GameLift alias ARN, the resource ID matches the alias ID value.
     */
    public val aliasArn: kotlin.String? = builder.aliasArn
    /**
     * A unique identifier for the alias. Alias IDs are unique within a Region.
     */
    public val aliasId: kotlin.String? = builder.aliasId
    /**
     * A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example `"1469498468.057"`).
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * A human-readable description of an alias.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The time that this data object was last modified. Format is a number expressed in Unix time as milliseconds (for example `"1469498468.057"`).
     */
    public val lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTime
    /**
     * A descriptive label that is associated with an alias. Alias names do not need to be unique.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The routing configuration, including routing type and fleet target, for the alias.
     */
    public val routingStrategy: aws.sdk.kotlin.services.gamelift.model.RoutingStrategy? = builder.routingStrategy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.Alias = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Alias(")
        append("aliasArn=$aliasArn,")
        append("aliasId=$aliasId,")
        append("creationTime=$creationTime,")
        append("description=$description,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("name=$name,")
        append("routingStrategy=$routingStrategy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aliasArn?.hashCode() ?: 0
        result = 31 * result + (aliasId?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (routingStrategy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Alias

        if (aliasArn != other.aliasArn) return false
        if (aliasId != other.aliasId) return false
        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (name != other.name) return false
        if (routingStrategy != other.routingStrategy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.Alias = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name ([ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is assigned to a Amazon GameLift Servers alias resource and uniquely identifies it. ARNs are unique across all Regions. Format is `arn:aws:gamelift:<region>::alias/alias-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912`. In a GameLift alias ARN, the resource ID matches the alias ID value.
         */
        public var aliasArn: kotlin.String? = null
        /**
         * A unique identifier for the alias. Alias IDs are unique within a Region.
         */
        public var aliasId: kotlin.String? = null
        /**
         * A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example `"1469498468.057"`).
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A human-readable description of an alias.
         */
        public var description: kotlin.String? = null
        /**
         * The time that this data object was last modified. Format is a number expressed in Unix time as milliseconds (for example `"1469498468.057"`).
         */
        public var lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A descriptive label that is associated with an alias. Alias names do not need to be unique.
         */
        public var name: kotlin.String? = null
        /**
         * The routing configuration, including routing type and fleet target, for the alias.
         */
        public var routingStrategy: aws.sdk.kotlin.services.gamelift.model.RoutingStrategy? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.Alias) : this() {
            this.aliasArn = x.aliasArn
            this.aliasId = x.aliasId
            this.creationTime = x.creationTime
            this.description = x.description
            this.lastUpdatedTime = x.lastUpdatedTime
            this.name = x.name
            this.routingStrategy = x.routingStrategy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.Alias = Alias(this)

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.RoutingStrategy] inside the given [block]
         */
        public fun routingStrategy(block: aws.sdk.kotlin.services.gamelift.model.RoutingStrategy.Builder.() -> kotlin.Unit) {
            this.routingStrategy = aws.sdk.kotlin.services.gamelift.model.RoutingStrategy.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
