// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.gamelift.auth.DefaultGameLiftAuthSchemeProvider
import aws.sdk.kotlin.services.gamelift.auth.GameLiftAuthSchemeProvider
import aws.sdk.kotlin.services.gamelift.endpoints.DefaultGameLiftEndpointProvider
import aws.sdk.kotlin.services.gamelift.endpoints.GameLiftEndpointParameters
import aws.sdk.kotlin.services.gamelift.endpoints.GameLiftEndpointProvider
import aws.sdk.kotlin.services.gamelift.model.AcceptMatchRequest
import aws.sdk.kotlin.services.gamelift.model.AcceptMatchResponse
import aws.sdk.kotlin.services.gamelift.model.ClaimGameServerRequest
import aws.sdk.kotlin.services.gamelift.model.ClaimGameServerResponse
import aws.sdk.kotlin.services.gamelift.model.CreateAliasRequest
import aws.sdk.kotlin.services.gamelift.model.CreateAliasResponse
import aws.sdk.kotlin.services.gamelift.model.CreateBuildRequest
import aws.sdk.kotlin.services.gamelift.model.CreateBuildResponse
import aws.sdk.kotlin.services.gamelift.model.CreateContainerFleetRequest
import aws.sdk.kotlin.services.gamelift.model.CreateContainerFleetResponse
import aws.sdk.kotlin.services.gamelift.model.CreateContainerGroupDefinitionRequest
import aws.sdk.kotlin.services.gamelift.model.CreateContainerGroupDefinitionResponse
import aws.sdk.kotlin.services.gamelift.model.CreateFleetLocationsRequest
import aws.sdk.kotlin.services.gamelift.model.CreateFleetLocationsResponse
import aws.sdk.kotlin.services.gamelift.model.CreateFleetRequest
import aws.sdk.kotlin.services.gamelift.model.CreateFleetResponse
import aws.sdk.kotlin.services.gamelift.model.CreateGameServerGroupRequest
import aws.sdk.kotlin.services.gamelift.model.CreateGameServerGroupResponse
import aws.sdk.kotlin.services.gamelift.model.CreateGameSessionQueueRequest
import aws.sdk.kotlin.services.gamelift.model.CreateGameSessionQueueResponse
import aws.sdk.kotlin.services.gamelift.model.CreateGameSessionRequest
import aws.sdk.kotlin.services.gamelift.model.CreateGameSessionResponse
import aws.sdk.kotlin.services.gamelift.model.CreateLocationRequest
import aws.sdk.kotlin.services.gamelift.model.CreateLocationResponse
import aws.sdk.kotlin.services.gamelift.model.CreateMatchmakingConfigurationRequest
import aws.sdk.kotlin.services.gamelift.model.CreateMatchmakingConfigurationResponse
import aws.sdk.kotlin.services.gamelift.model.CreateMatchmakingRuleSetRequest
import aws.sdk.kotlin.services.gamelift.model.CreateMatchmakingRuleSetResponse
import aws.sdk.kotlin.services.gamelift.model.CreatePlayerSessionRequest
import aws.sdk.kotlin.services.gamelift.model.CreatePlayerSessionResponse
import aws.sdk.kotlin.services.gamelift.model.CreatePlayerSessionsRequest
import aws.sdk.kotlin.services.gamelift.model.CreatePlayerSessionsResponse
import aws.sdk.kotlin.services.gamelift.model.CreateScriptRequest
import aws.sdk.kotlin.services.gamelift.model.CreateScriptResponse
import aws.sdk.kotlin.services.gamelift.model.CreateVpcPeeringAuthorizationRequest
import aws.sdk.kotlin.services.gamelift.model.CreateVpcPeeringAuthorizationResponse
import aws.sdk.kotlin.services.gamelift.model.CreateVpcPeeringConnectionRequest
import aws.sdk.kotlin.services.gamelift.model.CreateVpcPeeringConnectionResponse
import aws.sdk.kotlin.services.gamelift.model.DeleteAliasRequest
import aws.sdk.kotlin.services.gamelift.model.DeleteAliasResponse
import aws.sdk.kotlin.services.gamelift.model.DeleteBuildRequest
import aws.sdk.kotlin.services.gamelift.model.DeleteBuildResponse
import aws.sdk.kotlin.services.gamelift.model.DeleteContainerFleetRequest
import aws.sdk.kotlin.services.gamelift.model.DeleteContainerFleetResponse
import aws.sdk.kotlin.services.gamelift.model.DeleteContainerGroupDefinitionRequest
import aws.sdk.kotlin.services.gamelift.model.DeleteContainerGroupDefinitionResponse
import aws.sdk.kotlin.services.gamelift.model.DeleteFleetLocationsRequest
import aws.sdk.kotlin.services.gamelift.model.DeleteFleetLocationsResponse
import aws.sdk.kotlin.services.gamelift.model.DeleteFleetRequest
import aws.sdk.kotlin.services.gamelift.model.DeleteFleetResponse
import aws.sdk.kotlin.services.gamelift.model.DeleteGameServerGroupRequest
import aws.sdk.kotlin.services.gamelift.model.DeleteGameServerGroupResponse
import aws.sdk.kotlin.services.gamelift.model.DeleteGameSessionQueueRequest
import aws.sdk.kotlin.services.gamelift.model.DeleteGameSessionQueueResponse
import aws.sdk.kotlin.services.gamelift.model.DeleteLocationRequest
import aws.sdk.kotlin.services.gamelift.model.DeleteLocationResponse
import aws.sdk.kotlin.services.gamelift.model.DeleteMatchmakingConfigurationRequest
import aws.sdk.kotlin.services.gamelift.model.DeleteMatchmakingConfigurationResponse
import aws.sdk.kotlin.services.gamelift.model.DeleteMatchmakingRuleSetRequest
import aws.sdk.kotlin.services.gamelift.model.DeleteMatchmakingRuleSetResponse
import aws.sdk.kotlin.services.gamelift.model.DeleteScalingPolicyRequest
import aws.sdk.kotlin.services.gamelift.model.DeleteScalingPolicyResponse
import aws.sdk.kotlin.services.gamelift.model.DeleteScriptRequest
import aws.sdk.kotlin.services.gamelift.model.DeleteScriptResponse
import aws.sdk.kotlin.services.gamelift.model.DeleteVpcPeeringAuthorizationRequest
import aws.sdk.kotlin.services.gamelift.model.DeleteVpcPeeringAuthorizationResponse
import aws.sdk.kotlin.services.gamelift.model.DeleteVpcPeeringConnectionRequest
import aws.sdk.kotlin.services.gamelift.model.DeleteVpcPeeringConnectionResponse
import aws.sdk.kotlin.services.gamelift.model.DeregisterComputeRequest
import aws.sdk.kotlin.services.gamelift.model.DeregisterComputeResponse
import aws.sdk.kotlin.services.gamelift.model.DeregisterGameServerRequest
import aws.sdk.kotlin.services.gamelift.model.DeregisterGameServerResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeAliasRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeAliasResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeBuildRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeBuildResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeComputeRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeComputeResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeContainerFleetRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeContainerFleetResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeContainerGroupDefinitionRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeContainerGroupDefinitionResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeEc2InstanceLimitsRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeEc2InstanceLimitsResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeFleetAttributesRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeFleetAttributesResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeFleetCapacityRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeFleetCapacityResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeFleetDeploymentRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeFleetDeploymentResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeFleetEventsRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeFleetEventsResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeFleetLocationAttributesRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeFleetLocationAttributesResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeFleetLocationCapacityRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeFleetLocationCapacityResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeFleetLocationUtilizationRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeFleetLocationUtilizationResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeFleetPortSettingsRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeFleetPortSettingsResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeFleetUtilizationRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeFleetUtilizationResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeGameServerGroupRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeGameServerGroupResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeGameServerInstancesRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeGameServerInstancesResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeGameServerRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeGameServerResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeGameSessionDetailsRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeGameSessionDetailsResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeGameSessionPlacementRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeGameSessionPlacementResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeGameSessionQueuesRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeGameSessionQueuesResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeGameSessionsRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeGameSessionsResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeInstancesRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeInstancesResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeMatchmakingConfigurationsRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeMatchmakingConfigurationsResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeMatchmakingRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeMatchmakingResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeMatchmakingRuleSetsRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeMatchmakingRuleSetsResponse
import aws.sdk.kotlin.services.gamelift.model.DescribePlayerSessionsRequest
import aws.sdk.kotlin.services.gamelift.model.DescribePlayerSessionsResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeRuntimeConfigurationRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeRuntimeConfigurationResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeScalingPoliciesRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeScalingPoliciesResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeScriptRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeScriptResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeVpcPeeringAuthorizationsRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeVpcPeeringAuthorizationsResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeVpcPeeringConnectionsRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeVpcPeeringConnectionsResponse
import aws.sdk.kotlin.services.gamelift.model.GetComputeAccessRequest
import aws.sdk.kotlin.services.gamelift.model.GetComputeAccessResponse
import aws.sdk.kotlin.services.gamelift.model.GetComputeAuthTokenRequest
import aws.sdk.kotlin.services.gamelift.model.GetComputeAuthTokenResponse
import aws.sdk.kotlin.services.gamelift.model.GetGameSessionLogUrlRequest
import aws.sdk.kotlin.services.gamelift.model.GetGameSessionLogUrlResponse
import aws.sdk.kotlin.services.gamelift.model.GetInstanceAccessRequest
import aws.sdk.kotlin.services.gamelift.model.GetInstanceAccessResponse
import aws.sdk.kotlin.services.gamelift.model.ListAliasesRequest
import aws.sdk.kotlin.services.gamelift.model.ListAliasesResponse
import aws.sdk.kotlin.services.gamelift.model.ListBuildsRequest
import aws.sdk.kotlin.services.gamelift.model.ListBuildsResponse
import aws.sdk.kotlin.services.gamelift.model.ListComputeRequest
import aws.sdk.kotlin.services.gamelift.model.ListComputeResponse
import aws.sdk.kotlin.services.gamelift.model.ListContainerFleetsRequest
import aws.sdk.kotlin.services.gamelift.model.ListContainerFleetsResponse
import aws.sdk.kotlin.services.gamelift.model.ListContainerGroupDefinitionVersionsRequest
import aws.sdk.kotlin.services.gamelift.model.ListContainerGroupDefinitionVersionsResponse
import aws.sdk.kotlin.services.gamelift.model.ListContainerGroupDefinitionsRequest
import aws.sdk.kotlin.services.gamelift.model.ListContainerGroupDefinitionsResponse
import aws.sdk.kotlin.services.gamelift.model.ListFleetDeploymentsRequest
import aws.sdk.kotlin.services.gamelift.model.ListFleetDeploymentsResponse
import aws.sdk.kotlin.services.gamelift.model.ListFleetsRequest
import aws.sdk.kotlin.services.gamelift.model.ListFleetsResponse
import aws.sdk.kotlin.services.gamelift.model.ListGameServerGroupsRequest
import aws.sdk.kotlin.services.gamelift.model.ListGameServerGroupsResponse
import aws.sdk.kotlin.services.gamelift.model.ListGameServersRequest
import aws.sdk.kotlin.services.gamelift.model.ListGameServersResponse
import aws.sdk.kotlin.services.gamelift.model.ListLocationsRequest
import aws.sdk.kotlin.services.gamelift.model.ListLocationsResponse
import aws.sdk.kotlin.services.gamelift.model.ListScriptsRequest
import aws.sdk.kotlin.services.gamelift.model.ListScriptsResponse
import aws.sdk.kotlin.services.gamelift.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.gamelift.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.gamelift.model.PutScalingPolicyRequest
import aws.sdk.kotlin.services.gamelift.model.PutScalingPolicyResponse
import aws.sdk.kotlin.services.gamelift.model.RegisterComputeRequest
import aws.sdk.kotlin.services.gamelift.model.RegisterComputeResponse
import aws.sdk.kotlin.services.gamelift.model.RegisterGameServerRequest
import aws.sdk.kotlin.services.gamelift.model.RegisterGameServerResponse
import aws.sdk.kotlin.services.gamelift.model.RequestUploadCredentialsRequest
import aws.sdk.kotlin.services.gamelift.model.RequestUploadCredentialsResponse
import aws.sdk.kotlin.services.gamelift.model.ResolveAliasRequest
import aws.sdk.kotlin.services.gamelift.model.ResolveAliasResponse
import aws.sdk.kotlin.services.gamelift.model.ResumeGameServerGroupRequest
import aws.sdk.kotlin.services.gamelift.model.ResumeGameServerGroupResponse
import aws.sdk.kotlin.services.gamelift.model.SearchGameSessionsRequest
import aws.sdk.kotlin.services.gamelift.model.SearchGameSessionsResponse
import aws.sdk.kotlin.services.gamelift.model.StartFleetActionsRequest
import aws.sdk.kotlin.services.gamelift.model.StartFleetActionsResponse
import aws.sdk.kotlin.services.gamelift.model.StartGameSessionPlacementRequest
import aws.sdk.kotlin.services.gamelift.model.StartGameSessionPlacementResponse
import aws.sdk.kotlin.services.gamelift.model.StartMatchBackfillRequest
import aws.sdk.kotlin.services.gamelift.model.StartMatchBackfillResponse
import aws.sdk.kotlin.services.gamelift.model.StartMatchmakingRequest
import aws.sdk.kotlin.services.gamelift.model.StartMatchmakingResponse
import aws.sdk.kotlin.services.gamelift.model.StopFleetActionsRequest
import aws.sdk.kotlin.services.gamelift.model.StopFleetActionsResponse
import aws.sdk.kotlin.services.gamelift.model.StopGameSessionPlacementRequest
import aws.sdk.kotlin.services.gamelift.model.StopGameSessionPlacementResponse
import aws.sdk.kotlin.services.gamelift.model.StopMatchmakingRequest
import aws.sdk.kotlin.services.gamelift.model.StopMatchmakingResponse
import aws.sdk.kotlin.services.gamelift.model.SuspendGameServerGroupRequest
import aws.sdk.kotlin.services.gamelift.model.SuspendGameServerGroupResponse
import aws.sdk.kotlin.services.gamelift.model.TagResourceRequest
import aws.sdk.kotlin.services.gamelift.model.TagResourceResponse
import aws.sdk.kotlin.services.gamelift.model.TerminateGameSessionRequest
import aws.sdk.kotlin.services.gamelift.model.TerminateGameSessionResponse
import aws.sdk.kotlin.services.gamelift.model.UntagResourceRequest
import aws.sdk.kotlin.services.gamelift.model.UntagResourceResponse
import aws.sdk.kotlin.services.gamelift.model.UpdateAliasRequest
import aws.sdk.kotlin.services.gamelift.model.UpdateAliasResponse
import aws.sdk.kotlin.services.gamelift.model.UpdateBuildRequest
import aws.sdk.kotlin.services.gamelift.model.UpdateBuildResponse
import aws.sdk.kotlin.services.gamelift.model.UpdateContainerFleetRequest
import aws.sdk.kotlin.services.gamelift.model.UpdateContainerFleetResponse
import aws.sdk.kotlin.services.gamelift.model.UpdateContainerGroupDefinitionRequest
import aws.sdk.kotlin.services.gamelift.model.UpdateContainerGroupDefinitionResponse
import aws.sdk.kotlin.services.gamelift.model.UpdateFleetAttributesRequest
import aws.sdk.kotlin.services.gamelift.model.UpdateFleetAttributesResponse
import aws.sdk.kotlin.services.gamelift.model.UpdateFleetCapacityRequest
import aws.sdk.kotlin.services.gamelift.model.UpdateFleetCapacityResponse
import aws.sdk.kotlin.services.gamelift.model.UpdateFleetPortSettingsRequest
import aws.sdk.kotlin.services.gamelift.model.UpdateFleetPortSettingsResponse
import aws.sdk.kotlin.services.gamelift.model.UpdateGameServerGroupRequest
import aws.sdk.kotlin.services.gamelift.model.UpdateGameServerGroupResponse
import aws.sdk.kotlin.services.gamelift.model.UpdateGameServerRequest
import aws.sdk.kotlin.services.gamelift.model.UpdateGameServerResponse
import aws.sdk.kotlin.services.gamelift.model.UpdateGameSessionQueueRequest
import aws.sdk.kotlin.services.gamelift.model.UpdateGameSessionQueueResponse
import aws.sdk.kotlin.services.gamelift.model.UpdateGameSessionRequest
import aws.sdk.kotlin.services.gamelift.model.UpdateGameSessionResponse
import aws.sdk.kotlin.services.gamelift.model.UpdateMatchmakingConfigurationRequest
import aws.sdk.kotlin.services.gamelift.model.UpdateMatchmakingConfigurationResponse
import aws.sdk.kotlin.services.gamelift.model.UpdateRuntimeConfigurationRequest
import aws.sdk.kotlin.services.gamelift.model.UpdateRuntimeConfigurationResponse
import aws.sdk.kotlin.services.gamelift.model.UpdateScriptRequest
import aws.sdk.kotlin.services.gamelift.model.UpdateScriptResponse
import aws.sdk.kotlin.services.gamelift.model.ValidateMatchmakingRuleSetRequest
import aws.sdk.kotlin.services.gamelift.model.ValidateMatchmakingRuleSetResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "GameLift"
public const val SdkVersion: String = "1.5.7"
public const val ServiceApiVersion: String = "2015-10-01"

/**
 * Amazon GameLift Servers provides solutions for hosting session-based multiplayer game servers in the cloud, including tools for deploying, operating, and scaling game servers. Built on Amazon Web Services global computing infrastructure, GameLift helps you deliver high-performance, high-reliability, low-cost game servers while dynamically scaling your resource usage to meet player demand.
 *
 * **About Amazon GameLift Servers solutions**
 *
 * Get more information on these Amazon GameLift Servers solutions in the [Amazon GameLift Servers Developer Guide](https://docs.aws.amazon.com/gamelift/latest/developerguide/).
 * + Amazon GameLift Servers managed hosting -- Amazon GameLift Servers offers a fully managed service to set up and maintain computing machines for hosting, manage game session and player session life cycle, and handle security, storage, and performance tracking. You can use automatic scaling tools to balance player demand and hosting costs, configure your game session management to minimize player latency, and add FlexMatch for matchmaking.
 * + Managed hosting with Amazon GameLift Servers Realtime -- With Amazon GameLift Servers Amazon GameLift Servers Realtime, you can quickly configure and set up ready-to-go game servers for your game. Amazon GameLift Servers Realtime provides a game server framework with core Amazon GameLift Servers infrastructure already built in. Then use the full range of Amazon GameLift Servers managed hosting features, including FlexMatch, for your game.
 * + Amazon GameLift Servers FleetIQ -- Use Amazon GameLift Servers FleetIQ as a standalone service while hosting your games using EC2 instances and Auto Scaling groups. Amazon GameLift Servers FleetIQ provides optimizations for game hosting, including boosting the viability of low-cost Spot Instances gaming. For a complete solution, pair the Amazon GameLift Servers FleetIQ and FlexMatch standalone services.
 * + Amazon GameLift Servers FlexMatch -- Add matchmaking to your game hosting solution. FlexMatch is a customizable matchmaking service for multiplayer games. Use FlexMatch as integrated with Amazon GameLift Servers managed hosting or incorporate FlexMatch as a standalone service into your own hosting solution.
 *
 * **About this API Reference**
 *
 * This reference guide describes the low-level service API for Amazon GameLift Servers. With each topic in this guide, you can find links to language-specific SDK guides and the Amazon Web Services CLI reference. Useful links:
 * + [Amazon GameLift Servers API operations listed by tasks](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html)
 * + [ Amazon GameLift Servers tools and resources](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-components.html)
 */
public interface GameLiftClient : SdkClient {
    /**
     * GameLiftClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, GameLiftClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "GameLift",
                "GAMELIFT",
                "gamelift",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, GameLiftClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): GameLiftClient = DefaultGameLiftClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: GameLiftEndpointProvider = builder.endpointProvider ?: DefaultGameLiftEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: GameLiftAuthSchemeProvider = builder.authSchemeProvider ?: DefaultGameLiftAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "GameLift"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: GameLiftEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: GameLiftAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Registers a player's acceptance or rejection of a proposed FlexMatch match. A matchmaking configuration may require player acceptance; if so, then matches built with that configuration cannot be completed unless all players accept the proposed match within a specified time limit.
     *
     * When FlexMatch builds a match, all the matchmaking tickets involved in the proposed match are placed into status `REQUIRES_ACCEPTANCE`. This is a trigger for your game to get acceptance from all players in each ticket. Calls to this action are only valid for tickets that are in this status; calls for tickets not in this status result in an error.
     *
     * To register acceptance, specify the ticket ID, one or more players, and an acceptance response. When all players have accepted, Amazon GameLift Servers advances the matchmaking tickets to status `PLACING`, and attempts to create a new game session for the match.
     *
     * If any player rejects the match, or if acceptances are not received before a specified timeout, the proposed match is dropped. Each matchmaking ticket in the failed match is handled as follows:
     * + If the ticket has one or more players who rejected the match or failed to respond, the ticket status is set `CANCELLED` and processing is terminated.
     * + If all players in the ticket accepted the match, the ticket status is returned to `SEARCHING` to find a new match.
     *
     * **Learn more**
     *
     * [ Add FlexMatch to a game client](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-client.html)
     *
     * [ FlexMatch events](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html) (reference)
     */
    public suspend fun acceptMatch(input: AcceptMatchRequest): AcceptMatchResponse

    /**
     * **This operation is used with the Amazon GameLift Servers FleetIQ solution and game server groups.**
     *
     * Locates an available game server and temporarily reserves it to host gameplay and players. This operation is called from a game client or client service (such as a matchmaker) to request hosting resources for a new game session. In response, Amazon GameLift Servers FleetIQ locates an available game server, places it in `CLAIMED` status for 60 seconds, and returns connection information that players can use to connect to the game server.
     *
     * To claim a game server, identify a game server group. You can also specify a game server ID, although this approach bypasses Amazon GameLift Servers FleetIQ placement optimization. Optionally, include game data to pass to the game server at the start of a game session, such as a game map or player information. Add filter options to further restrict how a game server is chosen, such as only allowing game servers on `ACTIVE` instances to be claimed.
     *
     * When a game server is successfully claimed, connection information is returned. A claimed game server's utilization status remains `AVAILABLE` while the claim status is set to `CLAIMED` for up to 60 seconds. This time period gives the game server time to update its status to `UTILIZED` after players join. If the game server's status is not updated within 60 seconds, the game server reverts to unclaimed status and is available to be claimed by another request. The claim time period is a fixed value and is not configurable.
     *
     * If you try to claim a specific game server, this request will fail in the following cases:
     * + If the game server utilization status is `UTILIZED`.
     * + If the game server claim status is `CLAIMED`.
     * + If the game server is running on an instance in `DRAINING` status and the provided filter option does not allow placing on `DRAINING` instances.
     *
     * **Learn more**
     *
     * [Amazon GameLift Servers FleetIQ Guide](https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
     */
    public suspend fun claimGameServer(input: ClaimGameServerRequest): ClaimGameServerResponse

    /**
     * Creates an alias for a fleet. In most situations, you can use an alias ID in place of a fleet ID. An alias provides a level of abstraction for a fleet that is useful when redirecting player traffic from one fleet to another, such as when updating your game build.
     *
     * Amazon GameLift Servers supports two types of routing strategies for aliases: simple and terminal. A simple alias points to an active fleet. A terminal alias is used to display messaging or link to a URL instead of routing players to an active fleet. For example, you might use a terminal alias when a game version is no longer supported and you want to direct players to an upgrade site.
     *
     * To create a fleet alias, specify an alias name, routing strategy, and optional description. Each simple alias can point to only one fleet, but a fleet can have multiple aliases. If successful, a new alias record is returned, including an alias ID and an ARN. You can reassign an alias to another fleet by calling `UpdateAlias`.
     *
     * **Related actions**
     *
     * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
     */
    public suspend fun createAlias(input: CreateAliasRequest): CreateAliasResponse

    /**
     * Creates a new Amazon GameLift Servers build resource for your game server binary files. Combine game server binaries into a zip file for use with Amazon GameLift Servers.
     *
     * When setting up a new game build for Amazon GameLift Servers, we recommend using the CLI command **[upload-build](https://docs.aws.amazon.com/cli/latest/reference/gamelift/upload-build.html)**. This helper command combines two tasks: (1) it uploads your build files from a file directory to an Amazon GameLift Servers Amazon S3 location, and (2) it creates a new build resource.
     *
     * You can use the `CreateBuild` operation in the following scenarios:
     * + Create a new game build with build files that are in an Amazon S3 location under an Amazon Web Services account that you control. To use this option, you give Amazon GameLift Servers access to the Amazon S3 bucket. With permissions in place, specify a build name, operating system, and the Amazon S3 storage location of your game build.
     * + Upload your build files to a Amazon GameLift Servers Amazon S3 location. To use this option, specify a build name and operating system. This operation creates a new build resource and also returns an Amazon S3 location with temporary access credentials. Use the credentials to manually upload your build files to the specified Amazon S3 location. For more information, see [Uploading Objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/UploadingObjects.html) in the *Amazon S3 Developer Guide*. After you upload build files to the Amazon GameLift Servers Amazon S3 location, you can't update them.
     *
     * If successful, this operation creates a new build resource with a unique build ID and places it in `INITIALIZED` status. A build must be in `READY` status before you can create fleets with it.
     *
     * **Learn more**
     *
     * [Uploading Your Game](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html)
     *
     * [ Create a Build with Files in Amazon S3](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-cli-uploading.html#gamelift-build-cli-uploading-create-build)
     *
     * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
     */
    public suspend fun createBuild(input: CreateBuildRequest = CreateBuildRequest { }): CreateBuildResponse

    /**
     * Creates a managed fleet of Amazon Elastic Compute Cloud (Amazon EC2) instances to host your containerized game servers. Use this operation to define how to deploy a container architecture onto each fleet instance and configure fleet settings. You can create a container fleet in any Amazon Web Services Regions that Amazon GameLift Servers supports for multi-location fleets. A container fleet can be deployed to a single location or multiple locations. Container fleets are deployed with Amazon Linux 2023 as the instance operating system.
     *
     * Define the fleet's container architecture using container group definitions. Each fleet can have one of the following container group types:
     * + The game server container group runs your game server build and dependent software. Amazon GameLift Servers deploys one or more replicas of this container group to each fleet instance. The number of replicas depends on the computing capabilities of the fleet instance in use.
     * + An optional per-instance container group might be used to run other software that only needs to run once per instance, such as background services, logging, or test processes. One per-instance container group is deployed to each fleet instance.
     *
     * Each container group can include the definition for one or more containers. A container definition specifies a container image that is stored in an Amazon Elastic Container Registry (Amazon ECR) public or private repository.
     *
     * **Request options**
     *
     * Use this operation to make the following types of requests. Most fleet settings have default values, so you can create a working fleet with a minimal configuration and default values, which you can customize later.
     * + Create a fleet with no container groups. You can configure a container fleet and then add container group definitions later. In this scenario, no fleet instances are deployed, and the fleet can't host game sessions until you add a game server container group definition. Provide the following required parameter values:
     *    + `FleetRoleArn`
     * + Create a fleet with a game server container group. Provide the following required parameter values:
     *    + `FleetRoleArn`
     *    + `GameServerContainerGroupDefinitionName`
     * + Create a fleet with a game server container group and a per-instance container group. Provide the following required parameter values:
     *    + `FleetRoleArn`
     *    + `GameServerContainerGroupDefinitionName`
     *    + `PerInstanceContainerGroupDefinitionName`
     *
     * **Results**
     *
     * If successful, this operation creates a new container fleet resource, places it in `PENDING` status, and initiates the [fleet creation workflow](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-all.html#fleets-creation-workflow). For fleets with container groups, this workflow starts a fleet deployment and transitions the status to `ACTIVE`. Fleets without a container group are placed in `CREATED` status.
     *
     * You can update most of the properties of a fleet, including container group definitions, and deploy the update across all fleet instances. Use a fleet update to deploy a new game server version update across the container fleet.
     */
    public suspend fun createContainerFleet(input: CreateContainerFleetRequest): CreateContainerFleetResponse

    /**
     * Creates a `ContainerGroupDefinition` that describes a set of containers for hosting your game server with Amazon GameLift Servers managed containers hosting. An Amazon GameLift Servers container group is similar to a container task or pod. Use container group definitions when you create a container fleet with [CreateContainerFleet](https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateContainerFleet.html).
     *
     * A container group definition determines how Amazon GameLift Servers deploys your containers to each instance in a container fleet. You can maintain multiple versions of a container group definition.
     *
     * There are two types of container groups:
     * + A **game server container group** has the containers that run your game server application and supporting software. A game server container group can have these container types:
     *    + Game server container. This container runs your game server. You can define one game server container in a game server container group.
     *    + Support container. This container runs software in parallel with your game server. You can define up to 8 support containers in a game server group.
     * When building a game server container group definition, you can choose to bundle your game server executable and all dependent software into a single game server container. Alternatively, you can separate the software into one game server container and one or more support containers.On a container fleet instance, a game server container group can be deployed multiple times (depending on the compute resources of the instance). This means that all containers in the container group are replicated together.
     * + A **per-instance container group** has containers for processes that aren't replicated on a container fleet instance. This might include background services, logging, test processes, or processes that need to persist independently of the game server container group. When building a per-instance container group, you can define up to 10 support containers.
     *
     * This operation requires Identity and Access Management (IAM) permissions to access container images in Amazon ECR repositories. See [ IAM permissions for Amazon GameLift Servers](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-iam-policy-examples.html) for help setting the appropriate permissions.
     *
     * **Request options**
     *
     * Use this operation to make the following types of requests. You can specify values for the minimum required parameters and customize optional values later.
     * + Create a game server container group definition. Provide the following required parameter values:
     *    + `Name`
     *    + `ContainerGroupType` (`GAME_SERVER`)
     *    + `OperatingSystem` (omit to use default value)
     *    + `TotalMemoryLimitMebibytes` (omit to use default value)
     *    + `TotalVcpuLimit `(omit to use default value)
     *    + At least one `GameServerContainerDefinition`
     *       + `ContainerName`
     *       + `ImageUrl`
     *       + `PortConfiguration`
     *       + `ServerSdkVersion` (omit to use default value)
     * + Create a per-instance container group definition. Provide the following required parameter values:
     *    + `Name`
     *    + `ContainerGroupType` (`PER_INSTANCE`)
     *    + `OperatingSystem` (omit to use default value)
     *    + `TotalMemoryLimitMebibytes` (omit to use default value)
     *    + `TotalVcpuLimit `(omit to use default value)
     *    + At least one `SupportContainerDefinition`
     *       + `ContainerName`
     *       + `ImageUrl`
     *
     * **Results**
     *
     * If successful, this request creates a `ContainerGroupDefinition` resource and assigns a unique ARN value. You can update most properties of a container group definition by calling [UpdateContainerGroupDefinition](https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateContainerGroupDefinition.html), and optionally save the update as a new version.
     */
    public suspend fun createContainerGroupDefinition(input: CreateContainerGroupDefinitionRequest): CreateContainerGroupDefinitionResponse

    /**
     * Creates a fleet of compute resources to host your game servers. Use this operation to set up the following types of fleets based on compute type:
     *
     * **Managed EC2 fleet**
     *
     * An EC2 fleet is a set of Amazon Elastic Compute Cloud (Amazon EC2) instances. Your game server build is deployed to each fleet instance. Amazon GameLift Servers manages the fleet's instances and controls the lifecycle of game server processes, which host game sessions for players. EC2 fleets can have instances in multiple locations. Each instance in the fleet is designated a `Compute`.
     *
     * To create an EC2 fleet, provide these required parameters:
     * + Either `BuildId` or `ScriptId`
     * + `ComputeType` set to `EC2` (the default value)
     * + `EC2InboundPermissions`
     * + `EC2InstanceType`
     * + `FleetType`
     * + `Name`
     * + `RuntimeConfiguration` with at least one `ServerProcesses` configuration
     *
     * If successful, this operation creates a new fleet resource and places it in `NEW` status while Amazon GameLift Servers initiates the [fleet creation workflow](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-all.html#fleets-creation-workflow). To debug your fleet, fetch logs, view performance metrics or other actions on the fleet, create a development fleet with port 22/3389 open. As a best practice, we recommend opening ports for remote access only when you need them and closing them when you're finished.
     *
     * When the fleet status is ACTIVE, you can adjust capacity settings and turn autoscaling on/off for each location.
     *
     * **Anywhere fleet**
     *
     * An Anywhere fleet represents compute resources that are not owned or managed by Amazon GameLift Servers. You might create an Anywhere fleet with your local machine for testing, or use one to host game servers with on-premises hardware or other game hosting solutions.
     *
     * To create an Anywhere fleet, provide these required parameters:
     * + `ComputeType` set to `ANYWHERE`
     * + `Locations` specifying a custom location
     * + `Name`
     *
     * If successful, this operation creates a new fleet resource and places it in `ACTIVE` status. You can register computes with a fleet in `ACTIVE` status.
     *
     * **Learn more**
     *
     * [Setting up fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
     *
     * [Debug fleet creation issues](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html#fleets-creating-debug-creation)
     *
     * [Multi-location fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
     */
    public suspend fun createFleet(input: CreateFleetRequest): CreateFleetResponse

    /**
     * Adds remote locations to an EC2 and begins populating the new locations with instances. The new instances conform to the fleet's instance type, auto-scaling, and other configuration settings.
     *
     * You can't add remote locations to a fleet that resides in an Amazon Web Services Region that doesn't support multiple locations. Fleets created prior to March 2021 can't support multiple locations.
     *
     * To add fleet locations, specify the fleet to be updated and provide a list of one or more locations.
     *
     * If successful, this operation returns the list of added locations with their status set to `NEW`. Amazon GameLift Servers initiates the process of starting an instance in each added location. You can track the status of each new location by monitoring location creation events using [DescribeFleetEvents](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetEvents.html).
     *
     * **Learn more**
     *
     * [Setting up fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
     *
     * [Update fleet locations](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-editing.html#fleets-update-locations)
     *
     * [ Amazon GameLift Servers service locations](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html) for managed hosting.
     */
    public suspend fun createFleetLocations(input: CreateFleetLocationsRequest): CreateFleetLocationsResponse

    /**
     * **This operation is used with the Amazon GameLift Servers FleetIQ solution and game server groups.**
     *
     * Creates a Amazon GameLift Servers FleetIQ game server group for managing game hosting on a collection of Amazon Elastic Compute Cloud instances for game hosting. This operation creates the game server group, creates an Auto Scaling group in your Amazon Web Services account, and establishes a link between the two groups. You can view the status of your game server groups in the Amazon GameLift Servers console. Game server group metrics and events are emitted to Amazon CloudWatch.
     *
     * Before creating a new game server group, you must have the following:
     * + An Amazon Elastic Compute Cloud launch template that specifies how to launch Amazon Elastic Compute Cloud instances with your game server build. For more information, see [ Launching an Instance from a Launch Template](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html) in the *Amazon Elastic Compute Cloud User Guide*.
     * + An IAM role that extends limited access to your Amazon Web Services account to allow Amazon GameLift Servers FleetIQ to create and interact with the Auto Scaling group. For more information, see [Create IAM roles for cross-service interaction](https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-iam-permissions-roles.html) in the *Amazon GameLift Servers FleetIQ Developer Guide*.
     *
     * To create a new game server group, specify a unique group name, IAM role and Amazon Elastic Compute Cloud launch template, and provide a list of instance types that can be used in the group. You must also set initial maximum and minimum limits on the group's instance count. You can optionally set an Auto Scaling policy with target tracking based on a Amazon GameLift Servers FleetIQ metric.
     *
     * Once the game server group and corresponding Auto Scaling group are created, you have full access to change the Auto Scaling group's configuration as needed. Several properties that are set when creating a game server group, including maximum/minimum size and auto-scaling policy settings, must be updated directly in the Auto Scaling group. Keep in mind that some Auto Scaling group properties are periodically updated by Amazon GameLift Servers FleetIQ as part of its balancing activities to optimize for availability and cost.
     *
     * **Learn more**
     *
     * [Amazon GameLift Servers FleetIQ Guide](https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
     */
    public suspend fun createGameServerGroup(input: CreateGameServerGroupRequest): CreateGameServerGroupResponse

    /**
     * Creates a multiplayer game session for players in a specific fleet location. This operation prompts an available server process to start a game session and retrieves connection information for the new game session. As an alternative, consider using the Amazon GameLift Servers game session placement feature with [StartGameSessionPlacement](https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartGameSessionPlacement.html), which uses the FleetIQ algorithm and queues to optimize the placement process.
     *
     * When creating a game session, you specify exactly where you want to place it and provide a set of game session configuration settings. The target fleet must be in `ACTIVE` status.
     *
     * You can use this operation in the following ways:
     * + To create a game session on an instance in a fleet's home Region, provide a fleet or alias ID along with your game session configuration.
     * + To create a game session on an instance in a fleet's remote location, provide a fleet or alias ID and a location name, along with your game session configuration.
     * + To create a game session on an instance in an Anywhere fleet, specify the fleet's custom location.
     *
     * If successful, Amazon GameLift Servers initiates a workflow to start a new game session and returns a `GameSession` object containing the game session configuration and status. When the game session status is `ACTIVE`, it is updated with connection information and you can create player sessions for the game session. By default, newly created game sessions are open to new players. You can restrict new player access by using [UpdateGameSession](https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateGameSession.html) to change the game session's player session creation policy.
     *
     * Amazon GameLift Servers retains logs for active for 14 days. To access the logs, call [GetGameSessionLogUrl](https://docs.aws.amazon.com/gamelift/latest/apireference/API_GetGameSessionLogUrl.html) to download the log files.
     *
     * *Available in Amazon GameLift Servers Local.*
     *
     * **Learn more**
     *
     * [Start a game session](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession)
     *
     * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
     */
    public suspend fun createGameSession(input: CreateGameSessionRequest): CreateGameSessionResponse

    /**
     * Creates a placement queue that processes requests for new game sessions. A queue uses FleetIQ algorithms to locate the best available placement locations for a new game session, and then prompts the game server process to start a new game session.
     *
     * A game session queue is configured with a set of destinations (Amazon GameLift Servers fleets or aliases) that determine where the queue can place new game sessions. These destinations can span multiple Amazon Web Services Regions, can use different instance types, and can include both Spot and On-Demand fleets. If the queue includes multi-location fleets, the queue can place game sessions in any of a fleet's remote locations.
     *
     * You can configure a queue to determine how it selects the best available placement for a new game session. Queues can prioritize placement decisions based on a combination of location, hosting cost, and player latency. You can set up the queue to use the default prioritization or provide alternate instructions using `PriorityConfiguration`.
     *
     * **Request options**
     *
     * Use this operation to make these common types of requests.
     * + Create a queue with the minimum required parameters.
     *    + `Name`
     *    + `Destinations` (This parameter isn't required, but a queue can't make placements without at least one destination.)
     * + Create a queue with placement notification. Queues that have high placement activity must use a notification system, such as with Amazon Simple Notification Service (Amazon SNS) or Amazon CloudWatch.
     *    + Required parameters `Name` and `Destinations`
     *    + `NotificationTarget`
     * + Create a queue with custom prioritization settings. These custom settings replace the default prioritization configuration for a queue.
     *    + Required parameters `Name` and `Destinations`
     *    + `PriorityConfiguration`
     * + Create a queue with special rules for processing player latency data.
     *    + Required parameters `Name` and `Destinations`
     *    + `PlayerLatencyPolicies`
     *
     * **Results**
     *
     * If successful, this operation returns a new `GameSessionQueue` object with an assigned queue ARN. Use the queue's name or ARN when submitting new game session requests with [StartGameSessionPlacement](https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartGameSessionPlacement.html) or [StartMatchmaking](https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartMatchmaking.html).
     *
     * **Learn more**
     *
     * [ Design a game session queue](https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-design.html)
     *
     * [ Create a game session queue](https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-creating.html)
     *
     * **Related actions**
     *
     * [CreateGameSessionQueue](https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateGameSessionQueue.html) | [DescribeGameSessionQueues](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameSessionQueues.html) | [UpdateGameSessionQueue](https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateGameSessionQueue.html) | [DeleteGameSessionQueue](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteGameSessionQueue.html) | [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
     */
    public suspend fun createGameSessionQueue(input: CreateGameSessionQueueRequest): CreateGameSessionQueueResponse

    /**
     * Creates a custom location for use in an Anywhere fleet.
     */
    public suspend fun createLocation(input: CreateLocationRequest): CreateLocationResponse

    /**
     * Defines a new matchmaking configuration for use with FlexMatch. Whether your are using FlexMatch with Amazon GameLift Servers hosting or as a standalone matchmaking service, the matchmaking configuration sets out rules for matching players and forming teams. If you're also using Amazon GameLift Servers hosting, it defines how to start game sessions for each match. Your matchmaking system can use multiple configurations to handle different game scenarios. All matchmaking requests identify the matchmaking configuration to use and provide player attributes consistent with that configuration.
     *
     * To create a matchmaking configuration, you must provide the following: configuration name and FlexMatch mode (with or without Amazon GameLift Servers hosting); a rule set that specifies how to evaluate players and find acceptable matches; whether player acceptance is required; and the maximum time allowed for a matchmaking attempt. When using FlexMatch with Amazon GameLift Servers hosting, you also need to identify the game session queue to use when starting a game session for the match.
     *
     * In addition, you must set up an Amazon Simple Notification Service topic to receive matchmaking notifications. Provide the topic ARN in the matchmaking configuration.
     *
     * **Learn more**
     *
     * [ Design a FlexMatch matchmaker](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-configuration.html)
     *
     * [ Set up FlexMatch event notification](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html)
     */
    public suspend fun createMatchmakingConfiguration(input: CreateMatchmakingConfigurationRequest): CreateMatchmakingConfigurationResponse

    /**
     * Creates a new rule set for FlexMatch matchmaking. A rule set describes the type of match to create, such as the number and size of teams. It also sets the parameters for acceptable player matches, such as minimum skill level or character type.
     *
     * To create a matchmaking rule set, provide unique rule set name and the rule set body in JSON format. Rule sets must be defined in the same Region as the matchmaking configuration they are used with.
     *
     * Since matchmaking rule sets cannot be edited, it is a good idea to check the rule set syntax using [ValidateMatchmakingRuleSet](https://docs.aws.amazon.com/gamelift/latest/apireference/API_ValidateMatchmakingRuleSet.html) before creating a new rule set.
     *
     * **Learn more**
     * + [Build a rule set](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html)
     * + [Design a matchmaker](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-configuration.html)
     * + [Matchmaking with FlexMatch](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-intro.html)
     */
    public suspend fun createMatchmakingRuleSet(input: CreateMatchmakingRuleSetRequest): CreateMatchmakingRuleSetResponse

    /**
     * Reserves an open player slot in a game session for a player. New player sessions can be created in any game session with an open slot that is in `ACTIVE` status and has a player creation policy of `ACCEPT_ALL`. You can add a group of players to a game session with [CreatePlayerSessions](https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreatePlayerSessions.html) .
     *
     * To create a player session, specify a game session ID, player ID, and optionally a set of player data.
     *
     * If successful, a slot is reserved in the game session for the player and a new `PlayerSessions` object is returned with a player session ID. The player references the player session ID when sending a connection request to the game session, and the game server can use it to validate the player reservation with the Amazon GameLift Servers service. Player sessions cannot be updated.
     *
     * The maximum number of players per game session is 200. It is not adjustable.
     *
     * **Related actions**
     *
     * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
     */
    public suspend fun createPlayerSession(input: CreatePlayerSessionRequest): CreatePlayerSessionResponse

    /**
     * Reserves open slots in a game session for a group of players. New player sessions can be created in any game session with an open slot that is in `ACTIVE` status and has a player creation policy of `ACCEPT_ALL`. To add a single player to a game session, use [CreatePlayerSession](https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreatePlayerSession.html)
     *
     * To create player sessions, specify a game session ID and a list of player IDs. Optionally, provide a set of player data for each player ID.
     *
     * If successful, a slot is reserved in the game session for each player, and new `PlayerSession` objects are returned with player session IDs. Each player references their player session ID when sending a connection request to the game session, and the game server can use it to validate the player reservation with the Amazon GameLift Servers service. Player sessions cannot be updated.
     *
     * The maximum number of players per game session is 200. It is not adjustable.
     *
     * **Related actions**
     *
     * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
     */
    public suspend fun createPlayerSessions(input: CreatePlayerSessionsRequest): CreatePlayerSessionsResponse

    /**
     * Creates a new script record for your Amazon GameLift Servers Realtime script. Realtime scripts are JavaScript that provide configuration settings and optional custom game logic for your game. The script is deployed when you create a Amazon GameLift Servers Realtime fleet to host your game sessions. Script logic is executed during an active game session.
     *
     * To create a new script record, specify a script name and provide the script file(s). The script files and all dependencies must be zipped into a single file. You can pull the zip file from either of these locations:
     * + A locally available directory. Use the *ZipFile* parameter for this option.
     * + An Amazon Simple Storage Service (Amazon S3) bucket under your Amazon Web Services account. Use the *StorageLocation* parameter for this option. You'll need to have an Identity Access Management (IAM) role that allows the Amazon GameLift Servers service to access your S3 bucket.
     *
     * If the call is successful, a new script record is created with a unique script ID. If the script file is provided as a local file, the file is uploaded to an Amazon GameLift Servers-owned S3 bucket and the script record's storage location reflects this location. If the script file is provided as an S3 bucket, Amazon GameLift Servers accesses the file at this storage location as needed for deployment.
     *
     * **Learn more**
     *
     * [Amazon GameLift Servers Amazon GameLift Servers Realtime](https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html)
     *
     * [Set Up a Role for Amazon GameLift Servers Access](https://docs.aws.amazon.com/gamelift/latest/developerguide/setting-up-role.html)
     *
     * **Related actions**
     *
     * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
     */
    public suspend fun createScript(input: CreateScriptRequest = CreateScriptRequest { }): CreateScriptResponse

    /**
     * Requests authorization to create or delete a peer connection between the VPC for your Amazon GameLift Servers fleet and a virtual private cloud (VPC) in your Amazon Web Services account. VPC peering enables the game servers on your fleet to communicate directly with other Amazon Web Services resources. After you've received authorization, use [CreateVpcPeeringConnection](https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateVpcPeeringConnection.html) to establish the peering connection. For more information, see [VPC Peering with Amazon GameLift Servers Fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html).
     *
     * You can peer with VPCs that are owned by any Amazon Web Services account you have access to, including the account that you use to manage your Amazon GameLift Servers fleets. You cannot peer with VPCs that are in different Regions.
     *
     * To request authorization to create a connection, call this operation from the Amazon Web Services account with the VPC that you want to peer to your Amazon GameLift Servers fleet. For example, to enable your game servers to retrieve data from a DynamoDB table, use the account that manages that DynamoDB resource. Identify the following values: (1) The ID of the VPC that you want to peer with, and (2) the ID of the Amazon Web Services account that you use to manage Amazon GameLift Servers. If successful, VPC peering is authorized for the specified VPC.
     *
     * To request authorization to delete a connection, call this operation from the Amazon Web Services account with the VPC that is peered with your Amazon GameLift Servers fleet. Identify the following values: (1) VPC ID that you want to delete the peering connection for, and (2) ID of the Amazon Web Services account that you use to manage Amazon GameLift Servers.
     *
     * The authorization remains valid for 24 hours unless it is canceled. You must create or delete the peering connection while the authorization is valid.
     *
     * **Related actions**
     *
     * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
     */
    public suspend fun createVpcPeeringAuthorization(input: CreateVpcPeeringAuthorizationRequest): CreateVpcPeeringAuthorizationResponse

    /**
     * Establishes a VPC peering connection between a virtual private cloud (VPC) in an Amazon Web Services account with the VPC for your Amazon GameLift Servers fleet. VPC peering enables the game servers on your fleet to communicate directly with other Amazon Web Services resources. You can peer with VPCs in any Amazon Web Services account that you have access to, including the account that you use to manage your Amazon GameLift Servers fleets. You cannot peer with VPCs that are in different Regions. For more information, see [VPC Peering with Amazon GameLift Servers Fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html).
     *
     * Before calling this operation to establish the peering connection, you first need to use [CreateVpcPeeringAuthorization](https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateVpcPeeringAuthorization.html) and identify the VPC you want to peer with. Once the authorization for the specified VPC is issued, you have 24 hours to establish the connection. These two operations handle all tasks necessary to peer the two VPCs, including acceptance, updating routing tables, etc.
     *
     * To establish the connection, call this operation from the Amazon Web Services account that is used to manage the Amazon GameLift Servers fleets. Identify the following values: (1) The ID of the fleet you want to be enable a VPC peering connection for; (2) The Amazon Web Services account with the VPC that you want to peer with; and (3) The ID of the VPC you want to peer with. This operation is asynchronous. If successful, a connection request is created. You can use continuous polling to track the request's status using [DescribeVpcPeeringConnections](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeVpcPeeringConnections.html) , or by monitoring fleet events for success or failure using [DescribeFleetEvents](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetEvents.html) .
     *
     * **Related actions**
     *
     * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
     */
    public suspend fun createVpcPeeringConnection(input: CreateVpcPeeringConnectionRequest): CreateVpcPeeringConnectionResponse

    /**
     * Deletes an alias. This operation removes all record of the alias. Game clients attempting to access a server process using the deleted alias receive an error. To delete an alias, specify the alias ID to be deleted.
     *
     * **Related actions**
     *
     * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
     */
    public suspend fun deleteAlias(input: DeleteAliasRequest): DeleteAliasResponse

    /**
     * Deletes a build. This operation permanently deletes the build resource and any uploaded build files. Deleting a build does not affect the status of any active fleets using the build, but you can no longer create new fleets with the deleted build.
     *
     * To delete a build, specify the build ID.
     *
     * **Learn more**
     *
     * [ Upload a Custom Server Build](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html)
     *
     * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
     */
    public suspend fun deleteBuild(input: DeleteBuildRequest): DeleteBuildResponse

    /**
     * Deletes all resources and information related to a container fleet and shuts down currently running fleet instances, including those in remote locations. The container fleet must be in `ACTIVE` status to be deleted.
     *
     * To delete a fleet, specify the fleet ID to be terminated. During the deletion process, the fleet status is changed to `DELETING`.
     *
     * **Learn more**
     *
     * [Setting up Amazon GameLift Servers Fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
     */
    public suspend fun deleteContainerFleet(input: DeleteContainerFleetRequest): DeleteContainerFleetResponse

    /**
     * Deletes a container group definition.
     *
     * **Request options:**
     * + Delete an entire container group definition, including all versions. Specify the container group definition name, or use an ARN value without the version number.
     * + Delete a particular version. Specify the container group definition name and a version number, or use an ARN value that includes the version number.
     * + Keep the newest versions and delete all older versions. Specify the container group definition name and the number of versions to retain. For example, set `VersionCountToRetain` to 5 to delete all but the five most recent versions.
     *
     * **Result**
     *
     * If successful, Amazon GameLift Servers removes the container group definition versions that you request deletion for. This request will fail for any requested versions if the following is true:
     * + If the version is being used in an active fleet
     * + If the version is being deployed to a fleet in a deployment that's currently in progress.
     * + If the version is designated as a rollback definition in a fleet deployment that's currently in progress.
     *
     * **Learn more**
     * + [Manage a container group definition](https://docs.aws.amazon.com/gamelift/latest/developerguide/containers-create-groups.html)
     */
    public suspend fun deleteContainerGroupDefinition(input: DeleteContainerGroupDefinitionRequest): DeleteContainerGroupDefinitionResponse

    /**
     * Deletes all resources and information related to a fleet and shuts down any currently running fleet instances, including those in remote locations.
     *
     * If the fleet being deleted has a VPC peering connection, you first need to get a valid authorization (good for 24 hours) by calling [CreateVpcPeeringAuthorization](https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateVpcPeeringAuthorization.html). You don't need to explicitly delete the VPC peering connection.
     *
     * To delete a fleet, specify the fleet ID to be terminated. During the deletion process, the fleet status is changed to `DELETING`. When completed, the status switches to `TERMINATED` and the fleet event `FLEET_DELETED` is emitted.
     *
     * **Learn more**
     *
     * [Setting up Amazon GameLift Servers Fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
     */
    public suspend fun deleteFleet(input: DeleteFleetRequest): DeleteFleetResponse

    /**
     * Removes locations from a multi-location fleet. When deleting a location, all game server process and all instances that are still active in the location are shut down.
     *
     * To delete fleet locations, identify the fleet ID and provide a list of the locations to be deleted.
     *
     * If successful, GameLift sets the location status to `DELETING`, and begins to shut down existing server processes and terminate instances in each location being deleted. When completed, the location status changes to `TERMINATED`.
     *
     * **Learn more**
     *
     * [Setting up Amazon GameLift Servers fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
     */
    public suspend fun deleteFleetLocations(input: DeleteFleetLocationsRequest): DeleteFleetLocationsResponse

    /**
     * **This operation is used with the Amazon GameLift Servers FleetIQ solution and game server groups.**
     *
     * Terminates a game server group and permanently deletes the game server group record. You have several options for how these resources are impacted when deleting the game server group. Depending on the type of delete operation selected, this operation might affect these resources:
     * + The game server group
     * + The corresponding Auto Scaling group
     * + All game servers that are currently running in the group
     *
     * To delete a game server group, identify the game server group to delete and specify the type of delete operation to initiate. Game server groups can only be deleted if they are in `ACTIVE` or `ERROR` status.
     *
     * If the delete request is successful, a series of operations are kicked off. The game server group status is changed to `DELETE_SCHEDULED`, which prevents new game servers from being registered and stops automatic scaling activity. Once all game servers in the game server group are deregistered, Amazon GameLift Servers FleetIQ can begin deleting resources. If any of the delete operations fail, the game server group is placed in `ERROR` status.
     *
     * Amazon GameLift Servers FleetIQ emits delete events to Amazon CloudWatch.
     *
     * **Learn more**
     *
     * [Amazon GameLift Servers FleetIQ Guide](https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
     */
    public suspend fun deleteGameServerGroup(input: DeleteGameServerGroupRequest): DeleteGameServerGroupResponse

    /**
     * Deletes a game session queue. Once a queue is successfully deleted, unfulfilled [StartGameSessionPlacement](https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartGameSessionPlacement.html) requests that reference the queue will fail. To delete a queue, specify the queue name.
     */
    public suspend fun deleteGameSessionQueue(input: DeleteGameSessionQueueRequest): DeleteGameSessionQueueResponse

    /**
     * Deletes a custom location.
     *
     * Before deleting a custom location, review any fleets currently using the custom location and deregister the location if it is in use. For more information, see [DeregisterCompute](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeregisterCompute.html).
     */
    public suspend fun deleteLocation(input: DeleteLocationRequest): DeleteLocationResponse

    /**
     * Permanently removes a FlexMatch matchmaking configuration. To delete, specify the configuration name. A matchmaking configuration cannot be deleted if it is being used in any active matchmaking tickets.
     */
    public suspend fun deleteMatchmakingConfiguration(input: DeleteMatchmakingConfigurationRequest): DeleteMatchmakingConfigurationResponse

    /**
     * Deletes an existing matchmaking rule set. To delete the rule set, provide the rule set name. Rule sets cannot be deleted if they are currently being used by a matchmaking configuration.
     *
     * **Learn more**
     * + [Build a rule set](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html)
     */
    public suspend fun deleteMatchmakingRuleSet(input: DeleteMatchmakingRuleSetRequest): DeleteMatchmakingRuleSetResponse

    /**
     * Deletes a fleet scaling policy. Once deleted, the policy is no longer in force and Amazon GameLift Servers removes all record of it. To delete a scaling policy, specify both the scaling policy name and the fleet ID it is associated with.
     *
     * To temporarily suspend scaling policies, use [StopFleetActions](https://docs.aws.amazon.com/gamelift/latest/apireference/API_StopFleetActions.html). This operation suspends all policies for the fleet.
     */
    public suspend fun deleteScalingPolicy(input: DeleteScalingPolicyRequest): DeleteScalingPolicyResponse

    /**
     * Deletes a Realtime script. This operation permanently deletes the script record. If script files were uploaded, they are also deleted (files stored in an S3 bucket are not deleted).
     *
     * To delete a script, specify the script ID. Before deleting a script, be sure to terminate all fleets that are deployed with the script being deleted. Fleet instances periodically check for script updates, and if the script record no longer exists, the instance will go into an error state and be unable to host game sessions.
     *
     * **Learn more**
     *
     * [Amazon GameLift Servers Amazon GameLift Servers Realtime](https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html)
     *
     * **Related actions**
     *
     * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
     */
    public suspend fun deleteScript(input: DeleteScriptRequest): DeleteScriptResponse

    /**
     * Cancels a pending VPC peering authorization for the specified VPC. If you need to delete an existing VPC peering connection, use [DeleteVpcPeeringConnection](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteVpcPeeringConnection.html).
     *
     * **Related actions**
     *
     * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
     */
    public suspend fun deleteVpcPeeringAuthorization(input: DeleteVpcPeeringAuthorizationRequest): DeleteVpcPeeringAuthorizationResponse

    /**
     * Removes a VPC peering connection. To delete the connection, you must have a valid authorization for the VPC peering connection that you want to delete..
     *
     * Once a valid authorization exists, call this operation from the Amazon Web Services account that is used to manage the Amazon GameLift Servers fleets. Identify the connection to delete by the connection ID and fleet ID. If successful, the connection is removed.
     *
     * **Related actions**
     *
     * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
     */
    public suspend fun deleteVpcPeeringConnection(input: DeleteVpcPeeringConnectionRequest): DeleteVpcPeeringConnectionResponse

    /**
     * Removes a compute resource from an Anywhere fleet. Deregistered computes can no longer host game sessions through Amazon GameLift Servers. Use this operation with an Anywhere fleet that doesn't use the Amazon GameLift Servers Agent For Anywhere fleets with the Agent, the Agent handles all compute registry tasks for you.
     *
     * To deregister a compute, call this operation from the compute that's being deregistered and specify the compute name and the fleet ID.
     */
    public suspend fun deregisterCompute(input: DeregisterComputeRequest): DeregisterComputeResponse

    /**
     * **This operation is used with the Amazon GameLift Servers FleetIQ solution and game server groups.**
     *
     * Removes the game server from a game server group. As a result of this operation, the deregistered game server can no longer be claimed and will not be returned in a list of active game servers.
     *
     * To deregister a game server, specify the game server group and game server ID. If successful, this operation emits a CloudWatch event with termination timestamp and reason.
     *
     * **Learn more**
     *
     * [Amazon GameLift Servers FleetIQ Guide](https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
     */
    public suspend fun deregisterGameServer(input: DeregisterGameServerRequest): DeregisterGameServerResponse

    /**
     * Retrieves properties for an alias. This operation returns all alias metadata and settings. To get an alias's target fleet ID only, use `ResolveAlias`.
     *
     * To get alias properties, specify the alias ID. If successful, the requested alias record is returned.
     *
     * **Related actions**
     *
     * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
     */
    public suspend fun describeAlias(input: DescribeAliasRequest): DescribeAliasResponse

    /**
     * Retrieves properties for a custom game build. To request a build resource, specify a build ID. If successful, an object containing the build properties is returned.
     *
     * **Learn more**
     *
     * [ Upload a Custom Server Build](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html)
     *
     * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
     */
    public suspend fun describeBuild(input: DescribeBuildRequest): DescribeBuildResponse

    /**
     * Retrieves properties for a specific compute resource in an Amazon GameLift Servers fleet. You can list all computes in a fleet by calling [ListCompute](https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListCompute.html).
     *
     * **Request options**
     *
     * Provide the fleet ID and compute name. The compute name varies depending on the type of fleet.
     * + For a compute in a managed EC2 fleet, provide an instance ID. Each instance in the fleet is a compute.
     * + For a compute in a managed container fleet, provide a compute name. In a container fleet, each game server container group on a fleet instance is assigned a compute name.
     * + For a compute in an Anywhere fleet, provide a registered compute name. Anywhere fleet computes are created when you register a hosting resource with the fleet.
     *
     * **Results**
     *
     * If successful, this operation returns details for the requested compute resource. Depending on the fleet's compute type, the result includes the following information:
     * + For a managed EC2 fleet, this operation returns information about the EC2 instance.
     * + For an Anywhere fleet, this operation returns information about the registered compute.
     */
    public suspend fun describeCompute(input: DescribeComputeRequest): DescribeComputeResponse

    /**
     * Retrieves the properties for a container fleet. When requesting attributes for multiple fleets, use the pagination parameters to retrieve results as a set of sequential pages.
     *
     * **Request options**
     * + Get container fleet properties for a single fleet. Provide either the fleet ID or ARN value.
     *
     * **Results**
     *
     * If successful, a `ContainerFleet` object is returned. This object includes the fleet properties, including information about the most recent deployment.
     *
     * Some API operations limit the number of fleet IDs that allowed in one request. If a request exceeds this limit, the request fails and the error message contains the maximum allowed number.
     */
    public suspend fun describeContainerFleet(input: DescribeContainerFleetRequest): DescribeContainerFleetResponse

    /**
     * Retrieves the properties of a container group definition, including all container definitions in the group.
     *
     * **Request options:**
     * + Retrieve the latest version of a container group definition. Specify the container group definition name only, or use an ARN value without a version number.
     * + Retrieve a particular version. Specify the container group definition name and a version number, or use an ARN value that includes the version number.
     *
     * **Results:**
     *
     * If successful, this operation returns the complete properties of a container group definition version.
     *
     * **Learn more**
     * + [Manage a container group definition](https://docs.aws.amazon.com/gamelift/latest/developerguide/containers-create-groups.html)
     */
    public suspend fun describeContainerGroupDefinition(input: DescribeContainerGroupDefinitionRequest): DescribeContainerGroupDefinitionResponse

    /**
     * Retrieves the instance limits and current utilization for an Amazon Web Services Region or location. Instance limits control the number of instances, per instance type, per location, that your Amazon Web Services account can use. Learn more at [Amazon EC2 Instance Types](http://aws.amazon.com/ec2/instance-types/). The information returned includes the maximum number of instances allowed and your account's current usage across all fleets. This information can affect your ability to scale your Amazon GameLift Servers fleets. You can request a limit increase for your account by using the **Service limits** page in the Amazon GameLift Servers console.
     *
     * Instance limits differ based on whether the instances are deployed in a fleet's home Region or in a remote location. For remote locations, limits also differ based on the combination of home Region and remote location. All requests must specify an Amazon Web Services Region (either explicitly or as your default settings). To get the limit for a remote location, you must also specify the location. For example, the following requests all return different results:
     * + Request specifies the Region `ap-northeast-1` with no location. The result is limits and usage data on all instance types that are deployed in `us-east-2`, by all of the fleets that reside in `ap-northeast-1`.
     * + Request specifies the Region `us-east-1` with location `ca-central-1`. The result is limits and usage data on all instance types that are deployed in `ca-central-1`, by all of the fleets that reside in `us-east-2`. These limits do not affect fleets in any other Regions that deploy instances to `ca-central-1`.
     * + Request specifies the Region `eu-west-1` with location `ca-central-1`. The result is limits and usage data on all instance types that are deployed in `ca-central-1`, by all of the fleets that reside in `eu-west-1`.
     *
     * This operation can be used in the following ways:
     * + To get limit and usage data for all instance types that are deployed in an Amazon Web Services Region by fleets that reside in the same Region: Specify the Region only. Optionally, specify a single instance type to retrieve information for.
     * + To get limit and usage data for all instance types that are deployed to a remote location by fleets that reside in different Amazon Web Services Region: Provide both the Amazon Web Services Region and the remote location. Optionally, specify a single instance type to retrieve information for.
     *
     * If successful, an `EC2InstanceLimits` object is returned with limits and usage data for each requested instance type.
     *
     * **Learn more**
     *
     * [Setting up Amazon GameLift Servers fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
     */
    public suspend fun describeEc2InstanceLimits(input: DescribeEc2InstanceLimitsRequest = DescribeEc2InstanceLimitsRequest { }): DescribeEc2InstanceLimitsResponse

    /**
     * Retrieves core fleet-wide properties for fleets in an Amazon Web Services Region. Properties include the computing hardware and deployment configuration for instances in the fleet.
     *
     * You can use this operation in the following ways:
     * + To get attributes for specific fleets, provide a list of fleet IDs or fleet ARNs.
     * + To get attributes for all fleets, do not provide a fleet identifier.
     *
     * When requesting attributes for multiple fleets, use the pagination parameters to retrieve results as a set of sequential pages.
     *
     * If successful, a `FleetAttributes` object is returned for each fleet requested, unless the fleet identifier is not found.
     *
     * Some API operations limit the number of fleet IDs that allowed in one request. If a request exceeds this limit, the request fails and the error message contains the maximum allowed number.
     *
     * **Learn more**
     *
     * [Setting up Amazon GameLift Servers fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
     */
    public suspend fun describeFleetAttributes(input: DescribeFleetAttributesRequest = DescribeFleetAttributesRequest { }): DescribeFleetAttributesResponse

    /**
     * Retrieves the resource capacity settings for one or more fleets. For a container fleet, this operation also returns counts for game server container groups.
     *
     * With multi-location fleets, this operation retrieves data for the fleet's home Region only. To retrieve capacity for remote locations, see [https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationCapacity.html](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationCapacity.html).
     *
     * This operation can be used in the following ways:
     * + To get capacity data for one or more specific fleets, provide a list of fleet IDs or fleet ARNs.
     * + To get capacity data for all fleets, do not provide a fleet identifier.
     *
     * When requesting multiple fleets, use the pagination parameters to retrieve results as a set of sequential pages.
     *
     * If successful, a `FleetCapacity` object is returned for each requested fleet ID. Each `FleetCapacity` object includes a `Location` property, which is set to the fleet's home Region. Capacity values are returned only for fleets that currently exist.
     *
     * Some API operations may limit the number of fleet IDs that are allowed in one request. If a request exceeds this limit, the request fails and the error message includes the maximum allowed.
     *
     * **Learn more**
     *
     * [Setting up Amazon GameLift Servers fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
     *
     * [GameLift metrics for fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet)
     */
    public suspend fun describeFleetCapacity(input: DescribeFleetCapacityRequest = DescribeFleetCapacityRequest { }): DescribeFleetCapacityResponse

    /**
     * Retrieves information about a managed container fleet deployment.
     *
     * **Request options**
     * + Get information about the latest deployment for a specific fleet. Provide the fleet ID or ARN.
     * +  Get information about a specific deployment. Provide the fleet ID or ARN and the deployment ID.
     *
     * **Results**
     *
     * If successful, a `FleetDeployment` object is returned.
     */
    public suspend fun describeFleetDeployment(input: DescribeFleetDeploymentRequest): DescribeFleetDeploymentResponse

    /**
     * Retrieves entries from a fleet's event log. Fleet events are initiated by changes in status, such as during fleet creation and termination, changes in capacity, etc. If a fleet has multiple locations, events are also initiated by changes to status and capacity in remote locations.
     *
     * You can specify a time range to limit the result set. Use the pagination parameters to retrieve results as a set of sequential pages.
     *
     * If successful, a collection of event log entries matching the request are returned.
     *
     * **Learn more**
     *
     * [Setting up Amazon GameLift Servers fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
     */
    public suspend fun describeFleetEvents(input: DescribeFleetEventsRequest): DescribeFleetEventsResponse

    /**
     * Retrieves information on a fleet's remote locations, including life-cycle status and any suspended fleet activity.
     *
     * This operation can be used in the following ways:
     * + To get data for specific locations, provide a fleet identifier and a list of locations. Location data is returned in the order that it is requested.
     * + To get data for all locations, provide a fleet identifier only. Location data is returned in no particular order.
     *
     * When requesting attributes for multiple locations, use the pagination parameters to retrieve results as a set of sequential pages.
     *
     * If successful, a `LocationAttributes` object is returned for each requested location. If the fleet does not have a requested location, no information is returned. This operation does not return the home Region. To get information on a fleet's home Region, call `DescribeFleetAttributes`.
     *
     * **Learn more**
     *
     * [Setting up Amazon GameLift Servers fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
     *
     * [ Amazon GameLift Servers service locations](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html) for managed hosting
     */
    public suspend fun describeFleetLocationAttributes(input: DescribeFleetLocationAttributesRequest): DescribeFleetLocationAttributesResponse

    /**
     * Retrieves the resource capacity settings for a fleet location. The data returned includes the current capacity (number of EC2 instances) and some scaling settings for the requested fleet location. For a managed container fleet, this operation also returns counts for game server container groups.
     *
     * Use this operation to retrieve capacity information for a fleet's remote location or home Region (you can also retrieve home Region capacity by calling `DescribeFleetCapacity`).
     *
     * To retrieve capacity data, identify a fleet and location.
     *
     * If successful, a `FleetCapacity` object is returned for the requested fleet location.
     *
     * **Learn more**
     *
     * [Setting up Amazon GameLift Servers fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
     *
     * [ Amazon GameLift Servers service locations](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html) for managed hosting
     *
     * [GameLift metrics for fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet)
     */
    public suspend fun describeFleetLocationCapacity(input: DescribeFleetLocationCapacityRequest): DescribeFleetLocationCapacityResponse

    /**
     * Retrieves current usage data for a fleet location. Utilization data provides a snapshot of current game hosting activity at the requested location. Use this operation to retrieve utilization information for a fleet's remote location or home Region (you can also retrieve home Region utilization by calling `DescribeFleetUtilization`).
     *
     * To retrieve utilization data, identify a fleet and location.
     *
     * If successful, a `FleetUtilization` object is returned for the requested fleet location.
     *
     * **Learn more**
     *
     * [Setting up Amazon GameLift Servers fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
     *
     * [ Amazon GameLift Servers service locations](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html) for managed hosting
     *
     * [GameLift metrics for fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet)
     */
    public suspend fun describeFleetLocationUtilization(input: DescribeFleetLocationUtilizationRequest): DescribeFleetLocationUtilizationResponse

    /**
     * Retrieves a fleet's inbound connection permissions. Connection permissions specify IP addresses and port settings that incoming traffic can use to access server processes in the fleet. Game server processes that are running in the fleet must use a port that falls within this range.
     *
     * Use this operation in the following ways:
     * + To retrieve the port settings for a fleet, identify the fleet's unique identifier.
     * + To check the status of recent updates to a fleet remote location, specify the fleet ID and a location. Port setting updates can take time to propagate across all locations.
     *
     * If successful, a set of `IpPermission` objects is returned for the requested fleet ID. When specifying a location, this operation returns a pending status. If the requested fleet has been deleted, the result set is empty.
     *
     * **Learn more**
     *
     * [Setting up Amazon GameLift Servers fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
     */
    public suspend fun describeFleetPortSettings(input: DescribeFleetPortSettingsRequest): DescribeFleetPortSettingsResponse

    /**
     * Retrieves utilization statistics for one or more fleets. Utilization data provides a snapshot of how the fleet's hosting resources are currently being used. For fleets with remote locations, this operation retrieves data for the fleet's home Region only. See [DescribeFleetLocationUtilization](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationUtilization.html) to get utilization statistics for a fleet's remote locations.
     *
     * This operation can be used in the following ways:
     * + To get utilization data for one or more specific fleets, provide a list of fleet IDs or fleet ARNs.
     * + To get utilization data for all fleets, do not provide a fleet identifier.
     *
     * When requesting multiple fleets, use the pagination parameters to retrieve results as a set of sequential pages.
     *
     * If successful, a [FleetUtilization](https://docs.aws.amazon.com/gamelift/latest/apireference/API_FleetUtilization.html) object is returned for each requested fleet ID, unless the fleet identifier is not found. Each fleet utilization object includes a `Location` property, which is set to the fleet's home Region.
     *
     * Some API operations may limit the number of fleet IDs allowed in one request. If a request exceeds this limit, the request fails and the error message includes the maximum allowed.
     *
     * **Learn more**
     *
     * [Setting up Amazon GameLift Servers Fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
     *
     * [GameLift Metrics for Fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet)
     */
    public suspend fun describeFleetUtilization(input: DescribeFleetUtilizationRequest = DescribeFleetUtilizationRequest { }): DescribeFleetUtilizationResponse

    /**
     * **This operation is used with the Amazon GameLift Servers FleetIQ solution and game server groups.**
     *
     * Retrieves information for a registered game server. Information includes game server status, health check info, and the instance that the game server is running on.
     *
     * To retrieve game server information, specify the game server ID. If successful, the requested game server object is returned.
     *
     * **Learn more**
     *
     * [Amazon GameLift Servers FleetIQ Guide](https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
     */
    public suspend fun describeGameServer(input: DescribeGameServerRequest): DescribeGameServerResponse

    /**
     * **This operation is used with the Amazon GameLift Servers FleetIQ solution and game server groups.**
     *
     * Retrieves information on a game server group. This operation returns only properties related to Amazon GameLift Servers FleetIQ. To view or update properties for the corresponding Auto Scaling group, such as launch template, auto scaling policies, and maximum/minimum group size, access the Auto Scaling group directly.
     *
     * To get attributes for a game server group, provide a group name or ARN value. If successful, a `GameServerGroup` object is returned.
     *
     * **Learn more**
     *
     * [Amazon GameLift Servers FleetIQ Guide](https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
     */
    public suspend fun describeGameServerGroup(input: DescribeGameServerGroupRequest): DescribeGameServerGroupResponse

    /**
     * **This operation is used with the Amazon GameLift Servers FleetIQ solution and game server groups.**
     *
     * Retrieves status information about the Amazon EC2 instances associated with a Amazon GameLift Servers FleetIQ game server group. Use this operation to detect when instances are active or not available to host new game servers.
     *
     * To request status for all instances in the game server group, provide a game server group ID only. To request status for specific instances, provide the game server group ID and one or more instance IDs. Use the pagination parameters to retrieve results in sequential segments. If successful, a collection of `GameServerInstance` objects is returned.
     *
     * This operation is not designed to be called with every game server claim request; this practice can cause you to exceed your API limit, which results in errors. Instead, as a best practice, cache the results and refresh your cache no more than once every 10 seconds.
     *
     * **Learn more**
     *
     * [Amazon GameLift Servers FleetIQ Guide](https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
     */
    public suspend fun describeGameServerInstances(input: DescribeGameServerInstancesRequest): DescribeGameServerInstancesResponse

    /**
     * Retrieves additional game session properties, including the game session protection policy in force, a set of one or more game sessions in a specific fleet location. You can optionally filter the results by current game session status.
     *
     * This operation can be used in the following ways:
     * + To retrieve details for all game sessions that are currently running on all locations in a fleet, provide a fleet or alias ID, with an optional status filter. This approach returns details from the fleet's home Region and all remote locations.
     * + To retrieve details for all game sessions that are currently running on a specific fleet location, provide a fleet or alias ID and a location name, with optional status filter. The location can be the fleet's home Region or any remote location.
     * + To retrieve details for a specific game session, provide the game session ID. This approach looks for the game session ID in all fleets that reside in the Amazon Web Services Region defined in the request.
     *
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     *
     * If successful, a `GameSessionDetail` object is returned for each game session that matches the request.
     *
     * **Learn more**
     *
     * [Find a game session](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#gamelift-sdk-client-api-find)
     *
     * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
     */
    public suspend fun describeGameSessionDetails(input: DescribeGameSessionDetailsRequest = DescribeGameSessionDetailsRequest { }): DescribeGameSessionDetailsResponse

    /**
     * Retrieves information, including current status, about a game session placement request.
     *
     * To get game session placement details, specify the placement ID.
     *
     * This operation is not designed to be continually called to track game session status. This practice can cause you to exceed your API limit, which results in errors. Instead, you must configure an Amazon Simple Notification Service (SNS) topic to receive notifications from FlexMatch or queues. Continuously polling with `DescribeGameSessionPlacement` should only be used for games in development with low game session usage.
     */
    public suspend fun describeGameSessionPlacement(input: DescribeGameSessionPlacementRequest): DescribeGameSessionPlacementResponse

    /**
     * Retrieves the properties for one or more game session queues. When requesting multiple queues, use the pagination parameters to retrieve results as a set of sequential pages. When specifying a list of queues, objects are returned only for queues that currently exist in the Region.
     *
     * **Learn more**
     *
     * [ View Your Queues](https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-console.html)
     */
    public suspend fun describeGameSessionQueues(input: DescribeGameSessionQueuesRequest = DescribeGameSessionQueuesRequest { }): DescribeGameSessionQueuesResponse

    /**
     * Retrieves a set of one or more game sessions in a specific fleet location. You can optionally filter the results by current game session status.
     *
     * This operation can be used in the following ways:
     * + To retrieve all game sessions that are currently running on all locations in a fleet, provide a fleet or alias ID, with an optional status filter. This approach returns all game sessions in the fleet's home Region and all remote locations.
     * + To retrieve all game sessions that are currently running on a specific fleet location, provide a fleet or alias ID and a location name, with optional status filter. The location can be the fleet's home Region or any remote location.
     * + To retrieve a specific game session, provide the game session ID. This approach looks for the game session ID in all fleets that reside in the Amazon Web Services Region defined in the request.
     *
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     *
     * If successful, a `GameSession` object is returned for each game session that matches the request.
     *
     * This operation is not designed to be continually called to track game session status. This practice can cause you to exceed your API limit, which results in errors. Instead, you must configure an Amazon Simple Notification Service (SNS) topic to receive notifications from FlexMatch or queues. Continuously polling with `DescribeGameSessions` should only be used for games in development with low game session usage.
     *
     * *Available in Amazon GameLift Servers Local.*
     *
     * **Learn more**
     *
     * [Find a game session](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#gamelift-sdk-client-api-find)
     *
     * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
     */
    public suspend fun describeGameSessions(input: DescribeGameSessionsRequest = DescribeGameSessionsRequest { }): DescribeGameSessionsResponse

    /**
     * Retrieves information about the EC2 instances in an Amazon GameLift Servers managed fleet, including instance ID, connection data, and status. You can use this operation with a multi-location fleet to get location-specific instance information. As an alternative, use the operations [https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListCompute](https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListCompute) and [https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeCompute](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeCompute) to retrieve information for compute resources, including EC2 and Anywhere fleets.
     *
     * You can call this operation in the following ways:
     * + To get information on all instances in a fleet's home Region, specify the fleet ID.
     * + To get information on all instances in a fleet's remote location, specify the fleet ID and location name.
     * + To get information on a specific instance in a fleet, specify the fleet ID and instance ID.
     *
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     *
     * If successful, this operation returns `Instance` objects for each requested instance, listed in no particular order. If you call this operation for an Anywhere fleet, you receive an InvalidRequestException.
     *
     * **Learn more**
     *
     * [Remotely connect to fleet instances](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-remote-access.html)
     *
     * [Debug fleet issues](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html)
     *
     * **Related actions**
     *
     * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
     */
    public suspend fun describeInstances(input: DescribeInstancesRequest): DescribeInstancesResponse

    /**
     * Retrieves one or more matchmaking tickets. Use this operation to retrieve ticket information, including--after a successful match is made--connection information for the resulting new game session.
     *
     * To request matchmaking tickets, provide a list of up to 10 ticket IDs. If the request is successful, a ticket object is returned for each requested ID that currently exists.
     *
     * This operation is not designed to be continually called to track matchmaking ticket status. This practice can cause you to exceed your API limit, which results in errors. Instead, as a best practice, set up an Amazon Simple Notification Service to receive notifications, and provide the topic ARN in the matchmaking configuration.
     *
     * **Learn more**
     *
     * [ Add FlexMatch to a game client](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-client.html)
     *
     * [ Set Up FlexMatch event notification](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html)
     */
    public suspend fun describeMatchmaking(input: DescribeMatchmakingRequest): DescribeMatchmakingResponse

    /**
     * Retrieves the details of FlexMatch matchmaking configurations.
     *
     * This operation offers the following options: (1) retrieve all matchmaking configurations, (2) retrieve configurations for a specified list, or (3) retrieve all configurations that use a specified rule set name. When requesting multiple items, use the pagination parameters to retrieve results as a set of sequential pages.
     *
     * If successful, a configuration is returned for each requested name. When specifying a list of names, only configurations that currently exist are returned.
     *
     * **Learn more**
     *
     * [ Setting up FlexMatch matchmakers](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/matchmaker-build.html)
     */
    public suspend fun describeMatchmakingConfigurations(input: DescribeMatchmakingConfigurationsRequest = DescribeMatchmakingConfigurationsRequest { }): DescribeMatchmakingConfigurationsResponse

    /**
     * Retrieves the details for FlexMatch matchmaking rule sets. You can request all existing rule sets for the Region, or provide a list of one or more rule set names. When requesting multiple items, use the pagination parameters to retrieve results as a set of sequential pages. If successful, a rule set is returned for each requested name.
     *
     * **Learn more**
     * + [Build a rule set](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html)
     */
    public suspend fun describeMatchmakingRuleSets(input: DescribeMatchmakingRuleSetsRequest = DescribeMatchmakingRuleSetsRequest { }): DescribeMatchmakingRuleSetsResponse

    /**
     * Retrieves properties for one or more player sessions.
     *
     * This action can be used in the following ways:
     * + To retrieve a specific player session, provide the player session ID only.
     * + To retrieve all player sessions in a game session, provide the game session ID only.
     * + To retrieve all player sessions for a specific player, provide a player ID only.
     *
     * To request player sessions, specify either a player session ID, game session ID, or player ID. You can filter this request by player session status. If you provide a specific `PlayerSessionId` or `PlayerId`, Amazon GameLift Servers ignores the filter criteria. Use the pagination parameters to retrieve results as a set of sequential pages.
     *
     * If successful, a `PlayerSession` object is returned for each session that matches the request.
     *
     * **Related actions**
     *
     * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
     */
    public suspend fun describePlayerSessions(input: DescribePlayerSessionsRequest = DescribePlayerSessionsRequest { }): DescribePlayerSessionsResponse

    /**
     * Retrieves a fleet's runtime configuration settings. The runtime configuration determines which server processes run, and how, on computes in the fleet. For managed EC2 fleets, the runtime configuration describes server processes that run on each fleet instance. can update a fleet's runtime configuration at any time using [UpdateRuntimeConfiguration](https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateRuntimeConfiguration.html).
     *
     * To get the current runtime configuration for a fleet, provide the fleet ID.
     *
     * If successful, a `RuntimeConfiguration` object is returned for the requested fleet. If the requested fleet has been deleted, the result set is empty.
     *
     * **Learn more**
     *
     * [Setting up Amazon GameLift Servers fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
     *
     * [Running multiple processes on a fleet](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-multiprocess.html)
     */
    public suspend fun describeRuntimeConfiguration(input: DescribeRuntimeConfigurationRequest): DescribeRuntimeConfigurationResponse

    /**
     * Retrieves all scaling policies applied to a fleet.
     *
     * To get a fleet's scaling policies, specify the fleet ID. You can filter this request by policy status, such as to retrieve only active scaling policies. Use the pagination parameters to retrieve results as a set of sequential pages. If successful, set of `ScalingPolicy` objects is returned for the fleet.
     *
     * A fleet may have all of its scaling policies suspended. This operation does not affect the status of the scaling policies, which remains ACTIVE.
     */
    public suspend fun describeScalingPolicies(input: DescribeScalingPoliciesRequest): DescribeScalingPoliciesResponse

    /**
     * Retrieves properties for a Realtime script.
     *
     * To request a script record, specify the script ID. If successful, an object containing the script properties is returned.
     *
     * **Learn more**
     *
     * [Amazon GameLift Servers Amazon GameLift Servers Realtime](https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html)
     *
     * **Related actions**
     *
     * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
     */
    public suspend fun describeScript(input: DescribeScriptRequest): DescribeScriptResponse

    /**
     * Retrieves valid VPC peering authorizations that are pending for the Amazon Web Services account. This operation returns all VPC peering authorizations and requests for peering. This includes those initiated and received by this account.
     *
     * **Related actions**
     *
     * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
     */
    public suspend fun describeVpcPeeringAuthorizations(input: DescribeVpcPeeringAuthorizationsRequest = DescribeVpcPeeringAuthorizationsRequest { }): DescribeVpcPeeringAuthorizationsResponse

    /**
     * Retrieves information on VPC peering connections. Use this operation to get peering information for all fleets or for one specific fleet ID.
     *
     * To retrieve connection information, call this operation from the Amazon Web Services account that is used to manage the Amazon GameLift Servers fleets. Specify a fleet ID or leave the parameter empty to retrieve all connection records. If successful, the retrieved information includes both active and pending connections. Active connections identify the IpV4 CIDR block that the VPC uses to connect.
     *
     * **Related actions**
     *
     * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
     */
    public suspend fun describeVpcPeeringConnections(input: DescribeVpcPeeringConnectionsRequest = DescribeVpcPeeringConnectionsRequest { }): DescribeVpcPeeringConnectionsResponse

    /**
     * Requests authorization to remotely connect to a hosting resource in a Amazon GameLift Servers managed fleet. This operation is not used with Amazon GameLift Servers Anywhere fleets.
     *
     * **Request options**
     *
     * Provide the fleet ID and compute name. The compute name varies depending on the type of fleet.
     * + For a compute in a managed EC2 fleet, provide an instance ID. Each instance in the fleet is a compute.
     * + For a compute in a managed container fleet, provide a compute name. In a container fleet, each game server container group on a fleet instance is assigned a compute name.
     *
     * **Results**
     *
     * If successful, this operation returns a set of temporary Amazon Web Services credentials, including a two-part access key and a session token.
     * + With a managed EC2 fleet (where compute type is `EC2`), use these credentials with Amazon EC2 Systems Manager (SSM) to start a session with the compute. For more details, see [ Starting a session (CLI)](https://docs.aws.amazon.com/systems-manager/latest/userguide/session-manager-working-with-sessions-start.html#sessions-start-cli) in the *Amazon EC2 Systems Manager User Guide*.
     */
    public suspend fun getComputeAccess(input: GetComputeAccessRequest): GetComputeAccessResponse

    /**
     * Requests an authentication token from Amazon GameLift Servers for a compute resource in an Amazon GameLift Servers fleet. Game servers that are running on the compute use this token to communicate with the Amazon GameLift Servers service, such as when calling the Amazon GameLift Servers server SDK action `InitSDK()`. Authentication tokens are valid for a limited time span, so you need to request a fresh token before the current token expires.
     *
     * **Request options**
     * + For managed EC2 fleets (compute type `EC2`), auth token retrieval and refresh is handled automatically. All game servers that are running on all fleet instances have access to a valid auth token.
     * + For Anywhere fleets (compute type `ANYWHERE`), if you're using the Amazon GameLift Servers Agent, auth token retrieval and refresh is handled automatically for any compute where the Agent is running. If you're not using the Agent, create a mechanism to retrieve and refresh auth tokens for computes that are running game server processes.
     *
     * **Learn more**
     * + [Create an Anywhere fleet](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-anywhere.html)
     * + [Test your integration](https://docs.aws.amazon.com/gamelift/latest/developerguide/integration-testing.html)
     * + [Server SDK reference guides](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk.html) (for version 5.x)
     */
    public suspend fun getComputeAuthToken(input: GetComputeAuthTokenRequest): GetComputeAuthTokenResponse

    /**
     * Retrieves the location of stored game session logs for a specified game session on Amazon GameLift Servers managed fleets. When a game session is terminated, Amazon GameLift Servers automatically stores the logs in Amazon S3 and retains them for 14 days. Use this URL to download the logs.
     *
     * See the [Amazon Web Services Service Limits](https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_gamelift) page for maximum log file sizes. Log files that exceed this limit are not saved.
     *
     * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
     */
    public suspend fun getGameSessionLogUrl(input: GetGameSessionLogUrlRequest): GetGameSessionLogUrlResponse

    /**
     * Requests authorization to remotely connect to an instance in an Amazon GameLift Servers managed fleet. Use this operation to connect to instances with game servers that use Amazon GameLift Servers server SDK 4.x or earlier. To connect to instances with game servers that use server SDK 5.x or later, call [https://docs.aws.amazon.com/gamelift/latest/apireference/API_GetComputeAccess](https://docs.aws.amazon.com/gamelift/latest/apireference/API_GetComputeAccess).
     *
     * To request access to an instance, specify IDs for the instance and the fleet it belongs to. You can retrieve instance IDs for a fleet by calling [DescribeInstances](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeInstances.html) with the fleet ID.
     *
     * If successful, this operation returns an IP address and credentials. The returned credentials match the operating system of the instance, as follows:
     * + For a Windows instance: returns a user name and secret (password) for use with a Windows Remote Desktop client.
     * + For a Linux instance: returns a user name and secret (RSA private key) for use with an SSH client. You must save the secret to a `.pem` file. If you're using the CLI, see the example [ Get credentials for a Linux instance](https://docs.aws.amazon.com/gamelift/latest/apireference/API_GetInstanceAccess.html#API_GetInstanceAccess_Examples) for tips on automatically saving the secret to a `.pem` file.
     *
     * **Learn more**
     *
     * [Remotely connect to fleet instances](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-remote-access.html)
     *
     * [Debug fleet issues](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html)
     *
     * **Related actions**
     *
     * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
     */
    public suspend fun getInstanceAccess(input: GetInstanceAccessRequest): GetInstanceAccessResponse

    /**
     * Retrieves all aliases for this Amazon Web Services account. You can filter the result set by alias name and/or routing strategy type. Use the pagination parameters to retrieve results in sequential pages.
     *
     * Returned aliases are not listed in any particular order.
     *
     * **Related actions**
     *
     * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
     */
    public suspend fun listAliases(input: ListAliasesRequest = ListAliasesRequest { }): ListAliasesResponse

    /**
     * Retrieves build resources for all builds associated with the Amazon Web Services account in use. You can limit results to builds that are in a specific status by using the `Status` parameter. Use the pagination parameters to retrieve results in a set of sequential pages.
     *
     * Build resources are not listed in any particular order.
     *
     * **Learn more**
     *
     * [ Upload a Custom Server Build](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html)
     *
     * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
     */
    public suspend fun listBuilds(input: ListBuildsRequest = ListBuildsRequest { }): ListBuildsResponse

    /**
     * Retrieves information on the compute resources in an Amazon GameLift Servers fleet. Use the pagination parameters to retrieve results in a set of sequential pages.
     *
     * **Request options**
     * + Retrieve a list of all computes in a fleet. Specify a fleet ID.
     * + Retrieve a list of all computes in a specific fleet location. Specify a fleet ID and location.
     *
     * **Results**
     *
     * If successful, this operation returns information on a set of computes. Depending on the type of fleet, the result includes the following information:
     * + For a managed EC2 fleet (compute type `EC2`), this operation returns information about the EC2 instance. Compute names are EC2 instance IDs.
     * + For an Anywhere fleet (compute type `ANYWHERE`), this operation returns compute names and details from when the compute was registered with `RegisterCompute`. This includes `GameLiftServiceSdkEndpoint` or `GameLiftAgentEndpoint`.
     */
    public suspend fun listCompute(input: ListComputeRequest): ListComputeResponse

    /**
     * Retrieves a collection of container fleet resources in an Amazon Web Services Region. For fleets that have multiple locations, this operation retrieves fleets based on their home Region only.
     *
     * **Request options**
     * + Get a list of all fleets. Call this operation without specifying a container group definition.
     * + Get a list of fleets filtered by container group definition. Provide the container group definition name or ARN value.
     * + To get a list of all Amazon GameLift Servers Realtime fleets with a specific configuration script, provide the script ID.
     *
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     *
     * If successful, this operation returns a collection of container fleets that match the request parameters. A NextToken value is also returned if there are more result pages to retrieve.
     *
     * Fleet IDs are returned in no particular order.
     */
    public suspend fun listContainerFleets(input: ListContainerFleetsRequest = ListContainerFleetsRequest { }): ListContainerFleetsResponse

    /**
     * Retrieves all versions of a container group definition. Use the pagination parameters to retrieve results in a set of sequential pages.
     *
     * **Request options:**
     * + Get all versions of a specified container group definition. Specify the container group definition name or ARN value. (If the ARN value has a version number, it's ignored.)
     *
     * **Results:**
     *
     * If successful, this operation returns the complete properties of a set of container group definition versions that match the request.
     *
     * This operation returns the list of container group definitions in descending version order (latest first).
     *
     * **Learn more**
     * + [Manage a container group definition](https://docs.aws.amazon.com/gamelift/latest/developerguide/containers-create-groups.html)
     */
    public suspend fun listContainerGroupDefinitionVersions(input: ListContainerGroupDefinitionVersionsRequest): ListContainerGroupDefinitionVersionsResponse

    /**
     * Retrieves container group definitions for the Amazon Web Services account and Amazon Web Services Region. Use the pagination parameters to retrieve results in a set of sequential pages.
     *
     * This operation returns only the latest version of each definition. To retrieve all versions of a container group definition, use [ListContainerGroupDefinitionVersions](https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListContainerGroupDefinitionVersions.html).
     *
     * **Request options:**
     * + Retrieve the most recent versions of all container group definitions.
     * + Retrieve the most recent versions of all container group definitions, filtered by type. Specify the container group type to filter on.
     *
     * **Results:**
     *
     * If successful, this operation returns the complete properties of a set of container group definition versions that match the request.
     *
     * This operation returns the list of container group definitions in no particular order.
     */
    public suspend fun listContainerGroupDefinitions(input: ListContainerGroupDefinitionsRequest = ListContainerGroupDefinitionsRequest { }): ListContainerGroupDefinitionsResponse

    /**
     * Retrieves a collection of container fleet deployments in an Amazon Web Services Region. Use the pagination parameters to retrieve results as a set of sequential pages.
     *
     * **Request options**
     * + Get a list of all deployments. Call this operation without specifying a fleet ID.
     * + Get a list of all deployments for a fleet. Specify the container fleet ID or ARN value.
     *
     * **Results**
     *
     * If successful, this operation returns a list of deployments that match the request parameters. A NextToken value is also returned if there are more result pages to retrieve.
     *
     * Deployments are returned starting with the latest.
     */
    public suspend fun listFleetDeployments(input: ListFleetDeploymentsRequest = ListFleetDeploymentsRequest { }): ListFleetDeploymentsResponse

    /**
     * Retrieves a collection of fleet resources in an Amazon Web Services Region. You can filter the result set to find only those fleets that are deployed with a specific build or script. For fleets that have multiple locations, this operation retrieves fleets based on their home Region only.
     *
     * You can use operation in the following ways:
     * + To get a list of all fleets in a Region, don't provide a build or script identifier.
     * + To get a list of all fleets where a specific game build is deployed, provide the build ID.
     * + To get a list of all Amazon GameLift Servers Realtime fleets with a specific configuration script, provide the script ID.
     *
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     *
     * If successful, this operation returns a list of fleet IDs that match the request parameters. A NextToken value is also returned if there are more result pages to retrieve.
     *
     * Fleet IDs are returned in no particular order.
     */
    public suspend fun listFleets(input: ListFleetsRequest = ListFleetsRequest { }): ListFleetsResponse

    /**
     * Lists a game server groups.
     */
    public suspend fun listGameServerGroups(input: ListGameServerGroupsRequest = ListGameServerGroupsRequest { }): ListGameServerGroupsResponse

    /**
     * **This operation is used with the Amazon GameLift Servers FleetIQ solution and game server groups.**
     *
     * Retrieves information on all game servers that are currently active in a specified game server group. You can opt to sort the list by game server age. Use the pagination parameters to retrieve results in a set of sequential segments.
     *
     * **Learn more**
     *
     * [Amazon GameLift Servers FleetIQ Guide](https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
     */
    public suspend fun listGameServers(input: ListGameServersRequest): ListGameServersResponse

    /**
     * Lists all custom and Amazon Web Services locations where Amazon GameLift Servers can host game servers.
     *
     * Note that if you call this API using a location that doesn't have a service endpoint, such as one that can only be a remote location in a multi-location fleet, the API returns an error.
     *
     * Consult the table of supported locations in [Amazon GameLift Servers service locations](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html) to identify home Regions that support single and multi-location fleets.
     *
     * **Learn more**
     *
     * [Service locations](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html)
     */
    public suspend fun listLocations(input: ListLocationsRequest = ListLocationsRequest { }): ListLocationsResponse

    /**
     * Retrieves script records for all Realtime scripts that are associated with the Amazon Web Services account in use.
     *
     * **Learn more**
     *
     * [Amazon GameLift Servers Amazon GameLift Servers Realtime](https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html)
     *
     * **Related actions**
     *
     * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
     */
    public suspend fun listScripts(input: ListScriptsRequest = ListScriptsRequest { }): ListScriptsResponse

    /**
     * Retrieves all tags assigned to a Amazon GameLift Servers resource. Use resource tags to organize Amazon Web Services resources for a range of purposes. This operation handles the permissions necessary to manage tags for Amazon GameLift Servers resources that support tagging.
     *
     * To list tags for a resource, specify the unique ARN value for the resource.
     *
     * **Learn more**
     *
     * [Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference*
     *
     * [ Amazon Web Services Tagging Strategies](http://aws.amazon.com/answers/account-management/aws-tagging-strategies/)
     *
     * **Related actions**
     *
     * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Creates or updates a scaling policy for a fleet. Scaling policies are used to automatically scale a fleet's hosting capacity to meet player demand. An active scaling policy instructs Amazon GameLift Servers to track a fleet metric and automatically change the fleet's capacity when a certain threshold is reached. There are two types of scaling policies: target-based and rule-based. Use a target-based policy to quickly and efficiently manage fleet scaling; this option is the most commonly used. Use rule-based policies when you need to exert fine-grained control over auto-scaling.
     *
     * Fleets can have multiple scaling policies of each type in force at the same time; you can have one target-based policy, one or multiple rule-based scaling policies, or both. We recommend caution, however, because multiple auto-scaling policies can have unintended consequences.
     *
     * Learn more about how to work with auto-scaling in [Set Up Fleet Automatic Scaling](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-autoscaling.html).
     *
     * **Target-based policy**
     *
     * A target-based policy tracks a single metric: PercentAvailableGameSessions. This metric tells us how much of a fleet's hosting capacity is ready to host game sessions but is not currently in use. This is the fleet's buffer; it measures the additional player demand that the fleet could handle at current capacity. With a target-based policy, you set your ideal buffer size and leave it to Amazon GameLift Servers to take whatever action is needed to maintain that target.
     *
     * For example, you might choose to maintain a 10% buffer for a fleet that has the capacity to host 100 simultaneous game sessions. This policy tells Amazon GameLift Servers to take action whenever the fleet's available capacity falls below or rises above 10 game sessions. Amazon GameLift Servers will start new instances or stop unused instances in order to return to the 10% buffer.
     *
     * To create or update a target-based policy, specify a fleet ID and name, and set the policy type to "TargetBased". Specify the metric to track (PercentAvailableGameSessions) and reference a `TargetConfiguration` object with your desired buffer value. Exclude all other parameters. On a successful request, the policy name is returned. The scaling policy is automatically in force as soon as it's successfully created. If the fleet's auto-scaling actions are temporarily suspended, the new policy will be in force once the fleet actions are restarted.
     *
     * **Rule-based policy**
     *
     * A rule-based policy tracks specified fleet metric, sets a threshold value, and specifies the type of action to initiate when triggered. With a rule-based policy, you can select from several available fleet metrics. Each policy specifies whether to scale up or scale down (and by how much), so you need one policy for each type of action.
     *
     * For example, a policy may make the following statement: "If the percentage of idle instances is greater than 20% for more than 15 minutes, then reduce the fleet capacity by 10%."
     *
     * A policy's rule statement has the following structure:
     *
     * If `[MetricName]` is `[ComparisonOperator]``[Threshold]` for `[EvaluationPeriods]` minutes, then `[ScalingAdjustmentType]` to/by `[ScalingAdjustment]`.
     *
     * To implement the example, the rule statement would look like this:
     *
     * If `[PercentIdleInstances]` is `[GreaterThanThreshold]``[20]` for `[15]` minutes, then `[PercentChangeInCapacity]` to/by `[10]`.
     *
     * To create or update a scaling policy, specify a unique combination of name and fleet ID, and set the policy type to "RuleBased". Specify the parameter values for a policy rule statement. On a successful request, the policy name is returned. Scaling policies are automatically in force as soon as they're successfully created. If the fleet's auto-scaling actions are temporarily suspended, the new policy will be in force once the fleet actions are restarted.
     */
    public suspend fun putScalingPolicy(input: PutScalingPolicyRequest): PutScalingPolicyResponse

    /**
     * Registers a compute resource in an Amazon GameLift Servers Anywhere fleet.
     *
     * For an Anywhere fleet that's running the Amazon GameLift Servers Agent, the Agent handles all compute registry tasks for you. For an Anywhere fleet that doesn't use the Agent, call this operation to register fleet computes.
     *
     * To register a compute, give the compute a name (must be unique within the fleet) and specify the compute resource's DNS name or IP address. Provide a fleet ID and a fleet location to associate with the compute being registered. You can optionally include the path to a TLS certificate on the compute resource.
     *
     * If successful, this operation returns compute details, including an Amazon GameLift Servers SDK endpoint or Agent endpoint. Game server processes running on the compute can use this endpoint to communicate with the Amazon GameLift Servers service. Each server process includes the SDK endpoint in its call to the Amazon GameLift Servers server SDK action `InitSDK()`.
     *
     * To view compute details, call [DescribeCompute](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeCompute.html) with the compute name.
     *
     * **Learn more**
     * + [Create an Anywhere fleet](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-anywhere.html)
     * + [Test your integration](https://docs.aws.amazon.com/gamelift/latest/developerguide/integration-testing.html)
     * + [Server SDK reference guides](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk.html) (for version 5.x)
     */
    public suspend fun registerCompute(input: RegisterComputeRequest): RegisterComputeResponse

    /**
     * **This operation is used with the Amazon GameLift Servers FleetIQ solution and game server groups.**
     *
     * Creates a new game server resource and notifies Amazon GameLift Servers FleetIQ that the game server is ready to host gameplay and players. This operation is called by a game server process that is running on an instance in a game server group. Registering game servers enables Amazon GameLift Servers FleetIQ to track available game servers and enables game clients and services to claim a game server for a new game session.
     *
     * To register a game server, identify the game server group and instance where the game server is running, and provide a unique identifier for the game server. You can also include connection and game server data.
     *
     * Once a game server is successfully registered, it is put in status `AVAILABLE`. A request to register a game server may fail if the instance it is running on is in the process of shutting down as part of instance balancing or scale-down activity.
     *
     * **Learn more**
     *
     * [Amazon GameLift Servers FleetIQ Guide](https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
     */
    public suspend fun registerGameServer(input: RegisterGameServerRequest): RegisterGameServerResponse

    /**
     * Retrieves a fresh set of credentials for use when uploading a new set of game build files to Amazon GameLift Servers's Amazon S3. This is done as part of the build creation process; see [CreateBuild](https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateBuild.html).
     *
     * To request new credentials, specify the build ID as returned with an initial `CreateBuild` request. If successful, a new set of credentials are returned, along with the S3 storage location associated with the build ID.
     *
     * **Learn more**
     *
     * [ Create a Build with Files in S3](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-cli-uploading.html#gamelift-build-cli-uploading-create-build)
     *
     * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
     */
    public suspend fun requestUploadCredentials(input: RequestUploadCredentialsRequest): RequestUploadCredentialsResponse

    /**
     * Attempts to retrieve a fleet ID that is associated with an alias. Specify a unique alias identifier.
     *
     * If the alias has a `SIMPLE` routing strategy, Amazon GameLift Servers returns a fleet ID. If the alias has a `TERMINAL` routing strategy, the result is a `TerminalRoutingStrategyException`.
     *
     * **Related actions**
     *
     * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
     */
    public suspend fun resolveAlias(input: ResolveAliasRequest): ResolveAliasResponse

    /**
     * **This operation is used with the Amazon GameLift Servers FleetIQ solution and game server groups.**
     *
     * Reinstates activity on a game server group after it has been suspended. A game server group might be suspended by the [SuspendGameServerGroup](gamelift/latest/apireference/API_SuspendGameServerGroup.html) operation, or it might be suspended involuntarily due to a configuration problem. In the second case, you can manually resume activity on the group once the configuration problem has been resolved. Refer to the game server group status and status reason for more information on why group activity is suspended.
     *
     * To resume activity, specify a game server group ARN and the type of activity to be resumed. If successful, a `GameServerGroup` object is returned showing that the resumed activity is no longer listed in `SuspendedActions`.
     *
     * **Learn more**
     *
     * [Amazon GameLift Servers FleetIQ Guide](https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
     */
    public suspend fun resumeGameServerGroup(input: ResumeGameServerGroupRequest): ResumeGameServerGroupResponse

    /**
     * Retrieves all active game sessions that match a set of search criteria and sorts them into a specified order.
     *
     * This operation is not designed to continually track game session status because that practice can cause you to exceed your API limit and generate errors. Instead, configure an Amazon Simple Notification Service (Amazon SNS) topic to receive notifications from a matchmaker or a game session placement queue.
     *
     * When searching for game sessions, you specify exactly where you want to search and provide a search filter expression, a sort expression, or both. A search request can search only one fleet, but it can search all of a fleet's locations.
     *
     * This operation can be used in the following ways:
     * + To search all game sessions that are currently running on all locations in a fleet, provide a fleet or alias ID. This approach returns game sessions in the fleet's home Region and all remote locations that fit the search criteria.
     * + To search all game sessions that are currently running on a specific fleet location, provide a fleet or alias ID and a location name. For location, you can specify a fleet's home Region or any remote location.
     *
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     *
     * If successful, a `GameSession` object is returned for each game session that matches the request. Search finds game sessions that are in `ACTIVE` status only. To retrieve information on game sessions in other statuses, use [DescribeGameSessions](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameSessions.html).
     *
     * To set search and sort criteria, create a filter expression using the following game session attributes. For game session search examples, see the Examples section of this topic.
     * + **gameSessionId** -- A unique identifier for the game session. You can use either a `GameSessionId` or `GameSessionArn` value.
     * + **gameSessionName** -- Name assigned to a game session. Game session names do not need to be unique to a game session.
     * + **gameSessionProperties** -- A set of key-value pairs that can store custom data in a game session. For example: `{"Key": "difficulty", "Value": "novice"}`. The filter expression must specify the [https://docs.aws.amazon.com/gamelift/latest/apireference/API_GameProperty](https://docs.aws.amazon.com/gamelift/latest/apireference/API_GameProperty) -- a `Key` and a string `Value` to search for the game sessions.For example, to search for the above key-value pair, specify the following search filter: `gameSessionProperties.difficulty = "novice"`. All game property values are searched as strings. For examples of searching game sessions, see the ones below, and also see [Search game sessions by game property](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#game-properties-search).
     * + **maximumSessions** -- Maximum number of player sessions allowed for a game session.
     * + **creationTimeMillis** -- Value indicating when a game session was created. It is expressed in Unix time as milliseconds.
     * + **playerSessionCount** -- Number of players currently connected to a game session. This value changes rapidly as players join the session or drop out.
     * + **hasAvailablePlayerSessions** -- Boolean value indicating whether a game session has reached its maximum number of players. It is highly recommended that all search requests include this filter attribute to optimize search performance and return only sessions that players can join.
     *
     * Returned values for `playerSessionCount` and `hasAvailablePlayerSessions` change quickly as players join sessions and others drop out. Results should be considered a snapshot in time. Be sure to refresh search results often, and handle sessions that fill up before a player can join.
     *
     * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
     */
    public suspend fun searchGameSessions(input: SearchGameSessionsRequest = SearchGameSessionsRequest { }): SearchGameSessionsResponse

    /**
     * Resumes certain types of activity on fleet instances that were suspended with [StopFleetActions](https://docs.aws.amazon.com/gamelift/latest/apireference/API_StopFleetActions.html). For multi-location fleets, fleet actions are managed separately for each location. Currently, this operation is used to restart a fleet's auto-scaling activity.
     *
     * This operation can be used in the following ways:
     * + To restart actions on instances in the fleet's home Region, provide a fleet ID and the type of actions to resume.
     * + To restart actions on instances in one of the fleet's remote locations, provide a fleet ID, a location name, and the type of actions to resume.
     *
     * If successful, Amazon GameLift Servers once again initiates scaling events as triggered by the fleet's scaling policies. If actions on the fleet location were never stopped, this operation will have no effect.
     *
     * **Learn more**
     *
     * [Setting up Amazon GameLift Servers fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
     */
    public suspend fun startFleetActions(input: StartFleetActionsRequest): StartFleetActionsResponse

    /**
     * Makes a request to start a new game session using a game session queue. When processing a placement request, Amazon GameLift Servers looks for the best possible available resource to host the game session, based on how the queue is configured to prioritize factors such as resource cost, latency, and location. After selecting an available resource, Amazon GameLift Servers prompts the resource to start a game session. A placement request can include a list of players to create a set of player sessions. The request can also include information to pass to the new game session, such as to specify a game map or other options.
     *
     * **Request options**
     *
     * Use this operation to make the following types of requests.
     * + Request a placement using the queue's default prioritization process (see the default prioritization described in [PriorityConfiguration](https://docs.aws.amazon.com/gamelift/latest/apireference/API_PriorityConfiguration.html)). Include these required parameters:
     *    + `GameSessionQueueName`
     *    + `MaximumPlayerSessionCount`
     *    + `PlacementID`
     * + Request a placement and prioritize based on latency. Include these parameters:
     *    + Required parameters `GameSessionQueueName`, `MaximumPlayerSessionCount`, `PlacementID`.
     *    + `PlayerLatencies`. Include a set of latency values for destinations in the queue. When a request includes latency data, Amazon GameLift Servers automatically reorder the queue's locations priority list based on lowest available latency values. If a request includes latency data for multiple players, Amazon GameLift Servers calculates each location's average latency for all players and reorders to find the lowest latency across all players.
     *    + Don't include `PriorityConfigurationOverride`.
     *    + Prioritize based on a custom list of locations. If you're using a queue that's configured to prioritize location first (see [PriorityConfiguration](https://docs.aws.amazon.com/gamelift/latest/apireference/API_PriorityConfiguration.html) for game session queues), you can optionally use the *PriorityConfigurationOverride* parameter to substitute a different location priority list for this placement request. Amazon GameLift Servers searches each location on the priority override list to find an available hosting resource for the new game session. Specify a fallback strategy to use in the event that Amazon GameLift Servers fails to place the game session in any of the locations on the override list.
     * + Request a placement and prioritized based on a custom list of locations.
     * + You can request new player sessions for a group of players. Include the *DesiredPlayerSessions* parameter and include at minimum a unique player ID for each. You can also include player-specific data to pass to the new game session.
     *
     * **Result**
     *
     * If successful, this operation generates a new game session placement request and adds it to the game session queue for processing. You can track the status of individual placement requests by calling [DescribeGameSessionPlacement](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameSessionPlacement.html) or by monitoring queue notifications. When the request status is `FULFILLED`, a new game session has started and the placement request is updated with connection information for the game session (IP address and port). If the request included player session data, Amazon GameLift Servers creates a player session for each player ID in the request.
     *
     * The request results in a `InvalidRequestException` in the following situations:
     * + If the request includes both *PlayerLatencies* and *PriorityConfigurationOverride* parameters.
     * + If the request includes the *PriorityConfigurationOverride* parameter and specifies a queue that doesn't prioritize locations.
     *
     * Amazon GameLift Servers continues to retry each placement request until it reaches the queue's timeout setting. If a request times out, you can resubmit the request to the same queue or try a different queue.
     */
    public suspend fun startGameSessionPlacement(input: StartGameSessionPlacementRequest): StartGameSessionPlacementResponse

    /**
     * Finds new players to fill open slots in currently running game sessions. The backfill match process is essentially identical to the process of forming new matches. Backfill requests use the same matchmaker that was used to make the original match, and they provide matchmaking data for all players currently in the game session. FlexMatch uses this information to select new players so that backfilled match continues to meet the original match requirements.
     *
     * When using FlexMatch with Amazon GameLift Servers managed hosting, you can request a backfill match from a client service by calling this operation with a `GameSessions` ID. You also have the option of making backfill requests directly from your game server. In response to a request, FlexMatch creates player sessions for the new players, updates the `GameSession` resource, and sends updated matchmaking data to the game server. You can request a backfill match at any point after a game session is started. Each game session can have only one active backfill request at a time; a subsequent request automatically replaces the earlier request.
     *
     * When using FlexMatch as a standalone component, request a backfill match by calling this operation without a game session identifier. As with newly formed matches, matchmaking results are returned in a matchmaking event so that your game can update the game session that is being backfilled.
     *
     * To request a backfill match, specify a unique ticket ID, the original matchmaking configuration, and matchmaking data for all current players in the game session being backfilled. Optionally, specify the `GameSession` ARN. If successful, a match backfill ticket is created and returned with status set to QUEUED. Track the status of backfill tickets using the same method for tracking tickets for new matches.
     *
     * Only game sessions created by FlexMatch are supported for match backfill.
     *
     * **Learn more**
     *
     * [ Backfill existing games with FlexMatch](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-backfill.html)
     *
     * [ Matchmaking events](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html) (reference)
     *
     * [ How Amazon GameLift Servers FlexMatch works](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/gamelift-match.html)
     */
    public suspend fun startMatchBackfill(input: StartMatchBackfillRequest): StartMatchBackfillResponse

    /**
     * Uses FlexMatch to create a game match for a group of players based on custom matchmaking rules. With games that use Amazon GameLift Servers managed hosting, this operation also triggers Amazon GameLift Servers to find hosting resources and start a new game session for the new match. Each matchmaking request includes information on one or more players and specifies the FlexMatch matchmaker to use. When a request is for multiple players, FlexMatch attempts to build a match that includes all players in the request, placing them in the same team and finding additional players as needed to fill the match.
     *
     * To start matchmaking, provide a unique ticket ID, specify a matchmaking configuration, and include the players to be matched. You must also include any player attributes that are required by the matchmaking configuration's rule set. If successful, a matchmaking ticket is returned with status set to `QUEUED`.
     *
     * Track matchmaking events to respond as needed and acquire game session connection information for successfully completed matches. Ticket status updates are tracked using event notification through Amazon Simple Notification Service, which is defined in the matchmaking configuration.
     *
     * **Learn more**
     *
     * [ Add FlexMatch to a game client](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-client.html)
     *
     * [ Set Up FlexMatch event notification](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html)
     *
     * [ How Amazon GameLift Servers FlexMatch works](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/gamelift-match.html)
     */
    public suspend fun startMatchmaking(input: StartMatchmakingRequest): StartMatchmakingResponse

    /**
     * Suspends certain types of activity in a fleet location. Currently, this operation is used to stop auto-scaling activity. For multi-location fleets, fleet actions are managed separately for each location.
     *
     * Stopping fleet actions has several potential purposes. It allows you to temporarily stop auto-scaling activity but retain your scaling policies for use in the future. For multi-location fleets, you can set up fleet-wide auto-scaling, and then opt out of it for certain locations.
     *
     * This operation can be used in the following ways:
     * + To stop actions on instances in the fleet's home Region, provide a fleet ID and the type of actions to suspend.
     * + To stop actions on instances in one of the fleet's remote locations, provide a fleet ID, a location name, and the type of actions to suspend.
     *
     * If successful, Amazon GameLift Servers no longer initiates scaling events except in response to manual changes using [UpdateFleetCapacity](https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateFleetCapacity.html). To restart fleet actions again, call [StartFleetActions](https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartFleetActions.html).
     *
     * **Learn more**
     *
     * [Setting up Amazon GameLift Servers Fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
     */
    public suspend fun stopFleetActions(input: StopFleetActionsRequest): StopFleetActionsResponse

    /**
     * Cancels a game session placement that's in `PENDING` status. To stop a placement, provide the placement ID value.
     *
     * Results
     *
     * If successful, this operation removes the placement request from the queue and moves the `GameSessionPlacement` to `CANCELLED` status.
     *
     * This operation results in an `InvalidRequestExecption` (400) error if a game session has already been created for this placement. You can clean up an unneeded game session by calling [TerminateGameSession](https://docs.aws.amazon.com/gamelift/latest/apireference/API_TerminateGameSession).
     */
    public suspend fun stopGameSessionPlacement(input: StopGameSessionPlacementRequest): StopGameSessionPlacementResponse

    /**
     * Cancels a matchmaking ticket or match backfill ticket that is currently being processed. To stop the matchmaking operation, specify the ticket ID. If successful, work on the ticket is stopped, and the ticket status is changed to `CANCELLED`.
     *
     * This call is also used to turn off automatic backfill for an individual game session. This is for game sessions that are created with a matchmaking configuration that has automatic backfill enabled. The ticket ID is included in the `MatchmakerData` of an updated game session object, which is provided to the game server.
     *
     * If the operation is successful, the service sends back an empty JSON struct with the HTTP 200 response (not an empty HTTP body).
     *
     * **Learn more**
     *
     * [ Add FlexMatch to a game client](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-client.html)
     */
    public suspend fun stopMatchmaking(input: StopMatchmakingRequest): StopMatchmakingResponse

    /**
     * **This operation is used with the Amazon GameLift Servers FleetIQ solution and game server groups.**
     *
     * Temporarily stops activity on a game server group without terminating instances or the game server group. You can restart activity by calling [ResumeGameServerGroup](gamelift/latest/apireference/API_ResumeGameServerGroup.html). You can suspend the following activity:
     * + **Instance type replacement** - This activity evaluates the current game hosting viability of all Spot instance types that are defined for the game server group. It updates the Auto Scaling group to remove nonviable Spot Instance types, which have a higher chance of game server interruptions. It then balances capacity across the remaining viable Spot Instance types. When this activity is suspended, the Auto Scaling group continues with its current balance, regardless of viability. Instance protection, utilization metrics, and capacity scaling activities continue to be active.
     *
     * To suspend activity, specify a game server group ARN and the type of activity to be suspended. If successful, a `GameServerGroup` object is returned showing that the activity is listed in `SuspendedActions`.
     *
     * **Learn more**
     *
     * [Amazon GameLift Servers FleetIQ Guide](https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
     */
    public suspend fun suspendGameServerGroup(input: SuspendGameServerGroupRequest): SuspendGameServerGroupResponse

    /**
     * Assigns a tag to an Amazon GameLift Servers resource. You can use tags to organize resources, create IAM permissions policies to manage access to groups of resources, customize Amazon Web Services cost breakdowns, and more. This operation handles the permissions necessary to manage tags for Amazon GameLift Servers resources that support tagging.
     *
     * To add a tag to a resource, specify the unique ARN value for the resource and provide a tag list containing one or more tags. The operation succeeds even if the list includes tags that are already assigned to the resource.
     *
     * **Learn more**
     *
     * [Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference*
     *
     * [ Amazon Web Services Tagging Strategies](http://aws.amazon.com/answers/account-management/aws-tagging-strategies/)
     *
     * **Related actions**
     *
     * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Ends a game session that's currently in progress. Use this action to terminate any game session that isn't in `ERROR` status. Terminating a game session is the most efficient way to free up a server process when it's hosting a game session that's in a bad state or not ending properly. You can use this action to terminate a game session that's being hosted on any type of Amazon GameLift Servers fleet compute, including computes for managed EC2, managed container, and Anywhere fleets. The game server must be integrated with Amazon GameLift Servers server SDK 5.x or greater.
     *
     * **Request options**
     *
     * Request termination for a single game session. Provide the game session ID and the termination mode. There are two potential methods for terminating a game session:
     * + Initiate a graceful termination using the normal game session shutdown sequence. With this mode, the Amazon GameLift Servers service prompts the server process that's hosting the game session by calling the server SDK callback method `OnProcessTerminate()`. The callback implementation is part of the custom game server code. It might involve a variety of actions to gracefully end a game session, such as notifying players, before stopping the server process.
     * + Force an immediate game session termination. With this mode, the Amazon GameLift Servers service takes action to stop the server process, which ends the game session without the normal game session shutdown sequence.
     *
     * **Results**
     *
     * If successful, game session termination is initiated. During this activity, the game session status is changed to `TERMINATING`. When completed, the server process that was hosting the game session has been stopped and replaced with a new server process that's ready to host a new game session. The old game session's status is changed to `TERMINATED` with a status reason that indicates the termination method used.
     *
     * **Learn more**
     *
     * [Add Amazon GameLift Servers to your game server](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html)
     *
     * Amazon GameLift Servers server SDK 5 reference guide for `OnProcessTerminate()` ([C++](https://docs.aws.amazon.com/gamelift/latest/developerguide/integration-server-sdk5-cpp-initsdk.html)) ([C#](https://docs.aws.amazon.com/gamelift/latest/developerguide/integration-server-sdk5-csharp-initsdk.html)) ([Unreal](https://docs.aws.amazon.com/gamelift/latest/developerguide/integration-server-sdk5-unreal-initsdk.html)) ([Go](https://docs.aws.amazon.com/gamelift/latest/developerguide/integration-server-sdk-go-initsdk.html))
     */
    public suspend fun terminateGameSession(input: TerminateGameSessionRequest): TerminateGameSessionResponse

    /**
     * Removes a tag assigned to a Amazon GameLift Servers resource. You can use resource tags to organize Amazon Web Services resources for a range of purposes. This operation handles the permissions necessary to manage tags for Amazon GameLift Servers resources that support tagging.
     *
     * To remove a tag from a resource, specify the unique ARN value for the resource and provide a string list containing one or more tags to remove. This operation succeeds even if the list includes tags that aren't assigned to the resource.
     *
     * **Learn more**
     *
     * [Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference*
     *
     * [ Amazon Web Services Tagging Strategies](http://aws.amazon.com/answers/account-management/aws-tagging-strategies/)
     *
     * **Related actions**
     *
     * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates properties for an alias. Specify the unique identifier of the alias to be updated and the new property values. When reassigning an alias to a new fleet, provide an updated routing strategy. If successful, the updated alias record is returned.
     *
     * **Related actions**
     *
     * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
     */
    public suspend fun updateAlias(input: UpdateAliasRequest): UpdateAliasResponse

    /**
     * Updates metadata in a build resource, including the build name and version. To update the metadata, specify the build ID to update and provide the new values. If successful, a build object containing the updated metadata is returned.
     *
     * **Learn more**
     *
     * [ Upload a Custom Server Build](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html)
     *
     * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
     */
    public suspend fun updateBuild(input: UpdateBuildRequest): UpdateBuildResponse

    /**
     * Updates the properties of a managed container fleet. Depending on the properties being updated, this operation might initiate a fleet deployment. You can track deployments for a fleet using [https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetDeployment.html](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetDeployment.html).
     *
     * **Request options**
     *
     * As with CreateContainerFleet, many fleet properties use common defaults or are calculated based on the fleet's container group definitions.
     * + Update fleet properties that result in a fleet deployment. Include only those properties that you want to change. Specify deployment configuration settings.
     * + Update fleet properties that don't result in a fleet deployment. Include only those properties that you want to change.
     *
     * Changes to the following properties initiate a fleet deployment:
     * + `GameServerContainerGroupDefinition`
     * + `PerInstanceContainerGroupDefinition`
     * + `GameServerContainerGroupsPerInstance`
     * + `InstanceInboundPermissions`
     * + `InstanceConnectionPortRange`
     * + `LogConfiguration`
     *
     * **Results**
     *
     * If successful, this operation updates the container fleet resource, and might initiate a new deployment of fleet resources using the deployment configuration provided. A deployment replaces existing fleet instances with new instances that are deployed with the updated fleet properties. The fleet is placed in `UPDATING` status until the deployment is complete, then return to `ACTIVE`.
     *
     * You can have only one update deployment active at a time for a fleet. If a second update request initiates a deployment while another deployment is in progress, the first deployment is cancelled.
     */
    public suspend fun updateContainerFleet(input: UpdateContainerFleetRequest): UpdateContainerFleetResponse

    /**
     * Updates properties in an existing container group definition. This operation doesn't replace the definition. Instead, it creates a new version of the definition and saves it separately. You can access all versions that you choose to retain.
     *
     * The only property you can't update is the container group type.
     *
     * **Request options:**
     * + Update based on the latest version of the container group definition. Specify the container group definition name only, or use an ARN value without a version number. Provide updated values for the properties that you want to change only. All other values remain the same as the latest version.
     * + Update based on a specific version of the container group definition. Specify the container group definition name and a source version number, or use an ARN value with a version number. Provide updated values for the properties that you want to change only. All other values remain the same as the source version.
     * + Change a game server container definition. Provide the updated container definition.
     * + Add or change a support container definition. Provide a complete set of container definitions, including the updated definition.
     * + Remove a support container definition. Provide a complete set of container definitions, excluding the definition to remove. If the container group has only one support container definition, provide an empty set.
     *
     * **Results:**
     *
     * If successful, this operation returns the complete properties of the new container group definition version.
     *
     * If the container group definition version is used in an active fleets, the update automatically initiates a new fleet deployment of the new version. You can track a fleet's deployments using [ListFleetDeployments](https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListFleetDeployments.html).
     */
    public suspend fun updateContainerGroupDefinition(input: UpdateContainerGroupDefinitionRequest): UpdateContainerGroupDefinitionResponse

    /**
     * Updates a fleet's mutable attributes, such as game session protection and resource creation limits.
     *
     * To update fleet attributes, specify the fleet ID and the property values that you want to change. If successful, Amazon GameLift Servers returns the identifiers for the updated fleet.
     *
     * **Learn more**
     *
     * [Setting up Amazon GameLift Servers fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
     */
    public suspend fun updateFleetAttributes(input: UpdateFleetAttributesRequest): UpdateFleetAttributesResponse

    /**
     * Updates capacity settings for a managed EC2 fleet or managed container fleet. For these fleets, you adjust capacity by changing the number of instances in the fleet. Fleet capacity determines the number of game sessions and players that the fleet can host based on its configuration. For fleets with multiple locations, use this operation to manage capacity settings in each location individually.
     *
     * Use this operation to set these fleet capacity properties:
     * + Minimum/maximum size: Set hard limits on the number of Amazon EC2 instances allowed. If Amazon GameLift Servers receives a request--either through manual update or automatic scaling--it won't change the capacity to a value outside of this range.
     * + Desired capacity: As an alternative to automatic scaling, manually set the number of Amazon EC2 instances to be maintained. Before changing a fleet's desired capacity, check the maximum capacity of the fleet's Amazon EC2 instance type by calling [DescribeEC2InstanceLimits](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeEC2InstanceLimits.html).
     *
     * To update capacity for a fleet's home Region, or if the fleet has no remote locations, omit the `Location` parameter. The fleet must be in `ACTIVE` status.
     *
     * To update capacity for a fleet's remote location, set the `Location` parameter to the location to update. The location must be in `ACTIVE` status.
     *
     * If successful, Amazon GameLift Servers updates the capacity settings and returns the identifiers for the updated fleet and/or location. If a requested change to desired capacity exceeds the instance type's limit, the `LimitExceeded` exception occurs.
     *
     * Updates often prompt an immediate change in fleet capacity, such as when current capacity is different than the new desired capacity or outside the new limits. In this scenario, Amazon GameLift Servers automatically initiates steps to add or remove instances in the fleet location. You can track a fleet's current capacity by calling [DescribeFleetCapacity](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetCapacity.html) or [DescribeFleetLocationCapacity](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationCapacity.html).
     *
     * **Learn more**
     *
     * [Scaling fleet capacity](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-manage-capacity.html)
     */
    public suspend fun updateFleetCapacity(input: UpdateFleetCapacityRequest): UpdateFleetCapacityResponse

    /**
     * Updates permissions that allow inbound traffic to connect to game sessions in the fleet.
     *
     * To update settings, specify the fleet ID to be updated and specify the changes to be made. List the permissions you want to add in `InboundPermissionAuthorizations`, and permissions you want to remove in `InboundPermissionRevocations`. Permissions to be removed must match existing fleet permissions.
     *
     * If successful, the fleet ID for the updated fleet is returned. For fleets with remote locations, port setting updates can take time to propagate across all locations. You can check the status of updates in each location by calling `DescribeFleetPortSettings` with a location name.
     *
     * **Learn more**
     *
     * [Setting up Amazon GameLift Servers fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
     */
    public suspend fun updateFleetPortSettings(input: UpdateFleetPortSettingsRequest): UpdateFleetPortSettingsResponse

    /**
     * **This operation is used with the Amazon GameLift Servers FleetIQ solution and game server groups.**
     *
     * Updates information about a registered game server to help Amazon GameLift Servers FleetIQ track game server availability. This operation is called by a game server process that is running on an instance in a game server group.
     *
     * Use this operation to update the following types of game server information. You can make all three types of updates in the same request:
     * + To update the game server's utilization status from `AVAILABLE` (when the game server is available to be claimed) to `UTILIZED` (when the game server is currently hosting games). Identify the game server and game server group and specify the new utilization status. You can't change the status from to `UTILIZED` to `AVAILABLE` .
     * + To report health status, identify the game server and game server group and set health check to `HEALTHY`. If a game server does not report health status for a certain length of time, the game server is no longer considered healthy. As a result, it will be eventually deregistered from the game server group to avoid affecting utilization metrics. The best practice is to report health every 60 seconds.
     * + To change game server metadata, provide updated game server data.
     *
     * Once a game server is successfully updated, the relevant statuses and timestamps are updated.
     *
     * **Learn more**
     *
     * [Amazon GameLift Servers FleetIQ Guide](https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
     */
    public suspend fun updateGameServer(input: UpdateGameServerRequest): UpdateGameServerResponse

    /**
     * **This operation is used with the Amazon GameLift Servers FleetIQ solution and game server groups.**
     *
     * Updates Amazon GameLift Servers FleetIQ-specific properties for a game server group. Many Auto Scaling group properties are updated on the Auto Scaling group directly, including the launch template, Auto Scaling policies, and maximum/minimum/desired instance counts.
     *
     * To update the game server group, specify the game server group ID and provide the updated values. Before applying the updates, the new values are validated to ensure that Amazon GameLift Servers FleetIQ can continue to perform instance balancing activity. If successful, a `GameServerGroup` object is returned.
     *
     * **Learn more**
     *
     * [Amazon GameLift Servers FleetIQ Guide](https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
     */
    public suspend fun updateGameServerGroup(input: UpdateGameServerGroupRequest): UpdateGameServerGroupResponse

    /**
     * Updates the mutable properties of a game session.
     *
     * To update a game session, specify the game session ID and the values you want to change.
     *
     * If successful, the updated `GameSession` object is returned.
     *
     * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
     */
    public suspend fun updateGameSession(input: UpdateGameSessionRequest): UpdateGameSessionResponse

    /**
     * Updates the configuration of a game session queue, which determines how the queue processes new game session requests. To update settings, specify the queue name to be updated and provide the new settings. When updating destinations, provide a complete list of destinations.
     *
     * **Learn more**
     *
     * [ Using Multi-Region Queues](https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-intro.html)
     */
    public suspend fun updateGameSessionQueue(input: UpdateGameSessionQueueRequest): UpdateGameSessionQueueResponse

    /**
     * Updates settings for a FlexMatch matchmaking configuration. These changes affect all matches and game sessions that are created after the update. To update settings, specify the configuration name to be updated and provide the new settings.
     *
     * **Learn more**
     *
     * [ Design a FlexMatch matchmaker](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-configuration.html)
     */
    public suspend fun updateMatchmakingConfiguration(input: UpdateMatchmakingConfigurationRequest): UpdateMatchmakingConfigurationResponse

    /**
     * Updates the runtime configuration for the specified fleet. The runtime configuration tells Amazon GameLift Servers how to launch server processes on computes in managed EC2 and Anywhere fleets. You can update a fleet's runtime configuration at any time after the fleet is created; it does not need to be in `ACTIVE` status.
     *
     * To update runtime configuration, specify the fleet ID and provide a `RuntimeConfiguration` with an updated set of server process configurations.
     *
     * If successful, the fleet's runtime configuration settings are updated. Fleet computes that run game server processes regularly check for and receive updated runtime configurations. The computes immediately take action to comply with the new configuration by launching new server processes or by not replacing existing processes when they shut down. Updating a fleet's runtime configuration never affects existing server processes.
     *
     * **Learn more**
     *
     * [Setting up Amazon GameLift Servers fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
     */
    public suspend fun updateRuntimeConfiguration(input: UpdateRuntimeConfigurationRequest): UpdateRuntimeConfigurationResponse

    /**
     * Updates Realtime script metadata and content.
     *
     * To update script metadata, specify the script ID and provide updated name and/or version values.
     *
     * To update script content, provide an updated zip file by pointing to either a local file or an Amazon S3 bucket location. You can use either method regardless of how the original script was uploaded. Use the *Version* parameter to track updates to the script.
     *
     * If the call is successful, the updated metadata is stored in the script record and a revised script is uploaded to the Amazon GameLift Servers service. Once the script is updated and acquired by a fleet instance, the new version is used for all new game sessions.
     *
     * **Learn more**
     *
     * [Amazon GameLift Servers Amazon GameLift Servers Realtime](https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html)
     *
     * **Related actions**
     *
     * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
     */
    public suspend fun updateScript(input: UpdateScriptRequest): UpdateScriptResponse

    /**
     * Validates the syntax of a matchmaking rule or rule set. This operation checks that the rule set is using syntactically correct JSON and that it conforms to allowed property expressions. To validate syntax, provide a rule set JSON string.
     *
     * **Learn more**
     * + [Build a rule set](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html)
     */
    public suspend fun validateMatchmakingRuleSet(input: ValidateMatchmakingRuleSetRequest): ValidateMatchmakingRuleSetResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun GameLiftClient.withConfig(block: GameLiftClient.Config.Builder.() -> Unit): GameLiftClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultGameLiftClient(newConfig)
}

/**
 * Registers a player's acceptance or rejection of a proposed FlexMatch match. A matchmaking configuration may require player acceptance; if so, then matches built with that configuration cannot be completed unless all players accept the proposed match within a specified time limit.
 *
 * When FlexMatch builds a match, all the matchmaking tickets involved in the proposed match are placed into status `REQUIRES_ACCEPTANCE`. This is a trigger for your game to get acceptance from all players in each ticket. Calls to this action are only valid for tickets that are in this status; calls for tickets not in this status result in an error.
 *
 * To register acceptance, specify the ticket ID, one or more players, and an acceptance response. When all players have accepted, Amazon GameLift Servers advances the matchmaking tickets to status `PLACING`, and attempts to create a new game session for the match.
 *
 * If any player rejects the match, or if acceptances are not received before a specified timeout, the proposed match is dropped. Each matchmaking ticket in the failed match is handled as follows:
 * + If the ticket has one or more players who rejected the match or failed to respond, the ticket status is set `CANCELLED` and processing is terminated.
 * + If all players in the ticket accepted the match, the ticket status is returned to `SEARCHING` to find a new match.
 *
 * **Learn more**
 *
 * [ Add FlexMatch to a game client](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-client.html)
 *
 * [ FlexMatch events](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html) (reference)
 */
public suspend inline fun GameLiftClient.acceptMatch(crossinline block: AcceptMatchRequest.Builder.() -> Unit): AcceptMatchResponse = acceptMatch(AcceptMatchRequest.Builder().apply(block).build())

/**
 * **This operation is used with the Amazon GameLift Servers FleetIQ solution and game server groups.**
 *
 * Locates an available game server and temporarily reserves it to host gameplay and players. This operation is called from a game client or client service (such as a matchmaker) to request hosting resources for a new game session. In response, Amazon GameLift Servers FleetIQ locates an available game server, places it in `CLAIMED` status for 60 seconds, and returns connection information that players can use to connect to the game server.
 *
 * To claim a game server, identify a game server group. You can also specify a game server ID, although this approach bypasses Amazon GameLift Servers FleetIQ placement optimization. Optionally, include game data to pass to the game server at the start of a game session, such as a game map or player information. Add filter options to further restrict how a game server is chosen, such as only allowing game servers on `ACTIVE` instances to be claimed.
 *
 * When a game server is successfully claimed, connection information is returned. A claimed game server's utilization status remains `AVAILABLE` while the claim status is set to `CLAIMED` for up to 60 seconds. This time period gives the game server time to update its status to `UTILIZED` after players join. If the game server's status is not updated within 60 seconds, the game server reverts to unclaimed status and is available to be claimed by another request. The claim time period is a fixed value and is not configurable.
 *
 * If you try to claim a specific game server, this request will fail in the following cases:
 * + If the game server utilization status is `UTILIZED`.
 * + If the game server claim status is `CLAIMED`.
 * + If the game server is running on an instance in `DRAINING` status and the provided filter option does not allow placing on `DRAINING` instances.
 *
 * **Learn more**
 *
 * [Amazon GameLift Servers FleetIQ Guide](https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
 */
public suspend inline fun GameLiftClient.claimGameServer(crossinline block: ClaimGameServerRequest.Builder.() -> Unit): ClaimGameServerResponse = claimGameServer(ClaimGameServerRequest.Builder().apply(block).build())

/**
 * Creates an alias for a fleet. In most situations, you can use an alias ID in place of a fleet ID. An alias provides a level of abstraction for a fleet that is useful when redirecting player traffic from one fleet to another, such as when updating your game build.
 *
 * Amazon GameLift Servers supports two types of routing strategies for aliases: simple and terminal. A simple alias points to an active fleet. A terminal alias is used to display messaging or link to a URL instead of routing players to an active fleet. For example, you might use a terminal alias when a game version is no longer supported and you want to direct players to an upgrade site.
 *
 * To create a fleet alias, specify an alias name, routing strategy, and optional description. Each simple alias can point to only one fleet, but a fleet can have multiple aliases. If successful, a new alias record is returned, including an alias ID and an ARN. You can reassign an alias to another fleet by calling `UpdateAlias`.
 *
 * **Related actions**
 *
 * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public suspend inline fun GameLiftClient.createAlias(crossinline block: CreateAliasRequest.Builder.() -> Unit): CreateAliasResponse = createAlias(CreateAliasRequest.Builder().apply(block).build())

/**
 * Creates a new Amazon GameLift Servers build resource for your game server binary files. Combine game server binaries into a zip file for use with Amazon GameLift Servers.
 *
 * When setting up a new game build for Amazon GameLift Servers, we recommend using the CLI command **[upload-build](https://docs.aws.amazon.com/cli/latest/reference/gamelift/upload-build.html)**. This helper command combines two tasks: (1) it uploads your build files from a file directory to an Amazon GameLift Servers Amazon S3 location, and (2) it creates a new build resource.
 *
 * You can use the `CreateBuild` operation in the following scenarios:
 * + Create a new game build with build files that are in an Amazon S3 location under an Amazon Web Services account that you control. To use this option, you give Amazon GameLift Servers access to the Amazon S3 bucket. With permissions in place, specify a build name, operating system, and the Amazon S3 storage location of your game build.
 * + Upload your build files to a Amazon GameLift Servers Amazon S3 location. To use this option, specify a build name and operating system. This operation creates a new build resource and also returns an Amazon S3 location with temporary access credentials. Use the credentials to manually upload your build files to the specified Amazon S3 location. For more information, see [Uploading Objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/UploadingObjects.html) in the *Amazon S3 Developer Guide*. After you upload build files to the Amazon GameLift Servers Amazon S3 location, you can't update them.
 *
 * If successful, this operation creates a new build resource with a unique build ID and places it in `INITIALIZED` status. A build must be in `READY` status before you can create fleets with it.
 *
 * **Learn more**
 *
 * [Uploading Your Game](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html)
 *
 * [ Create a Build with Files in Amazon S3](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-cli-uploading.html#gamelift-build-cli-uploading-create-build)
 *
 * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public suspend inline fun GameLiftClient.createBuild(crossinline block: CreateBuildRequest.Builder.() -> Unit): CreateBuildResponse = createBuild(CreateBuildRequest.Builder().apply(block).build())

/**
 * Creates a managed fleet of Amazon Elastic Compute Cloud (Amazon EC2) instances to host your containerized game servers. Use this operation to define how to deploy a container architecture onto each fleet instance and configure fleet settings. You can create a container fleet in any Amazon Web Services Regions that Amazon GameLift Servers supports for multi-location fleets. A container fleet can be deployed to a single location or multiple locations. Container fleets are deployed with Amazon Linux 2023 as the instance operating system.
 *
 * Define the fleet's container architecture using container group definitions. Each fleet can have one of the following container group types:
 * + The game server container group runs your game server build and dependent software. Amazon GameLift Servers deploys one or more replicas of this container group to each fleet instance. The number of replicas depends on the computing capabilities of the fleet instance in use.
 * + An optional per-instance container group might be used to run other software that only needs to run once per instance, such as background services, logging, or test processes. One per-instance container group is deployed to each fleet instance.
 *
 * Each container group can include the definition for one or more containers. A container definition specifies a container image that is stored in an Amazon Elastic Container Registry (Amazon ECR) public or private repository.
 *
 * **Request options**
 *
 * Use this operation to make the following types of requests. Most fleet settings have default values, so you can create a working fleet with a minimal configuration and default values, which you can customize later.
 * + Create a fleet with no container groups. You can configure a container fleet and then add container group definitions later. In this scenario, no fleet instances are deployed, and the fleet can't host game sessions until you add a game server container group definition. Provide the following required parameter values:
 *    + `FleetRoleArn`
 * + Create a fleet with a game server container group. Provide the following required parameter values:
 *    + `FleetRoleArn`
 *    + `GameServerContainerGroupDefinitionName`
 * + Create a fleet with a game server container group and a per-instance container group. Provide the following required parameter values:
 *    + `FleetRoleArn`
 *    + `GameServerContainerGroupDefinitionName`
 *    + `PerInstanceContainerGroupDefinitionName`
 *
 * **Results**
 *
 * If successful, this operation creates a new container fleet resource, places it in `PENDING` status, and initiates the [fleet creation workflow](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-all.html#fleets-creation-workflow). For fleets with container groups, this workflow starts a fleet deployment and transitions the status to `ACTIVE`. Fleets without a container group are placed in `CREATED` status.
 *
 * You can update most of the properties of a fleet, including container group definitions, and deploy the update across all fleet instances. Use a fleet update to deploy a new game server version update across the container fleet.
 */
public suspend inline fun GameLiftClient.createContainerFleet(crossinline block: CreateContainerFleetRequest.Builder.() -> Unit): CreateContainerFleetResponse = createContainerFleet(CreateContainerFleetRequest.Builder().apply(block).build())

/**
 * Creates a `ContainerGroupDefinition` that describes a set of containers for hosting your game server with Amazon GameLift Servers managed containers hosting. An Amazon GameLift Servers container group is similar to a container task or pod. Use container group definitions when you create a container fleet with [CreateContainerFleet](https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateContainerFleet.html).
 *
 * A container group definition determines how Amazon GameLift Servers deploys your containers to each instance in a container fleet. You can maintain multiple versions of a container group definition.
 *
 * There are two types of container groups:
 * + A **game server container group** has the containers that run your game server application and supporting software. A game server container group can have these container types:
 *    + Game server container. This container runs your game server. You can define one game server container in a game server container group.
 *    + Support container. This container runs software in parallel with your game server. You can define up to 8 support containers in a game server group.
 * When building a game server container group definition, you can choose to bundle your game server executable and all dependent software into a single game server container. Alternatively, you can separate the software into one game server container and one or more support containers.On a container fleet instance, a game server container group can be deployed multiple times (depending on the compute resources of the instance). This means that all containers in the container group are replicated together.
 * + A **per-instance container group** has containers for processes that aren't replicated on a container fleet instance. This might include background services, logging, test processes, or processes that need to persist independently of the game server container group. When building a per-instance container group, you can define up to 10 support containers.
 *
 * This operation requires Identity and Access Management (IAM) permissions to access container images in Amazon ECR repositories. See [ IAM permissions for Amazon GameLift Servers](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-iam-policy-examples.html) for help setting the appropriate permissions.
 *
 * **Request options**
 *
 * Use this operation to make the following types of requests. You can specify values for the minimum required parameters and customize optional values later.
 * + Create a game server container group definition. Provide the following required parameter values:
 *    + `Name`
 *    + `ContainerGroupType` (`GAME_SERVER`)
 *    + `OperatingSystem` (omit to use default value)
 *    + `TotalMemoryLimitMebibytes` (omit to use default value)
 *    + `TotalVcpuLimit `(omit to use default value)
 *    + At least one `GameServerContainerDefinition`
 *       + `ContainerName`
 *       + `ImageUrl`
 *       + `PortConfiguration`
 *       + `ServerSdkVersion` (omit to use default value)
 * + Create a per-instance container group definition. Provide the following required parameter values:
 *    + `Name`
 *    + `ContainerGroupType` (`PER_INSTANCE`)
 *    + `OperatingSystem` (omit to use default value)
 *    + `TotalMemoryLimitMebibytes` (omit to use default value)
 *    + `TotalVcpuLimit `(omit to use default value)
 *    + At least one `SupportContainerDefinition`
 *       + `ContainerName`
 *       + `ImageUrl`
 *
 * **Results**
 *
 * If successful, this request creates a `ContainerGroupDefinition` resource and assigns a unique ARN value. You can update most properties of a container group definition by calling [UpdateContainerGroupDefinition](https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateContainerGroupDefinition.html), and optionally save the update as a new version.
 */
public suspend inline fun GameLiftClient.createContainerGroupDefinition(crossinline block: CreateContainerGroupDefinitionRequest.Builder.() -> Unit): CreateContainerGroupDefinitionResponse = createContainerGroupDefinition(CreateContainerGroupDefinitionRequest.Builder().apply(block).build())

/**
 * Creates a fleet of compute resources to host your game servers. Use this operation to set up the following types of fleets based on compute type:
 *
 * **Managed EC2 fleet**
 *
 * An EC2 fleet is a set of Amazon Elastic Compute Cloud (Amazon EC2) instances. Your game server build is deployed to each fleet instance. Amazon GameLift Servers manages the fleet's instances and controls the lifecycle of game server processes, which host game sessions for players. EC2 fleets can have instances in multiple locations. Each instance in the fleet is designated a `Compute`.
 *
 * To create an EC2 fleet, provide these required parameters:
 * + Either `BuildId` or `ScriptId`
 * + `ComputeType` set to `EC2` (the default value)
 * + `EC2InboundPermissions`
 * + `EC2InstanceType`
 * + `FleetType`
 * + `Name`
 * + `RuntimeConfiguration` with at least one `ServerProcesses` configuration
 *
 * If successful, this operation creates a new fleet resource and places it in `NEW` status while Amazon GameLift Servers initiates the [fleet creation workflow](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-all.html#fleets-creation-workflow). To debug your fleet, fetch logs, view performance metrics or other actions on the fleet, create a development fleet with port 22/3389 open. As a best practice, we recommend opening ports for remote access only when you need them and closing them when you're finished.
 *
 * When the fleet status is ACTIVE, you can adjust capacity settings and turn autoscaling on/off for each location.
 *
 * **Anywhere fleet**
 *
 * An Anywhere fleet represents compute resources that are not owned or managed by Amazon GameLift Servers. You might create an Anywhere fleet with your local machine for testing, or use one to host game servers with on-premises hardware or other game hosting solutions.
 *
 * To create an Anywhere fleet, provide these required parameters:
 * + `ComputeType` set to `ANYWHERE`
 * + `Locations` specifying a custom location
 * + `Name`
 *
 * If successful, this operation creates a new fleet resource and places it in `ACTIVE` status. You can register computes with a fleet in `ACTIVE` status.
 *
 * **Learn more**
 *
 * [Setting up fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
 *
 * [Debug fleet creation issues](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html#fleets-creating-debug-creation)
 *
 * [Multi-location fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
 */
public suspend inline fun GameLiftClient.createFleet(crossinline block: CreateFleetRequest.Builder.() -> Unit): CreateFleetResponse = createFleet(CreateFleetRequest.Builder().apply(block).build())

/**
 * Adds remote locations to an EC2 and begins populating the new locations with instances. The new instances conform to the fleet's instance type, auto-scaling, and other configuration settings.
 *
 * You can't add remote locations to a fleet that resides in an Amazon Web Services Region that doesn't support multiple locations. Fleets created prior to March 2021 can't support multiple locations.
 *
 * To add fleet locations, specify the fleet to be updated and provide a list of one or more locations.
 *
 * If successful, this operation returns the list of added locations with their status set to `NEW`. Amazon GameLift Servers initiates the process of starting an instance in each added location. You can track the status of each new location by monitoring location creation events using [DescribeFleetEvents](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetEvents.html).
 *
 * **Learn more**
 *
 * [Setting up fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
 *
 * [Update fleet locations](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-editing.html#fleets-update-locations)
 *
 * [ Amazon GameLift Servers service locations](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html) for managed hosting.
 */
public suspend inline fun GameLiftClient.createFleetLocations(crossinline block: CreateFleetLocationsRequest.Builder.() -> Unit): CreateFleetLocationsResponse = createFleetLocations(CreateFleetLocationsRequest.Builder().apply(block).build())

/**
 * **This operation is used with the Amazon GameLift Servers FleetIQ solution and game server groups.**
 *
 * Creates a Amazon GameLift Servers FleetIQ game server group for managing game hosting on a collection of Amazon Elastic Compute Cloud instances for game hosting. This operation creates the game server group, creates an Auto Scaling group in your Amazon Web Services account, and establishes a link between the two groups. You can view the status of your game server groups in the Amazon GameLift Servers console. Game server group metrics and events are emitted to Amazon CloudWatch.
 *
 * Before creating a new game server group, you must have the following:
 * + An Amazon Elastic Compute Cloud launch template that specifies how to launch Amazon Elastic Compute Cloud instances with your game server build. For more information, see [ Launching an Instance from a Launch Template](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html) in the *Amazon Elastic Compute Cloud User Guide*.
 * + An IAM role that extends limited access to your Amazon Web Services account to allow Amazon GameLift Servers FleetIQ to create and interact with the Auto Scaling group. For more information, see [Create IAM roles for cross-service interaction](https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-iam-permissions-roles.html) in the *Amazon GameLift Servers FleetIQ Developer Guide*.
 *
 * To create a new game server group, specify a unique group name, IAM role and Amazon Elastic Compute Cloud launch template, and provide a list of instance types that can be used in the group. You must also set initial maximum and minimum limits on the group's instance count. You can optionally set an Auto Scaling policy with target tracking based on a Amazon GameLift Servers FleetIQ metric.
 *
 * Once the game server group and corresponding Auto Scaling group are created, you have full access to change the Auto Scaling group's configuration as needed. Several properties that are set when creating a game server group, including maximum/minimum size and auto-scaling policy settings, must be updated directly in the Auto Scaling group. Keep in mind that some Auto Scaling group properties are periodically updated by Amazon GameLift Servers FleetIQ as part of its balancing activities to optimize for availability and cost.
 *
 * **Learn more**
 *
 * [Amazon GameLift Servers FleetIQ Guide](https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
 */
public suspend inline fun GameLiftClient.createGameServerGroup(crossinline block: CreateGameServerGroupRequest.Builder.() -> Unit): CreateGameServerGroupResponse = createGameServerGroup(CreateGameServerGroupRequest.Builder().apply(block).build())

/**
 * Creates a multiplayer game session for players in a specific fleet location. This operation prompts an available server process to start a game session and retrieves connection information for the new game session. As an alternative, consider using the Amazon GameLift Servers game session placement feature with [StartGameSessionPlacement](https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartGameSessionPlacement.html), which uses the FleetIQ algorithm and queues to optimize the placement process.
 *
 * When creating a game session, you specify exactly where you want to place it and provide a set of game session configuration settings. The target fleet must be in `ACTIVE` status.
 *
 * You can use this operation in the following ways:
 * + To create a game session on an instance in a fleet's home Region, provide a fleet or alias ID along with your game session configuration.
 * + To create a game session on an instance in a fleet's remote location, provide a fleet or alias ID and a location name, along with your game session configuration.
 * + To create a game session on an instance in an Anywhere fleet, specify the fleet's custom location.
 *
 * If successful, Amazon GameLift Servers initiates a workflow to start a new game session and returns a `GameSession` object containing the game session configuration and status. When the game session status is `ACTIVE`, it is updated with connection information and you can create player sessions for the game session. By default, newly created game sessions are open to new players. You can restrict new player access by using [UpdateGameSession](https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateGameSession.html) to change the game session's player session creation policy.
 *
 * Amazon GameLift Servers retains logs for active for 14 days. To access the logs, call [GetGameSessionLogUrl](https://docs.aws.amazon.com/gamelift/latest/apireference/API_GetGameSessionLogUrl.html) to download the log files.
 *
 * *Available in Amazon GameLift Servers Local.*
 *
 * **Learn more**
 *
 * [Start a game session](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession)
 *
 * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public suspend inline fun GameLiftClient.createGameSession(crossinline block: CreateGameSessionRequest.Builder.() -> Unit): CreateGameSessionResponse = createGameSession(CreateGameSessionRequest.Builder().apply(block).build())

/**
 * Creates a placement queue that processes requests for new game sessions. A queue uses FleetIQ algorithms to locate the best available placement locations for a new game session, and then prompts the game server process to start a new game session.
 *
 * A game session queue is configured with a set of destinations (Amazon GameLift Servers fleets or aliases) that determine where the queue can place new game sessions. These destinations can span multiple Amazon Web Services Regions, can use different instance types, and can include both Spot and On-Demand fleets. If the queue includes multi-location fleets, the queue can place game sessions in any of a fleet's remote locations.
 *
 * You can configure a queue to determine how it selects the best available placement for a new game session. Queues can prioritize placement decisions based on a combination of location, hosting cost, and player latency. You can set up the queue to use the default prioritization or provide alternate instructions using `PriorityConfiguration`.
 *
 * **Request options**
 *
 * Use this operation to make these common types of requests.
 * + Create a queue with the minimum required parameters.
 *    + `Name`
 *    + `Destinations` (This parameter isn't required, but a queue can't make placements without at least one destination.)
 * + Create a queue with placement notification. Queues that have high placement activity must use a notification system, such as with Amazon Simple Notification Service (Amazon SNS) or Amazon CloudWatch.
 *    + Required parameters `Name` and `Destinations`
 *    + `NotificationTarget`
 * + Create a queue with custom prioritization settings. These custom settings replace the default prioritization configuration for a queue.
 *    + Required parameters `Name` and `Destinations`
 *    + `PriorityConfiguration`
 * + Create a queue with special rules for processing player latency data.
 *    + Required parameters `Name` and `Destinations`
 *    + `PlayerLatencyPolicies`
 *
 * **Results**
 *
 * If successful, this operation returns a new `GameSessionQueue` object with an assigned queue ARN. Use the queue's name or ARN when submitting new game session requests with [StartGameSessionPlacement](https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartGameSessionPlacement.html) or [StartMatchmaking](https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartMatchmaking.html).
 *
 * **Learn more**
 *
 * [ Design a game session queue](https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-design.html)
 *
 * [ Create a game session queue](https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-creating.html)
 *
 * **Related actions**
 *
 * [CreateGameSessionQueue](https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateGameSessionQueue.html) | [DescribeGameSessionQueues](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameSessionQueues.html) | [UpdateGameSessionQueue](https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateGameSessionQueue.html) | [DeleteGameSessionQueue](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteGameSessionQueue.html) | [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public suspend inline fun GameLiftClient.createGameSessionQueue(crossinline block: CreateGameSessionQueueRequest.Builder.() -> Unit): CreateGameSessionQueueResponse = createGameSessionQueue(CreateGameSessionQueueRequest.Builder().apply(block).build())

/**
 * Creates a custom location for use in an Anywhere fleet.
 */
public suspend inline fun GameLiftClient.createLocation(crossinline block: CreateLocationRequest.Builder.() -> Unit): CreateLocationResponse = createLocation(CreateLocationRequest.Builder().apply(block).build())

/**
 * Defines a new matchmaking configuration for use with FlexMatch. Whether your are using FlexMatch with Amazon GameLift Servers hosting or as a standalone matchmaking service, the matchmaking configuration sets out rules for matching players and forming teams. If you're also using Amazon GameLift Servers hosting, it defines how to start game sessions for each match. Your matchmaking system can use multiple configurations to handle different game scenarios. All matchmaking requests identify the matchmaking configuration to use and provide player attributes consistent with that configuration.
 *
 * To create a matchmaking configuration, you must provide the following: configuration name and FlexMatch mode (with or without Amazon GameLift Servers hosting); a rule set that specifies how to evaluate players and find acceptable matches; whether player acceptance is required; and the maximum time allowed for a matchmaking attempt. When using FlexMatch with Amazon GameLift Servers hosting, you also need to identify the game session queue to use when starting a game session for the match.
 *
 * In addition, you must set up an Amazon Simple Notification Service topic to receive matchmaking notifications. Provide the topic ARN in the matchmaking configuration.
 *
 * **Learn more**
 *
 * [ Design a FlexMatch matchmaker](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-configuration.html)
 *
 * [ Set up FlexMatch event notification](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html)
 */
public suspend inline fun GameLiftClient.createMatchmakingConfiguration(crossinline block: CreateMatchmakingConfigurationRequest.Builder.() -> Unit): CreateMatchmakingConfigurationResponse = createMatchmakingConfiguration(CreateMatchmakingConfigurationRequest.Builder().apply(block).build())

/**
 * Creates a new rule set for FlexMatch matchmaking. A rule set describes the type of match to create, such as the number and size of teams. It also sets the parameters for acceptable player matches, such as minimum skill level or character type.
 *
 * To create a matchmaking rule set, provide unique rule set name and the rule set body in JSON format. Rule sets must be defined in the same Region as the matchmaking configuration they are used with.
 *
 * Since matchmaking rule sets cannot be edited, it is a good idea to check the rule set syntax using [ValidateMatchmakingRuleSet](https://docs.aws.amazon.com/gamelift/latest/apireference/API_ValidateMatchmakingRuleSet.html) before creating a new rule set.
 *
 * **Learn more**
 * + [Build a rule set](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html)
 * + [Design a matchmaker](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-configuration.html)
 * + [Matchmaking with FlexMatch](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-intro.html)
 */
public suspend inline fun GameLiftClient.createMatchmakingRuleSet(crossinline block: CreateMatchmakingRuleSetRequest.Builder.() -> Unit): CreateMatchmakingRuleSetResponse = createMatchmakingRuleSet(CreateMatchmakingRuleSetRequest.Builder().apply(block).build())

/**
 * Reserves an open player slot in a game session for a player. New player sessions can be created in any game session with an open slot that is in `ACTIVE` status and has a player creation policy of `ACCEPT_ALL`. You can add a group of players to a game session with [CreatePlayerSessions](https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreatePlayerSessions.html) .
 *
 * To create a player session, specify a game session ID, player ID, and optionally a set of player data.
 *
 * If successful, a slot is reserved in the game session for the player and a new `PlayerSessions` object is returned with a player session ID. The player references the player session ID when sending a connection request to the game session, and the game server can use it to validate the player reservation with the Amazon GameLift Servers service. Player sessions cannot be updated.
 *
 * The maximum number of players per game session is 200. It is not adjustable.
 *
 * **Related actions**
 *
 * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public suspend inline fun GameLiftClient.createPlayerSession(crossinline block: CreatePlayerSessionRequest.Builder.() -> Unit): CreatePlayerSessionResponse = createPlayerSession(CreatePlayerSessionRequest.Builder().apply(block).build())

/**
 * Reserves open slots in a game session for a group of players. New player sessions can be created in any game session with an open slot that is in `ACTIVE` status and has a player creation policy of `ACCEPT_ALL`. To add a single player to a game session, use [CreatePlayerSession](https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreatePlayerSession.html)
 *
 * To create player sessions, specify a game session ID and a list of player IDs. Optionally, provide a set of player data for each player ID.
 *
 * If successful, a slot is reserved in the game session for each player, and new `PlayerSession` objects are returned with player session IDs. Each player references their player session ID when sending a connection request to the game session, and the game server can use it to validate the player reservation with the Amazon GameLift Servers service. Player sessions cannot be updated.
 *
 * The maximum number of players per game session is 200. It is not adjustable.
 *
 * **Related actions**
 *
 * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public suspend inline fun GameLiftClient.createPlayerSessions(crossinline block: CreatePlayerSessionsRequest.Builder.() -> Unit): CreatePlayerSessionsResponse = createPlayerSessions(CreatePlayerSessionsRequest.Builder().apply(block).build())

/**
 * Creates a new script record for your Amazon GameLift Servers Realtime script. Realtime scripts are JavaScript that provide configuration settings and optional custom game logic for your game. The script is deployed when you create a Amazon GameLift Servers Realtime fleet to host your game sessions. Script logic is executed during an active game session.
 *
 * To create a new script record, specify a script name and provide the script file(s). The script files and all dependencies must be zipped into a single file. You can pull the zip file from either of these locations:
 * + A locally available directory. Use the *ZipFile* parameter for this option.
 * + An Amazon Simple Storage Service (Amazon S3) bucket under your Amazon Web Services account. Use the *StorageLocation* parameter for this option. You'll need to have an Identity Access Management (IAM) role that allows the Amazon GameLift Servers service to access your S3 bucket.
 *
 * If the call is successful, a new script record is created with a unique script ID. If the script file is provided as a local file, the file is uploaded to an Amazon GameLift Servers-owned S3 bucket and the script record's storage location reflects this location. If the script file is provided as an S3 bucket, Amazon GameLift Servers accesses the file at this storage location as needed for deployment.
 *
 * **Learn more**
 *
 * [Amazon GameLift Servers Amazon GameLift Servers Realtime](https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html)
 *
 * [Set Up a Role for Amazon GameLift Servers Access](https://docs.aws.amazon.com/gamelift/latest/developerguide/setting-up-role.html)
 *
 * **Related actions**
 *
 * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public suspend inline fun GameLiftClient.createScript(crossinline block: CreateScriptRequest.Builder.() -> Unit): CreateScriptResponse = createScript(CreateScriptRequest.Builder().apply(block).build())

/**
 * Requests authorization to create or delete a peer connection between the VPC for your Amazon GameLift Servers fleet and a virtual private cloud (VPC) in your Amazon Web Services account. VPC peering enables the game servers on your fleet to communicate directly with other Amazon Web Services resources. After you've received authorization, use [CreateVpcPeeringConnection](https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateVpcPeeringConnection.html) to establish the peering connection. For more information, see [VPC Peering with Amazon GameLift Servers Fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html).
 *
 * You can peer with VPCs that are owned by any Amazon Web Services account you have access to, including the account that you use to manage your Amazon GameLift Servers fleets. You cannot peer with VPCs that are in different Regions.
 *
 * To request authorization to create a connection, call this operation from the Amazon Web Services account with the VPC that you want to peer to your Amazon GameLift Servers fleet. For example, to enable your game servers to retrieve data from a DynamoDB table, use the account that manages that DynamoDB resource. Identify the following values: (1) The ID of the VPC that you want to peer with, and (2) the ID of the Amazon Web Services account that you use to manage Amazon GameLift Servers. If successful, VPC peering is authorized for the specified VPC.
 *
 * To request authorization to delete a connection, call this operation from the Amazon Web Services account with the VPC that is peered with your Amazon GameLift Servers fleet. Identify the following values: (1) VPC ID that you want to delete the peering connection for, and (2) ID of the Amazon Web Services account that you use to manage Amazon GameLift Servers.
 *
 * The authorization remains valid for 24 hours unless it is canceled. You must create or delete the peering connection while the authorization is valid.
 *
 * **Related actions**
 *
 * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public suspend inline fun GameLiftClient.createVpcPeeringAuthorization(crossinline block: CreateVpcPeeringAuthorizationRequest.Builder.() -> Unit): CreateVpcPeeringAuthorizationResponse = createVpcPeeringAuthorization(CreateVpcPeeringAuthorizationRequest.Builder().apply(block).build())

/**
 * Establishes a VPC peering connection between a virtual private cloud (VPC) in an Amazon Web Services account with the VPC for your Amazon GameLift Servers fleet. VPC peering enables the game servers on your fleet to communicate directly with other Amazon Web Services resources. You can peer with VPCs in any Amazon Web Services account that you have access to, including the account that you use to manage your Amazon GameLift Servers fleets. You cannot peer with VPCs that are in different Regions. For more information, see [VPC Peering with Amazon GameLift Servers Fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html).
 *
 * Before calling this operation to establish the peering connection, you first need to use [CreateVpcPeeringAuthorization](https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateVpcPeeringAuthorization.html) and identify the VPC you want to peer with. Once the authorization for the specified VPC is issued, you have 24 hours to establish the connection. These two operations handle all tasks necessary to peer the two VPCs, including acceptance, updating routing tables, etc.
 *
 * To establish the connection, call this operation from the Amazon Web Services account that is used to manage the Amazon GameLift Servers fleets. Identify the following values: (1) The ID of the fleet you want to be enable a VPC peering connection for; (2) The Amazon Web Services account with the VPC that you want to peer with; and (3) The ID of the VPC you want to peer with. This operation is asynchronous. If successful, a connection request is created. You can use continuous polling to track the request's status using [DescribeVpcPeeringConnections](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeVpcPeeringConnections.html) , or by monitoring fleet events for success or failure using [DescribeFleetEvents](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetEvents.html) .
 *
 * **Related actions**
 *
 * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public suspend inline fun GameLiftClient.createVpcPeeringConnection(crossinline block: CreateVpcPeeringConnectionRequest.Builder.() -> Unit): CreateVpcPeeringConnectionResponse = createVpcPeeringConnection(CreateVpcPeeringConnectionRequest.Builder().apply(block).build())

/**
 * Deletes an alias. This operation removes all record of the alias. Game clients attempting to access a server process using the deleted alias receive an error. To delete an alias, specify the alias ID to be deleted.
 *
 * **Related actions**
 *
 * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public suspend inline fun GameLiftClient.deleteAlias(crossinline block: DeleteAliasRequest.Builder.() -> Unit): DeleteAliasResponse = deleteAlias(DeleteAliasRequest.Builder().apply(block).build())

/**
 * Deletes a build. This operation permanently deletes the build resource and any uploaded build files. Deleting a build does not affect the status of any active fleets using the build, but you can no longer create new fleets with the deleted build.
 *
 * To delete a build, specify the build ID.
 *
 * **Learn more**
 *
 * [ Upload a Custom Server Build](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html)
 *
 * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public suspend inline fun GameLiftClient.deleteBuild(crossinline block: DeleteBuildRequest.Builder.() -> Unit): DeleteBuildResponse = deleteBuild(DeleteBuildRequest.Builder().apply(block).build())

/**
 * Deletes all resources and information related to a container fleet and shuts down currently running fleet instances, including those in remote locations. The container fleet must be in `ACTIVE` status to be deleted.
 *
 * To delete a fleet, specify the fleet ID to be terminated. During the deletion process, the fleet status is changed to `DELETING`.
 *
 * **Learn more**
 *
 * [Setting up Amazon GameLift Servers Fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
 */
public suspend inline fun GameLiftClient.deleteContainerFleet(crossinline block: DeleteContainerFleetRequest.Builder.() -> Unit): DeleteContainerFleetResponse = deleteContainerFleet(DeleteContainerFleetRequest.Builder().apply(block).build())

/**
 * Deletes a container group definition.
 *
 * **Request options:**
 * + Delete an entire container group definition, including all versions. Specify the container group definition name, or use an ARN value without the version number.
 * + Delete a particular version. Specify the container group definition name and a version number, or use an ARN value that includes the version number.
 * + Keep the newest versions and delete all older versions. Specify the container group definition name and the number of versions to retain. For example, set `VersionCountToRetain` to 5 to delete all but the five most recent versions.
 *
 * **Result**
 *
 * If successful, Amazon GameLift Servers removes the container group definition versions that you request deletion for. This request will fail for any requested versions if the following is true:
 * + If the version is being used in an active fleet
 * + If the version is being deployed to a fleet in a deployment that's currently in progress.
 * + If the version is designated as a rollback definition in a fleet deployment that's currently in progress.
 *
 * **Learn more**
 * + [Manage a container group definition](https://docs.aws.amazon.com/gamelift/latest/developerguide/containers-create-groups.html)
 */
public suspend inline fun GameLiftClient.deleteContainerGroupDefinition(crossinline block: DeleteContainerGroupDefinitionRequest.Builder.() -> Unit): DeleteContainerGroupDefinitionResponse = deleteContainerGroupDefinition(DeleteContainerGroupDefinitionRequest.Builder().apply(block).build())

/**
 * Deletes all resources and information related to a fleet and shuts down any currently running fleet instances, including those in remote locations.
 *
 * If the fleet being deleted has a VPC peering connection, you first need to get a valid authorization (good for 24 hours) by calling [CreateVpcPeeringAuthorization](https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateVpcPeeringAuthorization.html). You don't need to explicitly delete the VPC peering connection.
 *
 * To delete a fleet, specify the fleet ID to be terminated. During the deletion process, the fleet status is changed to `DELETING`. When completed, the status switches to `TERMINATED` and the fleet event `FLEET_DELETED` is emitted.
 *
 * **Learn more**
 *
 * [Setting up Amazon GameLift Servers Fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
 */
public suspend inline fun GameLiftClient.deleteFleet(crossinline block: DeleteFleetRequest.Builder.() -> Unit): DeleteFleetResponse = deleteFleet(DeleteFleetRequest.Builder().apply(block).build())

/**
 * Removes locations from a multi-location fleet. When deleting a location, all game server process and all instances that are still active in the location are shut down.
 *
 * To delete fleet locations, identify the fleet ID and provide a list of the locations to be deleted.
 *
 * If successful, GameLift sets the location status to `DELETING`, and begins to shut down existing server processes and terminate instances in each location being deleted. When completed, the location status changes to `TERMINATED`.
 *
 * **Learn more**
 *
 * [Setting up Amazon GameLift Servers fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
 */
public suspend inline fun GameLiftClient.deleteFleetLocations(crossinline block: DeleteFleetLocationsRequest.Builder.() -> Unit): DeleteFleetLocationsResponse = deleteFleetLocations(DeleteFleetLocationsRequest.Builder().apply(block).build())

/**
 * **This operation is used with the Amazon GameLift Servers FleetIQ solution and game server groups.**
 *
 * Terminates a game server group and permanently deletes the game server group record. You have several options for how these resources are impacted when deleting the game server group. Depending on the type of delete operation selected, this operation might affect these resources:
 * + The game server group
 * + The corresponding Auto Scaling group
 * + All game servers that are currently running in the group
 *
 * To delete a game server group, identify the game server group to delete and specify the type of delete operation to initiate. Game server groups can only be deleted if they are in `ACTIVE` or `ERROR` status.
 *
 * If the delete request is successful, a series of operations are kicked off. The game server group status is changed to `DELETE_SCHEDULED`, which prevents new game servers from being registered and stops automatic scaling activity. Once all game servers in the game server group are deregistered, Amazon GameLift Servers FleetIQ can begin deleting resources. If any of the delete operations fail, the game server group is placed in `ERROR` status.
 *
 * Amazon GameLift Servers FleetIQ emits delete events to Amazon CloudWatch.
 *
 * **Learn more**
 *
 * [Amazon GameLift Servers FleetIQ Guide](https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
 */
public suspend inline fun GameLiftClient.deleteGameServerGroup(crossinline block: DeleteGameServerGroupRequest.Builder.() -> Unit): DeleteGameServerGroupResponse = deleteGameServerGroup(DeleteGameServerGroupRequest.Builder().apply(block).build())

/**
 * Deletes a game session queue. Once a queue is successfully deleted, unfulfilled [StartGameSessionPlacement](https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartGameSessionPlacement.html) requests that reference the queue will fail. To delete a queue, specify the queue name.
 */
public suspend inline fun GameLiftClient.deleteGameSessionQueue(crossinline block: DeleteGameSessionQueueRequest.Builder.() -> Unit): DeleteGameSessionQueueResponse = deleteGameSessionQueue(DeleteGameSessionQueueRequest.Builder().apply(block).build())

/**
 * Deletes a custom location.
 *
 * Before deleting a custom location, review any fleets currently using the custom location and deregister the location if it is in use. For more information, see [DeregisterCompute](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeregisterCompute.html).
 */
public suspend inline fun GameLiftClient.deleteLocation(crossinline block: DeleteLocationRequest.Builder.() -> Unit): DeleteLocationResponse = deleteLocation(DeleteLocationRequest.Builder().apply(block).build())

/**
 * Permanently removes a FlexMatch matchmaking configuration. To delete, specify the configuration name. A matchmaking configuration cannot be deleted if it is being used in any active matchmaking tickets.
 */
public suspend inline fun GameLiftClient.deleteMatchmakingConfiguration(crossinline block: DeleteMatchmakingConfigurationRequest.Builder.() -> Unit): DeleteMatchmakingConfigurationResponse = deleteMatchmakingConfiguration(DeleteMatchmakingConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes an existing matchmaking rule set. To delete the rule set, provide the rule set name. Rule sets cannot be deleted if they are currently being used by a matchmaking configuration.
 *
 * **Learn more**
 * + [Build a rule set](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html)
 */
public suspend inline fun GameLiftClient.deleteMatchmakingRuleSet(crossinline block: DeleteMatchmakingRuleSetRequest.Builder.() -> Unit): DeleteMatchmakingRuleSetResponse = deleteMatchmakingRuleSet(DeleteMatchmakingRuleSetRequest.Builder().apply(block).build())

/**
 * Deletes a fleet scaling policy. Once deleted, the policy is no longer in force and Amazon GameLift Servers removes all record of it. To delete a scaling policy, specify both the scaling policy name and the fleet ID it is associated with.
 *
 * To temporarily suspend scaling policies, use [StopFleetActions](https://docs.aws.amazon.com/gamelift/latest/apireference/API_StopFleetActions.html). This operation suspends all policies for the fleet.
 */
public suspend inline fun GameLiftClient.deleteScalingPolicy(crossinline block: DeleteScalingPolicyRequest.Builder.() -> Unit): DeleteScalingPolicyResponse = deleteScalingPolicy(DeleteScalingPolicyRequest.Builder().apply(block).build())

/**
 * Deletes a Realtime script. This operation permanently deletes the script record. If script files were uploaded, they are also deleted (files stored in an S3 bucket are not deleted).
 *
 * To delete a script, specify the script ID. Before deleting a script, be sure to terminate all fleets that are deployed with the script being deleted. Fleet instances periodically check for script updates, and if the script record no longer exists, the instance will go into an error state and be unable to host game sessions.
 *
 * **Learn more**
 *
 * [Amazon GameLift Servers Amazon GameLift Servers Realtime](https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html)
 *
 * **Related actions**
 *
 * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public suspend inline fun GameLiftClient.deleteScript(crossinline block: DeleteScriptRequest.Builder.() -> Unit): DeleteScriptResponse = deleteScript(DeleteScriptRequest.Builder().apply(block).build())

/**
 * Cancels a pending VPC peering authorization for the specified VPC. If you need to delete an existing VPC peering connection, use [DeleteVpcPeeringConnection](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteVpcPeeringConnection.html).
 *
 * **Related actions**
 *
 * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public suspend inline fun GameLiftClient.deleteVpcPeeringAuthorization(crossinline block: DeleteVpcPeeringAuthorizationRequest.Builder.() -> Unit): DeleteVpcPeeringAuthorizationResponse = deleteVpcPeeringAuthorization(DeleteVpcPeeringAuthorizationRequest.Builder().apply(block).build())

/**
 * Removes a VPC peering connection. To delete the connection, you must have a valid authorization for the VPC peering connection that you want to delete..
 *
 * Once a valid authorization exists, call this operation from the Amazon Web Services account that is used to manage the Amazon GameLift Servers fleets. Identify the connection to delete by the connection ID and fleet ID. If successful, the connection is removed.
 *
 * **Related actions**
 *
 * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public suspend inline fun GameLiftClient.deleteVpcPeeringConnection(crossinline block: DeleteVpcPeeringConnectionRequest.Builder.() -> Unit): DeleteVpcPeeringConnectionResponse = deleteVpcPeeringConnection(DeleteVpcPeeringConnectionRequest.Builder().apply(block).build())

/**
 * Removes a compute resource from an Anywhere fleet. Deregistered computes can no longer host game sessions through Amazon GameLift Servers. Use this operation with an Anywhere fleet that doesn't use the Amazon GameLift Servers Agent For Anywhere fleets with the Agent, the Agent handles all compute registry tasks for you.
 *
 * To deregister a compute, call this operation from the compute that's being deregistered and specify the compute name and the fleet ID.
 */
public suspend inline fun GameLiftClient.deregisterCompute(crossinline block: DeregisterComputeRequest.Builder.() -> Unit): DeregisterComputeResponse = deregisterCompute(DeregisterComputeRequest.Builder().apply(block).build())

/**
 * **This operation is used with the Amazon GameLift Servers FleetIQ solution and game server groups.**
 *
 * Removes the game server from a game server group. As a result of this operation, the deregistered game server can no longer be claimed and will not be returned in a list of active game servers.
 *
 * To deregister a game server, specify the game server group and game server ID. If successful, this operation emits a CloudWatch event with termination timestamp and reason.
 *
 * **Learn more**
 *
 * [Amazon GameLift Servers FleetIQ Guide](https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
 */
public suspend inline fun GameLiftClient.deregisterGameServer(crossinline block: DeregisterGameServerRequest.Builder.() -> Unit): DeregisterGameServerResponse = deregisterGameServer(DeregisterGameServerRequest.Builder().apply(block).build())

/**
 * Retrieves properties for an alias. This operation returns all alias metadata and settings. To get an alias's target fleet ID only, use `ResolveAlias`.
 *
 * To get alias properties, specify the alias ID. If successful, the requested alias record is returned.
 *
 * **Related actions**
 *
 * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public suspend inline fun GameLiftClient.describeAlias(crossinline block: DescribeAliasRequest.Builder.() -> Unit): DescribeAliasResponse = describeAlias(DescribeAliasRequest.Builder().apply(block).build())

/**
 * Retrieves properties for a custom game build. To request a build resource, specify a build ID. If successful, an object containing the build properties is returned.
 *
 * **Learn more**
 *
 * [ Upload a Custom Server Build](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html)
 *
 * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public suspend inline fun GameLiftClient.describeBuild(crossinline block: DescribeBuildRequest.Builder.() -> Unit): DescribeBuildResponse = describeBuild(DescribeBuildRequest.Builder().apply(block).build())

/**
 * Retrieves properties for a specific compute resource in an Amazon GameLift Servers fleet. You can list all computes in a fleet by calling [ListCompute](https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListCompute.html).
 *
 * **Request options**
 *
 * Provide the fleet ID and compute name. The compute name varies depending on the type of fleet.
 * + For a compute in a managed EC2 fleet, provide an instance ID. Each instance in the fleet is a compute.
 * + For a compute in a managed container fleet, provide a compute name. In a container fleet, each game server container group on a fleet instance is assigned a compute name.
 * + For a compute in an Anywhere fleet, provide a registered compute name. Anywhere fleet computes are created when you register a hosting resource with the fleet.
 *
 * **Results**
 *
 * If successful, this operation returns details for the requested compute resource. Depending on the fleet's compute type, the result includes the following information:
 * + For a managed EC2 fleet, this operation returns information about the EC2 instance.
 * + For an Anywhere fleet, this operation returns information about the registered compute.
 */
public suspend inline fun GameLiftClient.describeCompute(crossinline block: DescribeComputeRequest.Builder.() -> Unit): DescribeComputeResponse = describeCompute(DescribeComputeRequest.Builder().apply(block).build())

/**
 * Retrieves the properties for a container fleet. When requesting attributes for multiple fleets, use the pagination parameters to retrieve results as a set of sequential pages.
 *
 * **Request options**
 * + Get container fleet properties for a single fleet. Provide either the fleet ID or ARN value.
 *
 * **Results**
 *
 * If successful, a `ContainerFleet` object is returned. This object includes the fleet properties, including information about the most recent deployment.
 *
 * Some API operations limit the number of fleet IDs that allowed in one request. If a request exceeds this limit, the request fails and the error message contains the maximum allowed number.
 */
public suspend inline fun GameLiftClient.describeContainerFleet(crossinline block: DescribeContainerFleetRequest.Builder.() -> Unit): DescribeContainerFleetResponse = describeContainerFleet(DescribeContainerFleetRequest.Builder().apply(block).build())

/**
 * Retrieves the properties of a container group definition, including all container definitions in the group.
 *
 * **Request options:**
 * + Retrieve the latest version of a container group definition. Specify the container group definition name only, or use an ARN value without a version number.
 * + Retrieve a particular version. Specify the container group definition name and a version number, or use an ARN value that includes the version number.
 *
 * **Results:**
 *
 * If successful, this operation returns the complete properties of a container group definition version.
 *
 * **Learn more**
 * + [Manage a container group definition](https://docs.aws.amazon.com/gamelift/latest/developerguide/containers-create-groups.html)
 */
public suspend inline fun GameLiftClient.describeContainerGroupDefinition(crossinline block: DescribeContainerGroupDefinitionRequest.Builder.() -> Unit): DescribeContainerGroupDefinitionResponse = describeContainerGroupDefinition(DescribeContainerGroupDefinitionRequest.Builder().apply(block).build())

/**
 * Retrieves the instance limits and current utilization for an Amazon Web Services Region or location. Instance limits control the number of instances, per instance type, per location, that your Amazon Web Services account can use. Learn more at [Amazon EC2 Instance Types](http://aws.amazon.com/ec2/instance-types/). The information returned includes the maximum number of instances allowed and your account's current usage across all fleets. This information can affect your ability to scale your Amazon GameLift Servers fleets. You can request a limit increase for your account by using the **Service limits** page in the Amazon GameLift Servers console.
 *
 * Instance limits differ based on whether the instances are deployed in a fleet's home Region or in a remote location. For remote locations, limits also differ based on the combination of home Region and remote location. All requests must specify an Amazon Web Services Region (either explicitly or as your default settings). To get the limit for a remote location, you must also specify the location. For example, the following requests all return different results:
 * + Request specifies the Region `ap-northeast-1` with no location. The result is limits and usage data on all instance types that are deployed in `us-east-2`, by all of the fleets that reside in `ap-northeast-1`.
 * + Request specifies the Region `us-east-1` with location `ca-central-1`. The result is limits and usage data on all instance types that are deployed in `ca-central-1`, by all of the fleets that reside in `us-east-2`. These limits do not affect fleets in any other Regions that deploy instances to `ca-central-1`.
 * + Request specifies the Region `eu-west-1` with location `ca-central-1`. The result is limits and usage data on all instance types that are deployed in `ca-central-1`, by all of the fleets that reside in `eu-west-1`.
 *
 * This operation can be used in the following ways:
 * + To get limit and usage data for all instance types that are deployed in an Amazon Web Services Region by fleets that reside in the same Region: Specify the Region only. Optionally, specify a single instance type to retrieve information for.
 * + To get limit and usage data for all instance types that are deployed to a remote location by fleets that reside in different Amazon Web Services Region: Provide both the Amazon Web Services Region and the remote location. Optionally, specify a single instance type to retrieve information for.
 *
 * If successful, an `EC2InstanceLimits` object is returned with limits and usage data for each requested instance type.
 *
 * **Learn more**
 *
 * [Setting up Amazon GameLift Servers fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
 */
public suspend inline fun GameLiftClient.describeEc2InstanceLimits(crossinline block: DescribeEc2InstanceLimitsRequest.Builder.() -> Unit): DescribeEc2InstanceLimitsResponse = describeEc2InstanceLimits(DescribeEc2InstanceLimitsRequest.Builder().apply(block).build())

/**
 * Retrieves core fleet-wide properties for fleets in an Amazon Web Services Region. Properties include the computing hardware and deployment configuration for instances in the fleet.
 *
 * You can use this operation in the following ways:
 * + To get attributes for specific fleets, provide a list of fleet IDs or fleet ARNs.
 * + To get attributes for all fleets, do not provide a fleet identifier.
 *
 * When requesting attributes for multiple fleets, use the pagination parameters to retrieve results as a set of sequential pages.
 *
 * If successful, a `FleetAttributes` object is returned for each fleet requested, unless the fleet identifier is not found.
 *
 * Some API operations limit the number of fleet IDs that allowed in one request. If a request exceeds this limit, the request fails and the error message contains the maximum allowed number.
 *
 * **Learn more**
 *
 * [Setting up Amazon GameLift Servers fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
 */
public suspend inline fun GameLiftClient.describeFleetAttributes(crossinline block: DescribeFleetAttributesRequest.Builder.() -> Unit): DescribeFleetAttributesResponse = describeFleetAttributes(DescribeFleetAttributesRequest.Builder().apply(block).build())

/**
 * Retrieves the resource capacity settings for one or more fleets. For a container fleet, this operation also returns counts for game server container groups.
 *
 * With multi-location fleets, this operation retrieves data for the fleet's home Region only. To retrieve capacity for remote locations, see [https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationCapacity.html](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationCapacity.html).
 *
 * This operation can be used in the following ways:
 * + To get capacity data for one or more specific fleets, provide a list of fleet IDs or fleet ARNs.
 * + To get capacity data for all fleets, do not provide a fleet identifier.
 *
 * When requesting multiple fleets, use the pagination parameters to retrieve results as a set of sequential pages.
 *
 * If successful, a `FleetCapacity` object is returned for each requested fleet ID. Each `FleetCapacity` object includes a `Location` property, which is set to the fleet's home Region. Capacity values are returned only for fleets that currently exist.
 *
 * Some API operations may limit the number of fleet IDs that are allowed in one request. If a request exceeds this limit, the request fails and the error message includes the maximum allowed.
 *
 * **Learn more**
 *
 * [Setting up Amazon GameLift Servers fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
 *
 * [GameLift metrics for fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet)
 */
public suspend inline fun GameLiftClient.describeFleetCapacity(crossinline block: DescribeFleetCapacityRequest.Builder.() -> Unit): DescribeFleetCapacityResponse = describeFleetCapacity(DescribeFleetCapacityRequest.Builder().apply(block).build())

/**
 * Retrieves information about a managed container fleet deployment.
 *
 * **Request options**
 * + Get information about the latest deployment for a specific fleet. Provide the fleet ID or ARN.
 * +  Get information about a specific deployment. Provide the fleet ID or ARN and the deployment ID.
 *
 * **Results**
 *
 * If successful, a `FleetDeployment` object is returned.
 */
public suspend inline fun GameLiftClient.describeFleetDeployment(crossinline block: DescribeFleetDeploymentRequest.Builder.() -> Unit): DescribeFleetDeploymentResponse = describeFleetDeployment(DescribeFleetDeploymentRequest.Builder().apply(block).build())

/**
 * Retrieves entries from a fleet's event log. Fleet events are initiated by changes in status, such as during fleet creation and termination, changes in capacity, etc. If a fleet has multiple locations, events are also initiated by changes to status and capacity in remote locations.
 *
 * You can specify a time range to limit the result set. Use the pagination parameters to retrieve results as a set of sequential pages.
 *
 * If successful, a collection of event log entries matching the request are returned.
 *
 * **Learn more**
 *
 * [Setting up Amazon GameLift Servers fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
 */
public suspend inline fun GameLiftClient.describeFleetEvents(crossinline block: DescribeFleetEventsRequest.Builder.() -> Unit): DescribeFleetEventsResponse = describeFleetEvents(DescribeFleetEventsRequest.Builder().apply(block).build())

/**
 * Retrieves information on a fleet's remote locations, including life-cycle status and any suspended fleet activity.
 *
 * This operation can be used in the following ways:
 * + To get data for specific locations, provide a fleet identifier and a list of locations. Location data is returned in the order that it is requested.
 * + To get data for all locations, provide a fleet identifier only. Location data is returned in no particular order.
 *
 * When requesting attributes for multiple locations, use the pagination parameters to retrieve results as a set of sequential pages.
 *
 * If successful, a `LocationAttributes` object is returned for each requested location. If the fleet does not have a requested location, no information is returned. This operation does not return the home Region. To get information on a fleet's home Region, call `DescribeFleetAttributes`.
 *
 * **Learn more**
 *
 * [Setting up Amazon GameLift Servers fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
 *
 * [ Amazon GameLift Servers service locations](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html) for managed hosting
 */
public suspend inline fun GameLiftClient.describeFleetLocationAttributes(crossinline block: DescribeFleetLocationAttributesRequest.Builder.() -> Unit): DescribeFleetLocationAttributesResponse = describeFleetLocationAttributes(DescribeFleetLocationAttributesRequest.Builder().apply(block).build())

/**
 * Retrieves the resource capacity settings for a fleet location. The data returned includes the current capacity (number of EC2 instances) and some scaling settings for the requested fleet location. For a managed container fleet, this operation also returns counts for game server container groups.
 *
 * Use this operation to retrieve capacity information for a fleet's remote location or home Region (you can also retrieve home Region capacity by calling `DescribeFleetCapacity`).
 *
 * To retrieve capacity data, identify a fleet and location.
 *
 * If successful, a `FleetCapacity` object is returned for the requested fleet location.
 *
 * **Learn more**
 *
 * [Setting up Amazon GameLift Servers fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
 *
 * [ Amazon GameLift Servers service locations](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html) for managed hosting
 *
 * [GameLift metrics for fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet)
 */
public suspend inline fun GameLiftClient.describeFleetLocationCapacity(crossinline block: DescribeFleetLocationCapacityRequest.Builder.() -> Unit): DescribeFleetLocationCapacityResponse = describeFleetLocationCapacity(DescribeFleetLocationCapacityRequest.Builder().apply(block).build())

/**
 * Retrieves current usage data for a fleet location. Utilization data provides a snapshot of current game hosting activity at the requested location. Use this operation to retrieve utilization information for a fleet's remote location or home Region (you can also retrieve home Region utilization by calling `DescribeFleetUtilization`).
 *
 * To retrieve utilization data, identify a fleet and location.
 *
 * If successful, a `FleetUtilization` object is returned for the requested fleet location.
 *
 * **Learn more**
 *
 * [Setting up Amazon GameLift Servers fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
 *
 * [ Amazon GameLift Servers service locations](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html) for managed hosting
 *
 * [GameLift metrics for fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet)
 */
public suspend inline fun GameLiftClient.describeFleetLocationUtilization(crossinline block: DescribeFleetLocationUtilizationRequest.Builder.() -> Unit): DescribeFleetLocationUtilizationResponse = describeFleetLocationUtilization(DescribeFleetLocationUtilizationRequest.Builder().apply(block).build())

/**
 * Retrieves a fleet's inbound connection permissions. Connection permissions specify IP addresses and port settings that incoming traffic can use to access server processes in the fleet. Game server processes that are running in the fleet must use a port that falls within this range.
 *
 * Use this operation in the following ways:
 * + To retrieve the port settings for a fleet, identify the fleet's unique identifier.
 * + To check the status of recent updates to a fleet remote location, specify the fleet ID and a location. Port setting updates can take time to propagate across all locations.
 *
 * If successful, a set of `IpPermission` objects is returned for the requested fleet ID. When specifying a location, this operation returns a pending status. If the requested fleet has been deleted, the result set is empty.
 *
 * **Learn more**
 *
 * [Setting up Amazon GameLift Servers fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
 */
public suspend inline fun GameLiftClient.describeFleetPortSettings(crossinline block: DescribeFleetPortSettingsRequest.Builder.() -> Unit): DescribeFleetPortSettingsResponse = describeFleetPortSettings(DescribeFleetPortSettingsRequest.Builder().apply(block).build())

/**
 * Retrieves utilization statistics for one or more fleets. Utilization data provides a snapshot of how the fleet's hosting resources are currently being used. For fleets with remote locations, this operation retrieves data for the fleet's home Region only. See [DescribeFleetLocationUtilization](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationUtilization.html) to get utilization statistics for a fleet's remote locations.
 *
 * This operation can be used in the following ways:
 * + To get utilization data for one or more specific fleets, provide a list of fleet IDs or fleet ARNs.
 * + To get utilization data for all fleets, do not provide a fleet identifier.
 *
 * When requesting multiple fleets, use the pagination parameters to retrieve results as a set of sequential pages.
 *
 * If successful, a [FleetUtilization](https://docs.aws.amazon.com/gamelift/latest/apireference/API_FleetUtilization.html) object is returned for each requested fleet ID, unless the fleet identifier is not found. Each fleet utilization object includes a `Location` property, which is set to the fleet's home Region.
 *
 * Some API operations may limit the number of fleet IDs allowed in one request. If a request exceeds this limit, the request fails and the error message includes the maximum allowed.
 *
 * **Learn more**
 *
 * [Setting up Amazon GameLift Servers Fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
 *
 * [GameLift Metrics for Fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet)
 */
public suspend inline fun GameLiftClient.describeFleetUtilization(crossinline block: DescribeFleetUtilizationRequest.Builder.() -> Unit): DescribeFleetUtilizationResponse = describeFleetUtilization(DescribeFleetUtilizationRequest.Builder().apply(block).build())

/**
 * **This operation is used with the Amazon GameLift Servers FleetIQ solution and game server groups.**
 *
 * Retrieves information for a registered game server. Information includes game server status, health check info, and the instance that the game server is running on.
 *
 * To retrieve game server information, specify the game server ID. If successful, the requested game server object is returned.
 *
 * **Learn more**
 *
 * [Amazon GameLift Servers FleetIQ Guide](https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
 */
public suspend inline fun GameLiftClient.describeGameServer(crossinline block: DescribeGameServerRequest.Builder.() -> Unit): DescribeGameServerResponse = describeGameServer(DescribeGameServerRequest.Builder().apply(block).build())

/**
 * **This operation is used with the Amazon GameLift Servers FleetIQ solution and game server groups.**
 *
 * Retrieves information on a game server group. This operation returns only properties related to Amazon GameLift Servers FleetIQ. To view or update properties for the corresponding Auto Scaling group, such as launch template, auto scaling policies, and maximum/minimum group size, access the Auto Scaling group directly.
 *
 * To get attributes for a game server group, provide a group name or ARN value. If successful, a `GameServerGroup` object is returned.
 *
 * **Learn more**
 *
 * [Amazon GameLift Servers FleetIQ Guide](https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
 */
public suspend inline fun GameLiftClient.describeGameServerGroup(crossinline block: DescribeGameServerGroupRequest.Builder.() -> Unit): DescribeGameServerGroupResponse = describeGameServerGroup(DescribeGameServerGroupRequest.Builder().apply(block).build())

/**
 * **This operation is used with the Amazon GameLift Servers FleetIQ solution and game server groups.**
 *
 * Retrieves status information about the Amazon EC2 instances associated with a Amazon GameLift Servers FleetIQ game server group. Use this operation to detect when instances are active or not available to host new game servers.
 *
 * To request status for all instances in the game server group, provide a game server group ID only. To request status for specific instances, provide the game server group ID and one or more instance IDs. Use the pagination parameters to retrieve results in sequential segments. If successful, a collection of `GameServerInstance` objects is returned.
 *
 * This operation is not designed to be called with every game server claim request; this practice can cause you to exceed your API limit, which results in errors. Instead, as a best practice, cache the results and refresh your cache no more than once every 10 seconds.
 *
 * **Learn more**
 *
 * [Amazon GameLift Servers FleetIQ Guide](https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
 */
public suspend inline fun GameLiftClient.describeGameServerInstances(crossinline block: DescribeGameServerInstancesRequest.Builder.() -> Unit): DescribeGameServerInstancesResponse = describeGameServerInstances(DescribeGameServerInstancesRequest.Builder().apply(block).build())

/**
 * Retrieves additional game session properties, including the game session protection policy in force, a set of one or more game sessions in a specific fleet location. You can optionally filter the results by current game session status.
 *
 * This operation can be used in the following ways:
 * + To retrieve details for all game sessions that are currently running on all locations in a fleet, provide a fleet or alias ID, with an optional status filter. This approach returns details from the fleet's home Region and all remote locations.
 * + To retrieve details for all game sessions that are currently running on a specific fleet location, provide a fleet or alias ID and a location name, with optional status filter. The location can be the fleet's home Region or any remote location.
 * + To retrieve details for a specific game session, provide the game session ID. This approach looks for the game session ID in all fleets that reside in the Amazon Web Services Region defined in the request.
 *
 * Use the pagination parameters to retrieve results as a set of sequential pages.
 *
 * If successful, a `GameSessionDetail` object is returned for each game session that matches the request.
 *
 * **Learn more**
 *
 * [Find a game session](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#gamelift-sdk-client-api-find)
 *
 * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public suspend inline fun GameLiftClient.describeGameSessionDetails(crossinline block: DescribeGameSessionDetailsRequest.Builder.() -> Unit): DescribeGameSessionDetailsResponse = describeGameSessionDetails(DescribeGameSessionDetailsRequest.Builder().apply(block).build())

/**
 * Retrieves information, including current status, about a game session placement request.
 *
 * To get game session placement details, specify the placement ID.
 *
 * This operation is not designed to be continually called to track game session status. This practice can cause you to exceed your API limit, which results in errors. Instead, you must configure an Amazon Simple Notification Service (SNS) topic to receive notifications from FlexMatch or queues. Continuously polling with `DescribeGameSessionPlacement` should only be used for games in development with low game session usage.
 */
public suspend inline fun GameLiftClient.describeGameSessionPlacement(crossinline block: DescribeGameSessionPlacementRequest.Builder.() -> Unit): DescribeGameSessionPlacementResponse = describeGameSessionPlacement(DescribeGameSessionPlacementRequest.Builder().apply(block).build())

/**
 * Retrieves the properties for one or more game session queues. When requesting multiple queues, use the pagination parameters to retrieve results as a set of sequential pages. When specifying a list of queues, objects are returned only for queues that currently exist in the Region.
 *
 * **Learn more**
 *
 * [ View Your Queues](https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-console.html)
 */
public suspend inline fun GameLiftClient.describeGameSessionQueues(crossinline block: DescribeGameSessionQueuesRequest.Builder.() -> Unit): DescribeGameSessionQueuesResponse = describeGameSessionQueues(DescribeGameSessionQueuesRequest.Builder().apply(block).build())

/**
 * Retrieves a set of one or more game sessions in a specific fleet location. You can optionally filter the results by current game session status.
 *
 * This operation can be used in the following ways:
 * + To retrieve all game sessions that are currently running on all locations in a fleet, provide a fleet or alias ID, with an optional status filter. This approach returns all game sessions in the fleet's home Region and all remote locations.
 * + To retrieve all game sessions that are currently running on a specific fleet location, provide a fleet or alias ID and a location name, with optional status filter. The location can be the fleet's home Region or any remote location.
 * + To retrieve a specific game session, provide the game session ID. This approach looks for the game session ID in all fleets that reside in the Amazon Web Services Region defined in the request.
 *
 * Use the pagination parameters to retrieve results as a set of sequential pages.
 *
 * If successful, a `GameSession` object is returned for each game session that matches the request.
 *
 * This operation is not designed to be continually called to track game session status. This practice can cause you to exceed your API limit, which results in errors. Instead, you must configure an Amazon Simple Notification Service (SNS) topic to receive notifications from FlexMatch or queues. Continuously polling with `DescribeGameSessions` should only be used for games in development with low game session usage.
 *
 * *Available in Amazon GameLift Servers Local.*
 *
 * **Learn more**
 *
 * [Find a game session](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#gamelift-sdk-client-api-find)
 *
 * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public suspend inline fun GameLiftClient.describeGameSessions(crossinline block: DescribeGameSessionsRequest.Builder.() -> Unit): DescribeGameSessionsResponse = describeGameSessions(DescribeGameSessionsRequest.Builder().apply(block).build())

/**
 * Retrieves information about the EC2 instances in an Amazon GameLift Servers managed fleet, including instance ID, connection data, and status. You can use this operation with a multi-location fleet to get location-specific instance information. As an alternative, use the operations [https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListCompute](https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListCompute) and [https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeCompute](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeCompute) to retrieve information for compute resources, including EC2 and Anywhere fleets.
 *
 * You can call this operation in the following ways:
 * + To get information on all instances in a fleet's home Region, specify the fleet ID.
 * + To get information on all instances in a fleet's remote location, specify the fleet ID and location name.
 * + To get information on a specific instance in a fleet, specify the fleet ID and instance ID.
 *
 * Use the pagination parameters to retrieve results as a set of sequential pages.
 *
 * If successful, this operation returns `Instance` objects for each requested instance, listed in no particular order. If you call this operation for an Anywhere fleet, you receive an InvalidRequestException.
 *
 * **Learn more**
 *
 * [Remotely connect to fleet instances](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-remote-access.html)
 *
 * [Debug fleet issues](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html)
 *
 * **Related actions**
 *
 * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public suspend inline fun GameLiftClient.describeInstances(crossinline block: DescribeInstancesRequest.Builder.() -> Unit): DescribeInstancesResponse = describeInstances(DescribeInstancesRequest.Builder().apply(block).build())

/**
 * Retrieves one or more matchmaking tickets. Use this operation to retrieve ticket information, including--after a successful match is made--connection information for the resulting new game session.
 *
 * To request matchmaking tickets, provide a list of up to 10 ticket IDs. If the request is successful, a ticket object is returned for each requested ID that currently exists.
 *
 * This operation is not designed to be continually called to track matchmaking ticket status. This practice can cause you to exceed your API limit, which results in errors. Instead, as a best practice, set up an Amazon Simple Notification Service to receive notifications, and provide the topic ARN in the matchmaking configuration.
 *
 * **Learn more**
 *
 * [ Add FlexMatch to a game client](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-client.html)
 *
 * [ Set Up FlexMatch event notification](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html)
 */
public suspend inline fun GameLiftClient.describeMatchmaking(crossinline block: DescribeMatchmakingRequest.Builder.() -> Unit): DescribeMatchmakingResponse = describeMatchmaking(DescribeMatchmakingRequest.Builder().apply(block).build())

/**
 * Retrieves the details of FlexMatch matchmaking configurations.
 *
 * This operation offers the following options: (1) retrieve all matchmaking configurations, (2) retrieve configurations for a specified list, or (3) retrieve all configurations that use a specified rule set name. When requesting multiple items, use the pagination parameters to retrieve results as a set of sequential pages.
 *
 * If successful, a configuration is returned for each requested name. When specifying a list of names, only configurations that currently exist are returned.
 *
 * **Learn more**
 *
 * [ Setting up FlexMatch matchmakers](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/matchmaker-build.html)
 */
public suspend inline fun GameLiftClient.describeMatchmakingConfigurations(crossinline block: DescribeMatchmakingConfigurationsRequest.Builder.() -> Unit): DescribeMatchmakingConfigurationsResponse = describeMatchmakingConfigurations(DescribeMatchmakingConfigurationsRequest.Builder().apply(block).build())

/**
 * Retrieves the details for FlexMatch matchmaking rule sets. You can request all existing rule sets for the Region, or provide a list of one or more rule set names. When requesting multiple items, use the pagination parameters to retrieve results as a set of sequential pages. If successful, a rule set is returned for each requested name.
 *
 * **Learn more**
 * + [Build a rule set](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html)
 */
public suspend inline fun GameLiftClient.describeMatchmakingRuleSets(crossinline block: DescribeMatchmakingRuleSetsRequest.Builder.() -> Unit): DescribeMatchmakingRuleSetsResponse = describeMatchmakingRuleSets(DescribeMatchmakingRuleSetsRequest.Builder().apply(block).build())

/**
 * Retrieves properties for one or more player sessions.
 *
 * This action can be used in the following ways:
 * + To retrieve a specific player session, provide the player session ID only.
 * + To retrieve all player sessions in a game session, provide the game session ID only.
 * + To retrieve all player sessions for a specific player, provide a player ID only.
 *
 * To request player sessions, specify either a player session ID, game session ID, or player ID. You can filter this request by player session status. If you provide a specific `PlayerSessionId` or `PlayerId`, Amazon GameLift Servers ignores the filter criteria. Use the pagination parameters to retrieve results as a set of sequential pages.
 *
 * If successful, a `PlayerSession` object is returned for each session that matches the request.
 *
 * **Related actions**
 *
 * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public suspend inline fun GameLiftClient.describePlayerSessions(crossinline block: DescribePlayerSessionsRequest.Builder.() -> Unit): DescribePlayerSessionsResponse = describePlayerSessions(DescribePlayerSessionsRequest.Builder().apply(block).build())

/**
 * Retrieves a fleet's runtime configuration settings. The runtime configuration determines which server processes run, and how, on computes in the fleet. For managed EC2 fleets, the runtime configuration describes server processes that run on each fleet instance. can update a fleet's runtime configuration at any time using [UpdateRuntimeConfiguration](https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateRuntimeConfiguration.html).
 *
 * To get the current runtime configuration for a fleet, provide the fleet ID.
 *
 * If successful, a `RuntimeConfiguration` object is returned for the requested fleet. If the requested fleet has been deleted, the result set is empty.
 *
 * **Learn more**
 *
 * [Setting up Amazon GameLift Servers fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
 *
 * [Running multiple processes on a fleet](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-multiprocess.html)
 */
public suspend inline fun GameLiftClient.describeRuntimeConfiguration(crossinline block: DescribeRuntimeConfigurationRequest.Builder.() -> Unit): DescribeRuntimeConfigurationResponse = describeRuntimeConfiguration(DescribeRuntimeConfigurationRequest.Builder().apply(block).build())

/**
 * Retrieves all scaling policies applied to a fleet.
 *
 * To get a fleet's scaling policies, specify the fleet ID. You can filter this request by policy status, such as to retrieve only active scaling policies. Use the pagination parameters to retrieve results as a set of sequential pages. If successful, set of `ScalingPolicy` objects is returned for the fleet.
 *
 * A fleet may have all of its scaling policies suspended. This operation does not affect the status of the scaling policies, which remains ACTIVE.
 */
public suspend inline fun GameLiftClient.describeScalingPolicies(crossinline block: DescribeScalingPoliciesRequest.Builder.() -> Unit): DescribeScalingPoliciesResponse = describeScalingPolicies(DescribeScalingPoliciesRequest.Builder().apply(block).build())

/**
 * Retrieves properties for a Realtime script.
 *
 * To request a script record, specify the script ID. If successful, an object containing the script properties is returned.
 *
 * **Learn more**
 *
 * [Amazon GameLift Servers Amazon GameLift Servers Realtime](https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html)
 *
 * **Related actions**
 *
 * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public suspend inline fun GameLiftClient.describeScript(crossinline block: DescribeScriptRequest.Builder.() -> Unit): DescribeScriptResponse = describeScript(DescribeScriptRequest.Builder().apply(block).build())

/**
 * Retrieves valid VPC peering authorizations that are pending for the Amazon Web Services account. This operation returns all VPC peering authorizations and requests for peering. This includes those initiated and received by this account.
 *
 * **Related actions**
 *
 * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public suspend inline fun GameLiftClient.describeVpcPeeringAuthorizations(crossinline block: DescribeVpcPeeringAuthorizationsRequest.Builder.() -> Unit): DescribeVpcPeeringAuthorizationsResponse = describeVpcPeeringAuthorizations(DescribeVpcPeeringAuthorizationsRequest.Builder().apply(block).build())

/**
 * Retrieves information on VPC peering connections. Use this operation to get peering information for all fleets or for one specific fleet ID.
 *
 * To retrieve connection information, call this operation from the Amazon Web Services account that is used to manage the Amazon GameLift Servers fleets. Specify a fleet ID or leave the parameter empty to retrieve all connection records. If successful, the retrieved information includes both active and pending connections. Active connections identify the IpV4 CIDR block that the VPC uses to connect.
 *
 * **Related actions**
 *
 * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public suspend inline fun GameLiftClient.describeVpcPeeringConnections(crossinline block: DescribeVpcPeeringConnectionsRequest.Builder.() -> Unit): DescribeVpcPeeringConnectionsResponse = describeVpcPeeringConnections(DescribeVpcPeeringConnectionsRequest.Builder().apply(block).build())

/**
 * Requests authorization to remotely connect to a hosting resource in a Amazon GameLift Servers managed fleet. This operation is not used with Amazon GameLift Servers Anywhere fleets.
 *
 * **Request options**
 *
 * Provide the fleet ID and compute name. The compute name varies depending on the type of fleet.
 * + For a compute in a managed EC2 fleet, provide an instance ID. Each instance in the fleet is a compute.
 * + For a compute in a managed container fleet, provide a compute name. In a container fleet, each game server container group on a fleet instance is assigned a compute name.
 *
 * **Results**
 *
 * If successful, this operation returns a set of temporary Amazon Web Services credentials, including a two-part access key and a session token.
 * + With a managed EC2 fleet (where compute type is `EC2`), use these credentials with Amazon EC2 Systems Manager (SSM) to start a session with the compute. For more details, see [ Starting a session (CLI)](https://docs.aws.amazon.com/systems-manager/latest/userguide/session-manager-working-with-sessions-start.html#sessions-start-cli) in the *Amazon EC2 Systems Manager User Guide*.
 */
public suspend inline fun GameLiftClient.getComputeAccess(crossinline block: GetComputeAccessRequest.Builder.() -> Unit): GetComputeAccessResponse = getComputeAccess(GetComputeAccessRequest.Builder().apply(block).build())

/**
 * Requests an authentication token from Amazon GameLift Servers for a compute resource in an Amazon GameLift Servers fleet. Game servers that are running on the compute use this token to communicate with the Amazon GameLift Servers service, such as when calling the Amazon GameLift Servers server SDK action `InitSDK()`. Authentication tokens are valid for a limited time span, so you need to request a fresh token before the current token expires.
 *
 * **Request options**
 * + For managed EC2 fleets (compute type `EC2`), auth token retrieval and refresh is handled automatically. All game servers that are running on all fleet instances have access to a valid auth token.
 * + For Anywhere fleets (compute type `ANYWHERE`), if you're using the Amazon GameLift Servers Agent, auth token retrieval and refresh is handled automatically for any compute where the Agent is running. If you're not using the Agent, create a mechanism to retrieve and refresh auth tokens for computes that are running game server processes.
 *
 * **Learn more**
 * + [Create an Anywhere fleet](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-anywhere.html)
 * + [Test your integration](https://docs.aws.amazon.com/gamelift/latest/developerguide/integration-testing.html)
 * + [Server SDK reference guides](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk.html) (for version 5.x)
 */
public suspend inline fun GameLiftClient.getComputeAuthToken(crossinline block: GetComputeAuthTokenRequest.Builder.() -> Unit): GetComputeAuthTokenResponse = getComputeAuthToken(GetComputeAuthTokenRequest.Builder().apply(block).build())

/**
 * Retrieves the location of stored game session logs for a specified game session on Amazon GameLift Servers managed fleets. When a game session is terminated, Amazon GameLift Servers automatically stores the logs in Amazon S3 and retains them for 14 days. Use this URL to download the logs.
 *
 * See the [Amazon Web Services Service Limits](https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_gamelift) page for maximum log file sizes. Log files that exceed this limit are not saved.
 *
 * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public suspend inline fun GameLiftClient.getGameSessionLogUrl(crossinline block: GetGameSessionLogUrlRequest.Builder.() -> Unit): GetGameSessionLogUrlResponse = getGameSessionLogUrl(GetGameSessionLogUrlRequest.Builder().apply(block).build())

/**
 * Requests authorization to remotely connect to an instance in an Amazon GameLift Servers managed fleet. Use this operation to connect to instances with game servers that use Amazon GameLift Servers server SDK 4.x or earlier. To connect to instances with game servers that use server SDK 5.x or later, call [https://docs.aws.amazon.com/gamelift/latest/apireference/API_GetComputeAccess](https://docs.aws.amazon.com/gamelift/latest/apireference/API_GetComputeAccess).
 *
 * To request access to an instance, specify IDs for the instance and the fleet it belongs to. You can retrieve instance IDs for a fleet by calling [DescribeInstances](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeInstances.html) with the fleet ID.
 *
 * If successful, this operation returns an IP address and credentials. The returned credentials match the operating system of the instance, as follows:
 * + For a Windows instance: returns a user name and secret (password) for use with a Windows Remote Desktop client.
 * + For a Linux instance: returns a user name and secret (RSA private key) for use with an SSH client. You must save the secret to a `.pem` file. If you're using the CLI, see the example [ Get credentials for a Linux instance](https://docs.aws.amazon.com/gamelift/latest/apireference/API_GetInstanceAccess.html#API_GetInstanceAccess_Examples) for tips on automatically saving the secret to a `.pem` file.
 *
 * **Learn more**
 *
 * [Remotely connect to fleet instances](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-remote-access.html)
 *
 * [Debug fleet issues](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html)
 *
 * **Related actions**
 *
 * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public suspend inline fun GameLiftClient.getInstanceAccess(crossinline block: GetInstanceAccessRequest.Builder.() -> Unit): GetInstanceAccessResponse = getInstanceAccess(GetInstanceAccessRequest.Builder().apply(block).build())

/**
 * Retrieves all aliases for this Amazon Web Services account. You can filter the result set by alias name and/or routing strategy type. Use the pagination parameters to retrieve results in sequential pages.
 *
 * Returned aliases are not listed in any particular order.
 *
 * **Related actions**
 *
 * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public suspend inline fun GameLiftClient.listAliases(crossinline block: ListAliasesRequest.Builder.() -> Unit): ListAliasesResponse = listAliases(ListAliasesRequest.Builder().apply(block).build())

/**
 * Retrieves build resources for all builds associated with the Amazon Web Services account in use. You can limit results to builds that are in a specific status by using the `Status` parameter. Use the pagination parameters to retrieve results in a set of sequential pages.
 *
 * Build resources are not listed in any particular order.
 *
 * **Learn more**
 *
 * [ Upload a Custom Server Build](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html)
 *
 * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public suspend inline fun GameLiftClient.listBuilds(crossinline block: ListBuildsRequest.Builder.() -> Unit): ListBuildsResponse = listBuilds(ListBuildsRequest.Builder().apply(block).build())

/**
 * Retrieves information on the compute resources in an Amazon GameLift Servers fleet. Use the pagination parameters to retrieve results in a set of sequential pages.
 *
 * **Request options**
 * + Retrieve a list of all computes in a fleet. Specify a fleet ID.
 * + Retrieve a list of all computes in a specific fleet location. Specify a fleet ID and location.
 *
 * **Results**
 *
 * If successful, this operation returns information on a set of computes. Depending on the type of fleet, the result includes the following information:
 * + For a managed EC2 fleet (compute type `EC2`), this operation returns information about the EC2 instance. Compute names are EC2 instance IDs.
 * + For an Anywhere fleet (compute type `ANYWHERE`), this operation returns compute names and details from when the compute was registered with `RegisterCompute`. This includes `GameLiftServiceSdkEndpoint` or `GameLiftAgentEndpoint`.
 */
public suspend inline fun GameLiftClient.listCompute(crossinline block: ListComputeRequest.Builder.() -> Unit): ListComputeResponse = listCompute(ListComputeRequest.Builder().apply(block).build())

/**
 * Retrieves a collection of container fleet resources in an Amazon Web Services Region. For fleets that have multiple locations, this operation retrieves fleets based on their home Region only.
 *
 * **Request options**
 * + Get a list of all fleets. Call this operation without specifying a container group definition.
 * + Get a list of fleets filtered by container group definition. Provide the container group definition name or ARN value.
 * + To get a list of all Amazon GameLift Servers Realtime fleets with a specific configuration script, provide the script ID.
 *
 * Use the pagination parameters to retrieve results as a set of sequential pages.
 *
 * If successful, this operation returns a collection of container fleets that match the request parameters. A NextToken value is also returned if there are more result pages to retrieve.
 *
 * Fleet IDs are returned in no particular order.
 */
public suspend inline fun GameLiftClient.listContainerFleets(crossinline block: ListContainerFleetsRequest.Builder.() -> Unit): ListContainerFleetsResponse = listContainerFleets(ListContainerFleetsRequest.Builder().apply(block).build())

/**
 * Retrieves all versions of a container group definition. Use the pagination parameters to retrieve results in a set of sequential pages.
 *
 * **Request options:**
 * + Get all versions of a specified container group definition. Specify the container group definition name or ARN value. (If the ARN value has a version number, it's ignored.)
 *
 * **Results:**
 *
 * If successful, this operation returns the complete properties of a set of container group definition versions that match the request.
 *
 * This operation returns the list of container group definitions in descending version order (latest first).
 *
 * **Learn more**
 * + [Manage a container group definition](https://docs.aws.amazon.com/gamelift/latest/developerguide/containers-create-groups.html)
 */
public suspend inline fun GameLiftClient.listContainerGroupDefinitionVersions(crossinline block: ListContainerGroupDefinitionVersionsRequest.Builder.() -> Unit): ListContainerGroupDefinitionVersionsResponse = listContainerGroupDefinitionVersions(ListContainerGroupDefinitionVersionsRequest.Builder().apply(block).build())

/**
 * Retrieves container group definitions for the Amazon Web Services account and Amazon Web Services Region. Use the pagination parameters to retrieve results in a set of sequential pages.
 *
 * This operation returns only the latest version of each definition. To retrieve all versions of a container group definition, use [ListContainerGroupDefinitionVersions](https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListContainerGroupDefinitionVersions.html).
 *
 * **Request options:**
 * + Retrieve the most recent versions of all container group definitions.
 * + Retrieve the most recent versions of all container group definitions, filtered by type. Specify the container group type to filter on.
 *
 * **Results:**
 *
 * If successful, this operation returns the complete properties of a set of container group definition versions that match the request.
 *
 * This operation returns the list of container group definitions in no particular order.
 */
public suspend inline fun GameLiftClient.listContainerGroupDefinitions(crossinline block: ListContainerGroupDefinitionsRequest.Builder.() -> Unit): ListContainerGroupDefinitionsResponse = listContainerGroupDefinitions(ListContainerGroupDefinitionsRequest.Builder().apply(block).build())

/**
 * Retrieves a collection of container fleet deployments in an Amazon Web Services Region. Use the pagination parameters to retrieve results as a set of sequential pages.
 *
 * **Request options**
 * + Get a list of all deployments. Call this operation without specifying a fleet ID.
 * + Get a list of all deployments for a fleet. Specify the container fleet ID or ARN value.
 *
 * **Results**
 *
 * If successful, this operation returns a list of deployments that match the request parameters. A NextToken value is also returned if there are more result pages to retrieve.
 *
 * Deployments are returned starting with the latest.
 */
public suspend inline fun GameLiftClient.listFleetDeployments(crossinline block: ListFleetDeploymentsRequest.Builder.() -> Unit): ListFleetDeploymentsResponse = listFleetDeployments(ListFleetDeploymentsRequest.Builder().apply(block).build())

/**
 * Retrieves a collection of fleet resources in an Amazon Web Services Region. You can filter the result set to find only those fleets that are deployed with a specific build or script. For fleets that have multiple locations, this operation retrieves fleets based on their home Region only.
 *
 * You can use operation in the following ways:
 * + To get a list of all fleets in a Region, don't provide a build or script identifier.
 * + To get a list of all fleets where a specific game build is deployed, provide the build ID.
 * + To get a list of all Amazon GameLift Servers Realtime fleets with a specific configuration script, provide the script ID.
 *
 * Use the pagination parameters to retrieve results as a set of sequential pages.
 *
 * If successful, this operation returns a list of fleet IDs that match the request parameters. A NextToken value is also returned if there are more result pages to retrieve.
 *
 * Fleet IDs are returned in no particular order.
 */
public suspend inline fun GameLiftClient.listFleets(crossinline block: ListFleetsRequest.Builder.() -> Unit): ListFleetsResponse = listFleets(ListFleetsRequest.Builder().apply(block).build())

/**
 * Lists a game server groups.
 */
public suspend inline fun GameLiftClient.listGameServerGroups(crossinline block: ListGameServerGroupsRequest.Builder.() -> Unit): ListGameServerGroupsResponse = listGameServerGroups(ListGameServerGroupsRequest.Builder().apply(block).build())

/**
 * **This operation is used with the Amazon GameLift Servers FleetIQ solution and game server groups.**
 *
 * Retrieves information on all game servers that are currently active in a specified game server group. You can opt to sort the list by game server age. Use the pagination parameters to retrieve results in a set of sequential segments.
 *
 * **Learn more**
 *
 * [Amazon GameLift Servers FleetIQ Guide](https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
 */
public suspend inline fun GameLiftClient.listGameServers(crossinline block: ListGameServersRequest.Builder.() -> Unit): ListGameServersResponse = listGameServers(ListGameServersRequest.Builder().apply(block).build())

/**
 * Lists all custom and Amazon Web Services locations where Amazon GameLift Servers can host game servers.
 *
 * Note that if you call this API using a location that doesn't have a service endpoint, such as one that can only be a remote location in a multi-location fleet, the API returns an error.
 *
 * Consult the table of supported locations in [Amazon GameLift Servers service locations](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html) to identify home Regions that support single and multi-location fleets.
 *
 * **Learn more**
 *
 * [Service locations](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html)
 */
public suspend inline fun GameLiftClient.listLocations(crossinline block: ListLocationsRequest.Builder.() -> Unit): ListLocationsResponse = listLocations(ListLocationsRequest.Builder().apply(block).build())

/**
 * Retrieves script records for all Realtime scripts that are associated with the Amazon Web Services account in use.
 *
 * **Learn more**
 *
 * [Amazon GameLift Servers Amazon GameLift Servers Realtime](https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html)
 *
 * **Related actions**
 *
 * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public suspend inline fun GameLiftClient.listScripts(crossinline block: ListScriptsRequest.Builder.() -> Unit): ListScriptsResponse = listScripts(ListScriptsRequest.Builder().apply(block).build())

/**
 * Retrieves all tags assigned to a Amazon GameLift Servers resource. Use resource tags to organize Amazon Web Services resources for a range of purposes. This operation handles the permissions necessary to manage tags for Amazon GameLift Servers resources that support tagging.
 *
 * To list tags for a resource, specify the unique ARN value for the resource.
 *
 * **Learn more**
 *
 * [Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference*
 *
 * [ Amazon Web Services Tagging Strategies](http://aws.amazon.com/answers/account-management/aws-tagging-strategies/)
 *
 * **Related actions**
 *
 * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public suspend inline fun GameLiftClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Creates or updates a scaling policy for a fleet. Scaling policies are used to automatically scale a fleet's hosting capacity to meet player demand. An active scaling policy instructs Amazon GameLift Servers to track a fleet metric and automatically change the fleet's capacity when a certain threshold is reached. There are two types of scaling policies: target-based and rule-based. Use a target-based policy to quickly and efficiently manage fleet scaling; this option is the most commonly used. Use rule-based policies when you need to exert fine-grained control over auto-scaling.
 *
 * Fleets can have multiple scaling policies of each type in force at the same time; you can have one target-based policy, one or multiple rule-based scaling policies, or both. We recommend caution, however, because multiple auto-scaling policies can have unintended consequences.
 *
 * Learn more about how to work with auto-scaling in [Set Up Fleet Automatic Scaling](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-autoscaling.html).
 *
 * **Target-based policy**
 *
 * A target-based policy tracks a single metric: PercentAvailableGameSessions. This metric tells us how much of a fleet's hosting capacity is ready to host game sessions but is not currently in use. This is the fleet's buffer; it measures the additional player demand that the fleet could handle at current capacity. With a target-based policy, you set your ideal buffer size and leave it to Amazon GameLift Servers to take whatever action is needed to maintain that target.
 *
 * For example, you might choose to maintain a 10% buffer for a fleet that has the capacity to host 100 simultaneous game sessions. This policy tells Amazon GameLift Servers to take action whenever the fleet's available capacity falls below or rises above 10 game sessions. Amazon GameLift Servers will start new instances or stop unused instances in order to return to the 10% buffer.
 *
 * To create or update a target-based policy, specify a fleet ID and name, and set the policy type to "TargetBased". Specify the metric to track (PercentAvailableGameSessions) and reference a `TargetConfiguration` object with your desired buffer value. Exclude all other parameters. On a successful request, the policy name is returned. The scaling policy is automatically in force as soon as it's successfully created. If the fleet's auto-scaling actions are temporarily suspended, the new policy will be in force once the fleet actions are restarted.
 *
 * **Rule-based policy**
 *
 * A rule-based policy tracks specified fleet metric, sets a threshold value, and specifies the type of action to initiate when triggered. With a rule-based policy, you can select from several available fleet metrics. Each policy specifies whether to scale up or scale down (and by how much), so you need one policy for each type of action.
 *
 * For example, a policy may make the following statement: "If the percentage of idle instances is greater than 20% for more than 15 minutes, then reduce the fleet capacity by 10%."
 *
 * A policy's rule statement has the following structure:
 *
 * If `[MetricName]` is `[ComparisonOperator]``[Threshold]` for `[EvaluationPeriods]` minutes, then `[ScalingAdjustmentType]` to/by `[ScalingAdjustment]`.
 *
 * To implement the example, the rule statement would look like this:
 *
 * If `[PercentIdleInstances]` is `[GreaterThanThreshold]``[20]` for `[15]` minutes, then `[PercentChangeInCapacity]` to/by `[10]`.
 *
 * To create or update a scaling policy, specify a unique combination of name and fleet ID, and set the policy type to "RuleBased". Specify the parameter values for a policy rule statement. On a successful request, the policy name is returned. Scaling policies are automatically in force as soon as they're successfully created. If the fleet's auto-scaling actions are temporarily suspended, the new policy will be in force once the fleet actions are restarted.
 */
public suspend inline fun GameLiftClient.putScalingPolicy(crossinline block: PutScalingPolicyRequest.Builder.() -> Unit): PutScalingPolicyResponse = putScalingPolicy(PutScalingPolicyRequest.Builder().apply(block).build())

/**
 * Registers a compute resource in an Amazon GameLift Servers Anywhere fleet.
 *
 * For an Anywhere fleet that's running the Amazon GameLift Servers Agent, the Agent handles all compute registry tasks for you. For an Anywhere fleet that doesn't use the Agent, call this operation to register fleet computes.
 *
 * To register a compute, give the compute a name (must be unique within the fleet) and specify the compute resource's DNS name or IP address. Provide a fleet ID and a fleet location to associate with the compute being registered. You can optionally include the path to a TLS certificate on the compute resource.
 *
 * If successful, this operation returns compute details, including an Amazon GameLift Servers SDK endpoint or Agent endpoint. Game server processes running on the compute can use this endpoint to communicate with the Amazon GameLift Servers service. Each server process includes the SDK endpoint in its call to the Amazon GameLift Servers server SDK action `InitSDK()`.
 *
 * To view compute details, call [DescribeCompute](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeCompute.html) with the compute name.
 *
 * **Learn more**
 * + [Create an Anywhere fleet](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-anywhere.html)
 * + [Test your integration](https://docs.aws.amazon.com/gamelift/latest/developerguide/integration-testing.html)
 * + [Server SDK reference guides](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk.html) (for version 5.x)
 */
public suspend inline fun GameLiftClient.registerCompute(crossinline block: RegisterComputeRequest.Builder.() -> Unit): RegisterComputeResponse = registerCompute(RegisterComputeRequest.Builder().apply(block).build())

/**
 * **This operation is used with the Amazon GameLift Servers FleetIQ solution and game server groups.**
 *
 * Creates a new game server resource and notifies Amazon GameLift Servers FleetIQ that the game server is ready to host gameplay and players. This operation is called by a game server process that is running on an instance in a game server group. Registering game servers enables Amazon GameLift Servers FleetIQ to track available game servers and enables game clients and services to claim a game server for a new game session.
 *
 * To register a game server, identify the game server group and instance where the game server is running, and provide a unique identifier for the game server. You can also include connection and game server data.
 *
 * Once a game server is successfully registered, it is put in status `AVAILABLE`. A request to register a game server may fail if the instance it is running on is in the process of shutting down as part of instance balancing or scale-down activity.
 *
 * **Learn more**
 *
 * [Amazon GameLift Servers FleetIQ Guide](https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
 */
public suspend inline fun GameLiftClient.registerGameServer(crossinline block: RegisterGameServerRequest.Builder.() -> Unit): RegisterGameServerResponse = registerGameServer(RegisterGameServerRequest.Builder().apply(block).build())

/**
 * Retrieves a fresh set of credentials for use when uploading a new set of game build files to Amazon GameLift Servers's Amazon S3. This is done as part of the build creation process; see [CreateBuild](https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateBuild.html).
 *
 * To request new credentials, specify the build ID as returned with an initial `CreateBuild` request. If successful, a new set of credentials are returned, along with the S3 storage location associated with the build ID.
 *
 * **Learn more**
 *
 * [ Create a Build with Files in S3](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-cli-uploading.html#gamelift-build-cli-uploading-create-build)
 *
 * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public suspend inline fun GameLiftClient.requestUploadCredentials(crossinline block: RequestUploadCredentialsRequest.Builder.() -> Unit): RequestUploadCredentialsResponse = requestUploadCredentials(RequestUploadCredentialsRequest.Builder().apply(block).build())

/**
 * Attempts to retrieve a fleet ID that is associated with an alias. Specify a unique alias identifier.
 *
 * If the alias has a `SIMPLE` routing strategy, Amazon GameLift Servers returns a fleet ID. If the alias has a `TERMINAL` routing strategy, the result is a `TerminalRoutingStrategyException`.
 *
 * **Related actions**
 *
 * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public suspend inline fun GameLiftClient.resolveAlias(crossinline block: ResolveAliasRequest.Builder.() -> Unit): ResolveAliasResponse = resolveAlias(ResolveAliasRequest.Builder().apply(block).build())

/**
 * **This operation is used with the Amazon GameLift Servers FleetIQ solution and game server groups.**
 *
 * Reinstates activity on a game server group after it has been suspended. A game server group might be suspended by the [SuspendGameServerGroup](gamelift/latest/apireference/API_SuspendGameServerGroup.html) operation, or it might be suspended involuntarily due to a configuration problem. In the second case, you can manually resume activity on the group once the configuration problem has been resolved. Refer to the game server group status and status reason for more information on why group activity is suspended.
 *
 * To resume activity, specify a game server group ARN and the type of activity to be resumed. If successful, a `GameServerGroup` object is returned showing that the resumed activity is no longer listed in `SuspendedActions`.
 *
 * **Learn more**
 *
 * [Amazon GameLift Servers FleetIQ Guide](https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
 */
public suspend inline fun GameLiftClient.resumeGameServerGroup(crossinline block: ResumeGameServerGroupRequest.Builder.() -> Unit): ResumeGameServerGroupResponse = resumeGameServerGroup(ResumeGameServerGroupRequest.Builder().apply(block).build())

/**
 * Retrieves all active game sessions that match a set of search criteria and sorts them into a specified order.
 *
 * This operation is not designed to continually track game session status because that practice can cause you to exceed your API limit and generate errors. Instead, configure an Amazon Simple Notification Service (Amazon SNS) topic to receive notifications from a matchmaker or a game session placement queue.
 *
 * When searching for game sessions, you specify exactly where you want to search and provide a search filter expression, a sort expression, or both. A search request can search only one fleet, but it can search all of a fleet's locations.
 *
 * This operation can be used in the following ways:
 * + To search all game sessions that are currently running on all locations in a fleet, provide a fleet or alias ID. This approach returns game sessions in the fleet's home Region and all remote locations that fit the search criteria.
 * + To search all game sessions that are currently running on a specific fleet location, provide a fleet or alias ID and a location name. For location, you can specify a fleet's home Region or any remote location.
 *
 * Use the pagination parameters to retrieve results as a set of sequential pages.
 *
 * If successful, a `GameSession` object is returned for each game session that matches the request. Search finds game sessions that are in `ACTIVE` status only. To retrieve information on game sessions in other statuses, use [DescribeGameSessions](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameSessions.html).
 *
 * To set search and sort criteria, create a filter expression using the following game session attributes. For game session search examples, see the Examples section of this topic.
 * + **gameSessionId** -- A unique identifier for the game session. You can use either a `GameSessionId` or `GameSessionArn` value.
 * + **gameSessionName** -- Name assigned to a game session. Game session names do not need to be unique to a game session.
 * + **gameSessionProperties** -- A set of key-value pairs that can store custom data in a game session. For example: `{"Key": "difficulty", "Value": "novice"}`. The filter expression must specify the [https://docs.aws.amazon.com/gamelift/latest/apireference/API_GameProperty](https://docs.aws.amazon.com/gamelift/latest/apireference/API_GameProperty) -- a `Key` and a string `Value` to search for the game sessions.For example, to search for the above key-value pair, specify the following search filter: `gameSessionProperties.difficulty = "novice"`. All game property values are searched as strings. For examples of searching game sessions, see the ones below, and also see [Search game sessions by game property](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#game-properties-search).
 * + **maximumSessions** -- Maximum number of player sessions allowed for a game session.
 * + **creationTimeMillis** -- Value indicating when a game session was created. It is expressed in Unix time as milliseconds.
 * + **playerSessionCount** -- Number of players currently connected to a game session. This value changes rapidly as players join the session or drop out.
 * + **hasAvailablePlayerSessions** -- Boolean value indicating whether a game session has reached its maximum number of players. It is highly recommended that all search requests include this filter attribute to optimize search performance and return only sessions that players can join.
 *
 * Returned values for `playerSessionCount` and `hasAvailablePlayerSessions` change quickly as players join sessions and others drop out. Results should be considered a snapshot in time. Be sure to refresh search results often, and handle sessions that fill up before a player can join.
 *
 * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public suspend inline fun GameLiftClient.searchGameSessions(crossinline block: SearchGameSessionsRequest.Builder.() -> Unit): SearchGameSessionsResponse = searchGameSessions(SearchGameSessionsRequest.Builder().apply(block).build())

/**
 * Resumes certain types of activity on fleet instances that were suspended with [StopFleetActions](https://docs.aws.amazon.com/gamelift/latest/apireference/API_StopFleetActions.html). For multi-location fleets, fleet actions are managed separately for each location. Currently, this operation is used to restart a fleet's auto-scaling activity.
 *
 * This operation can be used in the following ways:
 * + To restart actions on instances in the fleet's home Region, provide a fleet ID and the type of actions to resume.
 * + To restart actions on instances in one of the fleet's remote locations, provide a fleet ID, a location name, and the type of actions to resume.
 *
 * If successful, Amazon GameLift Servers once again initiates scaling events as triggered by the fleet's scaling policies. If actions on the fleet location were never stopped, this operation will have no effect.
 *
 * **Learn more**
 *
 * [Setting up Amazon GameLift Servers fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
 */
public suspend inline fun GameLiftClient.startFleetActions(crossinline block: StartFleetActionsRequest.Builder.() -> Unit): StartFleetActionsResponse = startFleetActions(StartFleetActionsRequest.Builder().apply(block).build())

/**
 * Makes a request to start a new game session using a game session queue. When processing a placement request, Amazon GameLift Servers looks for the best possible available resource to host the game session, based on how the queue is configured to prioritize factors such as resource cost, latency, and location. After selecting an available resource, Amazon GameLift Servers prompts the resource to start a game session. A placement request can include a list of players to create a set of player sessions. The request can also include information to pass to the new game session, such as to specify a game map or other options.
 *
 * **Request options**
 *
 * Use this operation to make the following types of requests.
 * + Request a placement using the queue's default prioritization process (see the default prioritization described in [PriorityConfiguration](https://docs.aws.amazon.com/gamelift/latest/apireference/API_PriorityConfiguration.html)). Include these required parameters:
 *    + `GameSessionQueueName`
 *    + `MaximumPlayerSessionCount`
 *    + `PlacementID`
 * + Request a placement and prioritize based on latency. Include these parameters:
 *    + Required parameters `GameSessionQueueName`, `MaximumPlayerSessionCount`, `PlacementID`.
 *    + `PlayerLatencies`. Include a set of latency values for destinations in the queue. When a request includes latency data, Amazon GameLift Servers automatically reorder the queue's locations priority list based on lowest available latency values. If a request includes latency data for multiple players, Amazon GameLift Servers calculates each location's average latency for all players and reorders to find the lowest latency across all players.
 *    + Don't include `PriorityConfigurationOverride`.
 *    + Prioritize based on a custom list of locations. If you're using a queue that's configured to prioritize location first (see [PriorityConfiguration](https://docs.aws.amazon.com/gamelift/latest/apireference/API_PriorityConfiguration.html) for game session queues), you can optionally use the *PriorityConfigurationOverride* parameter to substitute a different location priority list for this placement request. Amazon GameLift Servers searches each location on the priority override list to find an available hosting resource for the new game session. Specify a fallback strategy to use in the event that Amazon GameLift Servers fails to place the game session in any of the locations on the override list.
 * + Request a placement and prioritized based on a custom list of locations.
 * + You can request new player sessions for a group of players. Include the *DesiredPlayerSessions* parameter and include at minimum a unique player ID for each. You can also include player-specific data to pass to the new game session.
 *
 * **Result**
 *
 * If successful, this operation generates a new game session placement request and adds it to the game session queue for processing. You can track the status of individual placement requests by calling [DescribeGameSessionPlacement](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameSessionPlacement.html) or by monitoring queue notifications. When the request status is `FULFILLED`, a new game session has started and the placement request is updated with connection information for the game session (IP address and port). If the request included player session data, Amazon GameLift Servers creates a player session for each player ID in the request.
 *
 * The request results in a `InvalidRequestException` in the following situations:
 * + If the request includes both *PlayerLatencies* and *PriorityConfigurationOverride* parameters.
 * + If the request includes the *PriorityConfigurationOverride* parameter and specifies a queue that doesn't prioritize locations.
 *
 * Amazon GameLift Servers continues to retry each placement request until it reaches the queue's timeout setting. If a request times out, you can resubmit the request to the same queue or try a different queue.
 */
public suspend inline fun GameLiftClient.startGameSessionPlacement(crossinline block: StartGameSessionPlacementRequest.Builder.() -> Unit): StartGameSessionPlacementResponse = startGameSessionPlacement(StartGameSessionPlacementRequest.Builder().apply(block).build())

/**
 * Finds new players to fill open slots in currently running game sessions. The backfill match process is essentially identical to the process of forming new matches. Backfill requests use the same matchmaker that was used to make the original match, and they provide matchmaking data for all players currently in the game session. FlexMatch uses this information to select new players so that backfilled match continues to meet the original match requirements.
 *
 * When using FlexMatch with Amazon GameLift Servers managed hosting, you can request a backfill match from a client service by calling this operation with a `GameSessions` ID. You also have the option of making backfill requests directly from your game server. In response to a request, FlexMatch creates player sessions for the new players, updates the `GameSession` resource, and sends updated matchmaking data to the game server. You can request a backfill match at any point after a game session is started. Each game session can have only one active backfill request at a time; a subsequent request automatically replaces the earlier request.
 *
 * When using FlexMatch as a standalone component, request a backfill match by calling this operation without a game session identifier. As with newly formed matches, matchmaking results are returned in a matchmaking event so that your game can update the game session that is being backfilled.
 *
 * To request a backfill match, specify a unique ticket ID, the original matchmaking configuration, and matchmaking data for all current players in the game session being backfilled. Optionally, specify the `GameSession` ARN. If successful, a match backfill ticket is created and returned with status set to QUEUED. Track the status of backfill tickets using the same method for tracking tickets for new matches.
 *
 * Only game sessions created by FlexMatch are supported for match backfill.
 *
 * **Learn more**
 *
 * [ Backfill existing games with FlexMatch](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-backfill.html)
 *
 * [ Matchmaking events](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html) (reference)
 *
 * [ How Amazon GameLift Servers FlexMatch works](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/gamelift-match.html)
 */
public suspend inline fun GameLiftClient.startMatchBackfill(crossinline block: StartMatchBackfillRequest.Builder.() -> Unit): StartMatchBackfillResponse = startMatchBackfill(StartMatchBackfillRequest.Builder().apply(block).build())

/**
 * Uses FlexMatch to create a game match for a group of players based on custom matchmaking rules. With games that use Amazon GameLift Servers managed hosting, this operation also triggers Amazon GameLift Servers to find hosting resources and start a new game session for the new match. Each matchmaking request includes information on one or more players and specifies the FlexMatch matchmaker to use. When a request is for multiple players, FlexMatch attempts to build a match that includes all players in the request, placing them in the same team and finding additional players as needed to fill the match.
 *
 * To start matchmaking, provide a unique ticket ID, specify a matchmaking configuration, and include the players to be matched. You must also include any player attributes that are required by the matchmaking configuration's rule set. If successful, a matchmaking ticket is returned with status set to `QUEUED`.
 *
 * Track matchmaking events to respond as needed and acquire game session connection information for successfully completed matches. Ticket status updates are tracked using event notification through Amazon Simple Notification Service, which is defined in the matchmaking configuration.
 *
 * **Learn more**
 *
 * [ Add FlexMatch to a game client](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-client.html)
 *
 * [ Set Up FlexMatch event notification](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html)
 *
 * [ How Amazon GameLift Servers FlexMatch works](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/gamelift-match.html)
 */
public suspend inline fun GameLiftClient.startMatchmaking(crossinline block: StartMatchmakingRequest.Builder.() -> Unit): StartMatchmakingResponse = startMatchmaking(StartMatchmakingRequest.Builder().apply(block).build())

/**
 * Suspends certain types of activity in a fleet location. Currently, this operation is used to stop auto-scaling activity. For multi-location fleets, fleet actions are managed separately for each location.
 *
 * Stopping fleet actions has several potential purposes. It allows you to temporarily stop auto-scaling activity but retain your scaling policies for use in the future. For multi-location fleets, you can set up fleet-wide auto-scaling, and then opt out of it for certain locations.
 *
 * This operation can be used in the following ways:
 * + To stop actions on instances in the fleet's home Region, provide a fleet ID and the type of actions to suspend.
 * + To stop actions on instances in one of the fleet's remote locations, provide a fleet ID, a location name, and the type of actions to suspend.
 *
 * If successful, Amazon GameLift Servers no longer initiates scaling events except in response to manual changes using [UpdateFleetCapacity](https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateFleetCapacity.html). To restart fleet actions again, call [StartFleetActions](https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartFleetActions.html).
 *
 * **Learn more**
 *
 * [Setting up Amazon GameLift Servers Fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
 */
public suspend inline fun GameLiftClient.stopFleetActions(crossinline block: StopFleetActionsRequest.Builder.() -> Unit): StopFleetActionsResponse = stopFleetActions(StopFleetActionsRequest.Builder().apply(block).build())

/**
 * Cancels a game session placement that's in `PENDING` status. To stop a placement, provide the placement ID value.
 *
 * Results
 *
 * If successful, this operation removes the placement request from the queue and moves the `GameSessionPlacement` to `CANCELLED` status.
 *
 * This operation results in an `InvalidRequestExecption` (400) error if a game session has already been created for this placement. You can clean up an unneeded game session by calling [TerminateGameSession](https://docs.aws.amazon.com/gamelift/latest/apireference/API_TerminateGameSession).
 */
public suspend inline fun GameLiftClient.stopGameSessionPlacement(crossinline block: StopGameSessionPlacementRequest.Builder.() -> Unit): StopGameSessionPlacementResponse = stopGameSessionPlacement(StopGameSessionPlacementRequest.Builder().apply(block).build())

/**
 * Cancels a matchmaking ticket or match backfill ticket that is currently being processed. To stop the matchmaking operation, specify the ticket ID. If successful, work on the ticket is stopped, and the ticket status is changed to `CANCELLED`.
 *
 * This call is also used to turn off automatic backfill for an individual game session. This is for game sessions that are created with a matchmaking configuration that has automatic backfill enabled. The ticket ID is included in the `MatchmakerData` of an updated game session object, which is provided to the game server.
 *
 * If the operation is successful, the service sends back an empty JSON struct with the HTTP 200 response (not an empty HTTP body).
 *
 * **Learn more**
 *
 * [ Add FlexMatch to a game client](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-client.html)
 */
public suspend inline fun GameLiftClient.stopMatchmaking(crossinline block: StopMatchmakingRequest.Builder.() -> Unit): StopMatchmakingResponse = stopMatchmaking(StopMatchmakingRequest.Builder().apply(block).build())

/**
 * **This operation is used with the Amazon GameLift Servers FleetIQ solution and game server groups.**
 *
 * Temporarily stops activity on a game server group without terminating instances or the game server group. You can restart activity by calling [ResumeGameServerGroup](gamelift/latest/apireference/API_ResumeGameServerGroup.html). You can suspend the following activity:
 * + **Instance type replacement** - This activity evaluates the current game hosting viability of all Spot instance types that are defined for the game server group. It updates the Auto Scaling group to remove nonviable Spot Instance types, which have a higher chance of game server interruptions. It then balances capacity across the remaining viable Spot Instance types. When this activity is suspended, the Auto Scaling group continues with its current balance, regardless of viability. Instance protection, utilization metrics, and capacity scaling activities continue to be active.
 *
 * To suspend activity, specify a game server group ARN and the type of activity to be suspended. If successful, a `GameServerGroup` object is returned showing that the activity is listed in `SuspendedActions`.
 *
 * **Learn more**
 *
 * [Amazon GameLift Servers FleetIQ Guide](https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
 */
public suspend inline fun GameLiftClient.suspendGameServerGroup(crossinline block: SuspendGameServerGroupRequest.Builder.() -> Unit): SuspendGameServerGroupResponse = suspendGameServerGroup(SuspendGameServerGroupRequest.Builder().apply(block).build())

/**
 * Assigns a tag to an Amazon GameLift Servers resource. You can use tags to organize resources, create IAM permissions policies to manage access to groups of resources, customize Amazon Web Services cost breakdowns, and more. This operation handles the permissions necessary to manage tags for Amazon GameLift Servers resources that support tagging.
 *
 * To add a tag to a resource, specify the unique ARN value for the resource and provide a tag list containing one or more tags. The operation succeeds even if the list includes tags that are already assigned to the resource.
 *
 * **Learn more**
 *
 * [Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference*
 *
 * [ Amazon Web Services Tagging Strategies](http://aws.amazon.com/answers/account-management/aws-tagging-strategies/)
 *
 * **Related actions**
 *
 * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public suspend inline fun GameLiftClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Ends a game session that's currently in progress. Use this action to terminate any game session that isn't in `ERROR` status. Terminating a game session is the most efficient way to free up a server process when it's hosting a game session that's in a bad state or not ending properly. You can use this action to terminate a game session that's being hosted on any type of Amazon GameLift Servers fleet compute, including computes for managed EC2, managed container, and Anywhere fleets. The game server must be integrated with Amazon GameLift Servers server SDK 5.x or greater.
 *
 * **Request options**
 *
 * Request termination for a single game session. Provide the game session ID and the termination mode. There are two potential methods for terminating a game session:
 * + Initiate a graceful termination using the normal game session shutdown sequence. With this mode, the Amazon GameLift Servers service prompts the server process that's hosting the game session by calling the server SDK callback method `OnProcessTerminate()`. The callback implementation is part of the custom game server code. It might involve a variety of actions to gracefully end a game session, such as notifying players, before stopping the server process.
 * + Force an immediate game session termination. With this mode, the Amazon GameLift Servers service takes action to stop the server process, which ends the game session without the normal game session shutdown sequence.
 *
 * **Results**
 *
 * If successful, game session termination is initiated. During this activity, the game session status is changed to `TERMINATING`. When completed, the server process that was hosting the game session has been stopped and replaced with a new server process that's ready to host a new game session. The old game session's status is changed to `TERMINATED` with a status reason that indicates the termination method used.
 *
 * **Learn more**
 *
 * [Add Amazon GameLift Servers to your game server](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html)
 *
 * Amazon GameLift Servers server SDK 5 reference guide for `OnProcessTerminate()` ([C++](https://docs.aws.amazon.com/gamelift/latest/developerguide/integration-server-sdk5-cpp-initsdk.html)) ([C#](https://docs.aws.amazon.com/gamelift/latest/developerguide/integration-server-sdk5-csharp-initsdk.html)) ([Unreal](https://docs.aws.amazon.com/gamelift/latest/developerguide/integration-server-sdk5-unreal-initsdk.html)) ([Go](https://docs.aws.amazon.com/gamelift/latest/developerguide/integration-server-sdk-go-initsdk.html))
 */
public suspend inline fun GameLiftClient.terminateGameSession(crossinline block: TerminateGameSessionRequest.Builder.() -> Unit): TerminateGameSessionResponse = terminateGameSession(TerminateGameSessionRequest.Builder().apply(block).build())

/**
 * Removes a tag assigned to a Amazon GameLift Servers resource. You can use resource tags to organize Amazon Web Services resources for a range of purposes. This operation handles the permissions necessary to manage tags for Amazon GameLift Servers resources that support tagging.
 *
 * To remove a tag from a resource, specify the unique ARN value for the resource and provide a string list containing one or more tags to remove. This operation succeeds even if the list includes tags that aren't assigned to the resource.
 *
 * **Learn more**
 *
 * [Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference*
 *
 * [ Amazon Web Services Tagging Strategies](http://aws.amazon.com/answers/account-management/aws-tagging-strategies/)
 *
 * **Related actions**
 *
 * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public suspend inline fun GameLiftClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates properties for an alias. Specify the unique identifier of the alias to be updated and the new property values. When reassigning an alias to a new fleet, provide an updated routing strategy. If successful, the updated alias record is returned.
 *
 * **Related actions**
 *
 * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public suspend inline fun GameLiftClient.updateAlias(crossinline block: UpdateAliasRequest.Builder.() -> Unit): UpdateAliasResponse = updateAlias(UpdateAliasRequest.Builder().apply(block).build())

/**
 * Updates metadata in a build resource, including the build name and version. To update the metadata, specify the build ID to update and provide the new values. If successful, a build object containing the updated metadata is returned.
 *
 * **Learn more**
 *
 * [ Upload a Custom Server Build](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html)
 *
 * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public suspend inline fun GameLiftClient.updateBuild(crossinline block: UpdateBuildRequest.Builder.() -> Unit): UpdateBuildResponse = updateBuild(UpdateBuildRequest.Builder().apply(block).build())

/**
 * Updates the properties of a managed container fleet. Depending on the properties being updated, this operation might initiate a fleet deployment. You can track deployments for a fleet using [https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetDeployment.html](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetDeployment.html).
 *
 * **Request options**
 *
 * As with CreateContainerFleet, many fleet properties use common defaults or are calculated based on the fleet's container group definitions.
 * + Update fleet properties that result in a fleet deployment. Include only those properties that you want to change. Specify deployment configuration settings.
 * + Update fleet properties that don't result in a fleet deployment. Include only those properties that you want to change.
 *
 * Changes to the following properties initiate a fleet deployment:
 * + `GameServerContainerGroupDefinition`
 * + `PerInstanceContainerGroupDefinition`
 * + `GameServerContainerGroupsPerInstance`
 * + `InstanceInboundPermissions`
 * + `InstanceConnectionPortRange`
 * + `LogConfiguration`
 *
 * **Results**
 *
 * If successful, this operation updates the container fleet resource, and might initiate a new deployment of fleet resources using the deployment configuration provided. A deployment replaces existing fleet instances with new instances that are deployed with the updated fleet properties. The fleet is placed in `UPDATING` status until the deployment is complete, then return to `ACTIVE`.
 *
 * You can have only one update deployment active at a time for a fleet. If a second update request initiates a deployment while another deployment is in progress, the first deployment is cancelled.
 */
public suspend inline fun GameLiftClient.updateContainerFleet(crossinline block: UpdateContainerFleetRequest.Builder.() -> Unit): UpdateContainerFleetResponse = updateContainerFleet(UpdateContainerFleetRequest.Builder().apply(block).build())

/**
 * Updates properties in an existing container group definition. This operation doesn't replace the definition. Instead, it creates a new version of the definition and saves it separately. You can access all versions that you choose to retain.
 *
 * The only property you can't update is the container group type.
 *
 * **Request options:**
 * + Update based on the latest version of the container group definition. Specify the container group definition name only, or use an ARN value without a version number. Provide updated values for the properties that you want to change only. All other values remain the same as the latest version.
 * + Update based on a specific version of the container group definition. Specify the container group definition name and a source version number, or use an ARN value with a version number. Provide updated values for the properties that you want to change only. All other values remain the same as the source version.
 * + Change a game server container definition. Provide the updated container definition.
 * + Add or change a support container definition. Provide a complete set of container definitions, including the updated definition.
 * + Remove a support container definition. Provide a complete set of container definitions, excluding the definition to remove. If the container group has only one support container definition, provide an empty set.
 *
 * **Results:**
 *
 * If successful, this operation returns the complete properties of the new container group definition version.
 *
 * If the container group definition version is used in an active fleets, the update automatically initiates a new fleet deployment of the new version. You can track a fleet's deployments using [ListFleetDeployments](https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListFleetDeployments.html).
 */
public suspend inline fun GameLiftClient.updateContainerGroupDefinition(crossinline block: UpdateContainerGroupDefinitionRequest.Builder.() -> Unit): UpdateContainerGroupDefinitionResponse = updateContainerGroupDefinition(UpdateContainerGroupDefinitionRequest.Builder().apply(block).build())

/**
 * Updates a fleet's mutable attributes, such as game session protection and resource creation limits.
 *
 * To update fleet attributes, specify the fleet ID and the property values that you want to change. If successful, Amazon GameLift Servers returns the identifiers for the updated fleet.
 *
 * **Learn more**
 *
 * [Setting up Amazon GameLift Servers fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
 */
public suspend inline fun GameLiftClient.updateFleetAttributes(crossinline block: UpdateFleetAttributesRequest.Builder.() -> Unit): UpdateFleetAttributesResponse = updateFleetAttributes(UpdateFleetAttributesRequest.Builder().apply(block).build())

/**
 * Updates capacity settings for a managed EC2 fleet or managed container fleet. For these fleets, you adjust capacity by changing the number of instances in the fleet. Fleet capacity determines the number of game sessions and players that the fleet can host based on its configuration. For fleets with multiple locations, use this operation to manage capacity settings in each location individually.
 *
 * Use this operation to set these fleet capacity properties:
 * + Minimum/maximum size: Set hard limits on the number of Amazon EC2 instances allowed. If Amazon GameLift Servers receives a request--either through manual update or automatic scaling--it won't change the capacity to a value outside of this range.
 * + Desired capacity: As an alternative to automatic scaling, manually set the number of Amazon EC2 instances to be maintained. Before changing a fleet's desired capacity, check the maximum capacity of the fleet's Amazon EC2 instance type by calling [DescribeEC2InstanceLimits](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeEC2InstanceLimits.html).
 *
 * To update capacity for a fleet's home Region, or if the fleet has no remote locations, omit the `Location` parameter. The fleet must be in `ACTIVE` status.
 *
 * To update capacity for a fleet's remote location, set the `Location` parameter to the location to update. The location must be in `ACTIVE` status.
 *
 * If successful, Amazon GameLift Servers updates the capacity settings and returns the identifiers for the updated fleet and/or location. If a requested change to desired capacity exceeds the instance type's limit, the `LimitExceeded` exception occurs.
 *
 * Updates often prompt an immediate change in fleet capacity, such as when current capacity is different than the new desired capacity or outside the new limits. In this scenario, Amazon GameLift Servers automatically initiates steps to add or remove instances in the fleet location. You can track a fleet's current capacity by calling [DescribeFleetCapacity](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetCapacity.html) or [DescribeFleetLocationCapacity](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationCapacity.html).
 *
 * **Learn more**
 *
 * [Scaling fleet capacity](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-manage-capacity.html)
 */
public suspend inline fun GameLiftClient.updateFleetCapacity(crossinline block: UpdateFleetCapacityRequest.Builder.() -> Unit): UpdateFleetCapacityResponse = updateFleetCapacity(UpdateFleetCapacityRequest.Builder().apply(block).build())

/**
 * Updates permissions that allow inbound traffic to connect to game sessions in the fleet.
 *
 * To update settings, specify the fleet ID to be updated and specify the changes to be made. List the permissions you want to add in `InboundPermissionAuthorizations`, and permissions you want to remove in `InboundPermissionRevocations`. Permissions to be removed must match existing fleet permissions.
 *
 * If successful, the fleet ID for the updated fleet is returned. For fleets with remote locations, port setting updates can take time to propagate across all locations. You can check the status of updates in each location by calling `DescribeFleetPortSettings` with a location name.
 *
 * **Learn more**
 *
 * [Setting up Amazon GameLift Servers fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
 */
public suspend inline fun GameLiftClient.updateFleetPortSettings(crossinline block: UpdateFleetPortSettingsRequest.Builder.() -> Unit): UpdateFleetPortSettingsResponse = updateFleetPortSettings(UpdateFleetPortSettingsRequest.Builder().apply(block).build())

/**
 * **This operation is used with the Amazon GameLift Servers FleetIQ solution and game server groups.**
 *
 * Updates information about a registered game server to help Amazon GameLift Servers FleetIQ track game server availability. This operation is called by a game server process that is running on an instance in a game server group.
 *
 * Use this operation to update the following types of game server information. You can make all three types of updates in the same request:
 * + To update the game server's utilization status from `AVAILABLE` (when the game server is available to be claimed) to `UTILIZED` (when the game server is currently hosting games). Identify the game server and game server group and specify the new utilization status. You can't change the status from to `UTILIZED` to `AVAILABLE` .
 * + To report health status, identify the game server and game server group and set health check to `HEALTHY`. If a game server does not report health status for a certain length of time, the game server is no longer considered healthy. As a result, it will be eventually deregistered from the game server group to avoid affecting utilization metrics. The best practice is to report health every 60 seconds.
 * + To change game server metadata, provide updated game server data.
 *
 * Once a game server is successfully updated, the relevant statuses and timestamps are updated.
 *
 * **Learn more**
 *
 * [Amazon GameLift Servers FleetIQ Guide](https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
 */
public suspend inline fun GameLiftClient.updateGameServer(crossinline block: UpdateGameServerRequest.Builder.() -> Unit): UpdateGameServerResponse = updateGameServer(UpdateGameServerRequest.Builder().apply(block).build())

/**
 * **This operation is used with the Amazon GameLift Servers FleetIQ solution and game server groups.**
 *
 * Updates Amazon GameLift Servers FleetIQ-specific properties for a game server group. Many Auto Scaling group properties are updated on the Auto Scaling group directly, including the launch template, Auto Scaling policies, and maximum/minimum/desired instance counts.
 *
 * To update the game server group, specify the game server group ID and provide the updated values. Before applying the updates, the new values are validated to ensure that Amazon GameLift Servers FleetIQ can continue to perform instance balancing activity. If successful, a `GameServerGroup` object is returned.
 *
 * **Learn more**
 *
 * [Amazon GameLift Servers FleetIQ Guide](https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
 */
public suspend inline fun GameLiftClient.updateGameServerGroup(crossinline block: UpdateGameServerGroupRequest.Builder.() -> Unit): UpdateGameServerGroupResponse = updateGameServerGroup(UpdateGameServerGroupRequest.Builder().apply(block).build())

/**
 * Updates the mutable properties of a game session.
 *
 * To update a game session, specify the game session ID and the values you want to change.
 *
 * If successful, the updated `GameSession` object is returned.
 *
 * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public suspend inline fun GameLiftClient.updateGameSession(crossinline block: UpdateGameSessionRequest.Builder.() -> Unit): UpdateGameSessionResponse = updateGameSession(UpdateGameSessionRequest.Builder().apply(block).build())

/**
 * Updates the configuration of a game session queue, which determines how the queue processes new game session requests. To update settings, specify the queue name to be updated and provide the new settings. When updating destinations, provide a complete list of destinations.
 *
 * **Learn more**
 *
 * [ Using Multi-Region Queues](https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-intro.html)
 */
public suspend inline fun GameLiftClient.updateGameSessionQueue(crossinline block: UpdateGameSessionQueueRequest.Builder.() -> Unit): UpdateGameSessionQueueResponse = updateGameSessionQueue(UpdateGameSessionQueueRequest.Builder().apply(block).build())

/**
 * Updates settings for a FlexMatch matchmaking configuration. These changes affect all matches and game sessions that are created after the update. To update settings, specify the configuration name to be updated and provide the new settings.
 *
 * **Learn more**
 *
 * [ Design a FlexMatch matchmaker](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-configuration.html)
 */
public suspend inline fun GameLiftClient.updateMatchmakingConfiguration(crossinline block: UpdateMatchmakingConfigurationRequest.Builder.() -> Unit): UpdateMatchmakingConfigurationResponse = updateMatchmakingConfiguration(UpdateMatchmakingConfigurationRequest.Builder().apply(block).build())

/**
 * Updates the runtime configuration for the specified fleet. The runtime configuration tells Amazon GameLift Servers how to launch server processes on computes in managed EC2 and Anywhere fleets. You can update a fleet's runtime configuration at any time after the fleet is created; it does not need to be in `ACTIVE` status.
 *
 * To update runtime configuration, specify the fleet ID and provide a `RuntimeConfiguration` with an updated set of server process configurations.
 *
 * If successful, the fleet's runtime configuration settings are updated. Fleet computes that run game server processes regularly check for and receive updated runtime configurations. The computes immediately take action to comply with the new configuration by launching new server processes or by not replacing existing processes when they shut down. Updating a fleet's runtime configuration never affects existing server processes.
 *
 * **Learn more**
 *
 * [Setting up Amazon GameLift Servers fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
 */
public suspend inline fun GameLiftClient.updateRuntimeConfiguration(crossinline block: UpdateRuntimeConfigurationRequest.Builder.() -> Unit): UpdateRuntimeConfigurationResponse = updateRuntimeConfiguration(UpdateRuntimeConfigurationRequest.Builder().apply(block).build())

/**
 * Updates Realtime script metadata and content.
 *
 * To update script metadata, specify the script ID and provide updated name and/or version values.
 *
 * To update script content, provide an updated zip file by pointing to either a local file or an Amazon S3 bucket location. You can use either method regardless of how the original script was uploaded. Use the *Version* parameter to track updates to the script.
 *
 * If the call is successful, the updated metadata is stored in the script record and a revised script is uploaded to the Amazon GameLift Servers service. Once the script is updated and acquired by a fleet instance, the new version is used for all new game sessions.
 *
 * **Learn more**
 *
 * [Amazon GameLift Servers Amazon GameLift Servers Realtime](https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html)
 *
 * **Related actions**
 *
 * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public suspend inline fun GameLiftClient.updateScript(crossinline block: UpdateScriptRequest.Builder.() -> Unit): UpdateScriptResponse = updateScript(UpdateScriptRequest.Builder().apply(block).build())

/**
 * Validates the syntax of a matchmaking rule or rule set. This operation checks that the rule set is using syntactically correct JSON and that it conforms to allowed property expressions. To validate syntax, provide a rule set JSON string.
 *
 * **Learn more**
 * + [Build a rule set](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html)
 */
public suspend inline fun GameLiftClient.validateMatchmakingRuleSet(crossinline block: ValidateMatchmakingRuleSetRequest.Builder.() -> Unit): ValidateMatchmakingRuleSetResponse = validateMatchmakingRuleSet(ValidateMatchmakingRuleSetRequest.Builder().apply(block).build())
