// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.serde

import aws.sdk.kotlin.services.fsx.model.DeleteStorageVirtualMachineResponse
import aws.sdk.kotlin.services.fsx.model.FSxException
import aws.sdk.kotlin.services.fsx.model.StorageVirtualMachineLifecycle
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeleteStorageVirtualMachineOperationDeserializer: HttpDeserializer.NonStreaming<DeleteStorageVirtualMachineResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DeleteStorageVirtualMachineResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteStorageVirtualMachineError(context, call, payload)
        }
        val builder = DeleteStorageVirtualMachineResponse.Builder()

        if (payload != null) {
            deserializeDeleteStorageVirtualMachineOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDeleteStorageVirtualMachineError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw FSxException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequest" -> BadRequestDeserializer().deserialize(context, wrappedCall, payload)
        "IncompatibleParameterError" -> IncompatibleParameterErrorDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall, payload)
        "StorageVirtualMachineNotFound" -> StorageVirtualMachineNotFoundDeserializer().deserialize(context, wrappedCall, payload)
        else -> FSxException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteStorageVirtualMachineOperationBody(builder: DeleteStorageVirtualMachineResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val LIFECYCLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Lifecycle"))
    val STORAGEVIRTUALMACHINEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StorageVirtualMachineId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LIFECYCLE_DESCRIPTOR)
        field(STORAGEVIRTUALMACHINEID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LIFECYCLE_DESCRIPTOR.index -> builder.lifecycle = deserializeString().let { StorageVirtualMachineLifecycle.fromValue(it) }
                STORAGEVIRTUALMACHINEID_DESCRIPTOR.index -> builder.storageVirtualMachineId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
