// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.serde

import aws.sdk.kotlin.services.fsx.model.DeleteFileSystemLustreResponse
import aws.sdk.kotlin.services.fsx.model.DeleteFileSystemOpenZfsResponse
import aws.sdk.kotlin.services.fsx.model.DeleteFileSystemResponse
import aws.sdk.kotlin.services.fsx.model.DeleteFileSystemWindowsResponse
import aws.sdk.kotlin.services.fsx.model.FSxException
import aws.sdk.kotlin.services.fsx.model.FileSystemLifecycle
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeleteFileSystemOperationDeserializer: HttpDeserializer.NonStreaming<DeleteFileSystemResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DeleteFileSystemResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteFileSystemError(context, call, payload)
        }
        val builder = DeleteFileSystemResponse.Builder()

        if (payload != null) {
            deserializeDeleteFileSystemOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDeleteFileSystemError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw FSxException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequest" -> BadRequestDeserializer().deserialize(context, wrappedCall, payload)
        "FileSystemNotFound" -> FileSystemNotFoundDeserializer().deserialize(context, wrappedCall, payload)
        "IncompatibleParameterError" -> IncompatibleParameterErrorDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceLimitExceeded" -> ServiceLimitExceededDeserializer().deserialize(context, wrappedCall, payload)
        else -> FSxException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteFileSystemOperationBody(builder: DeleteFileSystemResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FILESYSTEMID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FileSystemId"))
    val LIFECYCLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Lifecycle"))
    val LUSTRERESPONSE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LustreResponse"))
    val OPENZFSRESPONSE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OpenZFSResponse"))
    val WINDOWSRESPONSE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("WindowsResponse"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FILESYSTEMID_DESCRIPTOR)
        field(LIFECYCLE_DESCRIPTOR)
        field(LUSTRERESPONSE_DESCRIPTOR)
        field(OPENZFSRESPONSE_DESCRIPTOR)
        field(WINDOWSRESPONSE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FILESYSTEMID_DESCRIPTOR.index -> builder.fileSystemId = deserializeString()
                LIFECYCLE_DESCRIPTOR.index -> builder.lifecycle = deserializeString().let { FileSystemLifecycle.fromValue(it) }
                LUSTRERESPONSE_DESCRIPTOR.index -> builder.lustreResponse = deserializeDeleteFileSystemLustreResponseDocument(deserializer)
                OPENZFSRESPONSE_DESCRIPTOR.index -> builder.openZfsResponse = deserializeDeleteFileSystemOpenZfsResponseDocument(deserializer)
                WINDOWSRESPONSE_DESCRIPTOR.index -> builder.windowsResponse = deserializeDeleteFileSystemWindowsResponseDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
