// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.serde

import aws.sdk.kotlin.services.fsx.model.CreateFileCacheLustreConfiguration
import aws.sdk.kotlin.services.fsx.model.CreateFileCacheRequest
import aws.sdk.kotlin.services.fsx.model.FileCacheDataRepositoryAssociation
import aws.sdk.kotlin.services.fsx.model.FileCacheType
import aws.sdk.kotlin.services.fsx.model.Tag
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateFileCacheOperationSerializer: HttpSerializer.NonStreaming<CreateFileCacheRequest> {
    override fun serialize(context: ExecutionContext, input: CreateFileCacheRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeCreateFileCacheOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeCreateFileCacheOperationBody(context: ExecutionContext, input: CreateFileCacheRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTREQUESTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientRequestToken"))
    val COPYTAGSTODATAREPOSITORYASSOCIATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("CopyTagsToDataRepositoryAssociations"))
    val DATAREPOSITORYASSOCIATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DataRepositoryAssociations"))
    val FILECACHETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("FileCacheType"))
    val FILECACHETYPEVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FileCacheTypeVersion"))
    val KMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KmsKeyId"))
    val LUSTRECONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LustreConfiguration"))
    val SECURITYGROUPIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SecurityGroupIds"))
    val STORAGECAPACITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("StorageCapacity"))
    val SUBNETIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SubnetIds"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTREQUESTTOKEN_DESCRIPTOR)
        field(COPYTAGSTODATAREPOSITORYASSOCIATIONS_DESCRIPTOR)
        field(DATAREPOSITORYASSOCIATIONS_DESCRIPTOR)
        field(FILECACHETYPE_DESCRIPTOR)
        field(FILECACHETYPEVERSION_DESCRIPTOR)
        field(KMSKEYID_DESCRIPTOR)
        field(LUSTRECONFIGURATION_DESCRIPTOR)
        field(SECURITYGROUPIDS_DESCRIPTOR)
        field(STORAGECAPACITY_DESCRIPTOR)
        field(SUBNETIDS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientRequestToken?.let { field(CLIENTREQUESTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTREQUESTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.copyTagsToDataRepositoryAssociations?.let { field(COPYTAGSTODATAREPOSITORYASSOCIATIONS_DESCRIPTOR, it) }
        if (input.dataRepositoryAssociations != null) {
            listField(DATAREPOSITORYASSOCIATIONS_DESCRIPTOR) {
                for (el0 in input.dataRepositoryAssociations) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeFileCacheDataRepositoryAssociationDocument))
                }
            }
        }
        input.fileCacheType?.let { field(FILECACHETYPE_DESCRIPTOR, it.value) }
        input.fileCacheTypeVersion?.let { field(FILECACHETYPEVERSION_DESCRIPTOR, it) }
        input.kmsKeyId?.let { field(KMSKEYID_DESCRIPTOR, it) }
        input.lustreConfiguration?.let { field(LUSTRECONFIGURATION_DESCRIPTOR, it, ::serializeCreateFileCacheLustreConfigurationDocument) }
        if (input.securityGroupIds != null) {
            listField(SECURITYGROUPIDS_DESCRIPTOR) {
                for (el0 in input.securityGroupIds) {
                    serializeString(el0)
                }
            }
        }
        input.storageCapacity?.let { field(STORAGECAPACITY_DESCRIPTOR, it) }
        if (input.subnetIds != null) {
            listField(SUBNETIDS_DESCRIPTOR) {
                for (el0 in input.subnetIds) {
                    serializeString(el0)
                }
            }
        }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
