// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.serde

import aws.sdk.kotlin.services.fsx.model.Backup
import aws.sdk.kotlin.services.fsx.model.BackupLifecycle
import aws.sdk.kotlin.services.fsx.model.BackupType
import aws.sdk.kotlin.services.fsx.model.ResourceType
import aws.sdk.kotlin.services.fsx.model.Tag
import aws.smithy.kotlin.runtime.serde.Deserializer
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf

internal fun deserializeBackupDocument(deserializer: Deserializer): Backup {
    val builder = Backup.Builder()
    val BACKUPID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BackupId"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DIRECTORYINFORMATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DirectoryInformation"))
    val FAILUREDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("FailureDetails"))
    val FILESYSTEM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("FileSystem"))
    val KMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KmsKeyId"))
    val LIFECYCLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Lifecycle"))
    val OWNERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OwnerId"))
    val PROGRESSPERCENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("ProgressPercent"))
    val RESOURCEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ResourceARN"))
    val RESOURCETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ResourceType"))
    val SIZEINBYTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("SizeInBytes"))
    val SOURCEBACKUPID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SourceBackupId"))
    val SOURCEBACKUPREGION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SourceBackupRegion"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Type"))
    val VOLUME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Volume"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BACKUPID_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DIRECTORYINFORMATION_DESCRIPTOR)
        field(FAILUREDETAILS_DESCRIPTOR)
        field(FILESYSTEM_DESCRIPTOR)
        field(KMSKEYID_DESCRIPTOR)
        field(LIFECYCLE_DESCRIPTOR)
        field(OWNERID_DESCRIPTOR)
        field(PROGRESSPERCENT_DESCRIPTOR)
        field(RESOURCEARN_DESCRIPTOR)
        field(RESOURCETYPE_DESCRIPTOR)
        field(SIZEINBYTES_DESCRIPTOR)
        field(SOURCEBACKUPID_DESCRIPTOR)
        field(SOURCEBACKUPREGION_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
        field(VOLUME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BACKUPID_DESCRIPTOR.index -> builder.backupId = deserializeString()
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DIRECTORYINFORMATION_DESCRIPTOR.index -> builder.directoryInformation = deserializeActiveDirectoryBackupAttributesDocument(deserializer)
                FAILUREDETAILS_DESCRIPTOR.index -> builder.failureDetails = deserializeBackupFailureDetailsDocument(deserializer)
                FILESYSTEM_DESCRIPTOR.index -> builder.fileSystem = deserializeFileSystemDocument(deserializer)
                KMSKEYID_DESCRIPTOR.index -> builder.kmsKeyId = deserializeString()
                LIFECYCLE_DESCRIPTOR.index -> builder.lifecycle = deserializeString().let { BackupLifecycle.fromValue(it) }
                OWNERID_DESCRIPTOR.index -> builder.ownerId = deserializeString()
                PROGRESSPERCENT_DESCRIPTOR.index -> builder.progressPercent = deserializeInt()
                RESOURCEARN_DESCRIPTOR.index -> builder.resourceArn = deserializeString()
                RESOURCETYPE_DESCRIPTOR.index -> builder.resourceType = deserializeString().let { ResourceType.fromValue(it) }
                SIZEINBYTES_DESCRIPTOR.index -> builder.sizeInBytes = deserializeLong()
                SOURCEBACKUPID_DESCRIPTOR.index -> builder.sourceBackupId = deserializeString()
                SOURCEBACKUPREGION_DESCRIPTOR.index -> builder.sourceBackupRegion = deserializeString()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeList(TAGS_DESCRIPTOR) {
                        val col0 = mutableListOf<Tag>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTagDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TYPE_DESCRIPTOR.index -> builder.type = deserializeString().let { BackupType.fromValue(it) }
                VOLUME_DESCRIPTOR.index -> builder.volume = deserializeVolumeDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
    builder.correctErrors()
    return builder.build()
}
