// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration for this Microsoft Windows file system.
 */
public class WindowsFileSystemConfiguration private constructor(builder: Builder) {
    /**
     * The ID for an existing Amazon Web Services Managed Microsoft Active Directory instance that the file system is joined to.
     */
    public val activeDirectoryId: kotlin.String? = builder.activeDirectoryId
    /**
     * An array of one or more DNS aliases that are currently associated with the Amazon FSx file system. Aliases allow you to use existing DNS names to access the data in your Amazon FSx file system. You can associate up to 50 aliases with a file system at any time. You can associate additional DNS aliases after you create the file system using the AssociateFileSystemAliases operation. You can remove DNS aliases from the file system after it is created using the DisassociateFileSystemAliases operation. You only need to specify the alias name in the request payload. For more information, see [DNS aliases](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html).
     */
    public val aliases: List<Alias>? = builder.aliases
    /**
     * The configuration that Amazon FSx for Windows File Server uses to audit and log user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server file system.
     */
    public val auditLogConfiguration: aws.sdk.kotlin.services.fsx.model.WindowsAuditLogConfiguration? = builder.auditLogConfiguration
    /**
     * The number of days to retain automatic backups. Setting this to 0 disables automatic backups. You can retain automatic backups for a maximum of 90 days.
     */
    public val automaticBackupRetentionDays: kotlin.Int? = builder.automaticBackupRetentionDays
    /**
     * A boolean flag indicating whether tags on the file system should be copied to backups. This value defaults to false. If it's set to true, all tags on the file system are copied to all automatic backups and any user-initiated backups where the user doesn't specify any tags. If this value is true, and you specify one or more tags, only the specified tags are copied to backups. If you specify one or more tags when creating a user-initiated backup, no tags are copied from the file system, regardless of this value.
     */
    public val copyTagsToBackups: kotlin.Boolean? = builder.copyTagsToBackups
    /**
     * The preferred time to take daily automatic backups, in the UTC time zone.
     */
    public val dailyAutomaticBackupStartTime: kotlin.String? = builder.dailyAutomaticBackupStartTime
    /**
     * Specifies the file system deployment type, valid values are the following:
     * + `MULTI_AZ_1` - Specifies a high availability file system that is configured for Multi-AZ redundancy to tolerate temporary Availability Zone (AZ) unavailability, and supports SSD and HDD storage.
     * + `SINGLE_AZ_1` - (Default) Specifies a file system that is configured for single AZ redundancy, only supports SSD storage.
     * + `SINGLE_AZ_2` - Latest generation Single AZ file system. Specifies a file system that is configured for single AZ redundancy and supports SSD and HDD storage.
     *
     * For more information, see [Single-AZ and Multi-AZ File Systems](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html).
     */
    public val deploymentType: aws.sdk.kotlin.services.fsx.model.WindowsDeploymentType? = builder.deploymentType
    /**
     * The SSD IOPS (input/output operations per second) configuration for an Amazon FSx for Windows file system. By default, Amazon FSx automatically provisions 3 IOPS per GiB of storage capacity. You can provision additional IOPS per GiB of storage, up to the maximum limit associated with your chosen throughput capacity.
     */
    public val diskIopsConfiguration: aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration? = builder.diskIopsConfiguration
    /**
     * The list of maintenance operations in progress for this file system.
     */
    public val maintenanceOperationsInProgress: List<FileSystemMaintenanceOperation>? = builder.maintenanceOperationsInProgress
    /**
     * For `MULTI_AZ_1` deployment types, the IP address of the primary, or preferred, file server.
     *
     * Use this IP address when mounting the file system on Linux SMB clients or Windows SMB clients that are not joined to a Microsoft Active Directory. Applicable for all Windows file system deployment types. This IP address is temporarily unavailable when the file system is undergoing maintenance. For Linux and Windows SMB clients that are joined to an Active Directory, use the file system's DNSName instead. For more information on mapping and mounting file shares, see [Accessing File Shares](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/accessing-file-shares.html).
     */
    public val preferredFileServerIp: kotlin.String? = builder.preferredFileServerIp
    /**
     * For `MULTI_AZ_1` deployment types, it specifies the ID of the subnet where the preferred file server is located. Must be one of the two subnet IDs specified in `SubnetIds` property. Amazon FSx serves traffic from this subnet except in the event of a failover to the secondary file server.
     *
     * For `SINGLE_AZ_1` and `SINGLE_AZ_2` deployment types, this value is the same as that for `SubnetIDs`. For more information, see [Availability and durability: Single-AZ and Multi-AZ file systems](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html#single-multi-az-resources).
     */
    public val preferredSubnetId: kotlin.String? = builder.preferredSubnetId
    /**
     * For `MULTI_AZ_1` deployment types, use this endpoint when performing administrative tasks on the file system using Amazon FSx Remote PowerShell.
     *
     * For `SINGLE_AZ_1` and `SINGLE_AZ_2` deployment types, this is the DNS name of the file system.
     *
     * This endpoint is temporarily unavailable when the file system is undergoing maintenance.
     */
    public val remoteAdministrationEndpoint: kotlin.String? = builder.remoteAdministrationEndpoint
    /**
     * The configuration of the self-managed Microsoft Active Directory (AD) directory to which the Windows File Server or ONTAP storage virtual machine (SVM) instance is joined.
     */
    public val selfManagedActiveDirectoryConfiguration: aws.sdk.kotlin.services.fsx.model.SelfManagedActiveDirectoryAttributes? = builder.selfManagedActiveDirectoryConfiguration
    /**
     * The throughput of the Amazon FSx file system, measured in megabytes per second.
     */
    public val throughputCapacity: kotlin.Int? = builder.throughputCapacity
    /**
     * The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone. d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.
     */
    public val weeklyMaintenanceStartTime: kotlin.String? = builder.weeklyMaintenanceStartTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.WindowsFileSystemConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WindowsFileSystemConfiguration(")
        append("activeDirectoryId=$activeDirectoryId,")
        append("aliases=$aliases,")
        append("auditLogConfiguration=$auditLogConfiguration,")
        append("automaticBackupRetentionDays=$automaticBackupRetentionDays,")
        append("copyTagsToBackups=$copyTagsToBackups,")
        append("dailyAutomaticBackupStartTime=$dailyAutomaticBackupStartTime,")
        append("deploymentType=$deploymentType,")
        append("diskIopsConfiguration=$diskIopsConfiguration,")
        append("maintenanceOperationsInProgress=$maintenanceOperationsInProgress,")
        append("preferredFileServerIp=$preferredFileServerIp,")
        append("preferredSubnetId=$preferredSubnetId,")
        append("remoteAdministrationEndpoint=$remoteAdministrationEndpoint,")
        append("selfManagedActiveDirectoryConfiguration=$selfManagedActiveDirectoryConfiguration,")
        append("throughputCapacity=$throughputCapacity,")
        append("weeklyMaintenanceStartTime=$weeklyMaintenanceStartTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeDirectoryId?.hashCode() ?: 0
        result = 31 * result + (aliases?.hashCode() ?: 0)
        result = 31 * result + (auditLogConfiguration?.hashCode() ?: 0)
        result = 31 * result + (automaticBackupRetentionDays ?: 0)
        result = 31 * result + (copyTagsToBackups?.hashCode() ?: 0)
        result = 31 * result + (dailyAutomaticBackupStartTime?.hashCode() ?: 0)
        result = 31 * result + (deploymentType?.hashCode() ?: 0)
        result = 31 * result + (diskIopsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (maintenanceOperationsInProgress?.hashCode() ?: 0)
        result = 31 * result + (preferredFileServerIp?.hashCode() ?: 0)
        result = 31 * result + (preferredSubnetId?.hashCode() ?: 0)
        result = 31 * result + (remoteAdministrationEndpoint?.hashCode() ?: 0)
        result = 31 * result + (selfManagedActiveDirectoryConfiguration?.hashCode() ?: 0)
        result = 31 * result + (throughputCapacity ?: 0)
        result = 31 * result + (weeklyMaintenanceStartTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WindowsFileSystemConfiguration

        if (activeDirectoryId != other.activeDirectoryId) return false
        if (aliases != other.aliases) return false
        if (auditLogConfiguration != other.auditLogConfiguration) return false
        if (automaticBackupRetentionDays != other.automaticBackupRetentionDays) return false
        if (copyTagsToBackups != other.copyTagsToBackups) return false
        if (dailyAutomaticBackupStartTime != other.dailyAutomaticBackupStartTime) return false
        if (deploymentType != other.deploymentType) return false
        if (diskIopsConfiguration != other.diskIopsConfiguration) return false
        if (maintenanceOperationsInProgress != other.maintenanceOperationsInProgress) return false
        if (preferredFileServerIp != other.preferredFileServerIp) return false
        if (preferredSubnetId != other.preferredSubnetId) return false
        if (remoteAdministrationEndpoint != other.remoteAdministrationEndpoint) return false
        if (selfManagedActiveDirectoryConfiguration != other.selfManagedActiveDirectoryConfiguration) return false
        if (throughputCapacity != other.throughputCapacity) return false
        if (weeklyMaintenanceStartTime != other.weeklyMaintenanceStartTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.WindowsFileSystemConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID for an existing Amazon Web Services Managed Microsoft Active Directory instance that the file system is joined to.
         */
        public var activeDirectoryId: kotlin.String? = null
        /**
         * An array of one or more DNS aliases that are currently associated with the Amazon FSx file system. Aliases allow you to use existing DNS names to access the data in your Amazon FSx file system. You can associate up to 50 aliases with a file system at any time. You can associate additional DNS aliases after you create the file system using the AssociateFileSystemAliases operation. You can remove DNS aliases from the file system after it is created using the DisassociateFileSystemAliases operation. You only need to specify the alias name in the request payload. For more information, see [DNS aliases](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html).
         */
        public var aliases: List<Alias>? = null
        /**
         * The configuration that Amazon FSx for Windows File Server uses to audit and log user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server file system.
         */
        public var auditLogConfiguration: aws.sdk.kotlin.services.fsx.model.WindowsAuditLogConfiguration? = null
        /**
         * The number of days to retain automatic backups. Setting this to 0 disables automatic backups. You can retain automatic backups for a maximum of 90 days.
         */
        public var automaticBackupRetentionDays: kotlin.Int? = null
        /**
         * A boolean flag indicating whether tags on the file system should be copied to backups. This value defaults to false. If it's set to true, all tags on the file system are copied to all automatic backups and any user-initiated backups where the user doesn't specify any tags. If this value is true, and you specify one or more tags, only the specified tags are copied to backups. If you specify one or more tags when creating a user-initiated backup, no tags are copied from the file system, regardless of this value.
         */
        public var copyTagsToBackups: kotlin.Boolean? = null
        /**
         * The preferred time to take daily automatic backups, in the UTC time zone.
         */
        public var dailyAutomaticBackupStartTime: kotlin.String? = null
        /**
         * Specifies the file system deployment type, valid values are the following:
         * + `MULTI_AZ_1` - Specifies a high availability file system that is configured for Multi-AZ redundancy to tolerate temporary Availability Zone (AZ) unavailability, and supports SSD and HDD storage.
         * + `SINGLE_AZ_1` - (Default) Specifies a file system that is configured for single AZ redundancy, only supports SSD storage.
         * + `SINGLE_AZ_2` - Latest generation Single AZ file system. Specifies a file system that is configured for single AZ redundancy and supports SSD and HDD storage.
         *
         * For more information, see [Single-AZ and Multi-AZ File Systems](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html).
         */
        public var deploymentType: aws.sdk.kotlin.services.fsx.model.WindowsDeploymentType? = null
        /**
         * The SSD IOPS (input/output operations per second) configuration for an Amazon FSx for Windows file system. By default, Amazon FSx automatically provisions 3 IOPS per GiB of storage capacity. You can provision additional IOPS per GiB of storage, up to the maximum limit associated with your chosen throughput capacity.
         */
        public var diskIopsConfiguration: aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration? = null
        /**
         * The list of maintenance operations in progress for this file system.
         */
        public var maintenanceOperationsInProgress: List<FileSystemMaintenanceOperation>? = null
        /**
         * For `MULTI_AZ_1` deployment types, the IP address of the primary, or preferred, file server.
         *
         * Use this IP address when mounting the file system on Linux SMB clients or Windows SMB clients that are not joined to a Microsoft Active Directory. Applicable for all Windows file system deployment types. This IP address is temporarily unavailable when the file system is undergoing maintenance. For Linux and Windows SMB clients that are joined to an Active Directory, use the file system's DNSName instead. For more information on mapping and mounting file shares, see [Accessing File Shares](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/accessing-file-shares.html).
         */
        public var preferredFileServerIp: kotlin.String? = null
        /**
         * For `MULTI_AZ_1` deployment types, it specifies the ID of the subnet where the preferred file server is located. Must be one of the two subnet IDs specified in `SubnetIds` property. Amazon FSx serves traffic from this subnet except in the event of a failover to the secondary file server.
         *
         * For `SINGLE_AZ_1` and `SINGLE_AZ_2` deployment types, this value is the same as that for `SubnetIDs`. For more information, see [Availability and durability: Single-AZ and Multi-AZ file systems](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html#single-multi-az-resources).
         */
        public var preferredSubnetId: kotlin.String? = null
        /**
         * For `MULTI_AZ_1` deployment types, use this endpoint when performing administrative tasks on the file system using Amazon FSx Remote PowerShell.
         *
         * For `SINGLE_AZ_1` and `SINGLE_AZ_2` deployment types, this is the DNS name of the file system.
         *
         * This endpoint is temporarily unavailable when the file system is undergoing maintenance.
         */
        public var remoteAdministrationEndpoint: kotlin.String? = null
        /**
         * The configuration of the self-managed Microsoft Active Directory (AD) directory to which the Windows File Server or ONTAP storage virtual machine (SVM) instance is joined.
         */
        public var selfManagedActiveDirectoryConfiguration: aws.sdk.kotlin.services.fsx.model.SelfManagedActiveDirectoryAttributes? = null
        /**
         * The throughput of the Amazon FSx file system, measured in megabytes per second.
         */
        public var throughputCapacity: kotlin.Int? = null
        /**
         * The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone. d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.
         */
        public var weeklyMaintenanceStartTime: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.WindowsFileSystemConfiguration) : this() {
            this.activeDirectoryId = x.activeDirectoryId
            this.aliases = x.aliases
            this.auditLogConfiguration = x.auditLogConfiguration
            this.automaticBackupRetentionDays = x.automaticBackupRetentionDays
            this.copyTagsToBackups = x.copyTagsToBackups
            this.dailyAutomaticBackupStartTime = x.dailyAutomaticBackupStartTime
            this.deploymentType = x.deploymentType
            this.diskIopsConfiguration = x.diskIopsConfiguration
            this.maintenanceOperationsInProgress = x.maintenanceOperationsInProgress
            this.preferredFileServerIp = x.preferredFileServerIp
            this.preferredSubnetId = x.preferredSubnetId
            this.remoteAdministrationEndpoint = x.remoteAdministrationEndpoint
            this.selfManagedActiveDirectoryConfiguration = x.selfManagedActiveDirectoryConfiguration
            this.throughputCapacity = x.throughputCapacity
            this.weeklyMaintenanceStartTime = x.weeklyMaintenanceStartTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.WindowsFileSystemConfiguration = WindowsFileSystemConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.WindowsAuditLogConfiguration] inside the given [block]
         */
        public fun auditLogConfiguration(block: aws.sdk.kotlin.services.fsx.model.WindowsAuditLogConfiguration.Builder.() -> kotlin.Unit) {
            this.auditLogConfiguration = aws.sdk.kotlin.services.fsx.model.WindowsAuditLogConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration] inside the given [block]
         */
        public fun diskIopsConfiguration(block: aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration.Builder.() -> kotlin.Unit) {
            this.diskIopsConfiguration = aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.SelfManagedActiveDirectoryAttributes] inside the given [block]
         */
        public fun selfManagedActiveDirectoryConfiguration(block: aws.sdk.kotlin.services.fsx.model.SelfManagedActiveDirectoryAttributes.Builder.() -> kotlin.Unit) {
            this.selfManagedActiveDirectoryConfiguration = aws.sdk.kotlin.services.fsx.model.SelfManagedActiveDirectoryAttributes.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
