// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an Amazon FSx volume.
 */
public class Volume private constructor(builder: Builder) {
    /**
     * A list of administrative actions for the volume that are in process or waiting to be processed. Administrative actions describe changes to the volume that you have initiated using the `UpdateVolume` action.
     */
    public val administrativeActions: List<AdministrativeAction>? = builder.administrativeActions
    /**
     * The time that the resource was created, in seconds (since 1970-01-01T00:00:00Z), also known as Unix time.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The globally unique ID of the file system, assigned by Amazon FSx.
     */
    public val fileSystemId: kotlin.String? = builder.fileSystemId
    /**
     * The lifecycle status of the volume.
     * + `AVAILABLE` - The volume is fully available for use.
     * + `CREATED` - The volume has been created.
     * + `CREATING` - Amazon FSx is creating the new volume.
     * + `DELETING` - Amazon FSx is deleting an existing volume.
     * + `FAILED` - Amazon FSx was unable to create the volume.
     * + `MISCONFIGURED` - The volume is in a failed but recoverable state.
     * + `PENDING` - Amazon FSx hasn't started creating the volume.
     */
    public val lifecycle: aws.sdk.kotlin.services.fsx.model.VolumeLifecycle? = builder.lifecycle
    /**
     * The reason why the volume lifecycle status changed.
     */
    public val lifecycleTransitionReason: aws.sdk.kotlin.services.fsx.model.LifecycleTransitionReason? = builder.lifecycleTransitionReason
    /**
     * The name of the volume.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The configuration of an Amazon FSx for NetApp ONTAP volume.
     */
    public val ontapConfiguration: aws.sdk.kotlin.services.fsx.model.OntapVolumeConfiguration? = builder.ontapConfiguration
    /**
     * The configuration of an Amazon FSx for OpenZFS volume.
     */
    public val openZfsConfiguration: aws.sdk.kotlin.services.fsx.model.OpenZfsVolumeConfiguration? = builder.openZfsConfiguration
    /**
     * The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services resources. We require an ARN when you need to specify a resource unambiguously across all of Amazon Web Services. For more information, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * A list of `Tag` values, with a maximum of 50 elements.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The system-generated, unique ID of the volume.
     */
    public val volumeId: kotlin.String? = builder.volumeId
    /**
     * The type of the volume.
     */
    public val volumeType: aws.sdk.kotlin.services.fsx.model.VolumeType? = builder.volumeType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.Volume = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Volume(")
        append("administrativeActions=$administrativeActions,")
        append("creationTime=$creationTime,")
        append("fileSystemId=$fileSystemId,")
        append("lifecycle=$lifecycle,")
        append("lifecycleTransitionReason=$lifecycleTransitionReason,")
        append("name=$name,")
        append("ontapConfiguration=$ontapConfiguration,")
        append("openZfsConfiguration=$openZfsConfiguration,")
        append("resourceArn=$resourceArn,")
        append("tags=$tags,")
        append("volumeId=$volumeId,")
        append("volumeType=$volumeType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = administrativeActions?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (fileSystemId?.hashCode() ?: 0)
        result = 31 * result + (lifecycle?.hashCode() ?: 0)
        result = 31 * result + (lifecycleTransitionReason?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (ontapConfiguration?.hashCode() ?: 0)
        result = 31 * result + (openZfsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (volumeId?.hashCode() ?: 0)
        result = 31 * result + (volumeType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Volume

        if (administrativeActions != other.administrativeActions) return false
        if (creationTime != other.creationTime) return false
        if (fileSystemId != other.fileSystemId) return false
        if (lifecycle != other.lifecycle) return false
        if (lifecycleTransitionReason != other.lifecycleTransitionReason) return false
        if (name != other.name) return false
        if (ontapConfiguration != other.ontapConfiguration) return false
        if (openZfsConfiguration != other.openZfsConfiguration) return false
        if (resourceArn != other.resourceArn) return false
        if (tags != other.tags) return false
        if (volumeId != other.volumeId) return false
        if (volumeType != other.volumeType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.Volume = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of administrative actions for the volume that are in process or waiting to be processed. Administrative actions describe changes to the volume that you have initiated using the `UpdateVolume` action.
         */
        public var administrativeActions: List<AdministrativeAction>? = null
        /**
         * The time that the resource was created, in seconds (since 1970-01-01T00:00:00Z), also known as Unix time.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The globally unique ID of the file system, assigned by Amazon FSx.
         */
        public var fileSystemId: kotlin.String? = null
        /**
         * The lifecycle status of the volume.
         * + `AVAILABLE` - The volume is fully available for use.
         * + `CREATED` - The volume has been created.
         * + `CREATING` - Amazon FSx is creating the new volume.
         * + `DELETING` - Amazon FSx is deleting an existing volume.
         * + `FAILED` - Amazon FSx was unable to create the volume.
         * + `MISCONFIGURED` - The volume is in a failed but recoverable state.
         * + `PENDING` - Amazon FSx hasn't started creating the volume.
         */
        public var lifecycle: aws.sdk.kotlin.services.fsx.model.VolumeLifecycle? = null
        /**
         * The reason why the volume lifecycle status changed.
         */
        public var lifecycleTransitionReason: aws.sdk.kotlin.services.fsx.model.LifecycleTransitionReason? = null
        /**
         * The name of the volume.
         */
        public var name: kotlin.String? = null
        /**
         * The configuration of an Amazon FSx for NetApp ONTAP volume.
         */
        public var ontapConfiguration: aws.sdk.kotlin.services.fsx.model.OntapVolumeConfiguration? = null
        /**
         * The configuration of an Amazon FSx for OpenZFS volume.
         */
        public var openZfsConfiguration: aws.sdk.kotlin.services.fsx.model.OpenZfsVolumeConfiguration? = null
        /**
         * The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services resources. We require an ARN when you need to specify a resource unambiguously across all of Amazon Web Services. For more information, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * A list of `Tag` values, with a maximum of 50 elements.
         */
        public var tags: List<Tag>? = null
        /**
         * The system-generated, unique ID of the volume.
         */
        public var volumeId: kotlin.String? = null
        /**
         * The type of the volume.
         */
        public var volumeType: aws.sdk.kotlin.services.fsx.model.VolumeType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.Volume) : this() {
            this.administrativeActions = x.administrativeActions
            this.creationTime = x.creationTime
            this.fileSystemId = x.fileSystemId
            this.lifecycle = x.lifecycle
            this.lifecycleTransitionReason = x.lifecycleTransitionReason
            this.name = x.name
            this.ontapConfiguration = x.ontapConfiguration
            this.openZfsConfiguration = x.openZfsConfiguration
            this.resourceArn = x.resourceArn
            this.tags = x.tags
            this.volumeId = x.volumeId
            this.volumeType = x.volumeType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.Volume = Volume(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.LifecycleTransitionReason] inside the given [block]
         */
        public fun lifecycleTransitionReason(block: aws.sdk.kotlin.services.fsx.model.LifecycleTransitionReason.Builder.() -> kotlin.Unit) {
            this.lifecycleTransitionReason = aws.sdk.kotlin.services.fsx.model.LifecycleTransitionReason.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.OntapVolumeConfiguration] inside the given [block]
         */
        public fun ontapConfiguration(block: aws.sdk.kotlin.services.fsx.model.OntapVolumeConfiguration.Builder.() -> kotlin.Unit) {
            this.ontapConfiguration = aws.sdk.kotlin.services.fsx.model.OntapVolumeConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.OpenZfsVolumeConfiguration] inside the given [block]
         */
        public fun openZfsConfiguration(block: aws.sdk.kotlin.services.fsx.model.OpenZfsVolumeConfiguration.Builder.() -> kotlin.Unit) {
            this.openZfsConfiguration = aws.sdk.kotlin.services.fsx.model.OpenZfsVolumeConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
