// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Used to specify changes to the OpenZFS configuration for the volume that you are updating.
 */
public class UpdateOpenZfsVolumeConfiguration private constructor(builder: Builder) {
    /**
     * Specifies the method used to compress the data on the volume. The compression type is `NONE` by default.
     * + `NONE` - Doesn't compress the data on the volume. `NONE` is the default.
     * + `ZSTD` - Compresses the data in the volume using the Zstandard (ZSTD) compression algorithm. Compared to LZ4, Z-Standard provides a better compression ratio to minimize on-disk storage utilization.
     * + `LZ4` - Compresses the data in the volume using the LZ4 compression algorithm. Compared to Z-Standard, LZ4 is less compute-intensive and delivers higher write throughput speeds.
     */
    public val dataCompressionType: aws.sdk.kotlin.services.fsx.model.OpenZfsDataCompressionType? = builder.dataCompressionType
    /**
     * The configuration object for mounting a Network File System (NFS) file system.
     */
    public val nfsExports: List<OpenZfsNfsExport>? = builder.nfsExports
    /**
     * A Boolean value indicating whether the volume is read-only.
     */
    public val readOnly: kotlin.Boolean? = builder.readOnly
    /**
     * Specifies the record size of an OpenZFS volume, in kibibytes (KiB). Valid values are 4, 8, 16, 32, 64, 128, 256, 512, or 1024 KiB. The default is 128 KiB. Most workloads should use the default record size. Database workflows can benefit from a smaller record size, while streaming workflows can benefit from a larger record size. For additional guidance on when to set a custom record size, see [ Tips for maximizing performance](https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#performance-tips-zfs) in the *Amazon FSx for OpenZFS User Guide*.
     */
    public val recordSizeKib: kotlin.Int? = builder.recordSizeKib
    /**
     * The maximum amount of storage in gibibytes (GiB) that the volume can use from its parent. You can specify a quota larger than the storage on the parent volume. You can specify a value of `-1` to unset a volume's storage capacity quota.
     */
    public val storageCapacityQuotaGib: kotlin.Int? = builder.storageCapacityQuotaGib
    /**
     * The amount of storage in gibibytes (GiB) to reserve from the parent volume. You can't reserve more storage than the parent volume has reserved. You can specify a value of `-1` to unset a volume's storage capacity reservation.
     */
    public val storageCapacityReservationGib: kotlin.Int? = builder.storageCapacityReservationGib
    /**
     * An object specifying how much storage users or groups can use on the volume.
     */
    public val userAndGroupQuotas: List<OpenZfsUserOrGroupQuota>? = builder.userAndGroupQuotas

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.UpdateOpenZfsVolumeConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateOpenZfsVolumeConfiguration(")
        append("dataCompressionType=$dataCompressionType,")
        append("nfsExports=$nfsExports,")
        append("readOnly=$readOnly,")
        append("recordSizeKib=$recordSizeKib,")
        append("storageCapacityQuotaGib=$storageCapacityQuotaGib,")
        append("storageCapacityReservationGib=$storageCapacityReservationGib,")
        append("userAndGroupQuotas=$userAndGroupQuotas")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataCompressionType?.hashCode() ?: 0
        result = 31 * result + (nfsExports?.hashCode() ?: 0)
        result = 31 * result + (readOnly?.hashCode() ?: 0)
        result = 31 * result + (recordSizeKib ?: 0)
        result = 31 * result + (storageCapacityQuotaGib ?: 0)
        result = 31 * result + (storageCapacityReservationGib ?: 0)
        result = 31 * result + (userAndGroupQuotas?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateOpenZfsVolumeConfiguration

        if (dataCompressionType != other.dataCompressionType) return false
        if (nfsExports != other.nfsExports) return false
        if (readOnly != other.readOnly) return false
        if (recordSizeKib != other.recordSizeKib) return false
        if (storageCapacityQuotaGib != other.storageCapacityQuotaGib) return false
        if (storageCapacityReservationGib != other.storageCapacityReservationGib) return false
        if (userAndGroupQuotas != other.userAndGroupQuotas) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.UpdateOpenZfsVolumeConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the method used to compress the data on the volume. The compression type is `NONE` by default.
         * + `NONE` - Doesn't compress the data on the volume. `NONE` is the default.
         * + `ZSTD` - Compresses the data in the volume using the Zstandard (ZSTD) compression algorithm. Compared to LZ4, Z-Standard provides a better compression ratio to minimize on-disk storage utilization.
         * + `LZ4` - Compresses the data in the volume using the LZ4 compression algorithm. Compared to Z-Standard, LZ4 is less compute-intensive and delivers higher write throughput speeds.
         */
        public var dataCompressionType: aws.sdk.kotlin.services.fsx.model.OpenZfsDataCompressionType? = null
        /**
         * The configuration object for mounting a Network File System (NFS) file system.
         */
        public var nfsExports: List<OpenZfsNfsExport>? = null
        /**
         * A Boolean value indicating whether the volume is read-only.
         */
        public var readOnly: kotlin.Boolean? = null
        /**
         * Specifies the record size of an OpenZFS volume, in kibibytes (KiB). Valid values are 4, 8, 16, 32, 64, 128, 256, 512, or 1024 KiB. The default is 128 KiB. Most workloads should use the default record size. Database workflows can benefit from a smaller record size, while streaming workflows can benefit from a larger record size. For additional guidance on when to set a custom record size, see [ Tips for maximizing performance](https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#performance-tips-zfs) in the *Amazon FSx for OpenZFS User Guide*.
         */
        public var recordSizeKib: kotlin.Int? = null
        /**
         * The maximum amount of storage in gibibytes (GiB) that the volume can use from its parent. You can specify a quota larger than the storage on the parent volume. You can specify a value of `-1` to unset a volume's storage capacity quota.
         */
        public var storageCapacityQuotaGib: kotlin.Int? = null
        /**
         * The amount of storage in gibibytes (GiB) to reserve from the parent volume. You can't reserve more storage than the parent volume has reserved. You can specify a value of `-1` to unset a volume's storage capacity reservation.
         */
        public var storageCapacityReservationGib: kotlin.Int? = null
        /**
         * An object specifying how much storage users or groups can use on the volume.
         */
        public var userAndGroupQuotas: List<OpenZfsUserOrGroupQuota>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.UpdateOpenZfsVolumeConfiguration) : this() {
            this.dataCompressionType = x.dataCompressionType
            this.nfsExports = x.nfsExports
            this.readOnly = x.readOnly
            this.recordSizeKib = x.recordSizeKib
            this.storageCapacityQuotaGib = x.storageCapacityQuotaGib
            this.storageCapacityReservationGib = x.storageCapacityReservationGib
            this.userAndGroupQuotas = x.userAndGroupQuotas
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.UpdateOpenZfsVolumeConfiguration = UpdateOpenZfsVolumeConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
