// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Used to specify changes to the ONTAP configuration for the volume you are updating.
 */
public class UpdateOntapVolumeConfiguration private constructor(builder: Builder) {
    /**
     * A boolean flag indicating whether tags for the volume should be copied to backups. This value defaults to false. If it's set to true, all tags for the volume are copied to all automatic and user-initiated backups where the user doesn't specify tags. If this value is true, and you specify one or more tags, only the specified tags are copied to backups. If you specify one or more tags when creating a user-initiated backup, no tags are copied from the volume, regardless of this value.
     */
    public val copyTagsToBackups: kotlin.Boolean? = builder.copyTagsToBackups
    /**
     * Specifies the location in the SVM's namespace where the volume is mounted. The `JunctionPath` must have a leading forward slash, such as `/vol3`.
     */
    public val junctionPath: kotlin.String? = builder.junctionPath
    /**
     * The security style for the volume, which can be `UNIX`, `NTFS`, or `MIXED`.
     */
    public val securityStyle: aws.sdk.kotlin.services.fsx.model.SecurityStyle? = builder.securityStyle
    /**
     * The configured size of the volume, in bytes.
     */
    public val sizeInBytes: kotlin.Long? = builder.sizeInBytes
    /**
     * Specifies the size of the volume in megabytes.
     */
    public val sizeInMegabytes: kotlin.Int? = builder.sizeInMegabytes
    /**
     * The configuration object for updating the SnapLock configuration of an FSx for ONTAP SnapLock volume.
     */
    public val snaplockConfiguration: aws.sdk.kotlin.services.fsx.model.UpdateSnaplockConfiguration? = builder.snaplockConfiguration
    /**
     * Specifies the snapshot policy for the volume. There are three built-in snapshot policies:
     * + `default`: This is the default policy. A maximum of six hourly snapshots taken five minutes past the hour. A maximum of two daily snapshots taken Monday through Saturday at 10 minutes after midnight. A maximum of two weekly snapshots taken every Sunday at 15 minutes after midnight.
     * + `default-1weekly`: This policy is the same as the `default` policy except that it only retains one snapshot from the weekly schedule.
     * + `none`: This policy does not take any snapshots. This policy can be assigned to volumes to prevent automatic snapshots from being taken.
     *
     * You can also provide the name of a custom policy that you created with the ONTAP CLI or REST API.
     *
     * For more information, see [Snapshot policies](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snapshots-ontap.html#snapshot-policies) in the *Amazon FSx for NetApp ONTAP User Guide*.
     */
    public val snapshotPolicy: kotlin.String? = builder.snapshotPolicy
    /**
     * Default is `false`. Set to true to enable the deduplication, compression, and compaction storage efficiency features on the volume.
     */
    public val storageEfficiencyEnabled: kotlin.Boolean? = builder.storageEfficiencyEnabled
    /**
     * Update the volume's data tiering policy.
     */
    public val tieringPolicy: aws.sdk.kotlin.services.fsx.model.TieringPolicy? = builder.tieringPolicy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.UpdateOntapVolumeConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateOntapVolumeConfiguration(")
        append("copyTagsToBackups=$copyTagsToBackups,")
        append("junctionPath=$junctionPath,")
        append("securityStyle=$securityStyle,")
        append("sizeInBytes=$sizeInBytes,")
        append("sizeInMegabytes=$sizeInMegabytes,")
        append("snaplockConfiguration=$snaplockConfiguration,")
        append("snapshotPolicy=$snapshotPolicy,")
        append("storageEfficiencyEnabled=$storageEfficiencyEnabled,")
        append("tieringPolicy=$tieringPolicy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = copyTagsToBackups?.hashCode() ?: 0
        result = 31 * result + (junctionPath?.hashCode() ?: 0)
        result = 31 * result + (securityStyle?.hashCode() ?: 0)
        result = 31 * result + (sizeInBytes?.hashCode() ?: 0)
        result = 31 * result + (sizeInMegabytes ?: 0)
        result = 31 * result + (snaplockConfiguration?.hashCode() ?: 0)
        result = 31 * result + (snapshotPolicy?.hashCode() ?: 0)
        result = 31 * result + (storageEfficiencyEnabled?.hashCode() ?: 0)
        result = 31 * result + (tieringPolicy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateOntapVolumeConfiguration

        if (copyTagsToBackups != other.copyTagsToBackups) return false
        if (junctionPath != other.junctionPath) return false
        if (securityStyle != other.securityStyle) return false
        if (sizeInBytes != other.sizeInBytes) return false
        if (sizeInMegabytes != other.sizeInMegabytes) return false
        if (snaplockConfiguration != other.snaplockConfiguration) return false
        if (snapshotPolicy != other.snapshotPolicy) return false
        if (storageEfficiencyEnabled != other.storageEfficiencyEnabled) return false
        if (tieringPolicy != other.tieringPolicy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.UpdateOntapVolumeConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A boolean flag indicating whether tags for the volume should be copied to backups. This value defaults to false. If it's set to true, all tags for the volume are copied to all automatic and user-initiated backups where the user doesn't specify tags. If this value is true, and you specify one or more tags, only the specified tags are copied to backups. If you specify one or more tags when creating a user-initiated backup, no tags are copied from the volume, regardless of this value.
         */
        public var copyTagsToBackups: kotlin.Boolean? = null
        /**
         * Specifies the location in the SVM's namespace where the volume is mounted. The `JunctionPath` must have a leading forward slash, such as `/vol3`.
         */
        public var junctionPath: kotlin.String? = null
        /**
         * The security style for the volume, which can be `UNIX`, `NTFS`, or `MIXED`.
         */
        public var securityStyle: aws.sdk.kotlin.services.fsx.model.SecurityStyle? = null
        /**
         * The configured size of the volume, in bytes.
         */
        public var sizeInBytes: kotlin.Long? = null
        /**
         * Specifies the size of the volume in megabytes.
         */
        public var sizeInMegabytes: kotlin.Int? = null
        /**
         * The configuration object for updating the SnapLock configuration of an FSx for ONTAP SnapLock volume.
         */
        public var snaplockConfiguration: aws.sdk.kotlin.services.fsx.model.UpdateSnaplockConfiguration? = null
        /**
         * Specifies the snapshot policy for the volume. There are three built-in snapshot policies:
         * + `default`: This is the default policy. A maximum of six hourly snapshots taken five minutes past the hour. A maximum of two daily snapshots taken Monday through Saturday at 10 minutes after midnight. A maximum of two weekly snapshots taken every Sunday at 15 minutes after midnight.
         * + `default-1weekly`: This policy is the same as the `default` policy except that it only retains one snapshot from the weekly schedule.
         * + `none`: This policy does not take any snapshots. This policy can be assigned to volumes to prevent automatic snapshots from being taken.
         *
         * You can also provide the name of a custom policy that you created with the ONTAP CLI or REST API.
         *
         * For more information, see [Snapshot policies](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snapshots-ontap.html#snapshot-policies) in the *Amazon FSx for NetApp ONTAP User Guide*.
         */
        public var snapshotPolicy: kotlin.String? = null
        /**
         * Default is `false`. Set to true to enable the deduplication, compression, and compaction storage efficiency features on the volume.
         */
        public var storageEfficiencyEnabled: kotlin.Boolean? = null
        /**
         * Update the volume's data tiering policy.
         */
        public var tieringPolicy: aws.sdk.kotlin.services.fsx.model.TieringPolicy? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.UpdateOntapVolumeConfiguration) : this() {
            this.copyTagsToBackups = x.copyTagsToBackups
            this.junctionPath = x.junctionPath
            this.securityStyle = x.securityStyle
            this.sizeInBytes = x.sizeInBytes
            this.sizeInMegabytes = x.sizeInMegabytes
            this.snaplockConfiguration = x.snaplockConfiguration
            this.snapshotPolicy = x.snapshotPolicy
            this.storageEfficiencyEnabled = x.storageEfficiencyEnabled
            this.tieringPolicy = x.tieringPolicy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.UpdateOntapVolumeConfiguration = UpdateOntapVolumeConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.UpdateSnaplockConfiguration] inside the given [block]
         */
        public fun snaplockConfiguration(block: aws.sdk.kotlin.services.fsx.model.UpdateSnaplockConfiguration.Builder.() -> kotlin.Unit) {
            this.snaplockConfiguration = aws.sdk.kotlin.services.fsx.model.UpdateSnaplockConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.TieringPolicy] inside the given [block]
         */
        public fun tieringPolicy(block: aws.sdk.kotlin.services.fsx.model.TieringPolicy.Builder.() -> kotlin.Unit) {
            this.tieringPolicy = aws.sdk.kotlin.services.fsx.model.TieringPolicy.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
