// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Updates the configuration for an existing Amazon FSx for Windows File Server file system. Amazon FSx only overwrites existing properties with non-null values provided in the request.
 */
public class UpdateFileSystemWindowsConfiguration private constructor(builder: Builder) {
    /**
     * The configuration that Amazon FSx for Windows File Server uses to audit and log user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server file system..
     */
    public val auditLogConfiguration: aws.sdk.kotlin.services.fsx.model.WindowsAuditLogCreateConfiguration? = builder.auditLogConfiguration
    /**
     * The number of days to retain automatic backups. Setting this property to `0` disables automatic backups. You can retain automatic backups for a maximum of 90 days. The default is `30`. For more information, see [Working with Automatic Daily Backups](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/using-backups.html#automatic-backups).
     */
    public val automaticBackupRetentionDays: kotlin.Int? = builder.automaticBackupRetentionDays
    /**
     * The preferred time to start the daily automatic backup, in the UTC time zone, for example, `02:00`
     */
    public val dailyAutomaticBackupStartTime: kotlin.String? = builder.dailyAutomaticBackupStartTime
    /**
     * The SSD IOPS (input/output operations per second) configuration for an Amazon FSx for Windows file system. By default, Amazon FSx automatically provisions 3 IOPS per GiB of storage capacity. You can provision additional IOPS per GiB of storage, up to the maximum limit associated with your chosen throughput capacity.
     */
    public val diskIopsConfiguration: aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration? = builder.diskIopsConfiguration
    /**
     * The configuration Amazon FSx uses to join the Windows File Server instance to the self-managed Microsoft AD directory. You cannot make a self-managed Microsoft AD update request if there is an existing self-managed Microsoft AD update request in progress.
     */
    public val selfManagedActiveDirectoryConfiguration: aws.sdk.kotlin.services.fsx.model.SelfManagedActiveDirectoryConfigurationUpdates? = builder.selfManagedActiveDirectoryConfiguration
    /**
     * Sets the target value for a file system's throughput capacity, in MB/s, that you are updating the file system to. Valid values are 8, 16, 32, 64, 128, 256, 512, 1024, 2048. You cannot make a throughput capacity update request if there is an existing throughput capacity update request in progress. For more information, see [Managing Throughput Capacity](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-throughput-capacity.html).
     */
    public val throughputCapacity: kotlin.Int? = builder.throughputCapacity
    /**
     * The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone. Where d is the weekday number, from 1 through 7, with 1 = Monday and 7 = Sunday.
     */
    public val weeklyMaintenanceStartTime: kotlin.String? = builder.weeklyMaintenanceStartTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.UpdateFileSystemWindowsConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateFileSystemWindowsConfiguration(")
        append("auditLogConfiguration=$auditLogConfiguration,")
        append("automaticBackupRetentionDays=$automaticBackupRetentionDays,")
        append("dailyAutomaticBackupStartTime=$dailyAutomaticBackupStartTime,")
        append("diskIopsConfiguration=$diskIopsConfiguration,")
        append("selfManagedActiveDirectoryConfiguration=$selfManagedActiveDirectoryConfiguration,")
        append("throughputCapacity=$throughputCapacity,")
        append("weeklyMaintenanceStartTime=$weeklyMaintenanceStartTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = auditLogConfiguration?.hashCode() ?: 0
        result = 31 * result + (automaticBackupRetentionDays ?: 0)
        result = 31 * result + (dailyAutomaticBackupStartTime?.hashCode() ?: 0)
        result = 31 * result + (diskIopsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (selfManagedActiveDirectoryConfiguration?.hashCode() ?: 0)
        result = 31 * result + (throughputCapacity ?: 0)
        result = 31 * result + (weeklyMaintenanceStartTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateFileSystemWindowsConfiguration

        if (auditLogConfiguration != other.auditLogConfiguration) return false
        if (automaticBackupRetentionDays != other.automaticBackupRetentionDays) return false
        if (dailyAutomaticBackupStartTime != other.dailyAutomaticBackupStartTime) return false
        if (diskIopsConfiguration != other.diskIopsConfiguration) return false
        if (selfManagedActiveDirectoryConfiguration != other.selfManagedActiveDirectoryConfiguration) return false
        if (throughputCapacity != other.throughputCapacity) return false
        if (weeklyMaintenanceStartTime != other.weeklyMaintenanceStartTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.UpdateFileSystemWindowsConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The configuration that Amazon FSx for Windows File Server uses to audit and log user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server file system..
         */
        public var auditLogConfiguration: aws.sdk.kotlin.services.fsx.model.WindowsAuditLogCreateConfiguration? = null
        /**
         * The number of days to retain automatic backups. Setting this property to `0` disables automatic backups. You can retain automatic backups for a maximum of 90 days. The default is `30`. For more information, see [Working with Automatic Daily Backups](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/using-backups.html#automatic-backups).
         */
        public var automaticBackupRetentionDays: kotlin.Int? = null
        /**
         * The preferred time to start the daily automatic backup, in the UTC time zone, for example, `02:00`
         */
        public var dailyAutomaticBackupStartTime: kotlin.String? = null
        /**
         * The SSD IOPS (input/output operations per second) configuration for an Amazon FSx for Windows file system. By default, Amazon FSx automatically provisions 3 IOPS per GiB of storage capacity. You can provision additional IOPS per GiB of storage, up to the maximum limit associated with your chosen throughput capacity.
         */
        public var diskIopsConfiguration: aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration? = null
        /**
         * The configuration Amazon FSx uses to join the Windows File Server instance to the self-managed Microsoft AD directory. You cannot make a self-managed Microsoft AD update request if there is an existing self-managed Microsoft AD update request in progress.
         */
        public var selfManagedActiveDirectoryConfiguration: aws.sdk.kotlin.services.fsx.model.SelfManagedActiveDirectoryConfigurationUpdates? = null
        /**
         * Sets the target value for a file system's throughput capacity, in MB/s, that you are updating the file system to. Valid values are 8, 16, 32, 64, 128, 256, 512, 1024, 2048. You cannot make a throughput capacity update request if there is an existing throughput capacity update request in progress. For more information, see [Managing Throughput Capacity](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-throughput-capacity.html).
         */
        public var throughputCapacity: kotlin.Int? = null
        /**
         * The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone. Where d is the weekday number, from 1 through 7, with 1 = Monday and 7 = Sunday.
         */
        public var weeklyMaintenanceStartTime: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.UpdateFileSystemWindowsConfiguration) : this() {
            this.auditLogConfiguration = x.auditLogConfiguration
            this.automaticBackupRetentionDays = x.automaticBackupRetentionDays
            this.dailyAutomaticBackupStartTime = x.dailyAutomaticBackupStartTime
            this.diskIopsConfiguration = x.diskIopsConfiguration
            this.selfManagedActiveDirectoryConfiguration = x.selfManagedActiveDirectoryConfiguration
            this.throughputCapacity = x.throughputCapacity
            this.weeklyMaintenanceStartTime = x.weeklyMaintenanceStartTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.UpdateFileSystemWindowsConfiguration = UpdateFileSystemWindowsConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.WindowsAuditLogCreateConfiguration] inside the given [block]
         */
        public fun auditLogConfiguration(block: aws.sdk.kotlin.services.fsx.model.WindowsAuditLogCreateConfiguration.Builder.() -> kotlin.Unit) {
            this.auditLogConfiguration = aws.sdk.kotlin.services.fsx.model.WindowsAuditLogCreateConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration] inside the given [block]
         */
        public fun diskIopsConfiguration(block: aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration.Builder.() -> kotlin.Unit) {
            this.diskIopsConfiguration = aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.SelfManagedActiveDirectoryConfigurationUpdates] inside the given [block]
         */
        public fun selfManagedActiveDirectoryConfiguration(block: aws.sdk.kotlin.services.fsx.model.SelfManagedActiveDirectoryConfigurationUpdates.Builder.() -> kotlin.Unit) {
            this.selfManagedActiveDirectoryConfiguration = aws.sdk.kotlin.services.fsx.model.SelfManagedActiveDirectoryConfigurationUpdates.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
