// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The Lustre metadata performance configuration update for an Amazon FSx for Lustre file system using a `PERSISTENT_2` deployment type. You can request an increase in your file system's Metadata IOPS and/or switch your file system's metadata configuration mode. For more information, see [Managing metadata performance](https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-metadata-performance.html) in the *Amazon FSx for Lustre User Guide*.
 */
public class UpdateFileSystemLustreMetadataConfiguration private constructor(builder: Builder) {
    /**
     * (USER_PROVISIONED mode only) Specifies the number of Metadata IOPS to provision for your file system. Valid values are `1500`, `3000`, `6000`, `12000`, and multiples of `12000` up to a maximum of `192000`.
     *
     * The value you provide must be greater than or equal to the current number of Metadata IOPS provisioned for the file system.
     */
    public val iops: kotlin.Int? = builder.iops
    /**
     * The metadata configuration mode for provisioning Metadata IOPS for an FSx for Lustre file system using a `PERSISTENT_2` deployment type.
     * + To increase the Metadata IOPS or to switch from AUTOMATIC mode, specify `USER_PROVISIONED` as the value for this parameter. Then use the Iops parameter to provide a Metadata IOPS value that is greater than or equal to the current number of Metadata IOPS provisioned for the file system.
     * + To switch from USER_PROVISIONED mode, specify `AUTOMATIC` as the value for this parameter, but do not input a value for Iops.If you request to switch from USER_PROVISIONED to AUTOMATIC mode and the current Metadata IOPS value is greater than the automated default, FSx for Lustre rejects the request because downscaling Metadata IOPS is not supported.
     */
    public val mode: aws.sdk.kotlin.services.fsx.model.MetadataConfigurationMode? = builder.mode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.UpdateFileSystemLustreMetadataConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateFileSystemLustreMetadataConfiguration(")
        append("iops=$iops,")
        append("mode=$mode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = iops ?: 0
        result = 31 * result + (mode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateFileSystemLustreMetadataConfiguration

        if (iops != other.iops) return false
        if (mode != other.mode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.UpdateFileSystemLustreMetadataConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * (USER_PROVISIONED mode only) Specifies the number of Metadata IOPS to provision for your file system. Valid values are `1500`, `3000`, `6000`, `12000`, and multiples of `12000` up to a maximum of `192000`.
         *
         * The value you provide must be greater than or equal to the current number of Metadata IOPS provisioned for the file system.
         */
        public var iops: kotlin.Int? = null
        /**
         * The metadata configuration mode for provisioning Metadata IOPS for an FSx for Lustre file system using a `PERSISTENT_2` deployment type.
         * + To increase the Metadata IOPS or to switch from AUTOMATIC mode, specify `USER_PROVISIONED` as the value for this parameter. Then use the Iops parameter to provide a Metadata IOPS value that is greater than or equal to the current number of Metadata IOPS provisioned for the file system.
         * + To switch from USER_PROVISIONED mode, specify `AUTOMATIC` as the value for this parameter, but do not input a value for Iops.If you request to switch from USER_PROVISIONED to AUTOMATIC mode and the current Metadata IOPS value is greater than the automated default, FSx for Lustre rejects the request because downscaling Metadata IOPS is not supported.
         */
        public var mode: aws.sdk.kotlin.services.fsx.model.MetadataConfigurationMode? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.UpdateFileSystemLustreMetadataConfiguration) : this() {
            this.iops = x.iops
            this.mode = x.mode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.UpdateFileSystemLustreMetadataConfiguration = UpdateFileSystemLustreMetadataConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
