// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration object for Amazon FSx for Lustre file systems used in the `UpdateFileSystem` operation.
 */
public class UpdateFileSystemLustreConfiguration private constructor(builder: Builder) {
    /**
     * (Optional) When you create your file system, your existing S3 objects appear as file and directory listings. Use this property to choose how Amazon FSx keeps your file and directory listing up to date as you add or modify objects in your linked S3 bucket. `AutoImportPolicy` can have the following values:
     * + `NONE` - (Default) AutoImport is off. Amazon FSx only updates file and directory listings from the linked S3 bucket when the file system is created. FSx does not update the file and directory listing for any new or changed objects after choosing this option.
     * + `NEW` - AutoImport is on. Amazon FSx automatically imports directory listings of any new objects added to the linked S3 bucket that do not currently exist in the FSx file system.
     * + `NEW_CHANGED` - AutoImport is on. Amazon FSx automatically imports file and directory listings of any new objects added to the S3 bucket and any existing objects that are changed in the S3 bucket after you choose this option.
     * + `NEW_CHANGED_DELETED` - AutoImport is on. Amazon FSx automatically imports file and directory listings of any new objects added to the S3 bucket, any existing objects that are changed in the S3 bucket, and any objects that were deleted in the S3 bucket.
     *
     * This parameter is not supported for file systems with a data repository association.
     */
    public val autoImportPolicy: aws.sdk.kotlin.services.fsx.model.AutoImportPolicyType? = builder.autoImportPolicy
    /**
     * The number of days to retain automatic backups. Setting this property to `0` disables automatic backups. You can retain automatic backups for a maximum of 90 days. The default is `0`.
     */
    public val automaticBackupRetentionDays: kotlin.Int? = builder.automaticBackupRetentionDays
    /**
     * A recurring daily time, in the format `HH:MM`. `HH` is the zero-padded hour of the day (0-23), and `MM` is the zero-padded minute of the hour. For example, `05:00` specifies 5 AM daily.
     */
    public val dailyAutomaticBackupStartTime: kotlin.String? = builder.dailyAutomaticBackupStartTime
    /**
     * Sets the data compression configuration for the file system. `DataCompressionType` can have the following values:
     * + `NONE` - Data compression is turned off for the file system.
     * + `LZ4` - Data compression is turned on with the LZ4 algorithm.
     *
     * If you don't use `DataCompressionType`, the file system retains its current data compression configuration.
     *
     * For more information, see [Lustre data compression](https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html).
     */
    public val dataCompressionType: aws.sdk.kotlin.services.fsx.model.DataCompressionType? = builder.dataCompressionType
    /**
     * The Lustre logging configuration used when updating an Amazon FSx for Lustre file system. When logging is enabled, Lustre logs error and warning events for data repositories associated with your file system to Amazon CloudWatch Logs.
     */
    public val logConfiguration: aws.sdk.kotlin.services.fsx.model.LustreLogCreateConfiguration? = builder.logConfiguration
    /**
     * The Lustre metadata performance configuration for an Amazon FSx for Lustre file system using a `PERSISTENT_2` deployment type. When this configuration is enabled, the file system supports increasing metadata performance.
     */
    public val metadataConfiguration: aws.sdk.kotlin.services.fsx.model.UpdateFileSystemLustreMetadataConfiguration? = builder.metadataConfiguration
    /**
     * The throughput of an Amazon FSx for Lustre Persistent SSD-based file system, measured in megabytes per second per tebibyte (MB/s/TiB). You can increase or decrease your file system's throughput. Valid values depend on the deployment type of the file system, as follows:
     * + For `PERSISTENT_1` SSD-based deployment types, valid values are 50, 100, and 200 MB/s/TiB.
     * + For `PERSISTENT_2` SSD-based deployment types, valid values are 125, 250, 500, and 1000 MB/s/TiB.
     *
     * For more information, see [ Managing throughput capacity](https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-throughput-capacity.html).
     */
    public val perUnitStorageThroughput: kotlin.Int? = builder.perUnitStorageThroughput
    /**
     * The Lustre root squash configuration used when updating an Amazon FSx for Lustre file system. When enabled, root squash restricts root-level access from clients that try to access your file system as a root user.
     */
    public val rootSquashConfiguration: aws.sdk.kotlin.services.fsx.model.LustreRootSquashConfiguration? = builder.rootSquashConfiguration
    /**
     * (Optional) The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone. d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.
     */
    public val weeklyMaintenanceStartTime: kotlin.String? = builder.weeklyMaintenanceStartTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.UpdateFileSystemLustreConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateFileSystemLustreConfiguration(")
        append("autoImportPolicy=$autoImportPolicy,")
        append("automaticBackupRetentionDays=$automaticBackupRetentionDays,")
        append("dailyAutomaticBackupStartTime=$dailyAutomaticBackupStartTime,")
        append("dataCompressionType=$dataCompressionType,")
        append("logConfiguration=$logConfiguration,")
        append("metadataConfiguration=$metadataConfiguration,")
        append("perUnitStorageThroughput=$perUnitStorageThroughput,")
        append("rootSquashConfiguration=$rootSquashConfiguration,")
        append("weeklyMaintenanceStartTime=$weeklyMaintenanceStartTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoImportPolicy?.hashCode() ?: 0
        result = 31 * result + (automaticBackupRetentionDays ?: 0)
        result = 31 * result + (dailyAutomaticBackupStartTime?.hashCode() ?: 0)
        result = 31 * result + (dataCompressionType?.hashCode() ?: 0)
        result = 31 * result + (logConfiguration?.hashCode() ?: 0)
        result = 31 * result + (metadataConfiguration?.hashCode() ?: 0)
        result = 31 * result + (perUnitStorageThroughput ?: 0)
        result = 31 * result + (rootSquashConfiguration?.hashCode() ?: 0)
        result = 31 * result + (weeklyMaintenanceStartTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateFileSystemLustreConfiguration

        if (autoImportPolicy != other.autoImportPolicy) return false
        if (automaticBackupRetentionDays != other.automaticBackupRetentionDays) return false
        if (dailyAutomaticBackupStartTime != other.dailyAutomaticBackupStartTime) return false
        if (dataCompressionType != other.dataCompressionType) return false
        if (logConfiguration != other.logConfiguration) return false
        if (metadataConfiguration != other.metadataConfiguration) return false
        if (perUnitStorageThroughput != other.perUnitStorageThroughput) return false
        if (rootSquashConfiguration != other.rootSquashConfiguration) return false
        if (weeklyMaintenanceStartTime != other.weeklyMaintenanceStartTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.UpdateFileSystemLustreConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * (Optional) When you create your file system, your existing S3 objects appear as file and directory listings. Use this property to choose how Amazon FSx keeps your file and directory listing up to date as you add or modify objects in your linked S3 bucket. `AutoImportPolicy` can have the following values:
         * + `NONE` - (Default) AutoImport is off. Amazon FSx only updates file and directory listings from the linked S3 bucket when the file system is created. FSx does not update the file and directory listing for any new or changed objects after choosing this option.
         * + `NEW` - AutoImport is on. Amazon FSx automatically imports directory listings of any new objects added to the linked S3 bucket that do not currently exist in the FSx file system.
         * + `NEW_CHANGED` - AutoImport is on. Amazon FSx automatically imports file and directory listings of any new objects added to the S3 bucket and any existing objects that are changed in the S3 bucket after you choose this option.
         * + `NEW_CHANGED_DELETED` - AutoImport is on. Amazon FSx automatically imports file and directory listings of any new objects added to the S3 bucket, any existing objects that are changed in the S3 bucket, and any objects that were deleted in the S3 bucket.
         *
         * This parameter is not supported for file systems with a data repository association.
         */
        public var autoImportPolicy: aws.sdk.kotlin.services.fsx.model.AutoImportPolicyType? = null
        /**
         * The number of days to retain automatic backups. Setting this property to `0` disables automatic backups. You can retain automatic backups for a maximum of 90 days. The default is `0`.
         */
        public var automaticBackupRetentionDays: kotlin.Int? = null
        /**
         * A recurring daily time, in the format `HH:MM`. `HH` is the zero-padded hour of the day (0-23), and `MM` is the zero-padded minute of the hour. For example, `05:00` specifies 5 AM daily.
         */
        public var dailyAutomaticBackupStartTime: kotlin.String? = null
        /**
         * Sets the data compression configuration for the file system. `DataCompressionType` can have the following values:
         * + `NONE` - Data compression is turned off for the file system.
         * + `LZ4` - Data compression is turned on with the LZ4 algorithm.
         *
         * If you don't use `DataCompressionType`, the file system retains its current data compression configuration.
         *
         * For more information, see [Lustre data compression](https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html).
         */
        public var dataCompressionType: aws.sdk.kotlin.services.fsx.model.DataCompressionType? = null
        /**
         * The Lustre logging configuration used when updating an Amazon FSx for Lustre file system. When logging is enabled, Lustre logs error and warning events for data repositories associated with your file system to Amazon CloudWatch Logs.
         */
        public var logConfiguration: aws.sdk.kotlin.services.fsx.model.LustreLogCreateConfiguration? = null
        /**
         * The Lustre metadata performance configuration for an Amazon FSx for Lustre file system using a `PERSISTENT_2` deployment type. When this configuration is enabled, the file system supports increasing metadata performance.
         */
        public var metadataConfiguration: aws.sdk.kotlin.services.fsx.model.UpdateFileSystemLustreMetadataConfiguration? = null
        /**
         * The throughput of an Amazon FSx for Lustre Persistent SSD-based file system, measured in megabytes per second per tebibyte (MB/s/TiB). You can increase or decrease your file system's throughput. Valid values depend on the deployment type of the file system, as follows:
         * + For `PERSISTENT_1` SSD-based deployment types, valid values are 50, 100, and 200 MB/s/TiB.
         * + For `PERSISTENT_2` SSD-based deployment types, valid values are 125, 250, 500, and 1000 MB/s/TiB.
         *
         * For more information, see [ Managing throughput capacity](https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-throughput-capacity.html).
         */
        public var perUnitStorageThroughput: kotlin.Int? = null
        /**
         * The Lustre root squash configuration used when updating an Amazon FSx for Lustre file system. When enabled, root squash restricts root-level access from clients that try to access your file system as a root user.
         */
        public var rootSquashConfiguration: aws.sdk.kotlin.services.fsx.model.LustreRootSquashConfiguration? = null
        /**
         * (Optional) The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone. d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.
         */
        public var weeklyMaintenanceStartTime: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.UpdateFileSystemLustreConfiguration) : this() {
            this.autoImportPolicy = x.autoImportPolicy
            this.automaticBackupRetentionDays = x.automaticBackupRetentionDays
            this.dailyAutomaticBackupStartTime = x.dailyAutomaticBackupStartTime
            this.dataCompressionType = x.dataCompressionType
            this.logConfiguration = x.logConfiguration
            this.metadataConfiguration = x.metadataConfiguration
            this.perUnitStorageThroughput = x.perUnitStorageThroughput
            this.rootSquashConfiguration = x.rootSquashConfiguration
            this.weeklyMaintenanceStartTime = x.weeklyMaintenanceStartTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.UpdateFileSystemLustreConfiguration = UpdateFileSystemLustreConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.LustreLogCreateConfiguration] inside the given [block]
         */
        public fun logConfiguration(block: aws.sdk.kotlin.services.fsx.model.LustreLogCreateConfiguration.Builder.() -> kotlin.Unit) {
            this.logConfiguration = aws.sdk.kotlin.services.fsx.model.LustreLogCreateConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.UpdateFileSystemLustreMetadataConfiguration] inside the given [block]
         */
        public fun metadataConfiguration(block: aws.sdk.kotlin.services.fsx.model.UpdateFileSystemLustreMetadataConfiguration.Builder.() -> kotlin.Unit) {
            this.metadataConfiguration = aws.sdk.kotlin.services.fsx.model.UpdateFileSystemLustreMetadataConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.LustreRootSquashConfiguration] inside the given [block]
         */
        public fun rootSquashConfiguration(block: aws.sdk.kotlin.services.fsx.model.LustreRootSquashConfiguration.Builder.() -> kotlin.Unit) {
            this.rootSquashConfiguration = aws.sdk.kotlin.services.fsx.model.LustreRootSquashConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
