// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration of the self-managed Microsoft Active Directory (AD) directory to which the Windows File Server or ONTAP storage virtual machine (SVM) instance is joined.
 */
public class SelfManagedActiveDirectoryAttributes private constructor(builder: Builder) {
    /**
     * A list of up to three IP addresses of DNS servers or domain controllers in the self-managed AD directory.
     */
    public val dnsIps: List<String>? = builder.dnsIps
    /**
     * The fully qualified domain name of the self-managed AD directory.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * The name of the domain group whose members have administrative privileges for the FSx file system.
     */
    public val fileSystemAdministratorsGroup: kotlin.String? = builder.fileSystemAdministratorsGroup
    /**
     * The fully qualified distinguished name of the organizational unit within the self-managed AD directory to which the Windows File Server or ONTAP storage virtual machine (SVM) instance is joined.
     */
    public val organizationalUnitDistinguishedName: kotlin.String? = builder.organizationalUnitDistinguishedName
    /**
     * The user name for the service account on your self-managed AD domain that FSx uses to join to your AD domain.
     */
    public val userName: kotlin.String? = builder.userName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.SelfManagedActiveDirectoryAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SelfManagedActiveDirectoryAttributes(")
        append("dnsIps=$dnsIps,")
        append("domainName=$domainName,")
        append("fileSystemAdministratorsGroup=$fileSystemAdministratorsGroup,")
        append("organizationalUnitDistinguishedName=$organizationalUnitDistinguishedName,")
        append("userName=$userName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dnsIps?.hashCode() ?: 0
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (fileSystemAdministratorsGroup?.hashCode() ?: 0)
        result = 31 * result + (organizationalUnitDistinguishedName?.hashCode() ?: 0)
        result = 31 * result + (userName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SelfManagedActiveDirectoryAttributes

        if (dnsIps != other.dnsIps) return false
        if (domainName != other.domainName) return false
        if (fileSystemAdministratorsGroup != other.fileSystemAdministratorsGroup) return false
        if (organizationalUnitDistinguishedName != other.organizationalUnitDistinguishedName) return false
        if (userName != other.userName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.SelfManagedActiveDirectoryAttributes = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of up to three IP addresses of DNS servers or domain controllers in the self-managed AD directory.
         */
        public var dnsIps: List<String>? = null
        /**
         * The fully qualified domain name of the self-managed AD directory.
         */
        public var domainName: kotlin.String? = null
        /**
         * The name of the domain group whose members have administrative privileges for the FSx file system.
         */
        public var fileSystemAdministratorsGroup: kotlin.String? = null
        /**
         * The fully qualified distinguished name of the organizational unit within the self-managed AD directory to which the Windows File Server or ONTAP storage virtual machine (SVM) instance is joined.
         */
        public var organizationalUnitDistinguishedName: kotlin.String? = null
        /**
         * The user name for the service account on your self-managed AD domain that FSx uses to join to your AD domain.
         */
        public var userName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.SelfManagedActiveDirectoryAttributes) : this() {
            this.dnsIps = x.dnsIps
            this.domainName = x.domainName
            this.fileSystemAdministratorsGroup = x.fileSystemAdministratorsGroup
            this.organizationalUnitDistinguishedName = x.organizationalUnitDistinguishedName
            this.userName = x.userName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.SelfManagedActiveDirectoryAttributes = SelfManagedActiveDirectoryAttributes(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
