// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration for an Amazon S3 data repository linked to an Amazon FSx for Lustre file system with a data repository association. The configuration consists of an `AutoImportPolicy` that defines which file events on the data repository are automatically imported to the file system and an `AutoExportPolicy` that defines which file events on the file system are automatically exported to the data repository. File events are when files or directories are added, changed, or deleted on the file system or the data repository.
 *
 * Data repository associations on Amazon File Cache don't use `S3DataRepositoryConfiguration` because they don't support automatic import or automatic export.
 */
public class S3DataRepositoryConfiguration private constructor(builder: Builder) {
    /**
     * Specifies the type of updated objects (new, changed, deleted) that will be automatically exported from your file system to the linked S3 bucket.
     */
    public val autoExportPolicy: aws.sdk.kotlin.services.fsx.model.AutoExportPolicy? = builder.autoExportPolicy
    /**
     * Specifies the type of updated objects (new, changed, deleted) that will be automatically imported from the linked S3 bucket to your file system.
     */
    public val autoImportPolicy: aws.sdk.kotlin.services.fsx.model.AutoImportPolicy? = builder.autoImportPolicy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.S3DataRepositoryConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3DataRepositoryConfiguration(")
        append("autoExportPolicy=$autoExportPolicy,")
        append("autoImportPolicy=$autoImportPolicy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoExportPolicy?.hashCode() ?: 0
        result = 31 * result + (autoImportPolicy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3DataRepositoryConfiguration

        if (autoExportPolicy != other.autoExportPolicy) return false
        if (autoImportPolicy != other.autoImportPolicy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.S3DataRepositoryConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the type of updated objects (new, changed, deleted) that will be automatically exported from your file system to the linked S3 bucket.
         */
        public var autoExportPolicy: aws.sdk.kotlin.services.fsx.model.AutoExportPolicy? = null
        /**
         * Specifies the type of updated objects (new, changed, deleted) that will be automatically imported from the linked S3 bucket to your file system.
         */
        public var autoImportPolicy: aws.sdk.kotlin.services.fsx.model.AutoImportPolicy? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.S3DataRepositoryConfiguration) : this() {
            this.autoExportPolicy = x.autoExportPolicy
            this.autoImportPolicy = x.autoImportPolicy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.S3DataRepositoryConfiguration = S3DataRepositoryConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.AutoExportPolicy] inside the given [block]
         */
        public fun autoExportPolicy(block: aws.sdk.kotlin.services.fsx.model.AutoExportPolicy.Builder.() -> kotlin.Unit) {
            this.autoExportPolicy = aws.sdk.kotlin.services.fsx.model.AutoExportPolicy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.AutoImportPolicy] inside the given [block]
         */
        public fun autoImportPolicy(block: aws.sdk.kotlin.services.fsx.model.AutoImportPolicy.Builder.() -> kotlin.Unit) {
            this.autoImportPolicy = aws.sdk.kotlin.services.fsx.model.AutoImportPolicy.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
