// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the retention period of an FSx for ONTAP SnapLock volume. After it is set, it can't be changed. Files can't be deleted or modified during the retention period.
 *
 * For more information, see [Working with the retention period in SnapLock](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-retention.html).
 */
public class RetentionPeriod private constructor(builder: Builder) {
    /**
     * Defines the type of time for the retention period of an FSx for ONTAP SnapLock volume. Set it to one of the valid types. If you set it to `INFINITE`, the files are retained forever. If you set it to `UNSPECIFIED`, the files are retained until you set an explicit retention period.
     */
    public val type: aws.sdk.kotlin.services.fsx.model.RetentionPeriodType? = builder.type
    /**
     * Defines the amount of time for the retention period of an FSx for ONTAP SnapLock volume. You can't set a value for `INFINITE` or `UNSPECIFIED`. For all other options, the following ranges are valid:
     * + `Seconds`: 0 - 65,535
     * + `Minutes`: 0 - 65,535
     * + `Hours`: 0 - 24
     * + `Days`: 0 - 365
     * + `Months`: 0 - 12
     * + `Years`: 0 - 100
     */
    public val value: kotlin.Int? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.RetentionPeriod = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RetentionPeriod(")
        append("type=$type,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = type?.hashCode() ?: 0
        result = 31 * result + (value ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RetentionPeriod

        if (type != other.type) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.RetentionPeriod = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Defines the type of time for the retention period of an FSx for ONTAP SnapLock volume. Set it to one of the valid types. If you set it to `INFINITE`, the files are retained forever. If you set it to `UNSPECIFIED`, the files are retained until you set an explicit retention period.
         */
        public var type: aws.sdk.kotlin.services.fsx.model.RetentionPeriodType? = null
        /**
         * Defines the amount of time for the retention period of an FSx for ONTAP SnapLock volume. You can't set a value for `INFINITE` or `UNSPECIFIED`. For all other options, the following ranges are valid:
         * + `Seconds`: 0 - 65,535
         * + `Minutes`: 0 - 65,535
         * + `Hours`: 0 - 24
         * + `Days`: 0 - 365
         * + `Months`: 0 - 12
         * + `Years`: 0 - 100
         */
        public var value: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.RetentionPeriod) : this() {
            this.type = x.type
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.RetentionPeriod = RetentionPeriod(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
