// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration for the optional provisioned SSD read cache on file systems that use the Intelligent-Tiering storage class.
 */
public class OpenZfsReadCacheConfiguration private constructor(builder: Builder) {
    /**
     * Required if `SizingMode` is set to `USER_PROVISIONED`. Specifies the size of the file system's SSD read cache, in gibibytes (GiB).
     */
    public val sizeGib: kotlin.Int? = builder.sizeGib
    /**
     * Specifies how the provisioned SSD read cache is sized, as follows:
     * + Set to `NO_CACHE` if you do not want to use an SSD read cache with your Intelligent-Tiering file system.
     * + Set to `USER_PROVISIONED` to specify the exact size of your SSD read cache.
     * + Set to `PROPORTIONAL_TO_THROUGHPUT_CAPACITY` to have your SSD read cache automatically sized based on your throughput capacity.
     */
    public val sizingMode: aws.sdk.kotlin.services.fsx.model.OpenZfsReadCacheSizingMode? = builder.sizingMode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.OpenZfsReadCacheConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OpenZfsReadCacheConfiguration(")
        append("sizeGib=$sizeGib,")
        append("sizingMode=$sizingMode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = sizeGib ?: 0
        result = 31 * result + (sizingMode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OpenZfsReadCacheConfiguration

        if (sizeGib != other.sizeGib) return false
        if (sizingMode != other.sizingMode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.OpenZfsReadCacheConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Required if `SizingMode` is set to `USER_PROVISIONED`. Specifies the size of the file system's SSD read cache, in gibibytes (GiB).
         */
        public var sizeGib: kotlin.Int? = null
        /**
         * Specifies how the provisioned SSD read cache is sized, as follows:
         * + Set to `NO_CACHE` if you do not want to use an SSD read cache with your Intelligent-Tiering file system.
         * + Set to `USER_PROVISIONED` to specify the exact size of your SSD read cache.
         * + Set to `PROPORTIONAL_TO_THROUGHPUT_CAPACITY` to have your SSD read cache automatically sized based on your throughput capacity.
         */
        public var sizingMode: aws.sdk.kotlin.services.fsx.model.OpenZfsReadCacheSizingMode? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.OpenZfsReadCacheConfiguration) : this() {
            this.sizeGib = x.sizeGib
            this.sizingMode = x.sizingMode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.OpenZfsReadCacheConfiguration = OpenZfsReadCacheConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
