// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The snapshot configuration used when creating an Amazon FSx for OpenZFS volume from a snapshot.
 */
public class OpenZfsOriginSnapshotConfiguration private constructor(builder: Builder) {
    /**
     * The strategy used when copying data from the snapshot to the new volume.
     * + `CLONE` - The new volume references the data in the origin snapshot. Cloning a snapshot is faster than copying the data from a snapshot to a new volume and doesn't consume disk throughput. However, the origin snapshot can't be deleted if there is a volume using its copied data.
     * + `FULL_COPY` - Copies all data from the snapshot to the new volume.
     *
     * The `INCREMENTAL_COPY` option is only for updating an existing volume by using a snapshot from another FSx for OpenZFS file system. For more information, see [CopySnapshotAndUpdateVolume](https://docs.aws.amazon.com/fsx/latest/APIReference/API_CopySnapshotAndUpdateVolume.html).
     */
    public val copyStrategy: aws.sdk.kotlin.services.fsx.model.OpenZfsCopyStrategy? = builder.copyStrategy
    /**
     * The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services resources. We require an ARN when you need to specify a resource unambiguously across all of Amazon Web Services. For more information, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
     */
    public val snapshotArn: kotlin.String? = builder.snapshotArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.OpenZfsOriginSnapshotConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OpenZfsOriginSnapshotConfiguration(")
        append("copyStrategy=$copyStrategy,")
        append("snapshotArn=$snapshotArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = copyStrategy?.hashCode() ?: 0
        result = 31 * result + (snapshotArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OpenZfsOriginSnapshotConfiguration

        if (copyStrategy != other.copyStrategy) return false
        if (snapshotArn != other.snapshotArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.OpenZfsOriginSnapshotConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The strategy used when copying data from the snapshot to the new volume.
         * + `CLONE` - The new volume references the data in the origin snapshot. Cloning a snapshot is faster than copying the data from a snapshot to a new volume and doesn't consume disk throughput. However, the origin snapshot can't be deleted if there is a volume using its copied data.
         * + `FULL_COPY` - Copies all data from the snapshot to the new volume.
         *
         * The `INCREMENTAL_COPY` option is only for updating an existing volume by using a snapshot from another FSx for OpenZFS file system. For more information, see [CopySnapshotAndUpdateVolume](https://docs.aws.amazon.com/fsx/latest/APIReference/API_CopySnapshotAndUpdateVolume.html).
         */
        public var copyStrategy: aws.sdk.kotlin.services.fsx.model.OpenZfsCopyStrategy? = null
        /**
         * The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services resources. We require an ARN when you need to specify a resource unambiguously across all of Amazon Web Services. For more information, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
         */
        public var snapshotArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.OpenZfsOriginSnapshotConfiguration) : this() {
            this.copyStrategy = x.copyStrategy
            this.snapshotArn = x.snapshotArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.OpenZfsOriginSnapshotConfiguration = OpenZfsOriginSnapshotConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
