// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Configuration for the FSx for NetApp ONTAP file system.
 */
public class OntapFileSystemConfiguration private constructor(builder: Builder) {
    /**
     * The number of days to retain automatic backups. Setting this property to `0` disables automatic backups. You can retain automatic backups for a maximum of 90 days. The default is `30`.
     */
    public val automaticBackupRetentionDays: kotlin.Int? = builder.automaticBackupRetentionDays
    /**
     * A recurring daily time, in the format `HH:MM`. `HH` is the zero-padded hour of the day (0-23), and `MM` is the zero-padded minute of the hour. For example, `05:00` specifies 5 AM daily.
     */
    public val dailyAutomaticBackupStartTime: kotlin.String? = builder.dailyAutomaticBackupStartTime
    /**
     * Specifies the FSx for ONTAP file system deployment type in use in the file system.
     * + `MULTI_AZ_1` - A high availability file system configured for Multi-AZ redundancy to tolerate temporary Availability Zone (AZ) unavailability. This is a first-generation FSx for ONTAP file system.
     * + `MULTI_AZ_2` - A high availability file system configured for Multi-AZ redundancy to tolerate temporary AZ unavailability. This is a second-generation FSx for ONTAP file system.
     * + `SINGLE_AZ_1` - A file system configured for Single-AZ redundancy. This is a first-generation FSx for ONTAP file system.
     * + `SINGLE_AZ_2` - A file system configured with multiple high-availability (HA) pairs for Single-AZ redundancy. This is a second-generation FSx for ONTAP file system.
     *
     * For information about the use cases for Multi-AZ and Single-AZ deployments, refer to [Choosing Multi-AZ or Single-AZ file system deployment](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/high-availability-multiAZ.html).
     */
    public val deploymentType: aws.sdk.kotlin.services.fsx.model.OntapDeploymentType? = builder.deploymentType
    /**
     * The SSD IOPS configuration for the ONTAP file system, specifying the number of provisioned IOPS and the provision mode.
     */
    public val diskIopsConfiguration: aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration? = builder.diskIopsConfiguration
    /**
     * (Multi-AZ only) Specifies the IP address range in which the endpoints to access your file system will be created. By default in the Amazon FSx API, Amazon FSx selects an unused IP address range for you from the 198.19.* range. By default in the Amazon FSx console, Amazon FSx chooses the last 64 IP addresses from the VPC’s primary CIDR range to use as the endpoint IP address range for the file system. You can have overlapping endpoint IP addresses for file systems deployed in the same VPC/route tables.
     */
    public val endpointIpAddressRange: kotlin.String? = builder.endpointIpAddressRange
    /**
     * The `Management` and `Intercluster` endpoints that are used to access data or to manage the file system using the NetApp ONTAP CLI, REST API, or NetApp SnapMirror.
     */
    public val endpoints: aws.sdk.kotlin.services.fsx.model.FileSystemEndpoints? = builder.endpoints
    /**
     * You can use the `fsxadmin` user account to access the NetApp ONTAP CLI and REST API. The password value is always redacted in the response.
     */
    public val fsxAdminPassword: kotlin.String? = builder.fsxAdminPassword
    /**
     * Specifies how many high-availability (HA) file server pairs the file system will have. The default value is 1. The value of this property affects the values of `StorageCapacity`, `Iops`, and `ThroughputCapacity`. For more information, see [High-availability (HA) pairs](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/HA-pairs.html) in the FSx for ONTAP user guide.
     *
     * Amazon FSx responds with an HTTP status code 400 (Bad Request) for the following conditions:
     * + The value of `HAPairs` is less than 1 or greater than 12.
     * + The value of `HAPairs` is greater than 1 and the value of `DeploymentType` is `SINGLE_AZ_1`, `MULTI_AZ_1`, or `MULTI_AZ_2`.
     */
    public val haPairs: kotlin.Int? = builder.haPairs
    /**
     * The ID for a subnet. A *subnet* is a range of IP addresses in your virtual private cloud (VPC). For more information, see [VPC and subnets](https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Subnets.html) in the *Amazon VPC User Guide.*
     */
    public val preferredSubnetId: kotlin.String? = builder.preferredSubnetId
    /**
     * (Multi-AZ only) The VPC route tables in which your file system's endpoints are created.
     */
    public val routeTableIds: List<String>? = builder.routeTableIds
    /**
     * The sustained throughput of an Amazon FSx file system in Megabytes per second (MBps).
     */
    public val throughputCapacity: kotlin.Int? = builder.throughputCapacity
    /**
     * Use to choose the throughput capacity per HA pair. When the value of `HAPairs` is equal to 1, the value of `ThroughputCapacityPerHAPair` is the total throughput for the file system.
     *
     * This field and `ThroughputCapacity` cannot be defined in the same API call, but one is required.
     *
     * This field and `ThroughputCapacity` are the same for file systems with one HA pair.
     * + For `SINGLE_AZ_1` and `MULTI_AZ_1` file systems, valid values are 128, 256, 512, 1024, 2048, or 4096 MBps.
     * + For `SINGLE_AZ_2`, valid values are 1536, 3072, or 6144 MBps.
     * + For `MULTI_AZ_2`, valid values are 384, 768, 1536, 3072, or 6144 MBps.
     *
     * Amazon FSx responds with an HTTP status code 400 (Bad Request) for the following conditions:
     * + The value of `ThroughputCapacity` and `ThroughputCapacityPerHAPair` are not the same value.
     * + The value of deployment type is `SINGLE_AZ_2` and `ThroughputCapacity` / `ThroughputCapacityPerHAPair` is not a valid HA pair (a value between 1 and 12).
     * + The value of `ThroughputCapacityPerHAPair` is not a valid value.
     */
    public val throughputCapacityPerHaPair: kotlin.Int? = builder.throughputCapacityPerHaPair
    /**
     * A recurring weekly time, in the format `D:HH:MM`.
     *
     * `D` is the day of the week, for which 1 represents Monday and 7 represents Sunday. For further details, see [the ISO-8601 spec as described on Wikipedia](https://en.wikipedia.org/wiki/ISO_week_date).
     *
     * `HH` is the zero-padded hour of the day (0-23), and `MM` is the zero-padded minute of the hour.
     *
     * For example, `1:05:00` specifies maintenance at 5 AM Monday.
     */
    public val weeklyMaintenanceStartTime: kotlin.String? = builder.weeklyMaintenanceStartTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.OntapFileSystemConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OntapFileSystemConfiguration(")
        append("automaticBackupRetentionDays=$automaticBackupRetentionDays,")
        append("dailyAutomaticBackupStartTime=$dailyAutomaticBackupStartTime,")
        append("deploymentType=$deploymentType,")
        append("diskIopsConfiguration=$diskIopsConfiguration,")
        append("endpointIpAddressRange=$endpointIpAddressRange,")
        append("endpoints=$endpoints,")
        append("fsxAdminPassword=*** Sensitive Data Redacted ***,")
        append("haPairs=$haPairs,")
        append("preferredSubnetId=$preferredSubnetId,")
        append("routeTableIds=$routeTableIds,")
        append("throughputCapacity=$throughputCapacity,")
        append("throughputCapacityPerHaPair=$throughputCapacityPerHaPair,")
        append("weeklyMaintenanceStartTime=$weeklyMaintenanceStartTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = automaticBackupRetentionDays ?: 0
        result = 31 * result + (dailyAutomaticBackupStartTime?.hashCode() ?: 0)
        result = 31 * result + (deploymentType?.hashCode() ?: 0)
        result = 31 * result + (diskIopsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (endpointIpAddressRange?.hashCode() ?: 0)
        result = 31 * result + (endpoints?.hashCode() ?: 0)
        result = 31 * result + (fsxAdminPassword?.hashCode() ?: 0)
        result = 31 * result + (haPairs ?: 0)
        result = 31 * result + (preferredSubnetId?.hashCode() ?: 0)
        result = 31 * result + (routeTableIds?.hashCode() ?: 0)
        result = 31 * result + (throughputCapacity ?: 0)
        result = 31 * result + (throughputCapacityPerHaPair ?: 0)
        result = 31 * result + (weeklyMaintenanceStartTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OntapFileSystemConfiguration

        if (automaticBackupRetentionDays != other.automaticBackupRetentionDays) return false
        if (dailyAutomaticBackupStartTime != other.dailyAutomaticBackupStartTime) return false
        if (deploymentType != other.deploymentType) return false
        if (diskIopsConfiguration != other.diskIopsConfiguration) return false
        if (endpointIpAddressRange != other.endpointIpAddressRange) return false
        if (endpoints != other.endpoints) return false
        if (fsxAdminPassword != other.fsxAdminPassword) return false
        if (haPairs != other.haPairs) return false
        if (preferredSubnetId != other.preferredSubnetId) return false
        if (routeTableIds != other.routeTableIds) return false
        if (throughputCapacity != other.throughputCapacity) return false
        if (throughputCapacityPerHaPair != other.throughputCapacityPerHaPair) return false
        if (weeklyMaintenanceStartTime != other.weeklyMaintenanceStartTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.OntapFileSystemConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of days to retain automatic backups. Setting this property to `0` disables automatic backups. You can retain automatic backups for a maximum of 90 days. The default is `30`.
         */
        public var automaticBackupRetentionDays: kotlin.Int? = null
        /**
         * A recurring daily time, in the format `HH:MM`. `HH` is the zero-padded hour of the day (0-23), and `MM` is the zero-padded minute of the hour. For example, `05:00` specifies 5 AM daily.
         */
        public var dailyAutomaticBackupStartTime: kotlin.String? = null
        /**
         * Specifies the FSx for ONTAP file system deployment type in use in the file system.
         * + `MULTI_AZ_1` - A high availability file system configured for Multi-AZ redundancy to tolerate temporary Availability Zone (AZ) unavailability. This is a first-generation FSx for ONTAP file system.
         * + `MULTI_AZ_2` - A high availability file system configured for Multi-AZ redundancy to tolerate temporary AZ unavailability. This is a second-generation FSx for ONTAP file system.
         * + `SINGLE_AZ_1` - A file system configured for Single-AZ redundancy. This is a first-generation FSx for ONTAP file system.
         * + `SINGLE_AZ_2` - A file system configured with multiple high-availability (HA) pairs for Single-AZ redundancy. This is a second-generation FSx for ONTAP file system.
         *
         * For information about the use cases for Multi-AZ and Single-AZ deployments, refer to [Choosing Multi-AZ or Single-AZ file system deployment](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/high-availability-multiAZ.html).
         */
        public var deploymentType: aws.sdk.kotlin.services.fsx.model.OntapDeploymentType? = null
        /**
         * The SSD IOPS configuration for the ONTAP file system, specifying the number of provisioned IOPS and the provision mode.
         */
        public var diskIopsConfiguration: aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration? = null
        /**
         * (Multi-AZ only) Specifies the IP address range in which the endpoints to access your file system will be created. By default in the Amazon FSx API, Amazon FSx selects an unused IP address range for you from the 198.19.* range. By default in the Amazon FSx console, Amazon FSx chooses the last 64 IP addresses from the VPC’s primary CIDR range to use as the endpoint IP address range for the file system. You can have overlapping endpoint IP addresses for file systems deployed in the same VPC/route tables.
         */
        public var endpointIpAddressRange: kotlin.String? = null
        /**
         * The `Management` and `Intercluster` endpoints that are used to access data or to manage the file system using the NetApp ONTAP CLI, REST API, or NetApp SnapMirror.
         */
        public var endpoints: aws.sdk.kotlin.services.fsx.model.FileSystemEndpoints? = null
        /**
         * You can use the `fsxadmin` user account to access the NetApp ONTAP CLI and REST API. The password value is always redacted in the response.
         */
        public var fsxAdminPassword: kotlin.String? = null
        /**
         * Specifies how many high-availability (HA) file server pairs the file system will have. The default value is 1. The value of this property affects the values of `StorageCapacity`, `Iops`, and `ThroughputCapacity`. For more information, see [High-availability (HA) pairs](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/HA-pairs.html) in the FSx for ONTAP user guide.
         *
         * Amazon FSx responds with an HTTP status code 400 (Bad Request) for the following conditions:
         * + The value of `HAPairs` is less than 1 or greater than 12.
         * + The value of `HAPairs` is greater than 1 and the value of `DeploymentType` is `SINGLE_AZ_1`, `MULTI_AZ_1`, or `MULTI_AZ_2`.
         */
        public var haPairs: kotlin.Int? = null
        /**
         * The ID for a subnet. A *subnet* is a range of IP addresses in your virtual private cloud (VPC). For more information, see [VPC and subnets](https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Subnets.html) in the *Amazon VPC User Guide.*
         */
        public var preferredSubnetId: kotlin.String? = null
        /**
         * (Multi-AZ only) The VPC route tables in which your file system's endpoints are created.
         */
        public var routeTableIds: List<String>? = null
        /**
         * The sustained throughput of an Amazon FSx file system in Megabytes per second (MBps).
         */
        public var throughputCapacity: kotlin.Int? = null
        /**
         * Use to choose the throughput capacity per HA pair. When the value of `HAPairs` is equal to 1, the value of `ThroughputCapacityPerHAPair` is the total throughput for the file system.
         *
         * This field and `ThroughputCapacity` cannot be defined in the same API call, but one is required.
         *
         * This field and `ThroughputCapacity` are the same for file systems with one HA pair.
         * + For `SINGLE_AZ_1` and `MULTI_AZ_1` file systems, valid values are 128, 256, 512, 1024, 2048, or 4096 MBps.
         * + For `SINGLE_AZ_2`, valid values are 1536, 3072, or 6144 MBps.
         * + For `MULTI_AZ_2`, valid values are 384, 768, 1536, 3072, or 6144 MBps.
         *
         * Amazon FSx responds with an HTTP status code 400 (Bad Request) for the following conditions:
         * + The value of `ThroughputCapacity` and `ThroughputCapacityPerHAPair` are not the same value.
         * + The value of deployment type is `SINGLE_AZ_2` and `ThroughputCapacity` / `ThroughputCapacityPerHAPair` is not a valid HA pair (a value between 1 and 12).
         * + The value of `ThroughputCapacityPerHAPair` is not a valid value.
         */
        public var throughputCapacityPerHaPair: kotlin.Int? = null
        /**
         * A recurring weekly time, in the format `D:HH:MM`.
         *
         * `D` is the day of the week, for which 1 represents Monday and 7 represents Sunday. For further details, see [the ISO-8601 spec as described on Wikipedia](https://en.wikipedia.org/wiki/ISO_week_date).
         *
         * `HH` is the zero-padded hour of the day (0-23), and `MM` is the zero-padded minute of the hour.
         *
         * For example, `1:05:00` specifies maintenance at 5 AM Monday.
         */
        public var weeklyMaintenanceStartTime: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.OntapFileSystemConfiguration) : this() {
            this.automaticBackupRetentionDays = x.automaticBackupRetentionDays
            this.dailyAutomaticBackupStartTime = x.dailyAutomaticBackupStartTime
            this.deploymentType = x.deploymentType
            this.diskIopsConfiguration = x.diskIopsConfiguration
            this.endpointIpAddressRange = x.endpointIpAddressRange
            this.endpoints = x.endpoints
            this.fsxAdminPassword = x.fsxAdminPassword
            this.haPairs = x.haPairs
            this.preferredSubnetId = x.preferredSubnetId
            this.routeTableIds = x.routeTableIds
            this.throughputCapacity = x.throughputCapacity
            this.throughputCapacityPerHaPair = x.throughputCapacityPerHaPair
            this.weeklyMaintenanceStartTime = x.weeklyMaintenanceStartTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.OntapFileSystemConfiguration = OntapFileSystemConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration] inside the given [block]
         */
        public fun diskIopsConfiguration(block: aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration.Builder.() -> kotlin.Unit) {
            this.diskIopsConfiguration = aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.FileSystemEndpoints] inside the given [block]
         */
        public fun endpoints(block: aws.sdk.kotlin.services.fsx.model.FileSystemEndpoints.Builder.() -> kotlin.Unit) {
            this.endpoints = aws.sdk.kotlin.services.fsx.model.FileSystemEndpoints.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
