// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration for a data repository association that links an Amazon File Cache resource to an NFS data repository.
 */
public class NfsDataRepositoryConfiguration private constructor(builder: Builder) {
    /**
     * This parameter is not supported for Amazon File Cache.
     */
    public val autoExportPolicy: aws.sdk.kotlin.services.fsx.model.AutoExportPolicy? = builder.autoExportPolicy
    /**
     * A list of up to 2 IP addresses of DNS servers used to resolve the NFS file system domain name. The provided IP addresses can either be the IP addresses of a DNS forwarder or resolver that the customer manages and runs inside the customer VPC, or the IP addresses of the on-premises DNS servers.
     */
    public val dnsIps: List<String>? = builder.dnsIps
    /**
     * The version of the NFS (Network File System) protocol of the NFS data repository. Currently, the only supported value is `NFS3`, which indicates that the data repository must support the NFSv3 protocol.
     */
    public val version: aws.sdk.kotlin.services.fsx.model.NfsVersion? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.NfsDataRepositoryConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NfsDataRepositoryConfiguration(")
        append("autoExportPolicy=$autoExportPolicy,")
        append("dnsIps=$dnsIps,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoExportPolicy?.hashCode() ?: 0
        result = 31 * result + (dnsIps?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NfsDataRepositoryConfiguration

        if (autoExportPolicy != other.autoExportPolicy) return false
        if (dnsIps != other.dnsIps) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.NfsDataRepositoryConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * This parameter is not supported for Amazon File Cache.
         */
        public var autoExportPolicy: aws.sdk.kotlin.services.fsx.model.AutoExportPolicy? = null
        /**
         * A list of up to 2 IP addresses of DNS servers used to resolve the NFS file system domain name. The provided IP addresses can either be the IP addresses of a DNS forwarder or resolver that the customer manages and runs inside the customer VPC, or the IP addresses of the on-premises DNS servers.
         */
        public var dnsIps: List<String>? = null
        /**
         * The version of the NFS (Network File System) protocol of the NFS data repository. Currently, the only supported value is `NFS3`, which indicates that the data repository must support the NFSv3 protocol.
         */
        public var version: aws.sdk.kotlin.services.fsx.model.NfsVersion? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.NfsDataRepositoryConfiguration) : this() {
            this.autoExportPolicy = x.autoExportPolicy
            this.dnsIps = x.dnsIps
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.NfsDataRepositoryConfiguration = NfsDataRepositoryConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.AutoExportPolicy] inside the given [block]
         */
        public fun autoExportPolicy(block: aws.sdk.kotlin.services.fsx.model.AutoExportPolicy.Builder.() -> kotlin.Unit) {
            this.autoExportPolicy = aws.sdk.kotlin.services.fsx.model.AutoExportPolicy.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
