// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration for the Amazon FSx for Lustre file system.
 */
public class LustreFileSystemConfiguration private constructor(builder: Builder) {
    /**
     * The number of days to retain automatic backups. Setting this property to `0` disables automatic backups. You can retain automatic backups for a maximum of 90 days. The default is `30`.
     */
    public val automaticBackupRetentionDays: kotlin.Int? = builder.automaticBackupRetentionDays
    /**
     * A boolean flag indicating whether tags on the file system are copied to backups. If it's set to true, all tags on the file system are copied to all automatic backups and any user-initiated backups where the user doesn't specify any tags. If this value is true, and you specify one or more tags, only the specified tags are copied to backups. If you specify one or more tags when creating a user-initiated backup, no tags are copied from the file system, regardless of this value. (Default = false)
     */
    public val copyTagsToBackups: kotlin.Boolean? = builder.copyTagsToBackups
    /**
     * A recurring daily time, in the format `HH:MM`. `HH` is the zero-padded hour of the day (0-23), and `MM` is the zero-padded minute of the hour. For example, `05:00` specifies 5 AM daily.
     */
    public val dailyAutomaticBackupStartTime: kotlin.String? = builder.dailyAutomaticBackupStartTime
    /**
     * The data compression configuration for the file system. `DataCompressionType` can have the following values:
     * + `NONE` - Data compression is turned off for the file system.
     * + `LZ4` - Data compression is turned on with the LZ4 algorithm.
     *
     * For more information, see [Lustre data compression](https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html).
     */
    public val dataCompressionType: aws.sdk.kotlin.services.fsx.model.DataCompressionType? = builder.dataCompressionType
    /**
     * The data repository configuration object for Lustre file systems returned in the response of the `CreateFileSystem` operation.
     *
     * This data type is not supported on file systems with a data repository association. For file systems with a data repository association, see .
     */
    public val dataRepositoryConfiguration: aws.sdk.kotlin.services.fsx.model.DataRepositoryConfiguration? = builder.dataRepositoryConfiguration
    /**
     * The deployment type of the FSx for Lustre file system. *Scratch deployment type* is designed for temporary storage and shorter-term processing of data.
     *
     * `SCRATCH_1` and `SCRATCH_2` deployment types are best suited for when you need temporary storage and shorter-term processing of data. The `SCRATCH_2` deployment type provides in-transit encryption of data and higher burst throughput capacity than `SCRATCH_1`.
     *
     * The `PERSISTENT_1` and `PERSISTENT_2` deployment type is used for longer-term storage and workloads and encryption of data in transit. `PERSISTENT_2` offers higher `PerUnitStorageThroughput` (up to 1000 MB/s/TiB) along with a lower minimum storage capacity requirement (600 GiB). To learn more about FSx for Lustre deployment types, see [ FSx for Lustre deployment options](https://docs.aws.amazon.com/fsx/latest/LustreGuide/lustre-deployment-types.html).
     *
     * The default is `SCRATCH_1`.
     */
    public val deploymentType: aws.sdk.kotlin.services.fsx.model.LustreDeploymentType? = builder.deploymentType
    /**
     * The type of drive cache used by `PERSISTENT_1` file systems that are provisioned with HDD storage devices. This parameter is required when `StorageType` is HDD. When set to `READ` the file system has an SSD storage cache that is sized to 20% of the file system's storage capacity. This improves the performance for frequently accessed files by caching up to 20% of the total storage capacity.
     *
     * This parameter is required when `StorageType` is set to HDD.
     */
    public val driveCacheType: aws.sdk.kotlin.services.fsx.model.DriveCacheType? = builder.driveCacheType
    /**
     * Specifies whether Elastic Fabric Adapter (EFA) and GPUDirect Storage (GDS) support is enabled for the Amazon FSx for Lustre file system.
     */
    public val efaEnabled: kotlin.Boolean? = builder.efaEnabled
    /**
     * The Lustre logging configuration. Lustre logging writes the enabled log events for your file system to Amazon CloudWatch Logs.
     */
    public val logConfiguration: aws.sdk.kotlin.services.fsx.model.LustreLogConfiguration? = builder.logConfiguration
    /**
     * The Lustre metadata performance configuration for an Amazon FSx for Lustre file system using a `PERSISTENT_2` deployment type.
     */
    public val metadataConfiguration: aws.sdk.kotlin.services.fsx.model.FileSystemLustreMetadataConfiguration? = builder.metadataConfiguration
    /**
     * You use the `MountName` value when mounting the file system.
     *
     * For the `SCRATCH_1` deployment type, this value is always "`fsx`". For `SCRATCH_2`, `PERSISTENT_1`, and `PERSISTENT_2` deployment types, this value is a string that is unique within an Amazon Web Services Region.
     */
    public val mountName: kotlin.String? = builder.mountName
    /**
     * Per unit storage throughput represents the megabytes per second of read or write throughput per 1 tebibyte of storage provisioned. File system throughput capacity is equal to Storage capacity (TiB) * PerUnitStorageThroughput (MB/s/TiB). This option is only valid for `PERSISTENT_1` and `PERSISTENT_2` deployment types.
     *
     * Valid values:
     * + For `PERSISTENT_1` SSD storage: 50, 100, 200.
     * + For `PERSISTENT_1` HDD storage: 12, 40.
     * + For `PERSISTENT_2` SSD storage: 125, 250, 500, 1000.
     */
    public val perUnitStorageThroughput: kotlin.Int? = builder.perUnitStorageThroughput
    /**
     * The Lustre root squash configuration for an Amazon FSx for Lustre file system. When enabled, root squash restricts root-level access from clients that try to access your file system as a root user.
     */
    public val rootSquashConfiguration: aws.sdk.kotlin.services.fsx.model.LustreRootSquashConfiguration? = builder.rootSquashConfiguration
    /**
     * The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone. Here, `d` is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.
     */
    public val weeklyMaintenanceStartTime: kotlin.String? = builder.weeklyMaintenanceStartTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.LustreFileSystemConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LustreFileSystemConfiguration(")
        append("automaticBackupRetentionDays=$automaticBackupRetentionDays,")
        append("copyTagsToBackups=$copyTagsToBackups,")
        append("dailyAutomaticBackupStartTime=$dailyAutomaticBackupStartTime,")
        append("dataCompressionType=$dataCompressionType,")
        append("dataRepositoryConfiguration=$dataRepositoryConfiguration,")
        append("deploymentType=$deploymentType,")
        append("driveCacheType=$driveCacheType,")
        append("efaEnabled=$efaEnabled,")
        append("logConfiguration=$logConfiguration,")
        append("metadataConfiguration=$metadataConfiguration,")
        append("mountName=$mountName,")
        append("perUnitStorageThroughput=$perUnitStorageThroughput,")
        append("rootSquashConfiguration=$rootSquashConfiguration,")
        append("weeklyMaintenanceStartTime=$weeklyMaintenanceStartTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = automaticBackupRetentionDays ?: 0
        result = 31 * result + (copyTagsToBackups?.hashCode() ?: 0)
        result = 31 * result + (dailyAutomaticBackupStartTime?.hashCode() ?: 0)
        result = 31 * result + (dataCompressionType?.hashCode() ?: 0)
        result = 31 * result + (dataRepositoryConfiguration?.hashCode() ?: 0)
        result = 31 * result + (deploymentType?.hashCode() ?: 0)
        result = 31 * result + (driveCacheType?.hashCode() ?: 0)
        result = 31 * result + (efaEnabled?.hashCode() ?: 0)
        result = 31 * result + (logConfiguration?.hashCode() ?: 0)
        result = 31 * result + (metadataConfiguration?.hashCode() ?: 0)
        result = 31 * result + (mountName?.hashCode() ?: 0)
        result = 31 * result + (perUnitStorageThroughput ?: 0)
        result = 31 * result + (rootSquashConfiguration?.hashCode() ?: 0)
        result = 31 * result + (weeklyMaintenanceStartTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LustreFileSystemConfiguration

        if (automaticBackupRetentionDays != other.automaticBackupRetentionDays) return false
        if (copyTagsToBackups != other.copyTagsToBackups) return false
        if (dailyAutomaticBackupStartTime != other.dailyAutomaticBackupStartTime) return false
        if (dataCompressionType != other.dataCompressionType) return false
        if (dataRepositoryConfiguration != other.dataRepositoryConfiguration) return false
        if (deploymentType != other.deploymentType) return false
        if (driveCacheType != other.driveCacheType) return false
        if (efaEnabled != other.efaEnabled) return false
        if (logConfiguration != other.logConfiguration) return false
        if (metadataConfiguration != other.metadataConfiguration) return false
        if (mountName != other.mountName) return false
        if (perUnitStorageThroughput != other.perUnitStorageThroughput) return false
        if (rootSquashConfiguration != other.rootSquashConfiguration) return false
        if (weeklyMaintenanceStartTime != other.weeklyMaintenanceStartTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.LustreFileSystemConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of days to retain automatic backups. Setting this property to `0` disables automatic backups. You can retain automatic backups for a maximum of 90 days. The default is `30`.
         */
        public var automaticBackupRetentionDays: kotlin.Int? = null
        /**
         * A boolean flag indicating whether tags on the file system are copied to backups. If it's set to true, all tags on the file system are copied to all automatic backups and any user-initiated backups where the user doesn't specify any tags. If this value is true, and you specify one or more tags, only the specified tags are copied to backups. If you specify one or more tags when creating a user-initiated backup, no tags are copied from the file system, regardless of this value. (Default = false)
         */
        public var copyTagsToBackups: kotlin.Boolean? = null
        /**
         * A recurring daily time, in the format `HH:MM`. `HH` is the zero-padded hour of the day (0-23), and `MM` is the zero-padded minute of the hour. For example, `05:00` specifies 5 AM daily.
         */
        public var dailyAutomaticBackupStartTime: kotlin.String? = null
        /**
         * The data compression configuration for the file system. `DataCompressionType` can have the following values:
         * + `NONE` - Data compression is turned off for the file system.
         * + `LZ4` - Data compression is turned on with the LZ4 algorithm.
         *
         * For more information, see [Lustre data compression](https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html).
         */
        public var dataCompressionType: aws.sdk.kotlin.services.fsx.model.DataCompressionType? = null
        /**
         * The data repository configuration object for Lustre file systems returned in the response of the `CreateFileSystem` operation.
         *
         * This data type is not supported on file systems with a data repository association. For file systems with a data repository association, see .
         */
        public var dataRepositoryConfiguration: aws.sdk.kotlin.services.fsx.model.DataRepositoryConfiguration? = null
        /**
         * The deployment type of the FSx for Lustre file system. *Scratch deployment type* is designed for temporary storage and shorter-term processing of data.
         *
         * `SCRATCH_1` and `SCRATCH_2` deployment types are best suited for when you need temporary storage and shorter-term processing of data. The `SCRATCH_2` deployment type provides in-transit encryption of data and higher burst throughput capacity than `SCRATCH_1`.
         *
         * The `PERSISTENT_1` and `PERSISTENT_2` deployment type is used for longer-term storage and workloads and encryption of data in transit. `PERSISTENT_2` offers higher `PerUnitStorageThroughput` (up to 1000 MB/s/TiB) along with a lower minimum storage capacity requirement (600 GiB). To learn more about FSx for Lustre deployment types, see [ FSx for Lustre deployment options](https://docs.aws.amazon.com/fsx/latest/LustreGuide/lustre-deployment-types.html).
         *
         * The default is `SCRATCH_1`.
         */
        public var deploymentType: aws.sdk.kotlin.services.fsx.model.LustreDeploymentType? = null
        /**
         * The type of drive cache used by `PERSISTENT_1` file systems that are provisioned with HDD storage devices. This parameter is required when `StorageType` is HDD. When set to `READ` the file system has an SSD storage cache that is sized to 20% of the file system's storage capacity. This improves the performance for frequently accessed files by caching up to 20% of the total storage capacity.
         *
         * This parameter is required when `StorageType` is set to HDD.
         */
        public var driveCacheType: aws.sdk.kotlin.services.fsx.model.DriveCacheType? = null
        /**
         * Specifies whether Elastic Fabric Adapter (EFA) and GPUDirect Storage (GDS) support is enabled for the Amazon FSx for Lustre file system.
         */
        public var efaEnabled: kotlin.Boolean? = null
        /**
         * The Lustre logging configuration. Lustre logging writes the enabled log events for your file system to Amazon CloudWatch Logs.
         */
        public var logConfiguration: aws.sdk.kotlin.services.fsx.model.LustreLogConfiguration? = null
        /**
         * The Lustre metadata performance configuration for an Amazon FSx for Lustre file system using a `PERSISTENT_2` deployment type.
         */
        public var metadataConfiguration: aws.sdk.kotlin.services.fsx.model.FileSystemLustreMetadataConfiguration? = null
        /**
         * You use the `MountName` value when mounting the file system.
         *
         * For the `SCRATCH_1` deployment type, this value is always "`fsx`". For `SCRATCH_2`, `PERSISTENT_1`, and `PERSISTENT_2` deployment types, this value is a string that is unique within an Amazon Web Services Region.
         */
        public var mountName: kotlin.String? = null
        /**
         * Per unit storage throughput represents the megabytes per second of read or write throughput per 1 tebibyte of storage provisioned. File system throughput capacity is equal to Storage capacity (TiB) * PerUnitStorageThroughput (MB/s/TiB). This option is only valid for `PERSISTENT_1` and `PERSISTENT_2` deployment types.
         *
         * Valid values:
         * + For `PERSISTENT_1` SSD storage: 50, 100, 200.
         * + For `PERSISTENT_1` HDD storage: 12, 40.
         * + For `PERSISTENT_2` SSD storage: 125, 250, 500, 1000.
         */
        public var perUnitStorageThroughput: kotlin.Int? = null
        /**
         * The Lustre root squash configuration for an Amazon FSx for Lustre file system. When enabled, root squash restricts root-level access from clients that try to access your file system as a root user.
         */
        public var rootSquashConfiguration: aws.sdk.kotlin.services.fsx.model.LustreRootSquashConfiguration? = null
        /**
         * The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone. Here, `d` is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.
         */
        public var weeklyMaintenanceStartTime: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.LustreFileSystemConfiguration) : this() {
            this.automaticBackupRetentionDays = x.automaticBackupRetentionDays
            this.copyTagsToBackups = x.copyTagsToBackups
            this.dailyAutomaticBackupStartTime = x.dailyAutomaticBackupStartTime
            this.dataCompressionType = x.dataCompressionType
            this.dataRepositoryConfiguration = x.dataRepositoryConfiguration
            this.deploymentType = x.deploymentType
            this.driveCacheType = x.driveCacheType
            this.efaEnabled = x.efaEnabled
            this.logConfiguration = x.logConfiguration
            this.metadataConfiguration = x.metadataConfiguration
            this.mountName = x.mountName
            this.perUnitStorageThroughput = x.perUnitStorageThroughput
            this.rootSquashConfiguration = x.rootSquashConfiguration
            this.weeklyMaintenanceStartTime = x.weeklyMaintenanceStartTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.LustreFileSystemConfiguration = LustreFileSystemConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.DataRepositoryConfiguration] inside the given [block]
         */
        public fun dataRepositoryConfiguration(block: aws.sdk.kotlin.services.fsx.model.DataRepositoryConfiguration.Builder.() -> kotlin.Unit) {
            this.dataRepositoryConfiguration = aws.sdk.kotlin.services.fsx.model.DataRepositoryConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.LustreLogConfiguration] inside the given [block]
         */
        public fun logConfiguration(block: aws.sdk.kotlin.services.fsx.model.LustreLogConfiguration.Builder.() -> kotlin.Unit) {
            this.logConfiguration = aws.sdk.kotlin.services.fsx.model.LustreLogConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.FileSystemLustreMetadataConfiguration] inside the given [block]
         */
        public fun metadataConfiguration(block: aws.sdk.kotlin.services.fsx.model.FileSystemLustreMetadataConfiguration.Builder.() -> kotlin.Unit) {
            this.metadataConfiguration = aws.sdk.kotlin.services.fsx.model.FileSystemLustreMetadataConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.LustreRootSquashConfiguration] inside the given [block]
         */
        public fun rootSquashConfiguration(block: aws.sdk.kotlin.services.fsx.model.LustreRootSquashConfiguration.Builder.() -> kotlin.Unit) {
            this.rootSquashConfiguration = aws.sdk.kotlin.services.fsx.model.LustreRootSquashConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
