// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * The error returned when a second request is received with the same client request token but different parameters settings. A client request token should always uniquely identify a single request.
 */
public class IncompatibleParameterError private constructor(builder: Builder) : FSxException(builder.message) {

    /**
     * A parameter that is incompatible with the earlier request.
     */
    public val parameter: kotlin.String? = builder.parameter

    init {
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Client
    }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.IncompatibleParameterError = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IncompatibleParameterError(")
        append("message=$message,")
        append("parameter=$parameter")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = message?.hashCode() ?: 0
        result = 31 * result + (parameter?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IncompatibleParameterError

        if (message != other.message) return false
        if (parameter != other.parameter) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.IncompatibleParameterError = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A detailed error message.
         */
        public var message: kotlin.String? = null
        /**
         * A parameter that is incompatible with the earlier request.
         */
        public var parameter: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.IncompatibleParameterError) : this() {
            this.message = x.message
            this.parameter = x.parameter
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.IncompatibleParameterError = IncompatibleParameterError(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
