// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The Lustre metadata performance configuration of an Amazon FSx for Lustre file system using a `PERSISTENT_2` deployment type. The configuration enables the file system to support increasing metadata performance.
 */
public class FileSystemLustreMetadataConfiguration private constructor(builder: Builder) {
    /**
     * The number of Metadata IOPS provisioned for the file system. Valid values are `1500`, `3000`, `6000`, `12000`, and multiples of `12000` up to a maximum of `192000`.
     */
    public val iops: kotlin.Int? = builder.iops
    /**
     * The metadata configuration mode for provisioning Metadata IOPS for the file system.
     * + In AUTOMATIC mode, FSx for Lustre automatically provisions and scales the number of Metadata IOPS on your file system based on your file system storage capacity.
     * + In USER_PROVISIONED mode, you can choose to specify the number of Metadata IOPS to provision for your file system.
     */
    public val mode: aws.sdk.kotlin.services.fsx.model.MetadataConfigurationMode? = builder.mode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.FileSystemLustreMetadataConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FileSystemLustreMetadataConfiguration(")
        append("iops=$iops,")
        append("mode=$mode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = iops ?: 0
        result = 31 * result + (mode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FileSystemLustreMetadataConfiguration

        if (iops != other.iops) return false
        if (mode != other.mode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.FileSystemLustreMetadataConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of Metadata IOPS provisioned for the file system. Valid values are `1500`, `3000`, `6000`, `12000`, and multiples of `12000` up to a maximum of `192000`.
         */
        public var iops: kotlin.Int? = null
        /**
         * The metadata configuration mode for provisioning Metadata IOPS for the file system.
         * + In AUTOMATIC mode, FSx for Lustre automatically provisions and scales the number of Metadata IOPS on your file system based on your file system storage capacity.
         * + In USER_PROVISIONED mode, you can choose to specify the number of Metadata IOPS to provision for your file system.
         */
        public var mode: aws.sdk.kotlin.services.fsx.model.MetadataConfigurationMode? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.FileSystemLustreMetadataConfiguration) : this() {
            this.iops = x.iops
            this.mode = x.mode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.FileSystemLustreMetadataConfiguration = FileSystemLustreMetadataConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
