// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration for the Amazon File Cache resource.
 */
public class FileCacheLustreConfiguration private constructor(builder: Builder) {
    /**
     * The deployment type of the Amazon File Cache resource, which must be `CACHE_1`.
     */
    public val deploymentType: aws.sdk.kotlin.services.fsx.model.FileCacheLustreDeploymentType? = builder.deploymentType
    /**
     * The configuration for Lustre logging used to write the enabled logging events for your Amazon File Cache resource to Amazon CloudWatch Logs.
     */
    public val logConfiguration: aws.sdk.kotlin.services.fsx.model.LustreLogConfiguration? = builder.logConfiguration
    /**
     * The configuration for a Lustre MDT (Metadata Target) storage volume.
     */
    public val metadataConfiguration: aws.sdk.kotlin.services.fsx.model.FileCacheLustreMetadataConfiguration? = builder.metadataConfiguration
    /**
     * You use the `MountName` value when mounting the cache. If you pass a cache ID to the `DescribeFileCaches` operation, it returns the the `MountName` value as part of the cache's description.
     */
    public val mountName: kotlin.String? = builder.mountName
    /**
     * Per unit storage throughput represents the megabytes per second of read or write throughput per 1 tebibyte of storage provisioned. Cache throughput capacity is equal to Storage capacity (TiB) * PerUnitStorageThroughput (MB/s/TiB). The only supported value is `1000`.
     */
    public val perUnitStorageThroughput: kotlin.Int? = builder.perUnitStorageThroughput
    /**
     * A recurring weekly time, in the format `D:HH:MM`.
     *
     * `D` is the day of the week, for which 1 represents Monday and 7 represents Sunday. For further details, see [the ISO-8601 spec as described on Wikipedia](https://en.wikipedia.org/wiki/ISO_week_date).
     *
     * `HH` is the zero-padded hour of the day (0-23), and `MM` is the zero-padded minute of the hour.
     *
     * For example, `1:05:00` specifies maintenance at 5 AM Monday.
     */
    public val weeklyMaintenanceStartTime: kotlin.String? = builder.weeklyMaintenanceStartTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.FileCacheLustreConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FileCacheLustreConfiguration(")
        append("deploymentType=$deploymentType,")
        append("logConfiguration=$logConfiguration,")
        append("metadataConfiguration=$metadataConfiguration,")
        append("mountName=$mountName,")
        append("perUnitStorageThroughput=$perUnitStorageThroughput,")
        append("weeklyMaintenanceStartTime=$weeklyMaintenanceStartTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deploymentType?.hashCode() ?: 0
        result = 31 * result + (logConfiguration?.hashCode() ?: 0)
        result = 31 * result + (metadataConfiguration?.hashCode() ?: 0)
        result = 31 * result + (mountName?.hashCode() ?: 0)
        result = 31 * result + (perUnitStorageThroughput ?: 0)
        result = 31 * result + (weeklyMaintenanceStartTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FileCacheLustreConfiguration

        if (deploymentType != other.deploymentType) return false
        if (logConfiguration != other.logConfiguration) return false
        if (metadataConfiguration != other.metadataConfiguration) return false
        if (mountName != other.mountName) return false
        if (perUnitStorageThroughput != other.perUnitStorageThroughput) return false
        if (weeklyMaintenanceStartTime != other.weeklyMaintenanceStartTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.FileCacheLustreConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The deployment type of the Amazon File Cache resource, which must be `CACHE_1`.
         */
        public var deploymentType: aws.sdk.kotlin.services.fsx.model.FileCacheLustreDeploymentType? = null
        /**
         * The configuration for Lustre logging used to write the enabled logging events for your Amazon File Cache resource to Amazon CloudWatch Logs.
         */
        public var logConfiguration: aws.sdk.kotlin.services.fsx.model.LustreLogConfiguration? = null
        /**
         * The configuration for a Lustre MDT (Metadata Target) storage volume.
         */
        public var metadataConfiguration: aws.sdk.kotlin.services.fsx.model.FileCacheLustreMetadataConfiguration? = null
        /**
         * You use the `MountName` value when mounting the cache. If you pass a cache ID to the `DescribeFileCaches` operation, it returns the the `MountName` value as part of the cache's description.
         */
        public var mountName: kotlin.String? = null
        /**
         * Per unit storage throughput represents the megabytes per second of read or write throughput per 1 tebibyte of storage provisioned. Cache throughput capacity is equal to Storage capacity (TiB) * PerUnitStorageThroughput (MB/s/TiB). The only supported value is `1000`.
         */
        public var perUnitStorageThroughput: kotlin.Int? = null
        /**
         * A recurring weekly time, in the format `D:HH:MM`.
         *
         * `D` is the day of the week, for which 1 represents Monday and 7 represents Sunday. For further details, see [the ISO-8601 spec as described on Wikipedia](https://en.wikipedia.org/wiki/ISO_week_date).
         *
         * `HH` is the zero-padded hour of the day (0-23), and `MM` is the zero-padded minute of the hour.
         *
         * For example, `1:05:00` specifies maintenance at 5 AM Monday.
         */
        public var weeklyMaintenanceStartTime: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.FileCacheLustreConfiguration) : this() {
            this.deploymentType = x.deploymentType
            this.logConfiguration = x.logConfiguration
            this.metadataConfiguration = x.metadataConfiguration
            this.mountName = x.mountName
            this.perUnitStorageThroughput = x.perUnitStorageThroughput
            this.weeklyMaintenanceStartTime = x.weeklyMaintenanceStartTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.FileCacheLustreConfiguration = FileCacheLustreConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.LustreLogConfiguration] inside the given [block]
         */
        public fun logConfiguration(block: aws.sdk.kotlin.services.fsx.model.LustreLogConfiguration.Builder.() -> kotlin.Unit) {
            this.logConfiguration = aws.sdk.kotlin.services.fsx.model.LustreLogConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.FileCacheLustreMetadataConfiguration] inside the given [block]
         */
        public fun metadataConfiguration(block: aws.sdk.kotlin.services.fsx.model.FileCacheLustreMetadataConfiguration.Builder.() -> kotlin.Unit) {
            this.metadataConfiguration = aws.sdk.kotlin.services.fsx.model.FileCacheLustreMetadataConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
