// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The SSD IOPS (input/output operations per second) configuration for an Amazon FSx for NetApp ONTAP, Amazon FSx for Windows File Server, or FSx for OpenZFS file system. By default, Amazon FSx automatically provisions 3 IOPS per GB of storage capacity. You can provision additional IOPS per GB of storage. The configuration consists of the total number of provisioned SSD IOPS and how it is was provisioned, or the mode (by the customer or by Amazon FSx).
 */
public class DiskIopsConfiguration private constructor(builder: Builder) {
    /**
     * The total number of SSD IOPS provisioned for the file system.
     *
     * The minimum and maximum values for this property depend on the value of `HAPairs` and `StorageCapacity`. The minimum value is calculated as `StorageCapacity` * 3 * `HAPairs` (3 IOPS per GB of `StorageCapacity`). The maximum value is calculated as 200,000 * `HAPairs`.
     *
     * Amazon FSx responds with an HTTP status code 400 (Bad Request) if the value of `Iops` is outside of the minimum or maximum values.
     */
    public val iops: kotlin.Long? = builder.iops
    /**
     * Specifies whether the file system is using the `AUTOMATIC` setting of SSD IOPS of 3 IOPS per GB of storage capacity, or if it using a `USER_PROVISIONED` value.
     */
    public val mode: aws.sdk.kotlin.services.fsx.model.DiskIopsConfigurationMode? = builder.mode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DiskIopsConfiguration(")
        append("iops=$iops,")
        append("mode=$mode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = iops?.hashCode() ?: 0
        result = 31 * result + (mode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DiskIopsConfiguration

        if (iops != other.iops) return false
        if (mode != other.mode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The total number of SSD IOPS provisioned for the file system.
         *
         * The minimum and maximum values for this property depend on the value of `HAPairs` and `StorageCapacity`. The minimum value is calculated as `StorageCapacity` * 3 * `HAPairs` (3 IOPS per GB of `StorageCapacity`). The maximum value is calculated as 200,000 * `HAPairs`.
         *
         * Amazon FSx responds with an HTTP status code 400 (Bad Request) if the value of `Iops` is outside of the minimum or maximum values.
         */
        public var iops: kotlin.Long? = null
        /**
         * Specifies whether the file system is using the `AUTOMATIC` setting of SSD IOPS of 3 IOPS per GB of storage capacity, or if it using a `USER_PROVISIONED` value.
         */
        public var mode: aws.sdk.kotlin.services.fsx.model.DiskIopsConfigurationMode? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration) : this() {
            this.iops = x.iops
            this.mode = x.mode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration = DiskIopsConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
