// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The request object for `DeleteFileSystem` operation.
 */
public class DeleteFileSystemRequest private constructor(builder: Builder) {
    /**
     * A string of up to 63 ASCII characters that Amazon FSx uses to ensure idempotent deletion. This token is automatically filled on your behalf when using the Command Line Interface (CLI) or an Amazon Web Services SDK.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The ID of the file system that you want to delete.
     */
    public val fileSystemId: kotlin.String? = builder.fileSystemId
    /**
     * The configuration object for the Amazon FSx for Lustre file system being deleted in the `DeleteFileSystem` operation.
     */
    public val lustreConfiguration: aws.sdk.kotlin.services.fsx.model.DeleteFileSystemLustreConfiguration? = builder.lustreConfiguration
    /**
     * The configuration object for the OpenZFS file system used in the `DeleteFileSystem` operation.
     */
    public val openZfsConfiguration: aws.sdk.kotlin.services.fsx.model.DeleteFileSystemOpenZfsConfiguration? = builder.openZfsConfiguration
    /**
     * The configuration object for the Microsoft Windows file system used in the `DeleteFileSystem` operation.
     */
    public val windowsConfiguration: aws.sdk.kotlin.services.fsx.model.DeleteFileSystemWindowsConfiguration? = builder.windowsConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.DeleteFileSystemRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteFileSystemRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("fileSystemId=$fileSystemId,")
        append("lustreConfiguration=$lustreConfiguration,")
        append("openZfsConfiguration=$openZfsConfiguration,")
        append("windowsConfiguration=$windowsConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (fileSystemId?.hashCode() ?: 0)
        result = 31 * result + (lustreConfiguration?.hashCode() ?: 0)
        result = 31 * result + (openZfsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (windowsConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteFileSystemRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (fileSystemId != other.fileSystemId) return false
        if (lustreConfiguration != other.lustreConfiguration) return false
        if (openZfsConfiguration != other.openZfsConfiguration) return false
        if (windowsConfiguration != other.windowsConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.DeleteFileSystemRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A string of up to 63 ASCII characters that Amazon FSx uses to ensure idempotent deletion. This token is automatically filled on your behalf when using the Command Line Interface (CLI) or an Amazon Web Services SDK.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The ID of the file system that you want to delete.
         */
        public var fileSystemId: kotlin.String? = null
        /**
         * The configuration object for the Amazon FSx for Lustre file system being deleted in the `DeleteFileSystem` operation.
         */
        public var lustreConfiguration: aws.sdk.kotlin.services.fsx.model.DeleteFileSystemLustreConfiguration? = null
        /**
         * The configuration object for the OpenZFS file system used in the `DeleteFileSystem` operation.
         */
        public var openZfsConfiguration: aws.sdk.kotlin.services.fsx.model.DeleteFileSystemOpenZfsConfiguration? = null
        /**
         * The configuration object for the Microsoft Windows file system used in the `DeleteFileSystem` operation.
         */
        public var windowsConfiguration: aws.sdk.kotlin.services.fsx.model.DeleteFileSystemWindowsConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.DeleteFileSystemRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.fileSystemId = x.fileSystemId
            this.lustreConfiguration = x.lustreConfiguration
            this.openZfsConfiguration = x.openZfsConfiguration
            this.windowsConfiguration = x.windowsConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.DeleteFileSystemRequest = DeleteFileSystemRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.DeleteFileSystemLustreConfiguration] inside the given [block]
         */
        public fun lustreConfiguration(block: aws.sdk.kotlin.services.fsx.model.DeleteFileSystemLustreConfiguration.Builder.() -> kotlin.Unit) {
            this.lustreConfiguration = aws.sdk.kotlin.services.fsx.model.DeleteFileSystemLustreConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.DeleteFileSystemOpenZfsConfiguration] inside the given [block]
         */
        public fun openZfsConfiguration(block: aws.sdk.kotlin.services.fsx.model.DeleteFileSystemOpenZfsConfiguration.Builder.() -> kotlin.Unit) {
            this.openZfsConfiguration = aws.sdk.kotlin.services.fsx.model.DeleteFileSystemOpenZfsConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.DeleteFileSystemWindowsConfiguration] inside the given [block]
         */
        public fun windowsConfiguration(block: aws.sdk.kotlin.services.fsx.model.DeleteFileSystemWindowsConfiguration.Builder.() -> kotlin.Unit) {
            this.windowsConfiguration = aws.sdk.kotlin.services.fsx.model.DeleteFileSystemWindowsConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
