// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides the task status showing a running total of the total number of files to be processed, the number successfully processed, and the number of files the task failed to process.
 */
public class DataRepositoryTaskStatus private constructor(builder: Builder) {
    /**
     * A running total of the number of files that the task failed to process.
     */
    public val failedCount: kotlin.Long? = builder.failedCount
    /**
     * The time at which the task status was last updated.
     */
    public val lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTime
    /**
     * The total amount of data, in GiB, released by an Amazon File Cache AUTO_RELEASE_DATA task that automatically releases files from the cache.
     */
    public val releasedCapacity: kotlin.Long? = builder.releasedCapacity
    /**
     * A running total of the number of files that the task has successfully processed.
     */
    public val succeededCount: kotlin.Long? = builder.succeededCount
    /**
     * The total number of files that the task will process. While a task is executing, the sum of `SucceededCount` plus `FailedCount` may not equal `TotalCount`. When the task is complete, `TotalCount` equals the sum of `SucceededCount` plus `FailedCount`.
     */
    public val totalCount: kotlin.Long? = builder.totalCount

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.DataRepositoryTaskStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataRepositoryTaskStatus(")
        append("failedCount=$failedCount,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("releasedCapacity=$releasedCapacity,")
        append("succeededCount=$succeededCount,")
        append("totalCount=$totalCount")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = failedCount?.hashCode() ?: 0
        result = 31 * result + (lastUpdatedTime?.hashCode() ?: 0)
        result = 31 * result + (releasedCapacity?.hashCode() ?: 0)
        result = 31 * result + (succeededCount?.hashCode() ?: 0)
        result = 31 * result + (totalCount?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataRepositoryTaskStatus

        if (failedCount != other.failedCount) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (releasedCapacity != other.releasedCapacity) return false
        if (succeededCount != other.succeededCount) return false
        if (totalCount != other.totalCount) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.DataRepositoryTaskStatus = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A running total of the number of files that the task failed to process.
         */
        public var failedCount: kotlin.Long? = null
        /**
         * The time at which the task status was last updated.
         */
        public var lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The total amount of data, in GiB, released by an Amazon File Cache AUTO_RELEASE_DATA task that automatically releases files from the cache.
         */
        public var releasedCapacity: kotlin.Long? = null
        /**
         * A running total of the number of files that the task has successfully processed.
         */
        public var succeededCount: kotlin.Long? = null
        /**
         * The total number of files that the task will process. While a task is executing, the sum of `SucceededCount` plus `FailedCount` may not equal `TotalCount`. When the task is complete, `TotalCount` equals the sum of `SucceededCount` plus `FailedCount`.
         */
        public var totalCount: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.DataRepositoryTaskStatus) : this() {
            this.failedCount = x.failedCount
            this.lastUpdatedTime = x.lastUpdatedTime
            this.releasedCapacity = x.releasedCapacity
            this.succeededCount = x.succeededCount
            this.totalCount = x.totalCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.DataRepositoryTaskStatus = DataRepositoryTaskStatus(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
