// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A description of the data repository task.
 * + You use import and export data repository tasks to perform bulk transfer operations between an Amazon FSx for Lustre file system and a linked data repository.
 * + You use release data repository tasks to release files that have been exported to a linked S3 bucket from your Amazon FSx for Lustre file system.
 * + An Amazon File Cache resource uses a task to automatically release files from the cache.
 *
 * To learn more about data repository tasks, see [Data Repository Tasks](https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-repository-tasks.html).
 */
public class DataRepositoryTask private constructor(builder: Builder) {
    /**
     * Specifies the amount of data to release, in GiB, by an Amazon File Cache AUTO_RELEASE_DATA task that automatically releases files from the cache.
     */
    public val capacityToRelease: kotlin.Long? = builder.capacityToRelease
    /**
     * The time that the resource was created, in seconds (since 1970-01-01T00:00:00Z), also known as Unix time.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The time the system completed processing the task, populated after the task is complete.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * Failure message describing why the task failed, it is populated only when `Lifecycle` is set to `FAILED`.
     */
    public val failureDetails: aws.sdk.kotlin.services.fsx.model.DataRepositoryTaskFailureDetails? = builder.failureDetails
    /**
     * The system-generated, unique ID of the cache.
     */
    public val fileCacheId: kotlin.String? = builder.fileCacheId
    /**
     * The globally unique ID of the file system.
     */
    public val fileSystemId: kotlin.String? = builder.fileSystemId
    /**
     * The lifecycle status of the data repository task, as follows:
     * + `PENDING` - The task has not started.
     * + `EXECUTING` - The task is in process.
     * + `FAILED` - The task was not able to be completed. For example, there may be files the task failed to process. The DataRepositoryTaskFailureDetails property provides more information about task failures.
     * + `SUCCEEDED` - The task has completed successfully.
     * + `CANCELED` - The task was canceled and it did not complete.
     * + `CANCELING` - The task is in process of being canceled.
     *
     * You cannot delete an FSx for Lustre file system if there are data repository tasks for the file system in the `PENDING` or `EXECUTING` states. Please retry when the data repository task is finished (with a status of `CANCELED`, `SUCCEEDED`, or `FAILED`). You can use the DescribeDataRepositoryTask action to monitor the task status. Contact the FSx team if you need to delete your file system immediately.
     */
    public val lifecycle: aws.sdk.kotlin.services.fsx.model.DataRepositoryTaskLifecycle? = builder.lifecycle
    /**
     * An array of paths that specify the data for the data repository task to process. For example, in an EXPORT_TO_REPOSITORY task, the paths specify which data to export to the linked data repository.
     *
     * (Default) If `Paths` is not specified, Amazon FSx uses the file system root directory.
     */
    public val paths: List<String>? = builder.paths
    /**
     * The configuration that specifies the last accessed time criteria for files that will be released from an Amazon FSx for Lustre file system.
     */
    public val releaseConfiguration: aws.sdk.kotlin.services.fsx.model.ReleaseConfiguration? = builder.releaseConfiguration
    /**
     * Provides a report detailing the data repository task results of the files processed that match the criteria specified in the report `Scope` parameter. FSx delivers the report to the file system's linked data repository in Amazon S3, using the path specified in the report `Path` parameter. You can specify whether or not a report gets generated for a task using the `Enabled` parameter.
     */
    public val report: aws.sdk.kotlin.services.fsx.model.CompletionReport? = builder.report
    /**
     * The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services resources. We require an ARN when you need to specify a resource unambiguously across all of Amazon Web Services. For more information, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * The time the system began processing the task.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * Provides the status of the number of files that the task has processed successfully and failed to process.
     */
    public val status: aws.sdk.kotlin.services.fsx.model.DataRepositoryTaskStatus? = builder.status
    /**
     * A list of `Tag` values, with a maximum of 50 elements.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The system-generated, unique 17-digit ID of the data repository task.
     */
    public val taskId: kotlin.String? = builder.taskId
    /**
     * The type of data repository task.
     * + `EXPORT_TO_REPOSITORY` tasks export from your Amazon FSx for Lustre file system to a linked data repository.
     * + `IMPORT_METADATA_FROM_REPOSITORY` tasks import metadata changes from a linked S3 bucket to your Amazon FSx for Lustre file system.
     * + `RELEASE_DATA_FROM_FILESYSTEM` tasks release files in your Amazon FSx for Lustre file system that have been exported to a linked S3 bucket and that meet your specified release criteria.
     * + `AUTO_RELEASE_DATA` tasks automatically release files from an Amazon File Cache resource.
     */
    public val type: aws.sdk.kotlin.services.fsx.model.DataRepositoryTaskType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.DataRepositoryTask = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataRepositoryTask(")
        append("capacityToRelease=$capacityToRelease,")
        append("creationTime=$creationTime,")
        append("endTime=$endTime,")
        append("failureDetails=$failureDetails,")
        append("fileCacheId=$fileCacheId,")
        append("fileSystemId=$fileSystemId,")
        append("lifecycle=$lifecycle,")
        append("paths=$paths,")
        append("releaseConfiguration=$releaseConfiguration,")
        append("report=$report,")
        append("resourceArn=$resourceArn,")
        append("startTime=$startTime,")
        append("status=$status,")
        append("tags=$tags,")
        append("taskId=$taskId,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = capacityToRelease?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (failureDetails?.hashCode() ?: 0)
        result = 31 * result + (fileCacheId?.hashCode() ?: 0)
        result = 31 * result + (fileSystemId?.hashCode() ?: 0)
        result = 31 * result + (lifecycle?.hashCode() ?: 0)
        result = 31 * result + (paths?.hashCode() ?: 0)
        result = 31 * result + (releaseConfiguration?.hashCode() ?: 0)
        result = 31 * result + (report?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (taskId?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataRepositoryTask

        if (capacityToRelease != other.capacityToRelease) return false
        if (creationTime != other.creationTime) return false
        if (endTime != other.endTime) return false
        if (failureDetails != other.failureDetails) return false
        if (fileCacheId != other.fileCacheId) return false
        if (fileSystemId != other.fileSystemId) return false
        if (lifecycle != other.lifecycle) return false
        if (paths != other.paths) return false
        if (releaseConfiguration != other.releaseConfiguration) return false
        if (report != other.report) return false
        if (resourceArn != other.resourceArn) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (taskId != other.taskId) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.DataRepositoryTask = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the amount of data to release, in GiB, by an Amazon File Cache AUTO_RELEASE_DATA task that automatically releases files from the cache.
         */
        public var capacityToRelease: kotlin.Long? = null
        /**
         * The time that the resource was created, in seconds (since 1970-01-01T00:00:00Z), also known as Unix time.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time the system completed processing the task, populated after the task is complete.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Failure message describing why the task failed, it is populated only when `Lifecycle` is set to `FAILED`.
         */
        public var failureDetails: aws.sdk.kotlin.services.fsx.model.DataRepositoryTaskFailureDetails? = null
        /**
         * The system-generated, unique ID of the cache.
         */
        public var fileCacheId: kotlin.String? = null
        /**
         * The globally unique ID of the file system.
         */
        public var fileSystemId: kotlin.String? = null
        /**
         * The lifecycle status of the data repository task, as follows:
         * + `PENDING` - The task has not started.
         * + `EXECUTING` - The task is in process.
         * + `FAILED` - The task was not able to be completed. For example, there may be files the task failed to process. The DataRepositoryTaskFailureDetails property provides more information about task failures.
         * + `SUCCEEDED` - The task has completed successfully.
         * + `CANCELED` - The task was canceled and it did not complete.
         * + `CANCELING` - The task is in process of being canceled.
         *
         * You cannot delete an FSx for Lustre file system if there are data repository tasks for the file system in the `PENDING` or `EXECUTING` states. Please retry when the data repository task is finished (with a status of `CANCELED`, `SUCCEEDED`, or `FAILED`). You can use the DescribeDataRepositoryTask action to monitor the task status. Contact the FSx team if you need to delete your file system immediately.
         */
        public var lifecycle: aws.sdk.kotlin.services.fsx.model.DataRepositoryTaskLifecycle? = null
        /**
         * An array of paths that specify the data for the data repository task to process. For example, in an EXPORT_TO_REPOSITORY task, the paths specify which data to export to the linked data repository.
         *
         * (Default) If `Paths` is not specified, Amazon FSx uses the file system root directory.
         */
        public var paths: List<String>? = null
        /**
         * The configuration that specifies the last accessed time criteria for files that will be released from an Amazon FSx for Lustre file system.
         */
        public var releaseConfiguration: aws.sdk.kotlin.services.fsx.model.ReleaseConfiguration? = null
        /**
         * Provides a report detailing the data repository task results of the files processed that match the criteria specified in the report `Scope` parameter. FSx delivers the report to the file system's linked data repository in Amazon S3, using the path specified in the report `Path` parameter. You can specify whether or not a report gets generated for a task using the `Enabled` parameter.
         */
        public var report: aws.sdk.kotlin.services.fsx.model.CompletionReport? = null
        /**
         * The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services resources. We require an ARN when you need to specify a resource unambiguously across all of Amazon Web Services. For more information, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * The time the system began processing the task.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Provides the status of the number of files that the task has processed successfully and failed to process.
         */
        public var status: aws.sdk.kotlin.services.fsx.model.DataRepositoryTaskStatus? = null
        /**
         * A list of `Tag` values, with a maximum of 50 elements.
         */
        public var tags: List<Tag>? = null
        /**
         * The system-generated, unique 17-digit ID of the data repository task.
         */
        public var taskId: kotlin.String? = null
        /**
         * The type of data repository task.
         * + `EXPORT_TO_REPOSITORY` tasks export from your Amazon FSx for Lustre file system to a linked data repository.
         * + `IMPORT_METADATA_FROM_REPOSITORY` tasks import metadata changes from a linked S3 bucket to your Amazon FSx for Lustre file system.
         * + `RELEASE_DATA_FROM_FILESYSTEM` tasks release files in your Amazon FSx for Lustre file system that have been exported to a linked S3 bucket and that meet your specified release criteria.
         * + `AUTO_RELEASE_DATA` tasks automatically release files from an Amazon File Cache resource.
         */
        public var type: aws.sdk.kotlin.services.fsx.model.DataRepositoryTaskType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.DataRepositoryTask) : this() {
            this.capacityToRelease = x.capacityToRelease
            this.creationTime = x.creationTime
            this.endTime = x.endTime
            this.failureDetails = x.failureDetails
            this.fileCacheId = x.fileCacheId
            this.fileSystemId = x.fileSystemId
            this.lifecycle = x.lifecycle
            this.paths = x.paths
            this.releaseConfiguration = x.releaseConfiguration
            this.report = x.report
            this.resourceArn = x.resourceArn
            this.startTime = x.startTime
            this.status = x.status
            this.tags = x.tags
            this.taskId = x.taskId
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.DataRepositoryTask = DataRepositoryTask(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.DataRepositoryTaskFailureDetails] inside the given [block]
         */
        public fun failureDetails(block: aws.sdk.kotlin.services.fsx.model.DataRepositoryTaskFailureDetails.Builder.() -> kotlin.Unit) {
            this.failureDetails = aws.sdk.kotlin.services.fsx.model.DataRepositoryTaskFailureDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.ReleaseConfiguration] inside the given [block]
         */
        public fun releaseConfiguration(block: aws.sdk.kotlin.services.fsx.model.ReleaseConfiguration.Builder.() -> kotlin.Unit) {
            this.releaseConfiguration = aws.sdk.kotlin.services.fsx.model.ReleaseConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.CompletionReport] inside the given [block]
         */
        public fun report(block: aws.sdk.kotlin.services.fsx.model.CompletionReport.Builder.() -> kotlin.Unit) {
            this.report = aws.sdk.kotlin.services.fsx.model.CompletionReport.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.DataRepositoryTaskStatus] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.fsx.model.DataRepositoryTaskStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.fsx.model.DataRepositoryTaskStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
