// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The data repository configuration object for Lustre file systems returned in the response of the `CreateFileSystem` operation.
 *
 * This data type is not supported on file systems with a data repository association. For file systems with a data repository association, see .
 */
public class DataRepositoryConfiguration private constructor(builder: Builder) {
    /**
     * Describes the file system's linked S3 data repository's `AutoImportPolicy`. The AutoImportPolicy configures how Amazon FSx keeps your file and directory listings up to date as you add or modify objects in your linked S3 bucket. `AutoImportPolicy` can have the following values:
     * + `NONE` - (Default) AutoImport is off. Amazon FSx only updates file and directory listings from the linked S3 bucket when the file system is created. FSx does not update file and directory listings for any new or changed objects after choosing this option.
     * + `NEW` - AutoImport is on. Amazon FSx automatically imports directory listings of any new objects added to the linked S3 bucket that do not currently exist in the FSx file system.
     * + `NEW_CHANGED` - AutoImport is on. Amazon FSx automatically imports file and directory listings of any new objects added to the S3 bucket and any existing objects that are changed in the S3 bucket after you choose this option.
     * + `NEW_CHANGED_DELETED` - AutoImport is on. Amazon FSx automatically imports file and directory listings of any new objects added to the S3 bucket, any existing objects that are changed in the S3 bucket, and any objects that were deleted in the S3 bucket.
     */
    public val autoImportPolicy: aws.sdk.kotlin.services.fsx.model.AutoImportPolicyType? = builder.autoImportPolicy
    /**
     * The export path to the Amazon S3 bucket (and prefix) that you are using to store new and changed Lustre file system files in S3.
     */
    public val exportPath: kotlin.String? = builder.exportPath
    /**
     * Provides detailed information about the data repository if its `Lifecycle` is set to `MISCONFIGURED` or `FAILED`.
     */
    public val failureDetails: aws.sdk.kotlin.services.fsx.model.DataRepositoryFailureDetails? = builder.failureDetails
    /**
     * The import path to the Amazon S3 bucket (and optional prefix) that you're using as the data repository for your FSx for Lustre file system, for example `s3://import-bucket/optional-prefix`. If a prefix is specified after the Amazon S3 bucket name, only object keys with that prefix are loaded into the file system.
     */
    public val importPath: kotlin.String? = builder.importPath
    /**
     * For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system.
     *
     * The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.
     */
    public val importedFileChunkSize: kotlin.Int? = builder.importedFileChunkSize
    /**
     * Describes the state of the file system's S3 durable data repository, if it is configured with an S3 repository. The lifecycle can have the following values:
     * + `CREATING` - The data repository configuration between the FSx file system and the linked S3 data repository is being created. The data repository is unavailable.
     * + `AVAILABLE` - The data repository is available for use.
     * + `MISCONFIGURED` - Amazon FSx cannot automatically import updates from the S3 bucket until the data repository configuration is corrected. For more information, see [Troubleshooting a Misconfigured linked S3 bucket](https://docs.aws.amazon.com/fsx/latest/LustreGuide/troubleshooting.html#troubleshooting-misconfigured-data-repository).
     * + `UPDATING` - The data repository is undergoing a customer initiated update and availability may be impacted.
     * + `FAILED` - The data repository is in a terminal state that cannot be recovered.
     */
    public val lifecycle: aws.sdk.kotlin.services.fsx.model.DataRepositoryLifecycle? = builder.lifecycle

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.DataRepositoryConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataRepositoryConfiguration(")
        append("autoImportPolicy=$autoImportPolicy,")
        append("exportPath=$exportPath,")
        append("failureDetails=$failureDetails,")
        append("importPath=$importPath,")
        append("importedFileChunkSize=$importedFileChunkSize,")
        append("lifecycle=$lifecycle")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoImportPolicy?.hashCode() ?: 0
        result = 31 * result + (exportPath?.hashCode() ?: 0)
        result = 31 * result + (failureDetails?.hashCode() ?: 0)
        result = 31 * result + (importPath?.hashCode() ?: 0)
        result = 31 * result + (importedFileChunkSize ?: 0)
        result = 31 * result + (lifecycle?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataRepositoryConfiguration

        if (autoImportPolicy != other.autoImportPolicy) return false
        if (exportPath != other.exportPath) return false
        if (failureDetails != other.failureDetails) return false
        if (importPath != other.importPath) return false
        if (importedFileChunkSize != other.importedFileChunkSize) return false
        if (lifecycle != other.lifecycle) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.DataRepositoryConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Describes the file system's linked S3 data repository's `AutoImportPolicy`. The AutoImportPolicy configures how Amazon FSx keeps your file and directory listings up to date as you add or modify objects in your linked S3 bucket. `AutoImportPolicy` can have the following values:
         * + `NONE` - (Default) AutoImport is off. Amazon FSx only updates file and directory listings from the linked S3 bucket when the file system is created. FSx does not update file and directory listings for any new or changed objects after choosing this option.
         * + `NEW` - AutoImport is on. Amazon FSx automatically imports directory listings of any new objects added to the linked S3 bucket that do not currently exist in the FSx file system.
         * + `NEW_CHANGED` - AutoImport is on. Amazon FSx automatically imports file and directory listings of any new objects added to the S3 bucket and any existing objects that are changed in the S3 bucket after you choose this option.
         * + `NEW_CHANGED_DELETED` - AutoImport is on. Amazon FSx automatically imports file and directory listings of any new objects added to the S3 bucket, any existing objects that are changed in the S3 bucket, and any objects that were deleted in the S3 bucket.
         */
        public var autoImportPolicy: aws.sdk.kotlin.services.fsx.model.AutoImportPolicyType? = null
        /**
         * The export path to the Amazon S3 bucket (and prefix) that you are using to store new and changed Lustre file system files in S3.
         */
        public var exportPath: kotlin.String? = null
        /**
         * Provides detailed information about the data repository if its `Lifecycle` is set to `MISCONFIGURED` or `FAILED`.
         */
        public var failureDetails: aws.sdk.kotlin.services.fsx.model.DataRepositoryFailureDetails? = null
        /**
         * The import path to the Amazon S3 bucket (and optional prefix) that you're using as the data repository for your FSx for Lustre file system, for example `s3://import-bucket/optional-prefix`. If a prefix is specified after the Amazon S3 bucket name, only object keys with that prefix are loaded into the file system.
         */
        public var importPath: kotlin.String? = null
        /**
         * For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system.
         *
         * The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.
         */
        public var importedFileChunkSize: kotlin.Int? = null
        /**
         * Describes the state of the file system's S3 durable data repository, if it is configured with an S3 repository. The lifecycle can have the following values:
         * + `CREATING` - The data repository configuration between the FSx file system and the linked S3 data repository is being created. The data repository is unavailable.
         * + `AVAILABLE` - The data repository is available for use.
         * + `MISCONFIGURED` - Amazon FSx cannot automatically import updates from the S3 bucket until the data repository configuration is corrected. For more information, see [Troubleshooting a Misconfigured linked S3 bucket](https://docs.aws.amazon.com/fsx/latest/LustreGuide/troubleshooting.html#troubleshooting-misconfigured-data-repository).
         * + `UPDATING` - The data repository is undergoing a customer initiated update and availability may be impacted.
         * + `FAILED` - The data repository is in a terminal state that cannot be recovered.
         */
        public var lifecycle: aws.sdk.kotlin.services.fsx.model.DataRepositoryLifecycle? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.DataRepositoryConfiguration) : this() {
            this.autoImportPolicy = x.autoImportPolicy
            this.exportPath = x.exportPath
            this.failureDetails = x.failureDetails
            this.importPath = x.importPath
            this.importedFileChunkSize = x.importedFileChunkSize
            this.lifecycle = x.lifecycle
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.DataRepositoryConfiguration = DataRepositoryConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.DataRepositoryFailureDetails] inside the given [block]
         */
        public fun failureDetails(block: aws.sdk.kotlin.services.fsx.model.DataRepositoryFailureDetails.Builder.() -> kotlin.Unit) {
            this.failureDetails = aws.sdk.kotlin.services.fsx.model.DataRepositoryFailureDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
